/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import java.nio.BufferOverflowException;
import java.util.Date;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.Cookie;
import org.glassfish.grizzly.http.util.CookieUtils;
import org.glassfish.grizzly.http.util.UEncoder;

public class CookieSerializerUtils {
    public static void serializeServerCookie(StringBuilder buf, Cookie cookie) {
        CookieSerializerUtils.serializeServerCookie(buf, CookieUtils.COOKIE_VERSION_ONE_STRICT_COMPLIANCE, CookieUtils.ALWAYS_ADD_EXPIRES, cookie);
    }

    public static void serializeServerCookie(StringBuilder buf, boolean versionOneStrictCompliance, boolean alwaysAddExpires, Cookie cookie) {
        CookieSerializerUtils.serializeServerCookie(buf, versionOneStrictCompliance, alwaysAddExpires, cookie.getName(), cookie.getValue(), cookie.getVersion(), cookie.getPath(), cookie.getDomain(), cookie.getComment(), cookie.getMaxAge(), cookie.isSecure(), cookie.isHttpOnly());
    }

    public static void serializeServerCookie(StringBuilder buf, boolean versionOneStrictCompliance, boolean alwaysAddExpires, String name, String value2, int version, String path, String domain, String comment2, int maxAge, boolean isSecure, boolean isHttpOnly) {
        buf.append(name);
        buf.append('=');
        version = CookieSerializerUtils.maybeQuote2(version, buf, value2, true);
        if (version == 1) {
            buf.append("; Version=1");
            if (comment2 != null) {
                buf.append("; Comment=");
                CookieSerializerUtils.maybeQuote2(version, buf, comment2, versionOneStrictCompliance);
            }
        }
        if (domain != null) {
            buf.append("; Domain=");
            CookieSerializerUtils.maybeQuote2(version, buf, domain, versionOneStrictCompliance);
        }
        if (maxAge >= 0) {
            if (version > 0) {
                buf.append("; Max-Age=");
                buf.append(maxAge);
            }
            if (version == 0 || alwaysAddExpires) {
                buf.append("; Expires=");
                if (maxAge == 0) {
                    buf.append(CookieUtils.ancientDate);
                } else {
                    buf.append(CookieUtils.OLD_COOKIE_FORMAT.get().format(new Date(System.currentTimeMillis() + (long)maxAge * 1000L)));
                }
            }
        }
        if (path != null) {
            buf.append("; Path=");
            UEncoder encoder = new UEncoder();
            encoder.addSafeCharacter('/');
            encoder.addSafeCharacter('\"');
            path = encoder.encodeURL(path, true);
            if (version == 0) {
                CookieSerializerUtils.maybeQuote2(version, buf, path, versionOneStrictCompliance);
            } else {
                CookieSerializerUtils.maybeQuote2(version, buf, path, "()<>@,;:\\\"[]?={} \t", false, versionOneStrictCompliance);
            }
        }
        if (isSecure) {
            buf.append("; Secure");
        }
        if (isHttpOnly) {
            buf.append("; HttpOnly");
        }
    }

    public static void serializeServerCookie(Buffer buf, Cookie cookie) {
        CookieSerializerUtils.serializeServerCookie(buf, CookieUtils.COOKIE_VERSION_ONE_STRICT_COMPLIANCE, CookieUtils.ALWAYS_ADD_EXPIRES, cookie);
    }

    public static void serializeServerCookie(Buffer buf, boolean versionOneStrictCompliance, boolean alwaysAddExpires, Cookie cookie) {
        CookieSerializerUtils.serializeServerCookie(buf, versionOneStrictCompliance, alwaysAddExpires, cookie.getName(), cookie.getValue(), cookie.getVersion(), cookie.getPath(), cookie.getDomain(), cookie.getComment(), cookie.getMaxAge(), cookie.isSecure(), cookie.isHttpOnly());
    }

    public static void serializeServerCookie(Buffer buf, boolean versionOneStrictCompliance, boolean alwaysAddExpires, String name, String value2, int version, String path, String domain, String comment2, int maxAge, boolean isSecure, boolean isHttpOnly) {
        CookieSerializerUtils.put(buf, name);
        CookieSerializerUtils.put(buf, 61);
        version = CookieSerializerUtils.maybeQuote2(version, buf, value2, true);
        if (version == 1) {
            CookieSerializerUtils.put(buf, "; Version=1");
            if (comment2 != null) {
                CookieSerializerUtils.put(buf, "; Comment=");
                CookieSerializerUtils.maybeQuote2(version, buf, comment2, versionOneStrictCompliance);
            }
        }
        if (domain != null) {
            CookieSerializerUtils.put(buf, "; Domain=");
            CookieSerializerUtils.maybeQuote2(version, buf, domain, versionOneStrictCompliance);
        }
        if (maxAge >= 0) {
            if (version > 0) {
                CookieSerializerUtils.put(buf, "; Max-Age=");
                CookieSerializerUtils.putInt(buf, maxAge);
            }
            if (version == 0 || alwaysAddExpires) {
                CookieSerializerUtils.put(buf, "; Expires=");
                if (maxAge == 0) {
                    CookieSerializerUtils.put(buf, CookieUtils.ancientDate);
                } else {
                    CookieSerializerUtils.put(buf, CookieUtils.OLD_COOKIE_FORMAT.get().format(new Date(System.currentTimeMillis() + (long)maxAge * 1000L)));
                }
            }
        }
        if (path != null) {
            CookieSerializerUtils.put(buf, "; Path=");
            UEncoder encoder = new UEncoder();
            encoder.addSafeCharacter('/');
            encoder.addSafeCharacter('\"');
            path = encoder.encodeURL(path, true);
            if (version == 0) {
                CookieSerializerUtils.maybeQuote2(version, buf, path, versionOneStrictCompliance);
            } else {
                CookieSerializerUtils.maybeQuote2(version, buf, path, "()<>@,;:\\\"[]?={} \t", false, versionOneStrictCompliance);
            }
        }
        if (isSecure) {
            CookieSerializerUtils.put(buf, "; Secure");
        }
        if (isHttpOnly) {
            CookieSerializerUtils.put(buf, "; HttpOnly");
        }
    }

    public static void serializeClientCookies(StringBuilder buf, Cookie ... cookies) {
        CookieSerializerUtils.serializeClientCookies(buf, CookieUtils.COOKIE_VERSION_ONE_STRICT_COMPLIANCE, cookies);
    }

    public static void serializeClientCookies(StringBuilder buf, boolean versionOneStrictCompliance, Cookie ... cookies) {
        if (cookies.length == 0) {
            return;
        }
        int version = cookies[0].getVersion();
        if (version == 1) {
            buf.append("$Version=\"1\"; ");
        }
        for (int i = 0; i < cookies.length; ++i) {
            Cookie cookie = cookies[i];
            buf.append(cookie.getName());
            buf.append('=');
            CookieSerializerUtils.maybeQuote2(version, buf, cookie.getValue(), true);
            if (version == 1) {
                String path;
                String domain = cookie.getDomain();
                if (domain != null) {
                    buf.append("; $Domain=");
                    CookieSerializerUtils.maybeQuote2(version, buf, domain, versionOneStrictCompliance);
                }
                if ((path = cookie.getPath()) != null) {
                    buf.append("; $Path=");
                    UEncoder encoder = new UEncoder();
                    encoder.addSafeCharacter('/');
                    encoder.addSafeCharacter('\"');
                    path = encoder.encodeURL(path, true);
                    CookieSerializerUtils.maybeQuote2(version, buf, path, "()<>@,;:\\\"[]?={} \t", false, versionOneStrictCompliance);
                }
            }
            if (i >= cookies.length - 1) continue;
            buf.append("; ");
        }
    }

    public static void serializeClientCookies(Buffer buf, Cookie ... cookies) {
        CookieSerializerUtils.serializeClientCookies(buf, CookieUtils.COOKIE_VERSION_ONE_STRICT_COMPLIANCE, cookies);
    }

    public static void serializeClientCookies(Buffer buf, boolean versionOneStrictCompliance, Cookie ... cookies) {
        if (cookies.length == 0) {
            return;
        }
        int version = cookies[0].getVersion();
        if (version == 1) {
            CookieSerializerUtils.put(buf, "$Version=\"1\"; ");
        }
        for (int i = 0; i < cookies.length; ++i) {
            Cookie cookie = cookies[i];
            CookieSerializerUtils.put(buf, cookie.getName());
            CookieSerializerUtils.put(buf, "=");
            CookieSerializerUtils.maybeQuote2(version, buf, cookie.getValue(), true);
            if (version == 1) {
                String path;
                String domain = cookie.getDomain();
                if (domain != null) {
                    CookieSerializerUtils.put(buf, "; $Domain=");
                    CookieSerializerUtils.maybeQuote2(version, buf, domain, versionOneStrictCompliance);
                }
                if ((path = cookie.getPath()) != null) {
                    CookieSerializerUtils.put(buf, "; $Path=");
                    UEncoder encoder = new UEncoder();
                    encoder.addSafeCharacter('/');
                    encoder.addSafeCharacter('\"');
                    path = encoder.encodeURL(path, true);
                    CookieSerializerUtils.maybeQuote2(version, buf, path, "()<>@,;:\\\"[]?={} \t", false, versionOneStrictCompliance);
                }
            }
            if (i >= cookies.length - 1) continue;
            CookieSerializerUtils.put(buf, "; ");
        }
    }

    public static int maybeQuote2(int version, StringBuilder buf, String value2, boolean versionOneStrictCompliance) {
        return CookieSerializerUtils.maybeQuote2(version, buf, value2, false, versionOneStrictCompliance);
    }

    public static int maybeQuote2(int version, StringBuilder buf, String value2, boolean allowVersionSwitch, boolean versionOneStrictCompliance) {
        return CookieSerializerUtils.maybeQuote2(version, buf, value2, null, allowVersionSwitch, versionOneStrictCompliance);
    }

    public static int maybeQuote2(int version, StringBuilder buf, String value2, String literals, boolean allowVersionSwitch, boolean versionOneStrictCompliance) {
        if (value2 == null || value2.length() == 0) {
            buf.append("\"\"");
        } else {
            if (CookieUtils.containsCTL(value2, version)) {
                throw new IllegalArgumentException("Control character in cookie value, consider BASE64 encoding your value");
            }
            if (CookieSerializerUtils.alreadyQuoted(value2)) {
                buf.append('\"');
                buf.append(CookieSerializerUtils.escapeDoubleQuotes(value2, 1, value2.length() - 1));
                buf.append('\"');
            } else if (allowVersionSwitch && versionOneStrictCompliance && version == 0 && !CookieUtils.isToken2(value2, literals)) {
                buf.append('\"');
                buf.append(CookieSerializerUtils.escapeDoubleQuotes(value2, 0, value2.length()));
                buf.append('\"');
                version = 1;
            } else if (version == 0 && !CookieUtils.isToken(value2, literals)) {
                buf.append('\"');
                buf.append(CookieSerializerUtils.escapeDoubleQuotes(value2, 0, value2.length()));
                buf.append('\"');
            } else if (version == 1 && !CookieUtils.isToken2(value2, literals)) {
                buf.append('\"');
                buf.append(CookieSerializerUtils.escapeDoubleQuotes(value2, 0, value2.length()));
                buf.append('\"');
            } else {
                buf.append(value2);
            }
        }
        return version;
    }

    public static int maybeQuote2(int version, Buffer buf, String value2, boolean versionOneStrictCompliance) {
        return CookieSerializerUtils.maybeQuote2(version, buf, value2, false, versionOneStrictCompliance);
    }

    public static int maybeQuote2(int version, Buffer buf, String value2, boolean allowVersionSwitch, boolean versionOneStrictCompliance) {
        return CookieSerializerUtils.maybeQuote2(version, buf, value2, null, allowVersionSwitch, versionOneStrictCompliance);
    }

    public static int maybeQuote2(int version, Buffer buf, String value2, String literals, boolean allowVersionSwitch, boolean versionOneStrictCompliance) {
        if (value2 == null || value2.length() == 0) {
            CookieSerializerUtils.put(buf, "\"\"");
        } else {
            if (CookieUtils.containsCTL(value2, version)) {
                throw new IllegalArgumentException("Control character in cookie value, consider BASE64 encoding your value");
            }
            if (CookieSerializerUtils.alreadyQuoted(value2)) {
                CookieSerializerUtils.put(buf, 34);
                CookieSerializerUtils.put(buf, CookieSerializerUtils.escapeDoubleQuotes(value2, 1, value2.length() - 1));
                CookieSerializerUtils.put(buf, 34);
            } else if (allowVersionSwitch && versionOneStrictCompliance && version == 0 && !CookieUtils.isToken2(value2, literals)) {
                CookieSerializerUtils.put(buf, 34);
                CookieSerializerUtils.put(buf, CookieSerializerUtils.escapeDoubleQuotes(value2, 0, value2.length()));
                CookieSerializerUtils.put(buf, 34);
                version = 1;
            } else if (version == 0 && !CookieUtils.isToken(value2, literals)) {
                CookieSerializerUtils.put(buf, 34);
                CookieSerializerUtils.put(buf, CookieSerializerUtils.escapeDoubleQuotes(value2, 0, value2.length()));
                CookieSerializerUtils.put(buf, 34);
            } else if (version == 1 && !CookieUtils.isToken2(value2, literals)) {
                CookieSerializerUtils.put(buf, 34);
                CookieSerializerUtils.put(buf, CookieSerializerUtils.escapeDoubleQuotes(value2, 0, value2.length()));
                CookieSerializerUtils.put(buf, 34);
            } else {
                CookieSerializerUtils.put(buf, value2);
            }
        }
        return version;
    }

    private static String escapeDoubleQuotes(String s2, int beginIndex, int endIndex) {
        if (s2 == null || s2.length() == 0 || s2.indexOf(34) == -1) {
            return s2;
        }
        StringBuilder b = new StringBuilder();
        for (int i = beginIndex; i < endIndex; ++i) {
            char c = s2.charAt(i);
            if (c == '\\') {
                b.append(c);
                if (++i >= endIndex) {
                    throw new IllegalArgumentException("Invalid escape character in cookie value.");
                }
                b.append(s2.charAt(i));
                continue;
            }
            if (c == '\"') {
                b.append('\\').append('\"');
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    public static boolean alreadyQuoted(String value2) {
        return value2 != null && value2.length() != 0 && value2.charAt(0) == '\"' && value2.charAt(value2.length() - 1) == '\"';
    }

    static void put(Buffer dstBuffer, int c) {
        dstBuffer.put((byte)c);
    }

    static void putInt(Buffer dstBuffer, int intValue) {
        CookieSerializerUtils.put(dstBuffer, Integer.toString(intValue));
    }

    static void put(Buffer dstBuffer, String s2) {
        int size2 = s2.length();
        if (dstBuffer.remaining() < size2) {
            throw new BufferOverflowException();
        }
        for (int i = 0; i < size2; ++i) {
            dstBuffer.put((byte)s2.charAt(i));
        }
    }

    static void put(StringBuilder dstBuffer, int c) {
        dstBuffer.append((char)c);
    }

    static void putInt(StringBuilder dstBuffer, int intValue) {
        dstBuffer.append(intValue);
    }

    static void put(StringBuilder dstBuffer, String s2) {
        dstBuffer.append(s2);
    }
}

