/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.filterchain;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.glassfish.grizzly.filterchain.DefaultFilterChain;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;

public abstract class FilterChainBuilder {
    protected final DefaultFilterChain patternFilterChain = new DefaultFilterChain();

    private FilterChainBuilder() {
    }

    public static FilterChainBuilder stateless() {
        return new StatelessFilterChainBuilder();
    }

    public static FilterChainBuilder stateful() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public abstract FilterChain build();

    public FilterChainBuilder add(Filter filter2) {
        return this.addLast(filter2);
    }

    public FilterChainBuilder addFirst(Filter filter2) {
        this.patternFilterChain.add(0, filter2);
        return this;
    }

    public FilterChainBuilder addLast(Filter filter2) {
        this.patternFilterChain.add(filter2);
        return this;
    }

    public FilterChainBuilder add(int index2, Filter filter2) {
        this.patternFilterChain.add(index2, filter2);
        return this;
    }

    public FilterChainBuilder set(int index2, Filter filter2) {
        this.patternFilterChain.set(index2, filter2);
        return this;
    }

    public FilterChainBuilder remove(int index2) {
        this.patternFilterChain.remove(index2);
        return this;
    }

    public FilterChainBuilder remove(Filter filter2) {
        this.patternFilterChain.remove(filter2);
        return this;
    }

    public FilterChainBuilder addAll(Filter[] array) {
        this.patternFilterChain.addAll(this.patternFilterChain.size(), (Collection<? extends Filter>)Arrays.asList(array));
        return this;
    }

    public FilterChainBuilder addAll(int filterIndex, Filter[] array) {
        this.patternFilterChain.addAll(filterIndex, (Collection<? extends Filter>)Arrays.asList(array));
        return this;
    }

    public FilterChainBuilder addAll(List<Filter> list) {
        return this.addAll(this.patternFilterChain.size(), list);
    }

    public FilterChainBuilder addAll(int filterIndex, List<Filter> list) {
        this.patternFilterChain.addAll(filterIndex, (Collection<? extends Filter>)list);
        return this;
    }

    public int indexOf(Filter filter2) {
        return this.patternFilterChain.indexOf(filter2);
    }

    public int indexOfType(Class<? extends Filter> filterType) {
        return this.patternFilterChain.indexOfType(filterType);
    }

    public static class StatelessFilterChainBuilder
    extends FilterChainBuilder {
        @Override
        public FilterChain build() {
            return this.patternFilterChain;
        }
    }
}

