/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.compression.lzma;

import java.io.IOException;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.TransformationResult;
import org.glassfish.grizzly.compression.lzma.LZMADecoder;
import org.glassfish.grizzly.compression.lzma.LZMAEncoder;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;

public class LZMAFilter
extends BaseFilter {
    private final LZMAEncoder encoder = new LZMAEncoder();
    private final LZMADecoder decoder = new LZMADecoder();

    @Override
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        Buffer input2;
        Connection connection = ctx.getConnection();
        TransformationResult result2 = this.decoder.transform(connection, input2 = (Buffer)ctx.getMessage());
        Buffer remainder = result2.getExternalRemainder();
        if (remainder == null) {
            input2.tryDispose();
        } else {
            input2.shrink();
        }
        try {
            switch (result2.getStatus()) {
                case COMPLETE: {
                    ctx.setMessage(result2.getMessage());
                    this.decoder.finish(connection);
                    NextAction nextAction = ctx.getInvokeAction(remainder);
                    return nextAction;
                }
                case INCOMPLETE: {
                    NextAction nextAction = ctx.getStopAction(remainder);
                    return nextAction;
                }
                case ERROR: {
                    throw new IllegalStateException("LZMA decode error. Code: " + result2.getErrorCode() + " Description: " + result2.getErrorDescription());
                }
            }
            throw new IllegalStateException("Unexpected status: " + (Object)((Object)result2.getStatus()));
        }
        finally {
            result2.recycle();
        }
    }

    @Override
    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        Connection connection = ctx.getConnection();
        Buffer input2 = (Buffer)ctx.getMessage();
        TransformationResult result2 = this.encoder.transform(connection, input2);
        if (!input2.hasRemaining()) {
            input2.tryDispose();
        } else {
            input2.shrink();
        }
        try {
            switch (result2.getStatus()) {
                case COMPLETE: {
                    this.encoder.finish(connection);
                }
                case INCOMPLETE: {
                    Buffer readyBuffer = (Buffer)result2.getMessage();
                    if (readyBuffer != null) {
                        ctx.setMessage(readyBuffer);
                        NextAction nextAction = ctx.getInvokeAction();
                        return nextAction;
                    }
                    NextAction nextAction = ctx.getStopAction();
                    return nextAction;
                }
                case ERROR: {
                    throw new IllegalStateException("LZMA encode error. Code: " + result2.getErrorCode() + " Description: " + result2.getErrorDescription());
                }
            }
            throw new IllegalStateException("Unexpected status: " + (Object)((Object)result2.getStatus()));
        }
        finally {
            result2.recycle();
        }
    }

    @Override
    public NextAction handleClose(FilterChainContext ctx) throws IOException {
        Connection connection = ctx.getConnection();
        this.decoder.release(connection);
        this.encoder.release(connection);
        return super.handleClose(ctx);
    }
}

