/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.attributes;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeBuilder;
import org.glassfish.grizzly.attributes.AttributeHolder;
import org.glassfish.grizzly.attributes.DefaultAttributeBuilder;
import org.glassfish.grizzly.attributes.IndexedAttributeAccessor;

public final class IndexedAttributeHolder
implements AttributeHolder {
    private volatile int count;
    private int size;
    private Object[] attributeValues;
    private int[] i2v;
    protected final DefaultAttributeBuilder attributeBuilder;
    protected final IndexedAttributeAccessor indexedAttributeAccessor;

    public IndexedAttributeHolder(AttributeBuilder attributeBuilder) {
        this.attributeBuilder = (DefaultAttributeBuilder)attributeBuilder;
        this.attributeValues = new Object[4];
        this.i2v = IndexedAttributeHolder.ensureSize(new int[0], 16);
        this.indexedAttributeAccessor = new IndexedAttributeAccessorImpl();
    }

    @Override
    public Object getAttribute(String name) {
        Attribute attribute = this.attributeBuilder.getAttributeByName(name);
        if (attribute != null) {
            return this.indexedAttributeAccessor.getAttribute(attribute.index());
        }
        return null;
    }

    @Override
    public void setAttribute(String name, Object value2) {
        Attribute attribute = this.attributeBuilder.getAttributeByName(name);
        if (attribute == null) {
            attribute = this.attributeBuilder.createAttribute(name);
        }
        this.indexedAttributeAccessor.setAttribute(attribute.index(), value2);
    }

    @Override
    public Object removeAttribute(String name) {
        Attribute attribute = this.attributeBuilder.getAttributeByName(name);
        if (attribute != null) {
            int index2 = attribute.index();
            Object value2 = this.indexedAttributeAccessor.getAttribute(index2);
            if (value2 != null) {
                this.indexedAttributeAccessor.setAttribute(index2, null);
            }
            return value2;
        }
        return null;
    }

    @Override
    public Set<String> getAttributeNames() {
        HashSet<String> result2 = new HashSet<String>();
        int localSize = this.size;
        Object[] localAttributeValues = this.attributeValues;
        for (int i = 0; i < localSize; ++i) {
            Object value2 = localAttributeValues[i];
            if (value2 == null) continue;
            Attribute attribute = this.attributeBuilder.getAttributeByIndex(i);
            result2.add(attribute.name());
        }
        return result2;
    }

    @Override
    public void recycle() {
        Arrays.fill(this.attributeValues, 0, this.size, null);
    }

    @Override
    public void clear() {
        this.attributeValues = new Object[this.attributeValues.length];
        ++this.count;
    }

    @Override
    public AttributeBuilder getAttributeBuilder() {
        return this.attributeBuilder;
    }

    @Override
    public IndexedAttributeAccessor getIndexedAttributeAccessor() {
        return this.indexedAttributeAccessor;
    }

    private static Object[] ensureSize(Object[] array, int size2) {
        int arrayLength = array.length;
        int delta = size2 - arrayLength;
        int newLength = Math.max(arrayLength + delta, arrayLength * 3 / 2 + 1);
        return Arrays.copyOf(array, newLength);
    }

    private static int[] ensureSize(int[] array, int size2) {
        int arrayLength = array.length;
        int delta = size2 - arrayLength;
        int newLength = Math.max(arrayLength + delta, arrayLength * 3 / 2 + 1);
        int[] newArray = Arrays.copyOf(array, newLength);
        Arrays.fill(newArray, array.length, newLength, -1);
        return newArray;
    }

    static /* synthetic */ int[] access$102(IndexedAttributeHolder x0, int[] x1) {
        x0.i2v = x1;
        return x1;
    }

    static /* synthetic */ Object[] access$202(IndexedAttributeHolder x0, Object[] x1) {
        x0.attributeValues = x1;
        return x1;
    }

    protected final class IndexedAttributeAccessorImpl
    implements IndexedAttributeAccessor {
        protected IndexedAttributeAccessorImpl() {
        }

        @Override
        public Object getAttribute(int index2) {
            int idx;
            int[] i2vLocal;
            if (IndexedAttributeHolder.this.count != 0 && index2 < (i2vLocal = IndexedAttributeHolder.this.i2v).length && (idx = i2vLocal[index2]) != -1) {
                return IndexedAttributeHolder.this.attributeValues[idx];
            }
            return null;
        }

        @Override
        public void setAttribute(int index2, Object value2) {
            int mappedIdx;
            int[] localI2v = IndexedAttributeHolder.this.i2v;
            if (index2 >= localI2v.length || (mappedIdx = localI2v[index2]) == -1) {
                mappedIdx = this.mapIndex(index2);
            }
            ((IndexedAttributeHolder)IndexedAttributeHolder.this).attributeValues[mappedIdx] = value2;
            IndexedAttributeHolder.this.count++;
        }

        private synchronized int mapIndex(int index2) {
            int mappedIdx;
            if (index2 >= IndexedAttributeHolder.this.i2v.length) {
                IndexedAttributeHolder.access$102(IndexedAttributeHolder.this, IndexedAttributeHolder.ensureSize(IndexedAttributeHolder.this.i2v, index2 + 1));
            }
            if ((mappedIdx = IndexedAttributeHolder.this.i2v[index2]) == -1) {
                if (IndexedAttributeHolder.this.size == IndexedAttributeHolder.this.attributeValues.length) {
                    IndexedAttributeHolder.access$202(IndexedAttributeHolder.this, IndexedAttributeHolder.ensureSize(IndexedAttributeHolder.this.attributeValues, IndexedAttributeHolder.this.size + 1));
                }
                IndexedAttributeHolder.this.count++;
                ((IndexedAttributeHolder)IndexedAttributeHolder.this).i2v[index2] = mappedIdx = IndexedAttributeHolder.this.size++;
            }
            return mappedIdx;
        }
    }
}

