/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kafka;

import java.io.File;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import kafka.admin.AdminUtils$;
import kafka.api.LeaderAndIsr;
import kafka.api.PartitionStateInfo;
import kafka.api.Request$;
import kafka.common.TopicAndPartition;
import kafka.producer.KeyedMessage;
import kafka.producer.Producer;
import kafka.producer.ProducerConfig;
import kafka.serializer.StringEncoder;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.apache.spark.Logging;
import org.apache.spark.SparkConf;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.kafka.KafkaCluster;
import org.apache.spark.streaming.kafka.KafkaTestUtils$;
import org.apache.spark.util.Utils$;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t\rf\u0001B\u0001\u0003\t5\u0011abS1gW\u0006$Vm\u001d;Vi&d7O\u0003\u0002\u0004\t\u0005)1.\u00194lC*\u0011QAB\u0001\ngR\u0014X-Y7j]\u001eT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\r\u0001a\u0002\u0006\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005U1R\"\u0001\u0004\n\u0005]1!a\u0002'pO\u001eLgn\u001a\u0005\u00063\u0001!\tAG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0001\"\u0001\b\u0001\u000e\u0003\tAqA\b\u0001C\u0002\u0013%q$\u0001\u0004{W\"{7\u000f^\u000b\u0002AA\u0011\u0011EJ\u0007\u0002E)\u00111\u0005J\u0001\u0005Y\u0006twMC\u0001&\u0003\u0011Q\u0017M^1\n\u0005\u001d\u0012#AB*ue&tw\r\u0003\u0004*\u0001\u0001\u0006I\u0001I\u0001\bu.Dun\u001d;!\u0011\u001dY\u0003\u00011A\u0005\n1\naA_6Q_J$X#A\u0017\u0011\u0005=q\u0013BA\u0018\u0011\u0005\rIe\u000e\u001e\u0005\bc\u0001\u0001\r\u0011\"\u00033\u0003)Q8\u000eU8si~#S-\u001d\u000b\u0003gY\u0002\"a\u0004\u001b\n\u0005U\u0002\"\u0001B+oSRDqa\u000e\u0019\u0002\u0002\u0003\u0007Q&A\u0002yIEBa!\u000f\u0001!B\u0013i\u0013a\u0002>l!>\u0014H\u000f\t\u0005\bw\u0001\u0011\r\u0011\"\u0003-\u0003MQ8nQ8o]\u0016\u001cG/[8o)&lWm\\;u\u0011\u0019i\u0004\u0001)A\u0005[\u0005!\"p[\"p]:,7\r^5p]RKW.Z8vi\u0002Bqa\u0010\u0001C\u0002\u0013%A&\u0001\t{WN+7o]5p]RKW.Z8vi\"1\u0011\t\u0001Q\u0001\n5\n\u0011C_6TKN\u001c\u0018n\u001c8US6,w.\u001e;!\u0011%\u0019\u0005\u00011AA\u0002\u0013%A)A\u0005{_>\\W-\u001a9feV\tQ\t\u0005\u0002G\u000f6\t\u0001A\u0002\u0003I\u0001\u0011I%!E#nE\u0016$G-\u001a3[_>\\W-\u001a9feN\u0011qI\u0004\u0005\t\u0017\u001e\u0013)\u0019!C\u0001\u0019\u0006I!p[\"p]:,7\r^\u000b\u0002\u001bB\u0011a*\u0015\b\u0003\u001f=K!\u0001\u0015\t\u0002\rA\u0013X\rZ3g\u0013\t9#K\u0003\u0002Q!!AAk\u0012B\u0001B\u0003%Q*\u0001\u0006{W\u000e{gN\\3di\u0002BQ!G$\u0005\u0002Y#\"!R,\t\u000b-+\u0006\u0019A'\t\u000fe;%\u0019!C\u00015\u0006Y1O\\1qg\"|G\u000fR5s+\u0005Y\u0006C\u0001/`\u001b\u0005i&B\u00010%\u0003\tIw.\u0003\u0002a;\n!a)\u001b7f\u0011\u0019\u0011w\t)A\u00057\u0006a1O\\1qg\"|G\u000fR5sA!9Am\u0012b\u0001\n\u0003Q\u0016A\u00027pO\u0012K'\u000f\u0003\u0004g\u000f\u0002\u0006IaW\u0001\bY><G)\u001b:!\u0011\u001d\u0019uI1A\u0005\u0002!,\u0012!\u001b\t\u0003U:l\u0011a\u001b\u0006\u0003Y6\faa]3sm\u0016\u0014(BA\"\t\u0013\ty7NA\b[_>\\U-\u001a9feN+'O^3s\u0011\u0019\tx\t)A\u0005S\u0006Q!p\\8lK\u0016\u0004XM\u001d\u0011\t\u0015M<\u0005\u0013!A\u0002B\u0003%A/A\u0002yIM\u0002BaD;![%\u0011a\u000f\u0005\u0002\u0007)V\u0004H.\u001a\u001a\t\u000fa<%\u0019!C\u0001?\u0005\u0011\u0011\u000e\u001d\u0005\u0007u\u001e\u0003\u000b\u0011\u0002\u0011\u0002\u0007%\u0004\b\u0005C\u0004}\u000f\n\u0007I\u0011\u0001\u0017\u0002\tA|'\u000f\u001e\u0005\u0007}\u001e\u0003\u000b\u0011B\u0017\u0002\u000bA|'\u000f\u001e\u0011\t\u0013\u0005\u0005qI1A\u0005\u0002\u0005\r\u0011a\u00024bGR|'/_\u000b\u0003\u0003\u000b\u00012A[A\u0004\u0013\r\tIa\u001b\u0002\u0015\u001d&{5+\u001a:wKJ\u001ce\u000e\u001f8GC\u000e$xN]=\t\u0011\u00055q\t)A\u0005\u0003\u000b\t\u0001BZ1di>\u0014\u0018\u0010\t\u0005\t\u0003#9%\u0019!C\u0001Y\u0005Q\u0011m\u0019;vC2\u0004vN\u001d;\t\u000f\u0005Uq\t)A\u0005[\u0005Y\u0011m\u0019;vC2\u0004vN\u001d;!\u0011\u001d\tIb\u0012C\u0001\u00037\t\u0001b\u001d5vi\u0012|wO\u001c\u000b\u0002g!Y\u0011q\u0004\u0001A\u0002\u0003\u0007I\u0011BA\u0011\u00035Qxn\\6fKB,'o\u0018\u0013fcR\u00191'a\t\t\u0011]\ni\"!AA\u0002\u0015Ca!\u001d\u0001!B\u0013)\u0005bCA\u0015\u0001\u0001\u0007\t\u0019!C\u0005\u0003W\t\u0001B_6DY&,g\u000e^\u000b\u0003\u0003[\u0001B!a\f\u0002:5\u0011\u0011\u0011\u0007\u0006\u0005\u0003g\t)$\u0001\u0005{W\u000ed\u0017.\u001a8u\u0015\r\t9DC\u0001\u0007\u0013BJE/Z2\n\t\u0005m\u0012\u0011\u0007\u0002\t5.\u001cE.[3oi\"Y\u0011q\b\u0001A\u0002\u0003\u0007I\u0011BA!\u00031Q8n\u00117jK:$x\fJ3r)\r\u0019\u00141\t\u0005\no\u0005u\u0012\u0011!a\u0001\u0003[A\u0001\"a\u0012\u0001A\u0003&\u0011QF\u0001\nu.\u001cE.[3oi\u0002B\u0001\"a\u0013\u0001\u0005\u0004%IaH\u0001\u000bEJ|7.\u001a:I_N$\bbBA(\u0001\u0001\u0006I\u0001I\u0001\fEJ|7.\u001a:I_N$\b\u0005\u0003\u0005\u0002T\u0001\u0001\r\u0011\"\u0003-\u0003)\u0011'o\\6feB{'\u000f\u001e\u0005\n\u0003/\u0002\u0001\u0019!C\u0005\u00033\naB\u0019:pW\u0016\u0014\bk\u001c:u?\u0012*\u0017\u000fF\u00024\u00037B\u0001bNA+\u0003\u0003\u0005\r!\f\u0005\b\u0003?\u0002\u0001\u0015)\u0003.\u0003-\u0011'o\\6feB{'\u000f\u001e\u0011\t\u0017\u0005\r\u0004\u00011AA\u0002\u0013%\u0011QM\u0001\u000bEJ|7.\u001a:D_:4WCAA4!\u0011\tI'a\u001c\u000e\u0005\u0005-$b\u00017\u0002n)\t1!\u0003\u0003\u0002r\u0005-$aC&bM.\f7i\u001c8gS\u001eD1\"!\u001e\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002x\u0005q!M]8lKJ\u001cuN\u001c4`I\u0015\fHcA\u001a\u0002z!Iq'a\u001d\u0002\u0002\u0003\u0007\u0011q\r\u0005\t\u0003{\u0002\u0001\u0015)\u0003\u0002h\u0005Y!M]8lKJ\u001cuN\u001c4!\u0011)a\u0007\u00011AA\u0002\u0013%\u0011\u0011Q\u000b\u0003\u0003\u0007\u0003B!!\u001b\u0002\u0006&!\u0011qQA6\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\t\u0017\u0005-\u0005\u00011AA\u0002\u0013%\u0011QR\u0001\u000bg\u0016\u0014h/\u001a:`I\u0015\fHcA\u001a\u0002\u0010\"Iq'!#\u0002\u0002\u0003\u0007\u00111\u0011\u0005\t\u0003'\u0003\u0001\u0015)\u0003\u0002\u0004\u000691/\u001a:wKJ\u0004\u0003bCAL\u0001\u0001\u0007\t\u0019!C\u0005\u00033\u000b\u0001\u0002\u001d:pIV\u001cWM]\u000b\u0003\u00037\u0003b!!(\u0002\"6kUBAAP\u0015\u0011\t9*!\u001c\n\t\u0005\r\u0016q\u0014\u0002\t!J|G-^2fe\"Y\u0011q\u0015\u0001A\u0002\u0003\u0007I\u0011BAU\u00031\u0001(o\u001c3vG\u0016\u0014x\fJ3r)\r\u0019\u00141\u0016\u0005\no\u0005\u0015\u0016\u0011!a\u0001\u00037C\u0001\"a,\u0001A\u0003&\u00111T\u0001\naJ|G-^2fe\u0002B\u0011\"a-\u0001\u0001\u0004%I!!.\u0002\u000fi\\'+Z1esV\u0011\u0011q\u0017\t\u0004\u001f\u0005e\u0016bAA^!\t9!i\\8mK\u0006t\u0007\"CA`\u0001\u0001\u0007I\u0011BAa\u0003-Q8NU3bIf|F%Z9\u0015\u0007M\n\u0019\rC\u00058\u0003{\u000b\t\u00111\u0001\u00028\"A\u0011q\u0019\u0001!B\u0013\t9,\u0001\u0005{WJ+\u0017\rZ=!\u0011%\tY\r\u0001a\u0001\n\u0013\t),A\u0006ce>\\WM\u001d*fC\u0012L\b\"CAh\u0001\u0001\u0007I\u0011BAi\u0003=\u0011'o\\6feJ+\u0017\rZ=`I\u0015\fHcA\u001a\u0002T\"Iq'!4\u0002\u0002\u0003\u0007\u0011q\u0017\u0005\t\u0003/\u0004\u0001\u0015)\u0003\u00028\u0006a!M]8lKJ\u0014V-\u00193zA!1\u00111\u001c\u0001\u0005\u00021\u000b\u0011B_6BI\u0012\u0014Xm]:\t\r\u0005}\u0007\u0001\"\u0001M\u00035\u0011'o\\6fe\u0006#GM]3tg\"9\u00111\u001d\u0001\u0005\u0002\u0005-\u0012a\u0004>p_.,W\r]3s\u00072LWM\u001c;\t\u000f\u0005\u001d\b\u0001\"\u0003\u0002\u001c\u000512/\u001a;va\u0016k'-\u001a3eK\u0012Tvn\\6fKB,'\u000fC\u0004\u0002l\u0002!I!a\u0007\u00021M,G/\u001e9F[\n,G\rZ3e\u0017\u000647.Y*feZ,'\u000fC\u0004\u0002p\u0002!\t!a\u0007\u0002\u000bM,G/\u001e9\t\u000f\u0005M\b\u0001\"\u0001\u0002\u001c\u0005AA/Z1sI><h\u000eC\u0004\u0002x\u0002!\t!!?\u0002\u0017\r\u0014X-\u0019;f)>\u0004\u0018n\u0019\u000b\u0004g\u0005m\bbBA\u007f\u0003k\u0004\r!T\u0001\u0006i>\u0004\u0018n\u0019\u0005\b\u0005\u0003\u0001A\u0011\u0001B\u0002\u00031\u0019XM\u001c3NKN\u001c\u0018mZ3t)\u0015\u0019$Q\u0001B\u0004\u0011\u001d\ti0a@A\u00025C\u0001B!\u0003\u0002\u0000\u0002\u0007!1B\u0001\u000e[\u0016\u001c8/Y4f)>4%/Z9\u0011\u000f\t5!1C'\u0003\u00185\u0011!q\u0002\u0006\u0004\u0005#!\u0013\u0001B;uS2LAA!\u0006\u0003\u0010\t\u0019Q*\u00199\u0011\u0007\u0005\u0012I\"C\u0002\u0003\u001c\t\u0012q!\u00138uK\u001e,'\u000fC\u0004\u0003\u0002\u0001!\tAa\b\u0015\u000bM\u0012\tCa\t\t\u000f\u0005u(Q\u0004a\u0001\u001b\"A!\u0011\u0002B\u000f\u0001\u0004\u0011)\u0003E\u0003O\u0005OiU&C\u0002\u0003\u0016ICqA!\u0001\u0001\t\u0003\u0011Y\u0003F\u00034\u0005[\u0011y\u0003C\u0004\u0002~\n%\u0002\u0019A'\t\u0011\tE\"\u0011\u0006a\u0001\u0005g\t\u0001\"\\3tg\u0006<Wm\u001d\t\u0005\u001f\tUR*C\u0002\u00038A\u0011Q!\u0011:sCfDqAa\u000f\u0001\t\u0013\u0011i$A\nce>\\WM]\"p]\u001aLw-\u001e:bi&|g.\u0006\u0002\u0003@A!!Q\u0002B!\u0013\u0011\u0011\u0019Ea\u0004\u0003\u0015A\u0013x\u000e]3si&,7\u000fC\u0004\u0003H\u0001!IA!\u0010\u0002+A\u0014x\u000eZ;dKJ\u001cuN\u001c4jOV\u0014\u0018\r^5p]\"9!1\n\u0001\u0005\u0002\t5\u0013AC3wK:$X/\u00197msV!!q\nB,)\u0019\u0011\tFa\u001d\u0003\u0000Q!!1\u000bB5!\u0011\u0011)Fa\u0016\r\u0001\u0011A!\u0011\fB%\u0005\u0004\u0011YFA\u0001U#\u0011\u0011iFa\u0019\u0011\u0007=\u0011y&C\u0002\u0003bA\u0011qAT8uQ&tw\rE\u0002\u0010\u0005KJ1Aa\u001a\u0011\u0005\r\te.\u001f\u0005\n\u0005W\u0012I\u0005\"a\u0001\u0005[\nAAZ;oGB)qBa\u001c\u0003T%\u0019!\u0011\u000f\t\u0003\u0011q\u0012\u0017P\\1nKzB\u0001B!\u001e\u0003J\u0001\u0007!qO\u0001\bi&lWm\\;u!\u0011\u0011IHa\u001f\u000e\u0003\u0011I1A! \u0005\u0005\u0011!\u0016.\\3\t\u0011\t\u0005%\u0011\na\u0001\u0005o\n\u0001\"\u001b8uKJ4\u0018\r\u001c\u0005\b\u0005\u000b\u0003A\u0011\u0001BD\u0003U9\u0018-\u001b;V]RLG\u000eT3bI\u0016\u0014xJ\u001a4tKR$ra\rBE\u0005\u0017\u0013y\tC\u0004\u0002~\n\r\u0005\u0019A'\t\u000f\t5%1\u0011a\u0001[\u0005I\u0001/\u0019:uSRLwN\u001c\u0005\t\u0005#\u0013\u0019\t1\u0001\u0003\u0014\u00061qN\u001a4tKR\u00042a\u0004BK\u0013\r\u00119\n\u0005\u0002\u0005\u0019>tw\rC\u0004\u0003\u001c\u0002!IA!(\u0002;]\f\u0017\u000e^+oi&dW*\u001a;bI\u0006$\u0018-S:Qe>\u0004\u0018mZ1uK\u0012$Ra\rBP\u0005CCq!!@\u0003\u001a\u0002\u0007Q\nC\u0004\u0003\u000e\ne\u0005\u0019A\u0017")
public class KafkaTestUtils
implements Logging {
    private final String zkHost;
    private int zkPort;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private EmbeddedZookeeper zookeeper;
    private ZkClient zkClient;
    private final String brokerHost;
    private int org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort;
    private KafkaConfig org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerConf;
    private KafkaServer org$apache$spark$streaming$kafka$KafkaTestUtils$$server;
    private Producer<String, String> producer;
    private boolean zkReady;
    private boolean brokerReady;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    private String zkHost() {
        return this.zkHost;
    }

    private int zkPort() {
        return this.zkPort;
    }

    private void zkPort_$eq(int x$1) {
        this.zkPort = x$1;
    }

    private int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    private int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    private EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    private void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    private ZkClient zkClient() {
        return this.zkClient;
    }

    private void zkClient_$eq(ZkClient x$1) {
        this.zkClient = x$1;
    }

    private String brokerHost() {
        return this.brokerHost;
    }

    private int org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort() {
        return this.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort;
    }

    public void org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort_$eq(int x$1) {
        this.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort = x$1;
    }

    public KafkaConfig org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerConf() {
        return this.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerConf;
    }

    public void org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerConf_$eq(KafkaConfig x$1) {
        this.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerConf = x$1;
    }

    public KafkaServer org$apache$spark$streaming$kafka$KafkaTestUtils$$server() {
        return this.org$apache$spark$streaming$kafka$KafkaTestUtils$$server;
    }

    public void org$apache$spark$streaming$kafka$KafkaTestUtils$$server_$eq(KafkaServer x$1) {
        this.org$apache$spark$streaming$kafka$KafkaTestUtils$$server = x$1;
    }

    private Producer<String, String> producer() {
        return this.producer;
    }

    private void producer_$eq(Producer<String, String> x$1) {
        this.producer = x$1;
    }

    private boolean zkReady() {
        return this.zkReady;
    }

    private void zkReady_$eq(boolean x$1) {
        this.zkReady = x$1;
    }

    private boolean brokerReady() {
        return this.brokerReady;
    }

    private void brokerReady_$eq(boolean x$1) {
        this.brokerReady = x$1;
    }

    public String zkAddress() {
        Predef$.MODULE$.assert(this.zkReady(), (Function0<Object>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Zookeeper not setup yet or already torn down, cannot get zookeeper address";
            }
        }));
        return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.zkHost(), BoxesRunTime.boxToInteger(this.zkPort())}));
    }

    public String brokerAddress() {
        Predef$.MODULE$.assert(this.brokerReady(), (Function0<Object>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Kafka not setup yet or already torn down, cannot get broker address";
            }
        }));
        return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.brokerHost(), BoxesRunTime.boxToInteger(this.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort())}));
    }

    public ZkClient zookeeperClient() {
        Predef$.MODULE$.assert(this.zkReady(), (Function0<Object>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Zookeeper not setup yet or already torn down, cannot get zookeeper client";
            }
        }));
        return (ZkClient)((Object)Option$.MODULE$.apply(this.zkClient()).getOrElse(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IllegalStateException("Zookeeper client is not yet initialized");
            }
        }));
    }

    private void setupEmbeddedZookeeper() {
        this.zookeeper_$eq(new EmbeddedZookeeper(this, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.zkHost(), BoxesRunTime.boxToInteger(this.zkPort())}))));
        this.zkPort_$eq(this.zookeeper().actualPort());
        this.zkClient_$eq(new ZkClient(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.zkHost(), BoxesRunTime.boxToInteger(this.zkPort())})), this.zkSessionTimeout(), this.zkConnectionTimeout(), ZKStringSerializer$.MODULE$));
        this.zkReady_$eq(true);
    }

    private void setupEmbeddedKafkaServer() {
        Predef$.MODULE$.assert(this.zkReady(), (Function0<Object>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Zookeeper should be set up beforehand";
            }
        }));
        Utils$.MODULE$.startServiceOnPort(this.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort(), (Function1)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaTestUtils $outer;

            public final Tuple2<KafkaServer, Object> apply(int port) {
                this.$outer.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort_$eq(port);
                this.$outer.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerConf_$eq(new KafkaConfig(this.$outer.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerConfiguration()));
                this.$outer.org$apache$spark$streaming$kafka$KafkaTestUtils$$server_$eq(new KafkaServer(this.$outer.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerConf(), KafkaServer$.MODULE$.$lessinit$greater$default$2()));
                this.$outer.org$apache$spark$streaming$kafka$KafkaTestUtils$$server().startup();
                return new Tuple2<KafkaServer, Object>(this.$outer.org$apache$spark$streaming$kafka$KafkaTestUtils$$server(), BoxesRunTime.boxToInteger(port));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }), new SparkConf(), "KafkaBroker");
        this.brokerReady_$eq(true);
    }

    public void setup() {
        this.setupEmbeddedZookeeper();
        this.setupEmbeddedKafkaServer();
    }

    public void teardown() {
        this.brokerReady_$eq(false);
        this.zkReady_$eq(false);
        if (this.producer() != null) {
            this.producer().close();
            this.producer_$eq(null);
        }
        if (this.org$apache$spark$streaming$kafka$KafkaTestUtils$$server() != null) {
            this.org$apache$spark$streaming$kafka$KafkaTestUtils$$server().shutdown();
            this.org$apache$spark$streaming$kafka$KafkaTestUtils$$server_$eq(null);
        }
        this.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerConf().logDirs().foreach(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(String f) {
                Utils$.MODULE$.deleteRecursively(new File(f));
            }
        });
        if (this.zkClient() != null) {
            this.zkClient().close();
            this.zkClient_$eq(null);
        }
        if (this.zookeeper() != null) {
            this.zookeeper().shutdown();
            this.zookeeper_$eq(null);
        }
    }

    public void createTopic(String topic) {
        AdminUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 1, AdminUtils$.MODULE$.createTopic$default$5());
        this.waitUntilMetadataIsPropagated(topic, 0);
    }

    public void sendMessages(String topic, Map<String, Integer> messageToFreq) {
        this.sendMessages(topic, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply(JavaConversions$.MODULE$.mapAsScalaMap(messageToFreq).mapValues(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Integer x$1) {
                return x$1;
            }
        }).toSeq()));
    }

    public void sendMessages(String topic, scala.collection.immutable.Map<String, Object> messageToFreq) {
        String[] messages = (String[])((TraversableOnce)messageToFreq.flatMap((Function1<String, GenTraversableOnce<Object>>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(Tuple2<String, Object> x0$1) {
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    String s2 = tuple2._1();
                    int freq = tuple2._2$mcI$sp();
                    Seq seq = (Seq)Seq$.MODULE$.fill(freq, new Serializable(this, s2){
                        public static final long serialVersionUID = 0L;
                        private final String s$1;

                        public final String apply() {
                            return this.s$1;
                        }
                        {
                            this.s$1 = s$1;
                        }
                    });
                    return seq;
                }
                throw new MatchError(tuple2);
            }
        }), Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
        this.sendMessages(topic, messages);
    }

    public void sendMessages(String topic, String[] messages) {
        this.producer_$eq(new Producer<String, String>(new ProducerConfig(this.producerConfiguration())));
        this.producer().send(Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])messages).map(new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$2;

            public final KeyedMessage<String, String> apply(String x$2) {
                return new KeyedMessage<String, String>(this.topic$2, x$2);
            }
            {
                this.topic$2 = topic$2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(KeyedMessage.class)))));
        this.producer().close();
        this.producer_$eq(null);
    }

    /*
     * WARNING - void declaration
     */
    public Properties org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerConfiguration() {
        void var1_1;
        Properties props = new Properties();
        props.put("broker.id", "0");
        props.put("host.name", "localhost");
        props.put("port", ((Object)BoxesRunTime.boxToInteger(this.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort())).toString());
        props.put("log.dir", Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).getAbsolutePath());
        props.put("zookeeper.connect", this.zkAddress());
        props.put("log.flush.interval.messages", "1");
        props.put("replica.socket.timeout.ms", "1500");
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Properties producerConfiguration() {
        void var1_1;
        Properties props = new Properties();
        props.put("metadata.broker.list", this.brokerAddress());
        props.put("serializer.class", StringEncoder.class.getName());
        return var1_1;
    }

    public <T> T eventually(Time timeout, Time interval, Function0<T> func) {
        long startTime = System.currentTimeMillis();
        return (T)this.tryAgain$1(1, timeout, interval, func, startTime);
    }

    public void waitUntilLeaderOffset(String topic, int partition2, long offset) {
        this.eventually(new Time(10000L), new Time(100L), (Function0)((Object)new Serializable(this, topic, partition2, offset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaTestUtils $outer;
            public final String topic$3;
            public final int partition$2;
            public final long offset$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                KafkaCluster kc = new KafkaCluster((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("metadata.broker.list"), this.$outer.brokerAddress())})));
                TopicAndPartition tp = new TopicAndPartition(this.topic$3, this.partition$2);
                long llo = ((KafkaCluster.LeaderOffset)((MapLike)kc.getLatestLeaderOffsets((Set)Predef$.MODULE$.Set().apply(Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{tp}))).right().get()).apply(tp)).offset();
                Predef$.MODULE$.assert(llo == this.offset$1, (Function0<Object>)((Object)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$waitUntilLeaderOffset$1 $outer;

                    public final String apply() {
                        return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " ", " not reached after timeout"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.topic$3, BoxesRunTime.boxToInteger(this.$outer.partition$2), BoxesRunTime.boxToLong(this.$outer.offset$1)}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$3 = topic$3;
                this.partition$2 = partition$2;
                this.offset$1 = offset$1;
            }
        }));
    }

    private void waitUntilMetadataIsPropagated(String topic, int partition2) {
        this.eventually(new Time(10000L), new Time(100L), (Function0)((Object)new Serializable(this, topic, partition2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaTestUtils $outer;
            public final String topic$1;
            public final int partition$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Predef$.MODULE$.assert(this.$outer.org$apache$spark$streaming$kafka$KafkaTestUtils$$isPropagated$1(this.topic$1, this.partition$1), (Function0<Object>)((Object)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$waitUntilMetadataIsPropagated$1 $outer;

                    public final String apply() {
                        return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition [", ", ", "] metadata not propagated after timeout"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.topic$1, BoxesRunTime.boxToInteger(this.$outer.partition$1)}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
                this.partition$1 = partition$1;
            }
        }));
    }

    private final Either makeAttempt$1(Function0 func$1) {
        Throwable throwable2;
        block2: {
            Either either2;
            try {
                either2 = package$.MODULE$.Right().apply(func$1.apply());
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                if (!NonFatal$.MODULE$.apply(throwable3)) break block2;
                Left left = package$.MODULE$.Left().apply(throwable3);
                either2 = left;
            }
            return either2;
        }
        throw throwable2;
    }

    private final Object tryAgain$1(int attempt, Time timeout$1, Time interval$1, Function0 func$1, long startTime$1) {
        Either either2;
        block2: {
            Throwable e;
            while (true) {
                if ((either2 = this.makeAttempt$1(func$1)) instanceof Right) {
                    Object result2;
                    Right right = (Right)either2;
                    Object b = result2 = right.b();
                    return b;
                }
                if (!(either2 instanceof Left)) break block2;
                Left left = (Left)either2;
                e = (Throwable)left.a();
                long duration = System.currentTimeMillis() - startTime$1;
                if (duration >= timeout$1.milliseconds()) break;
                Thread.sleep(interval$1.milliseconds());
                ++attempt;
            }
            throw new TimeoutException(e.getMessage());
        }
        throw new MatchError(either2);
    }

    public final boolean org$apache$spark$streaming$kafka$KafkaTestUtils$$isPropagated$1(String topic$1, int partition$1) {
        boolean bl;
        Option<PartitionStateInfo> option = this.org$apache$spark$streaming$kafka$KafkaTestUtils$$server().apis().metadataCache().getPartitionInfo(topic$1, partition$1);
        if (option instanceof Some) {
            Some some = (Some)option;
            PartitionStateInfo partitionState = (PartitionStateInfo)some.x();
            LeaderAndIsr leaderAndInSyncReplicas = partitionState.leaderIsrAndControllerEpoch().leaderAndIsr();
            bl = ZkUtils$.MODULE$.getLeaderForPartition(this.zkClient(), topic$1, partition$1).isDefined() && Request$.MODULE$.isValidBrokerId(leaderAndInSyncReplicas.leader()) && leaderAndInSyncReplicas.isr().size() >= 1;
        } else {
            bl = false;
        }
        return bl;
    }

    public KafkaTestUtils() {
        Logging.class.$init$((Logging)this);
        this.zkHost = "localhost";
        this.zkPort = 0;
        this.zkConnectionTimeout = 6000;
        this.zkSessionTimeout = 6000;
        this.brokerHost = "localhost";
        this.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort = 9092;
        this.zkReady = false;
        this.brokerReady = false;
    }

    public class EmbeddedZookeeper {
        private final String zkConnect;
        private final File snapshotDir;
        private final File logDir;
        private final ZooKeeperServer zookeeper;
        private final /* synthetic */ Tuple2 x$3;
        private final String ip;
        private final int port;
        private final NIOServerCnxnFactory factory;
        private final int actualPort;
        public final /* synthetic */ KafkaTestUtils $outer;

        public String zkConnect() {
            return this.zkConnect;
        }

        public File snapshotDir() {
            return this.snapshotDir;
        }

        public File logDir() {
            return this.logDir;
        }

        public ZooKeeperServer zookeeper() {
            return this.zookeeper;
        }

        public String ip() {
            return this.ip;
        }

        public int port() {
            return this.port;
        }

        public NIOServerCnxnFactory factory() {
            return this.factory;
        }

        public int actualPort() {
            return this.actualPort;
        }

        public void shutdown() {
            this.factory().shutdown();
            Utils$.MODULE$.deleteRecursively(this.snapshotDir());
            Utils$.MODULE$.deleteRecursively(this.logDir());
        }

        public /* synthetic */ KafkaTestUtils org$apache$spark$streaming$kafka$KafkaTestUtils$EmbeddedZookeeper$$$outer() {
            return this.$outer;
        }

        public EmbeddedZookeeper(KafkaTestUtils $outer, String zkConnect) {
            this.zkConnect = zkConnect;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.snapshotDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            this.logDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            this.zookeeper = new ZooKeeperServer(this.snapshotDir(), this.logDir(), 500);
            String[] splits = zkConnect.split(":");
            Tuple2<String, Integer> tuple2 = new Tuple2<String, Integer>(splits[0], BoxesRunTime.boxToInteger(new StringOps(Predef$.MODULE$.augmentString(splits[1])).toInt()));
            if (tuple2 != null) {
                Tuple2<String, Integer> tuple22;
                String ip = tuple2._1();
                int port = tuple2._2$mcI$sp();
                this.x$3 = tuple22 = new Tuple2<String, Integer>(ip, BoxesRunTime.boxToInteger(port));
                this.ip = (String)this.x$3._1();
                this.port = this.x$3._2$mcI$sp();
                this.factory = new NIOServerCnxnFactory();
                this.factory().configure(new InetSocketAddress(this.ip(), this.port()), 16);
                this.factory().startup(this.zookeeper());
                this.actualPort = this.factory().getLocalPort();
                return;
            }
            throw new MatchError(tuple2);
        }
    }
}

