/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.kafka.common.utils.CollectionUtils;

public class FetchRequest
extends AbstractRequestResponse {
    public static Schema curSchema = ProtoUtils.currentRequestSchema(ApiKeys.FETCH.id);
    private static String REPLICA_ID_KEY_NAME = "replica_id";
    private static String MAX_WAIT_KEY_NAME = "max_wait_time";
    private static String MIN_BYTES_KEY_NAME = "min_bytes";
    private static String TOPICS_KEY_NAME = "topics";
    private static String TOPIC_KEY_NAME = "topic";
    private static String PARTITIONS_KEY_NAME = "partitions";
    private static String PARTITION_KEY_NAME = "partition";
    private static String FETCH_OFFSET_KEY_NAME = "fetch_offset";
    private static String MAX_BYTES_KEY_NAME = "max_bytes";
    private final int replicaId;
    private final int maxWait;
    private final int minBytes;
    private final Map<TopicPartition, PartitionData> fetchData;

    public FetchRequest(int replicaId, int maxWait, int minBytes, Map<TopicPartition, PartitionData> fetchData) {
        super(new Struct(curSchema));
        Map<String, Map<Integer, PartitionData>> topicsData = CollectionUtils.groupDataByTopic(fetchData);
        this.struct.set(REPLICA_ID_KEY_NAME, (Object)replicaId);
        this.struct.set(MAX_WAIT_KEY_NAME, (Object)maxWait);
        this.struct.set(MIN_BYTES_KEY_NAME, (Object)minBytes);
        ArrayList<Struct> topicArray = new ArrayList<Struct>();
        for (Map.Entry<String, Map<Integer, PartitionData>> topicEntry : topicsData.entrySet()) {
            Struct topicData = this.struct.instance(TOPICS_KEY_NAME);
            topicData.set(TOPIC_KEY_NAME, (Object)topicEntry.getKey());
            ArrayList<Struct> partitionArray = new ArrayList<Struct>();
            for (Map.Entry<Integer, PartitionData> partitionEntry : topicEntry.getValue().entrySet()) {
                PartitionData fetchPartitionData = partitionEntry.getValue();
                Struct partitionData = topicData.instance(PARTITIONS_KEY_NAME);
                partitionData.set(PARTITION_KEY_NAME, (Object)partitionEntry.getKey());
                partitionData.set(FETCH_OFFSET_KEY_NAME, (Object)fetchPartitionData.offset);
                partitionData.set(MAX_BYTES_KEY_NAME, (Object)fetchPartitionData.maxBytes);
                partitionArray.add(partitionData);
            }
            topicData.set(PARTITIONS_KEY_NAME, (Object)partitionArray.toArray());
            topicArray.add(topicData);
        }
        this.struct.set(TOPICS_KEY_NAME, (Object)topicArray.toArray());
        this.replicaId = replicaId;
        this.maxWait = maxWait;
        this.minBytes = minBytes;
        this.fetchData = fetchData;
    }

    public FetchRequest(Struct struct) {
        super(struct);
        this.replicaId = struct.getInt(REPLICA_ID_KEY_NAME);
        this.maxWait = struct.getInt(MAX_WAIT_KEY_NAME);
        this.minBytes = struct.getInt(MIN_BYTES_KEY_NAME);
        this.fetchData = new HashMap<TopicPartition, PartitionData>();
        for (Object topicResponseObj : struct.getArray(TOPICS_KEY_NAME)) {
            Struct topicResponse = (Struct)topicResponseObj;
            String topic = topicResponse.getString(TOPIC_KEY_NAME);
            for (Object partitionResponseObj : topicResponse.getArray(PARTITIONS_KEY_NAME)) {
                Struct partitionResponse = (Struct)partitionResponseObj;
                int partition2 = partitionResponse.getInt(PARTITION_KEY_NAME);
                long offset = partitionResponse.getLong(FETCH_OFFSET_KEY_NAME);
                int maxBytes = partitionResponse.getInt(MAX_BYTES_KEY_NAME);
                PartitionData partitionData = new PartitionData(offset, maxBytes);
                this.fetchData.put(new TopicPartition(topic, partition2), partitionData);
            }
        }
    }

    public int replicaId() {
        return this.replicaId;
    }

    public int maxWait() {
        return this.maxWait;
    }

    public int minBytes() {
        return this.minBytes;
    }

    public Map<TopicPartition, PartitionData> fetchData() {
        return this.fetchData;
    }

    public static FetchRequest parse(ByteBuffer buffer) {
        return new FetchRequest((Struct)curSchema.read(buffer));
    }

    public static final class PartitionData {
        public final long offset;
        public final int maxBytes;

        public PartitionData(long offset, int maxBytes) {
            this.offset = offset;
            this.maxBytes = maxBytes;
        }
    }
}

