/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util.bloom;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.bloom.Filter;
import org.apache.hadoop.util.bloom.Key;

@InterfaceAudience.Public
@InterfaceStability.Stable
public final class CountingBloomFilter
extends Filter {
    private long[] buckets;
    private static final long BUCKET_MAX_VALUE = 15L;

    public CountingBloomFilter() {
    }

    public CountingBloomFilter(int vectorSize, int nbHash, int hashType) {
        super(vectorSize, nbHash, hashType);
        this.buckets = new long[CountingBloomFilter.buckets2words(vectorSize)];
    }

    private static int buckets2words(int vectorSize) {
        return (vectorSize - 1 >>> 4) + 1;
    }

    @Override
    public void add(Key key) {
        if (key == null) {
            throw new NullPointerException("key can not be null");
        }
        int[] h = this.hash.hash(key);
        this.hash.clear();
        for (int i = 0; i < this.nbHash; ++i) {
            int wordNum = h[i] >> 4;
            int bucketShift = (h[i] & 0xF) << 2;
            long bucketMask = 15L << bucketShift;
            long bucketValue = (this.buckets[wordNum] & bucketMask) >>> bucketShift;
            if (bucketValue >= 15L) continue;
            this.buckets[wordNum] = this.buckets[wordNum] & (bucketMask ^ 0xFFFFFFFFFFFFFFFFL) | bucketValue + 1L << bucketShift;
        }
    }

    public void delete(Key key) {
        if (key == null) {
            throw new NullPointerException("Key may not be null");
        }
        if (!this.membershipTest(key)) {
            throw new IllegalArgumentException("Key is not a member");
        }
        int[] h = this.hash.hash(key);
        this.hash.clear();
        for (int i = 0; i < this.nbHash; ++i) {
            int wordNum = h[i] >> 4;
            int bucketShift = (h[i] & 0xF) << 2;
            long bucketMask = 15L << bucketShift;
            long bucketValue = (this.buckets[wordNum] & bucketMask) >>> bucketShift;
            if (bucketValue < 1L || bucketValue >= 15L) continue;
            this.buckets[wordNum] = this.buckets[wordNum] & (bucketMask ^ 0xFFFFFFFFFFFFFFFFL) | bucketValue - 1L << bucketShift;
        }
    }

    @Override
    public void and(Filter filter2) {
        if (filter2 == null || !(filter2 instanceof CountingBloomFilter) || filter2.vectorSize != this.vectorSize || filter2.nbHash != this.nbHash) {
            throw new IllegalArgumentException("filters cannot be and-ed");
        }
        CountingBloomFilter cbf = (CountingBloomFilter)filter2;
        int sizeInWords = CountingBloomFilter.buckets2words(this.vectorSize);
        for (int i = 0; i < sizeInWords; ++i) {
            int n = i;
            this.buckets[n] = this.buckets[n] & cbf.buckets[i];
        }
    }

    @Override
    public boolean membershipTest(Key key) {
        if (key == null) {
            throw new NullPointerException("Key may not be null");
        }
        int[] h = this.hash.hash(key);
        this.hash.clear();
        for (int i = 0; i < this.nbHash; ++i) {
            int wordNum = h[i] >> 4;
            int bucketShift = (h[i] & 0xF) << 2;
            long bucketMask = 15L << bucketShift;
            if ((this.buckets[wordNum] & bucketMask) != 0L) continue;
            return false;
        }
        return true;
    }

    public int approximateCount(Key key) {
        int res = Integer.MAX_VALUE;
        int[] h = this.hash.hash(key);
        this.hash.clear();
        for (int i = 0; i < this.nbHash; ++i) {
            int wordNum = h[i] >> 4;
            int bucketShift = (h[i] & 0xF) << 2;
            long bucketMask = 15L << bucketShift;
            long bucketValue = (this.buckets[wordNum] & bucketMask) >>> bucketShift;
            if (bucketValue >= (long)res) continue;
            res = (int)bucketValue;
        }
        if (res != Integer.MAX_VALUE) {
            return res;
        }
        return 0;
    }

    @Override
    public void not() {
        throw new UnsupportedOperationException("not() is undefined for " + this.getClass().getName());
    }

    @Override
    public void or(Filter filter2) {
        if (filter2 == null || !(filter2 instanceof CountingBloomFilter) || filter2.vectorSize != this.vectorSize || filter2.nbHash != this.nbHash) {
            throw new IllegalArgumentException("filters cannot be or-ed");
        }
        CountingBloomFilter cbf = (CountingBloomFilter)filter2;
        int sizeInWords = CountingBloomFilter.buckets2words(this.vectorSize);
        for (int i = 0; i < sizeInWords; ++i) {
            int n = i;
            this.buckets[n] = this.buckets[n] | cbf.buckets[i];
        }
    }

    @Override
    public void xor(Filter filter2) {
        throw new UnsupportedOperationException("xor() is undefined for " + this.getClass().getName());
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < this.vectorSize; ++i) {
            if (i > 0) {
                res.append(" ");
            }
            int wordNum = i >> 4;
            int bucketShift = (i & 0xF) << 2;
            long bucketMask = 15L << bucketShift;
            long bucketValue = (this.buckets[wordNum] & bucketMask) >>> bucketShift;
            res.append(bucketValue);
        }
        return res.toString();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        int sizeInWords = CountingBloomFilter.buckets2words(this.vectorSize);
        for (int i = 0; i < sizeInWords; ++i) {
            out.writeLong(this.buckets[i]);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        int sizeInWords = CountingBloomFilter.buckets2words(this.vectorSize);
        this.buckets = new long[sizeInWords];
        for (int i = 0; i < sizeInWords; ++i) {
            this.buckets[i] = in.readLong();
        }
    }
}

