/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.FilterContainer;
import org.apache.hadoop.http.FilterInitializer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;

public class AuthenticationFilterInitializer
extends FilterInitializer {
    static final String PREFIX = "hadoop.http.authentication.";
    static final String SIGNATURE_SECRET_FILE = "signature.secret.file";

    @Override
    public void initFilter(FilterContainer container, Configuration conf) {
        HashMap<String, String> filterConfig = new HashMap<String, String>();
        filterConfig.put("cookie.path", "/");
        for (Map.Entry<String, String> entry2 : conf) {
            String name = entry2.getKey();
            if (!name.startsWith(PREFIX)) continue;
            String value2 = conf.get(name);
            name = name.substring(PREFIX.length());
            filterConfig.put(name, value2);
        }
        String signatureSecretFile = (String)filterConfig.get(SIGNATURE_SECRET_FILE);
        if (signatureSecretFile == null) {
            throw new RuntimeException("Undefined property: signature.secret.file");
        }
        try {
            StringBuilder secret = new StringBuilder();
            FileReader reader = new FileReader(signatureSecretFile);
            int c = ((Reader)reader).read();
            while (c > -1) {
                secret.append((char)c);
                c = ((Reader)reader).read();
            }
            ((Reader)reader).close();
            filterConfig.put("signature.secret", secret.toString());
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not read HTTP signature secret file: " + signatureSecretFile);
        }
        String bindAddress = conf.get("bind.address");
        String principal = (String)filterConfig.get("kerberos.principal");
        if (principal != null) {
            try {
                principal = SecurityUtil.getServerPrincipal(principal, bindAddress);
            }
            catch (IOException ex) {
                throw new RuntimeException("Could not resolve Kerberos principal name: " + ex.toString(), ex);
            }
            filterConfig.put("kerberos.principal", principal);
        }
        container.addFilter("authentication", AuthenticationFilter.class.getName(), filterConfig);
    }
}

