/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.security;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.mapreduce.v2.api.HSClientProtocol;
import org.apache.hadoop.mapreduce.v2.api.MRClientProtocol;
import org.apache.hadoop.mapreduce.v2.api.MRDelegationTokenIdentifier;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.CancelDelegationTokenRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.RenewDelegationTokenRequest;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenRenewer;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Private
public class MRDelegationTokenRenewer
extends TokenRenewer {
    private static final Log LOG = LogFactory.getLog(MRDelegationTokenRenewer.class);

    @Override
    public boolean handleKind(Text kind) {
        return MRDelegationTokenIdentifier.KIND_NAME.equals(kind);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long renew(Token<?> token2, Configuration conf) throws IOException, InterruptedException {
        org.apache.hadoop.yarn.api.records.Token dToken = org.apache.hadoop.yarn.api.records.Token.newInstance(token2.getIdentifier(), token2.getKind().toString(), token2.getPassword(), token2.getService().toString());
        MRClientProtocol histProxy = this.instantiateHistoryProxy(conf, SecurityUtil.getTokenServiceAddr(token2));
        try {
            RenewDelegationTokenRequest request = Records.newRecord(RenewDelegationTokenRequest.class);
            request.setDelegationToken(dToken);
            long l = histProxy.renewDelegationToken(request).getNextExpirationTime();
            return l;
        }
        finally {
            this.stopHistoryProxy(histProxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(Token<?> token2, Configuration conf) throws IOException, InterruptedException {
        org.apache.hadoop.yarn.api.records.Token dToken = org.apache.hadoop.yarn.api.records.Token.newInstance(token2.getIdentifier(), token2.getKind().toString(), token2.getPassword(), token2.getService().toString());
        MRClientProtocol histProxy = this.instantiateHistoryProxy(conf, SecurityUtil.getTokenServiceAddr(token2));
        try {
            CancelDelegationTokenRequest request = Records.newRecord(CancelDelegationTokenRequest.class);
            request.setDelegationToken(dToken);
            histProxy.cancelDelegationToken(request);
        }
        finally {
            this.stopHistoryProxy(histProxy);
        }
    }

    @Override
    public boolean isManaged(Token<?> token2) throws IOException {
        return true;
    }

    protected void stopHistoryProxy(MRClientProtocol proxy) {
        RPC.stopProxy(proxy);
    }

    protected MRClientProtocol instantiateHistoryProxy(final Configuration conf, final InetSocketAddress hsAddress) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Connecting to MRHistoryServer at: " + hsAddress));
        }
        final YarnRPC rpc = YarnRPC.create(conf);
        UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
        return currentUser.doAs(new PrivilegedAction<MRClientProtocol>(){

            @Override
            public MRClientProtocol run() {
                return (MRClientProtocol)rpc.getProxy(HSClientProtocol.class, hsAddress, conf);
            }
        });
    }
}

