/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp.dao;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.hadoop.mapreduce.JobACL;
import org.apache.hadoop.mapreduce.v2.api.records.JobReport;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.ConfEntryInfo;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.util.Times;

@XmlRootElement(name="job")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class JobInfo {
    protected long startTime;
    protected long finishTime;
    protected long elapsedTime;
    protected String id;
    protected String name;
    protected String user;
    protected JobState state;
    protected int mapsTotal;
    protected int mapsCompleted;
    protected int reducesTotal;
    protected int reducesCompleted;
    protected float mapProgress;
    protected float reduceProgress;
    @XmlTransient
    protected String mapProgressPercent;
    @XmlTransient
    protected String reduceProgressPercent;
    protected int mapsPending;
    protected int mapsRunning;
    protected int reducesPending;
    protected int reducesRunning;
    protected boolean uberized;
    protected String diagnostics;
    protected int newReduceAttempts = 0;
    protected int runningReduceAttempts = 0;
    protected int failedReduceAttempts = 0;
    protected int killedReduceAttempts = 0;
    protected int successfulReduceAttempts = 0;
    protected int newMapAttempts = 0;
    protected int runningMapAttempts = 0;
    protected int failedMapAttempts = 0;
    protected int killedMapAttempts = 0;
    protected int successfulMapAttempts = 0;
    protected ArrayList<ConfEntryInfo> acls;

    public JobInfo() {
    }

    public JobInfo(Job job, Boolean hasAccess) {
        this.id = MRApps.toString(job.getID());
        JobReport report = job.getReport();
        this.startTime = report.getStartTime();
        this.finishTime = report.getFinishTime();
        this.elapsedTime = Times.elapsed(this.startTime, this.finishTime);
        if (this.elapsedTime == -1L) {
            this.elapsedTime = 0L;
        }
        this.name = job.getName().toString();
        this.user = job.getUserName();
        this.state = job.getState();
        this.mapsTotal = job.getTotalMaps();
        this.mapsCompleted = job.getCompletedMaps();
        this.mapProgress = report.getMapProgress() * 100.0f;
        this.mapProgressPercent = StringHelper.percent(report.getMapProgress());
        this.reducesTotal = job.getTotalReduces();
        this.reducesCompleted = job.getCompletedReduces();
        this.reduceProgress = report.getReduceProgress() * 100.0f;
        this.reduceProgressPercent = StringHelper.percent(report.getReduceProgress());
        this.acls = new ArrayList();
        if (hasAccess.booleanValue()) {
            Map<JobACL, AccessControlList> allacls;
            this.diagnostics = "";
            this.countTasksAndAttempts(job);
            this.uberized = job.isUber();
            List<String> diagnostics = job.getDiagnostics();
            if (diagnostics != null && !diagnostics.isEmpty()) {
                StringBuffer b = new StringBuffer();
                for (String string2 : diagnostics) {
                    b.append(string2);
                }
                this.diagnostics = b.toString();
            }
            if ((allacls = job.getJobACLs()) != null) {
                for (Map.Entry entry2 : allacls.entrySet()) {
                    this.acls.add(new ConfEntryInfo(((JobACL)((Object)entry2.getKey())).getAclName(), ((AccessControlList)entry2.getValue()).getAclString()));
                }
            }
        }
    }

    public int getNewReduceAttempts() {
        return this.newReduceAttempts;
    }

    public int getKilledReduceAttempts() {
        return this.killedReduceAttempts;
    }

    public int getFailedReduceAttempts() {
        return this.failedReduceAttempts;
    }

    public int getRunningReduceAttempts() {
        return this.runningReduceAttempts;
    }

    public int getSuccessfulReduceAttempts() {
        return this.successfulReduceAttempts;
    }

    public int getNewMapAttempts() {
        return this.newMapAttempts;
    }

    public int getKilledMapAttempts() {
        return this.killedMapAttempts;
    }

    public ArrayList<ConfEntryInfo> getAcls() {
        return this.acls;
    }

    public int getFailedMapAttempts() {
        return this.failedMapAttempts;
    }

    public int getRunningMapAttempts() {
        return this.runningMapAttempts;
    }

    public int getSuccessfulMapAttempts() {
        return this.successfulMapAttempts;
    }

    public int getReducesCompleted() {
        return this.reducesCompleted;
    }

    public int getReducesTotal() {
        return this.reducesTotal;
    }

    public int getReducesPending() {
        return this.reducesPending;
    }

    public int getReducesRunning() {
        return this.reducesRunning;
    }

    public int getMapsCompleted() {
        return this.mapsCompleted;
    }

    public int getMapsTotal() {
        return this.mapsTotal;
    }

    public int getMapsPending() {
        return this.mapsPending;
    }

    public int getMapsRunning() {
        return this.mapsRunning;
    }

    public String getState() {
        return this.state.toString();
    }

    public String getUserName() {
        return this.user;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public boolean isUberized() {
        return this.uberized;
    }

    public String getdiagnostics() {
        return this.diagnostics;
    }

    public float getMapProgress() {
        return this.mapProgress;
    }

    public String getMapProgressPercent() {
        return this.mapProgressPercent;
    }

    public float getReduceProgress() {
        return this.reduceProgress;
    }

    public String getReduceProgressPercent() {
        return this.reduceProgressPercent;
    }

    private void countTasksAndAttempts(Job job) {
        Map<TaskId, Task> tasks = job.getTasks();
        if (tasks == null) {
            return;
        }
        for (Task task : tasks.values()) {
            block0 : switch (task.getType()) {
                case MAP: {
                    switch (task.getState()) {
                        case RUNNING: {
                            ++this.mapsRunning;
                            break block0;
                        }
                        case SCHEDULED: {
                            ++this.mapsPending;
                            break block0;
                        }
                    }
                    break;
                }
                case REDUCE: {
                    switch (task.getState()) {
                        case RUNNING: {
                            ++this.reducesRunning;
                            break block0;
                        }
                        case SCHEDULED: {
                            ++this.reducesPending;
                            break block0;
                        }
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Task type is neither map nor reduce: " + (Object)((Object)task.getType()));
                }
            }
            Map<TaskAttemptId, TaskAttempt> attempts = task.getAttempts();
            block17: for (TaskAttempt attempt : attempts.values()) {
                int newAttempts = 0;
                int running = 0;
                int successful = 0;
                int failed2 = 0;
                int killed = 0;
                if (MRApps.TaskAttemptStateUI.NEW.correspondsTo(attempt.getState())) {
                    ++newAttempts;
                } else if (MRApps.TaskAttemptStateUI.RUNNING.correspondsTo(attempt.getState())) {
                    ++running;
                } else if (MRApps.TaskAttemptStateUI.SUCCESSFUL.correspondsTo(attempt.getState())) {
                    ++successful;
                } else if (MRApps.TaskAttemptStateUI.FAILED.correspondsTo(attempt.getState())) {
                    ++failed2;
                } else if (MRApps.TaskAttemptStateUI.KILLED.correspondsTo(attempt.getState())) {
                    ++killed;
                }
                switch (task.getType()) {
                    case MAP: {
                        this.newMapAttempts += newAttempts;
                        this.runningMapAttempts += running;
                        this.successfulMapAttempts += successful;
                        this.failedMapAttempts += failed2;
                        this.killedMapAttempts += killed;
                        continue block17;
                    }
                    case REDUCE: {
                        this.newReduceAttempts += newAttempts;
                        this.runningReduceAttempts += running;
                        this.successfulReduceAttempts += successful;
                        this.failedReduceAttempts += failed2;
                        this.killedReduceAttempts += killed;
                        continue block17;
                    }
                }
                throw new IllegalStateException("Task type neither map nor reduce: " + (Object)((Object)task.getType()));
            }
        }
    }
}

