/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.task;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.StatusReporter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.task.JobContextImpl;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TaskAttemptContextImpl
extends JobContextImpl
implements TaskAttemptContext {
    private final TaskAttemptID taskId;
    private String status = "";
    private StatusReporter reporter;

    public TaskAttemptContextImpl(Configuration conf, TaskAttemptID taskId) {
        this(conf, taskId, new DummyReporter());
    }

    public TaskAttemptContextImpl(Configuration conf, TaskAttemptID taskId, StatusReporter reporter) {
        super(conf, taskId.getJobID());
        this.taskId = taskId;
        this.reporter = reporter;
    }

    @Override
    public TaskAttemptID getTaskAttemptID() {
        return this.taskId;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public Counter getCounter(Enum<?> counterName) {
        return this.reporter.getCounter(counterName);
    }

    @Override
    public Counter getCounter(String groupName, String counterName) {
        return this.reporter.getCounter(groupName, counterName);
    }

    @Override
    public void progress() {
        this.reporter.progress();
    }

    protected void setStatusString(String status) {
        this.status = status;
    }

    @Override
    public void setStatus(String status) {
        String normalizedStatus = Task.normalizeStatus(status, this.conf);
        this.setStatusString(normalizedStatus);
        this.reporter.setStatus(normalizedStatus);
    }

    @Override
    public float getProgress() {
        return this.reporter.getProgress();
    }

    public static class DummyReporter
    extends StatusReporter {
        @Override
        public void setStatus(String s2) {
        }

        @Override
        public void progress() {
        }

        @Override
        public Counter getCounter(Enum<?> name) {
            return new Counters().findCounter(name);
        }

        @Override
        public Counter getCounter(String group, String name) {
            return new Counters().findCounter(group, name);
        }

        @Override
        public float getProgress() {
            return 0.0f;
        }
    }
}

