/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.join;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.join.ComposableRecordReader;
import org.apache.hadoop.mapreduce.lib.join.CompositeRecordReader;
import org.apache.hadoop.mapreduce.lib.join.ResetableIterator;
import org.apache.hadoop.mapreduce.lib.join.StreamBackedIterator;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class WrappedRecordReader<K extends WritableComparable<?>, U extends Writable>
extends ComposableRecordReader<K, U> {
    protected boolean empty = false;
    private RecordReader<K, U> rr;
    private int id;
    protected WritableComparator cmp = null;
    private K key;
    private U value;
    private ResetableIterator<U> vjoin;
    private Configuration conf = new Configuration();
    private Class<? extends WritableComparable> keyclass = null;
    private Class<? extends Writable> valueclass = null;

    protected WrappedRecordReader(int id) {
        this.id = id;
        this.vjoin = new StreamBackedIterator<U>();
    }

    WrappedRecordReader(int id, RecordReader<K, U> rr, Class<? extends WritableComparator> cmpcl) throws IOException, InterruptedException {
        this.id = id;
        this.rr = rr;
        if (cmpcl != null) {
            try {
                this.cmp = cmpcl.newInstance();
            }
            catch (InstantiationException e) {
                throw new IOException(e);
            }
            catch (IllegalAccessException e) {
                throw new IOException(e);
            }
        }
        this.vjoin = new StreamBackedIterator<U>();
    }

    @Override
    public void initialize(InputSplit split2, TaskAttemptContext context) throws IOException, InterruptedException {
        this.rr.initialize(split2, context);
        this.conf = context.getConfiguration();
        this.nextKeyValue();
        if (!this.empty) {
            this.keyclass = this.key.getClass().asSubclass(WritableComparable.class);
            this.valueclass = this.value.getClass();
            if (this.cmp == null) {
                this.cmp = WritableComparator.get(this.keyclass);
            }
        }
    }

    @Override
    public K createKey() {
        if (this.keyclass != null) {
            return (K)ReflectionUtils.newInstance(this.keyclass, this.conf);
        }
        return (K)NullWritable.get();
    }

    @Override
    public U createValue() {
        if (this.valueclass != null) {
            return (U)ReflectionUtils.newInstance(this.valueclass, this.conf);
        }
        return (U)NullWritable.get();
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public K key() {
        return this.key;
    }

    @Override
    public void key(K qkey) throws IOException {
        ReflectionUtils.copy(this.conf, this.key, qkey);
    }

    @Override
    public boolean hasNext() {
        return !this.empty;
    }

    @Override
    public void skip(K key) throws IOException, InterruptedException {
        if (this.hasNext()) {
            while (this.cmp.compare((WritableComparable)this.key(), (WritableComparable)key) <= 0 && this.next()) {
            }
        }
    }

    @Override
    public void accept(CompositeRecordReader.JoinCollector i, K key) throws IOException, InterruptedException {
        this.vjoin.clear();
        if (this.key() != null && 0 == this.cmp.compare((WritableComparable)key, (WritableComparable)this.key())) {
            do {
                this.vjoin.add(this.value);
            } while (this.next() && 0 == this.cmp.compare((WritableComparable)key, (WritableComparable)this.key()));
        }
        i.add(this.id, this.vjoin);
    }

    @Override
    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (this.hasNext()) {
            this.next();
            return true;
        }
        return false;
    }

    private boolean next() throws IOException, InterruptedException {
        this.empty = !this.rr.nextKeyValue();
        this.key = (WritableComparable)this.rr.getCurrentKey();
        this.value = (Writable)this.rr.getCurrentValue();
        return !this.empty;
    }

    @Override
    public K getCurrentKey() throws IOException, InterruptedException {
        return (K)((WritableComparable)this.rr.getCurrentKey());
    }

    @Override
    public U getCurrentValue() throws IOException, InterruptedException {
        return (U)((Writable)this.rr.getCurrentValue());
    }

    @Override
    public float getProgress() throws IOException, InterruptedException {
        return this.rr.getProgress();
    }

    @Override
    public void close() throws IOException {
        this.rr.close();
    }

    @Override
    public int compareTo(ComposableRecordReader<K, ?> other) {
        return this.cmp.compare((WritableComparable)this.key(), (WritableComparable)other.key());
    }

    public boolean equals(Object other) {
        return other instanceof ComposableRecordReader && 0 == this.compareTo((ComposableRecordReader)other);
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }
}

