/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.hadoop.mapreduce.FileSystemCounter;
import org.apache.hadoop.mapreduce.counters.AbstractCounterGroup;
import org.apache.hadoop.mapreduce.counters.AbstractCounters;
import org.apache.hadoop.mapreduce.counters.CounterGroupBase;
import org.apache.hadoop.mapreduce.counters.CounterGroupFactory;
import org.apache.hadoop.mapreduce.counters.FileSystemCounterGroup;
import org.apache.hadoop.mapreduce.counters.FrameworkCounterGroup;
import org.apache.hadoop.mapreduce.counters.GenericCounter;
import org.apache.hadoop.mapreduce.counters.Limits;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class Counters
extends AbstractCounters<Counter, CounterGroup> {
    private static final GroupFactory groupFactory = new GroupFactory();

    public Counters() {
        super(groupFactory);
    }

    public <C extends Counter, G extends CounterGroupBase<C>> Counters(AbstractCounters<C, G> counters) {
        super(counters, groupFactory);
    }

    private static class GroupFactory
    extends CounterGroupFactory<Counter, CounterGroup> {
        private GroupFactory() {
        }

        @Override
        protected <T extends Enum<T>> CounterGroupFactory.FrameworkGroupFactory<CounterGroup> newFrameworkGroupFactory(final Class<T> cls) {
            return new CounterGroupFactory.FrameworkGroupFactory<CounterGroup>(){

                @Override
                public CounterGroup newGroup(String name) {
                    return new FrameworkGroupImpl(cls);
                }
            };
        }

        @Override
        protected CounterGroup newGenericGroup(String name, String displayName, Limits limits) {
            return new GenericGroup(name, displayName, limits);
        }

        @Override
        protected CounterGroup newFileSystemGroup() {
            return new FileSystemGroup();
        }
    }

    private static class FileSystemGroup
    extends FileSystemCounterGroup<Counter>
    implements CounterGroup {
        private FileSystemGroup() {
        }

        @Override
        protected Counter newCounter(String scheme, FileSystemCounter key) {
            return new FileSystemCounterGroup.FSCounter(scheme, key);
        }

        @Override
        public CounterGroupBase<Counter> getUnderlyingGroup() {
            return this;
        }
    }

    private static class GenericGroup
    extends AbstractCounterGroup<Counter>
    implements CounterGroup {
        GenericGroup(String name, String displayName, Limits limits) {
            super(name, displayName, limits);
        }

        @Override
        protected Counter newCounter(String name, String displayName, long value2) {
            return new GenericCounter(name, displayName, value2);
        }

        @Override
        protected Counter newCounter() {
            return new GenericCounter();
        }

        @Override
        public CounterGroupBase<Counter> getUnderlyingGroup() {
            return this;
        }
    }

    private static class FrameworkGroupImpl<T extends Enum<T>>
    extends FrameworkCounterGroup<T, Counter>
    implements CounterGroup {
        FrameworkGroupImpl(Class<T> cls) {
            super(cls);
        }

        @Override
        protected FrameworkCounterGroup.FrameworkCounter<T> newCounter(T key) {
            return new FrameworkCounterGroup.FrameworkCounter<T>(key, this.getName());
        }

        @Override
        public CounterGroupBase<Counter> getUnderlyingGroup() {
            return this;
        }
    }
}

