/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.lib.MultipleInputs;
import org.apache.hadoop.mapred.lib.TaggedInputSplit;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DelegatingInputFormat<K, V>
implements InputFormat<K, V> {
    @Override
    public InputSplit[] getSplits(JobConf conf, int numSplits) throws IOException {
        JobConf confCopy = new JobConf(conf);
        ArrayList<TaggedInputSplit> splits = new ArrayList<TaggedInputSplit>();
        Map<Path, InputFormat> formatMap = MultipleInputs.getInputFormatMap(conf);
        Map<Path, Class<? extends Mapper>> mapperMap = MultipleInputs.getMapperTypeMap(conf);
        HashMap formatPaths = new HashMap();
        for (Map.Entry<Path, InputFormat> entry2 : formatMap.entrySet()) {
            if (!formatPaths.containsKey(entry2.getValue().getClass())) {
                formatPaths.put(entry2.getValue().getClass(), new LinkedList());
            }
            ((List)formatPaths.get(entry2.getValue().getClass())).add(entry2.getKey());
        }
        for (Map.Entry entry3 : formatPaths.entrySet()) {
            Class<? extends Mapper> mapperClass;
            Class formatClass = (Class)((Object)entry3.getKey());
            InputFormat format2 = (InputFormat)ReflectionUtils.newInstance(formatClass, conf);
            List paths = (List)((Object)entry3.getValue());
            HashMap mapperPaths = new HashMap();
            for (Path path : paths) {
                mapperClass = mapperMap.get(path);
                if (!mapperPaths.containsKey(mapperClass)) {
                    mapperPaths.put(mapperClass, new LinkedList());
                }
                ((List)mapperPaths.get(mapperClass)).add(path);
            }
            for (Map.Entry entry4 : mapperPaths.entrySet()) {
                InputSplit[] pathSplits;
                paths = (List)entry4.getValue();
                mapperClass = (Class<? extends Mapper>)entry4.getKey();
                if (mapperClass == null) {
                    mapperClass = conf.getMapperClass();
                }
                FileInputFormat.setInputPaths(confCopy, paths.toArray(new Path[paths.size()]));
                for (InputSplit pathSplit : pathSplits = format2.getSplits(confCopy, numSplits)) {
                    splits.add(new TaggedInputSplit(pathSplit, conf, format2.getClass(), mapperClass));
                }
            }
        }
        return splits.toArray(new InputSplit[splits.size()]);
    }

    @Override
    public RecordReader<K, V> getRecordReader(InputSplit split2, JobConf conf, Reporter reporter) throws IOException {
        TaggedInputSplit taggedInputSplit = (TaggedInputSplit)split2;
        InputFormat inputFormat = ReflectionUtils.newInstance(taggedInputSplit.getInputFormatClass(), conf);
        return inputFormat.getRecordReader(taggedInputSplit.getInputSplit(), conf, reporter);
    }
}

