/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.ProtocolSignature;
import org.apache.hadoop.mapred.FileOutputCommitter;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContextImpl;
import org.apache.hadoop.mapred.JobEndNotifier;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobProfile;
import org.apache.hadoop.mapred.JvmContext;
import org.apache.hadoop.mapred.JvmTask;
import org.apache.hadoop.mapred.LocalDistributedCacheManager;
import org.apache.hadoop.mapred.LocalJobRunnerMetrics;
import org.apache.hadoop.mapred.MROutputFiles;
import org.apache.hadoop.mapred.MapOutputFile;
import org.apache.hadoop.mapred.MapTask;
import org.apache.hadoop.mapred.MapTaskCompletionEventsUpdate;
import org.apache.hadoop.mapred.ReduceTask;
import org.apache.hadoop.mapred.SortedRanges;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.ClusterMetrics;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.QueueAclsInfo;
import org.apache.hadoop.mapreduce.QueueInfo;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskReport;
import org.apache.hadoop.mapreduce.TaskTrackerInfo;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.protocol.ClientProtocol;
import org.apache.hadoop.mapreduce.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.mapreduce.split.JobSplit;
import org.apache.hadoop.mapreduce.split.SplitMetaInfoReader;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.hadoop.mapreduce.v2.LogParams;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.ReflectionUtils;
import org.spark-project.guava.util.concurrent.ThreadFactoryBuilder;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class LocalJobRunner
implements ClientProtocol {
    public static final Log LOG = LogFactory.getLog(LocalJobRunner.class);
    public static final String LOCAL_MAX_MAPS = "mapreduce.local.map.tasks.maximum";
    private FileSystem fs;
    private HashMap<JobID, Job> jobs = new HashMap();
    private JobConf conf;
    private AtomicInteger map_tasks = new AtomicInteger(0);
    private int reduce_tasks = 0;
    final Random rand = new Random();
    private LocalJobRunnerMetrics myMetrics = null;
    private static final String jobDir = "localRunner/";
    private static int jobid = 0;
    private int randid;
    static final String TASK_CLEANUP_SUFFIX = ".cleanup";
    static final String JOBCACHE = "jobcache";

    @Override
    public long getProtocolVersion(String protocol, long clientVersion) {
        return 37L;
    }

    @Override
    public ProtocolSignature getProtocolSignature(String protocol, long clientVersion, int clientMethodsHash) throws IOException {
        return ProtocolSignature.getProtocolSignature(this, protocol, clientVersion, clientMethodsHash);
    }

    public LocalJobRunner(Configuration conf) throws IOException {
        this(new JobConf(conf));
    }

    @Deprecated
    public LocalJobRunner(JobConf conf) throws IOException {
        this.fs = FileSystem.getLocal(conf);
        this.conf = conf;
        this.myMetrics = new LocalJobRunnerMetrics(new JobConf(conf));
    }

    @Override
    public synchronized org.apache.hadoop.mapreduce.JobID getNewJobID() {
        return new org.apache.hadoop.mapreduce.JobID("local" + this.randid, ++jobid);
    }

    @Override
    public JobStatus submitJob(org.apache.hadoop.mapreduce.JobID jobid, String jobSubmitDir, Credentials credentials) throws IOException {
        Job job = new Job(JobID.downgrade(jobid), jobSubmitDir);
        job.job.setCredentials(credentials);
        return job.status;
    }

    @Override
    public void killJob(org.apache.hadoop.mapreduce.JobID id) {
        this.jobs.get((Object)JobID.downgrade((org.apache.hadoop.mapreduce.JobID)id)).killed = true;
        this.jobs.get(JobID.downgrade(id)).interrupt();
    }

    @Override
    public void setJobPriority(org.apache.hadoop.mapreduce.JobID id, String jp) throws IOException {
        throw new UnsupportedOperationException("Changing job priority in LocalJobRunner is not supported.");
    }

    @Override
    public boolean killTask(TaskAttemptID taskId, boolean shouldFail) throws IOException {
        throw new UnsupportedOperationException("Killing tasks in LocalJobRunner is not supported");
    }

    @Override
    public TaskReport[] getTaskReports(org.apache.hadoop.mapreduce.JobID id, TaskType type) {
        return new TaskReport[0];
    }

    @Override
    public JobStatus getJobStatus(org.apache.hadoop.mapreduce.JobID id) {
        Job job = this.jobs.get(JobID.downgrade(id));
        if (job != null) {
            return job.status;
        }
        return null;
    }

    @Override
    public Counters getJobCounters(org.apache.hadoop.mapreduce.JobID id) {
        Job job = this.jobs.get(JobID.downgrade(id));
        return new Counters(job.getCurrentCounters());
    }

    @Override
    public String getFilesystemName() throws IOException {
        return this.fs.getUri().toString();
    }

    @Override
    public ClusterMetrics getClusterMetrics() {
        int numMapTasks = this.map_tasks.get();
        return new ClusterMetrics(numMapTasks, this.reduce_tasks, numMapTasks, this.reduce_tasks, 0, 0, 1, 1, this.jobs.size(), 1, 0, 0);
    }

    @Override
    public Cluster.JobTrackerStatus getJobTrackerStatus() {
        return Cluster.JobTrackerStatus.RUNNING;
    }

    @Override
    public long getTaskTrackerExpiryInterval() throws IOException, InterruptedException {
        return 0L;
    }

    @Override
    public TaskTrackerInfo[] getActiveTrackers() throws IOException, InterruptedException {
        return new TaskTrackerInfo[0];
    }

    @Override
    public TaskTrackerInfo[] getBlacklistedTrackers() throws IOException, InterruptedException {
        return new TaskTrackerInfo[0];
    }

    @Override
    public org.apache.hadoop.mapreduce.TaskCompletionEvent[] getTaskCompletionEvents(org.apache.hadoop.mapreduce.JobID jobid, int fromEventId, int maxEvents) throws IOException {
        return org.apache.hadoop.mapreduce.TaskCompletionEvent.EMPTY_ARRAY;
    }

    @Override
    public JobStatus[] getAllJobs() {
        return null;
    }

    @Override
    public String[] getTaskDiagnostics(TaskAttemptID taskid) throws IOException {
        return new String[0];
    }

    @Override
    public String getSystemDir() {
        Path sysDir = new Path(this.conf.get("mapreduce.jobtracker.system.dir", "/tmp/hadoop/mapred/system"));
        return this.fs.makeQualified(sysDir).toString();
    }

    @Override
    public AccessControlList getQueueAdmins(String queueName) throws IOException {
        return new AccessControlList(" ");
    }

    @Override
    public String getStagingAreaDir() throws IOException {
        Path stagingRootDir = new Path(this.conf.get("mapreduce.jobtracker.staging.root.dir", "/tmp/hadoop/mapred/staging"));
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        this.randid = this.rand.nextInt(Integer.MAX_VALUE);
        String user = ugi != null ? ugi.getShortUserName() + this.randid : "dummy" + this.randid;
        return this.fs.makeQualified(new Path(stagingRootDir, user + "/.staging")).toString();
    }

    @Override
    public String getJobHistoryDir() {
        return null;
    }

    @Override
    public QueueInfo[] getChildQueues(String queueName) throws IOException {
        return null;
    }

    @Override
    public QueueInfo[] getRootQueues() throws IOException {
        return null;
    }

    @Override
    public QueueInfo[] getQueues() throws IOException {
        return null;
    }

    @Override
    public QueueInfo getQueue(String queue) throws IOException {
        return null;
    }

    @Override
    public QueueAclsInfo[] getQueueAclsForCurrentUser() throws IOException {
        return null;
    }

    public static void setLocalMaxRunningMaps(JobContext job, int maxMaps) {
        job.getConfiguration().setInt(LOCAL_MAX_MAPS, maxMaps);
    }

    public static int getLocalMaxRunningMaps(JobContext job) {
        return job.getConfiguration().getInt(LOCAL_MAX_MAPS, 1);
    }

    @Override
    public void cancelDelegationToken(Token<DelegationTokenIdentifier> token2) throws IOException, InterruptedException {
    }

    @Override
    public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException, InterruptedException {
        return null;
    }

    @Override
    public long renewDelegationToken(Token<DelegationTokenIdentifier> token2) throws IOException, InterruptedException {
        return 0L;
    }

    @Override
    public LogParams getLogFileParams(org.apache.hadoop.mapreduce.JobID jobID, TaskAttemptID taskAttemptID) throws IOException, InterruptedException {
        throw new UnsupportedOperationException("Not supported");
    }

    static void setupChildMapredLocalDirs(Task t, JobConf conf) {
        String[] localDirs = conf.getTrimmedStrings("mapreduce.cluster.local.dir");
        String jobId = t.getJobID().toString();
        String taskId = t.getTaskID().toString();
        boolean isCleanup = t.isTaskCleanupTask();
        String user = t.getUser();
        StringBuffer childMapredLocalDir = new StringBuffer(localDirs[0] + "/" + LocalJobRunner.getLocalTaskDir(user, jobId, taskId, isCleanup));
        for (int i = 1; i < localDirs.length; ++i) {
            childMapredLocalDir.append("," + localDirs[i] + "/" + LocalJobRunner.getLocalTaskDir(user, jobId, taskId, isCleanup));
        }
        LOG.debug((Object)("mapreduce.cluster.local.dir for child : " + childMapredLocalDir));
        conf.set("mapreduce.cluster.local.dir", childMapredLocalDir.toString());
    }

    static String getLocalTaskDir(String user, String jobid, String taskid, boolean isCleanupAttempt) {
        String taskDir = "localRunner//" + user + "/" + JOBCACHE + "/" + jobid + "/" + taskid;
        if (isCleanupAttempt) {
            taskDir = taskDir + TASK_CLEANUP_SUFFIX;
        }
        return taskDir;
    }

    private class Job
    extends Thread
    implements TaskUmbilicalProtocol {
        private Path systemJobDir;
        private Path systemJobFile;
        private Path localJobDir;
        private Path localJobFile;
        private JobID id;
        private JobConf job;
        private int numMapTasks;
        private float[] partialMapProgress;
        private org.apache.hadoop.mapred.Counters[] mapCounters;
        private org.apache.hadoop.mapred.Counters reduceCounters;
        private org.apache.hadoop.mapred.JobStatus status;
        private List<org.apache.hadoop.mapred.TaskAttemptID> mapIds = Collections.synchronizedList(new ArrayList());
        private JobProfile profile;
        private FileSystem localFs;
        boolean killed = false;
        private LocalDistributedCacheManager localDistributedCacheManager;

        @Override
        public long getProtocolVersion(String protocol, long clientVersion) {
            return 19L;
        }

        @Override
        public ProtocolSignature getProtocolSignature(String protocol, long clientVersion, int clientMethodsHash) throws IOException {
            return ProtocolSignature.getProtocolSignature(this, protocol, clientVersion, clientMethodsHash);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Job(JobID jobid, String jobSubmitDir) throws IOException {
            this.systemJobDir = new Path(jobSubmitDir);
            this.systemJobFile = new Path(this.systemJobDir, "job.xml");
            this.id = jobid;
            JobConf conf = new JobConf(this.systemJobFile);
            this.localFs = FileSystem.getLocal(conf);
            String user = UserGroupInformation.getCurrentUser().getShortUserName();
            this.localJobDir = this.localFs.makeQualified(new Path(new Path(conf.getLocalPath(LocalJobRunner.jobDir), user), jobid.toString()));
            this.localJobFile = new Path(this.localJobDir, this.id + ".xml");
            this.localDistributedCacheManager = new LocalDistributedCacheManager();
            this.localDistributedCacheManager.setup(conf);
            FSDataOutputStream out = this.localFs.create(this.localJobFile);
            try {
                conf.writeXml(out);
            }
            finally {
                ((OutputStream)out).close();
            }
            this.job = new JobConf(this.localJobFile);
            if (this.localDistributedCacheManager.hasLocalClasspaths()) {
                this.setContextClassLoader(this.localDistributedCacheManager.makeClassLoader(this.getContextClassLoader()));
            }
            this.profile = new JobProfile(this.job.getUser(), this.id, this.systemJobFile.toString(), "http://localhost:8080/", this.job.getJobName());
            this.status = new org.apache.hadoop.mapred.JobStatus(this.id, 0.0f, 0.0f, org.apache.hadoop.mapred.JobStatus.RUNNING, this.profile.getUser(), this.profile.getJobName(), this.profile.getJobFile(), this.profile.getURL().toString());
            LocalJobRunner.this.jobs.put(this.id, this);
            this.start();
        }

        protected List<MapTaskRunnable> getMapTaskRunnables(JobSplit.TaskSplitMetaInfo[] taskInfo, JobID jobId, Map<org.apache.hadoop.mapred.TaskAttemptID, MapOutputFile> mapOutputFiles) {
            int numTasks = 0;
            ArrayList<MapTaskRunnable> list = new ArrayList<MapTaskRunnable>();
            for (JobSplit.TaskSplitMetaInfo task : taskInfo) {
                list.add(new MapTaskRunnable(task, numTasks++, jobId, mapOutputFiles));
            }
            return list;
        }

        private synchronized void initCounters(int numMaps) {
            this.partialMapProgress = new float[numMaps];
            this.mapCounters = new org.apache.hadoop.mapred.Counters[numMaps];
            for (int i = 0; i < numMaps; ++i) {
                this.mapCounters[i] = new org.apache.hadoop.mapred.Counters();
            }
            this.reduceCounters = new org.apache.hadoop.mapred.Counters();
        }

        protected ExecutorService createMapExecutor(int numMapTasks) {
            int maxMapThreads = this.job.getInt(LocalJobRunner.LOCAL_MAX_MAPS, 1);
            if (maxMapThreads < 1) {
                throw new IllegalArgumentException("Configured mapreduce.local.map.tasks.maximum must be >= 1");
            }
            this.numMapTasks = numMapTasks;
            maxMapThreads = Math.min(maxMapThreads, this.numMapTasks);
            maxMapThreads = Math.max(maxMapThreads, 1);
            this.initCounters(this.numMapTasks);
            LOG.debug((Object)"Starting thread pool executor.");
            LOG.debug((Object)("Max local threads: " + maxMapThreads));
            LOG.debug((Object)("Map tasks to process: " + this.numMapTasks));
            ThreadFactory tf = new ThreadFactoryBuilder().setNameFormat("LocalJobRunner Map Task Executor #%d").build();
            ExecutorService executor = Executors.newFixedThreadPool(maxMapThreads, tf);
            return executor;
        }

        private OutputCommitter createOutputCommitter(boolean newApiCommitter, JobID jobId, Configuration conf) throws Exception {
            OutputCommitter committer = null;
            LOG.info((Object)("OutputCommitter set in config " + conf.get("mapred.output.committer.class")));
            if (newApiCommitter) {
                org.apache.hadoop.mapreduce.TaskID taskId = new org.apache.hadoop.mapreduce.TaskID((org.apache.hadoop.mapreduce.JobID)jobId, TaskType.MAP, 0);
                TaskAttemptID taskAttemptID = new TaskAttemptID(taskId, 0);
                TaskAttemptContextImpl taskContext = new TaskAttemptContextImpl(conf, taskAttemptID);
                OutputFormat<?, ?> outputFormat = ReflectionUtils.newInstance(taskContext.getOutputFormatClass(), conf);
                committer = outputFormat.getOutputCommitter(taskContext);
            } else {
                committer = ReflectionUtils.newInstance(conf.getClass("mapred.output.committer.class", FileOutputCommitter.class, org.apache.hadoop.mapred.OutputCommitter.class), conf);
            }
            LOG.info((Object)("OutputCommitter is " + committer.getClass().getName()));
            return committer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            JobID jobId = this.profile.getJobID();
            JobContextImpl jContext = new JobContextImpl(this.job, (org.apache.hadoop.mapreduce.JobID)jobId);
            OutputCommitter outputCommitter = null;
            try {
                outputCommitter = this.createOutputCommitter(LocalJobRunner.this.conf.getUseNewMapper(), jobId, LocalJobRunner.this.conf);
            }
            catch (Exception e) {
                LOG.info((Object)"Failed to createOutputCommitter", (Throwable)e);
                return;
            }
            try {
                block32: {
                    JobSplit.TaskSplitMetaInfo[] taskSplitMetaInfos = SplitMetaInfoReader.readSplitMetaInfo(jobId, this.localFs, LocalJobRunner.this.conf, this.systemJobDir);
                    int numReduceTasks = this.job.getNumReduceTasks();
                    if (numReduceTasks > 1 || numReduceTasks < 0) {
                        numReduceTasks = 1;
                        this.job.setNumReduceTasks(1);
                    }
                    outputCommitter.setupJob(jContext);
                    this.status.setSetupProgress(1.0f);
                    Map<org.apache.hadoop.mapred.TaskAttemptID, MapOutputFile> mapOutputFiles = Collections.synchronizedMap(new HashMap());
                    List<MapTaskRunnable> taskRunnables = this.getMapTaskRunnables(taskSplitMetaInfos, jobId, mapOutputFiles);
                    ExecutorService mapService = this.createMapExecutor(taskRunnables.size());
                    for (MapTaskRunnable r : taskRunnables) {
                        mapService.submit(r);
                    }
                    try {
                        mapService.shutdown();
                        LOG.info((Object)"Waiting for map tasks");
                        mapService.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
                    }
                    catch (InterruptedException ie) {
                        mapService.shutdownNow();
                        throw ie;
                    }
                    LOG.info((Object)"Map task executor complete.");
                    for (MapTaskRunnable r : taskRunnables) {
                        if (r.storedException == null) continue;
                        throw new Exception(r.storedException);
                    }
                    org.apache.hadoop.mapred.TaskAttemptID reduceId = new org.apache.hadoop.mapred.TaskAttemptID(new TaskID((org.apache.hadoop.mapreduce.JobID)jobId, TaskType.REDUCE, 0), 0);
                    try {
                        if (numReduceTasks <= 0) break block32;
                        ReduceTask reduce2 = new ReduceTask(this.systemJobFile.toString(), reduceId, 0, this.mapIds.size(), 1);
                        reduce2.setUser(UserGroupInformation.getCurrentUser().getShortUserName());
                        JobConf localConf = new JobConf(this.job);
                        localConf.set("mapreduce.jobtracker.address", "local");
                        LocalJobRunner.setupChildMapredLocalDirs(reduce2, localConf);
                        for (int i = 0; i < this.mapIds.size(); ++i) {
                            if (!this.isInterrupted()) {
                                org.apache.hadoop.mapred.TaskAttemptID mapId = this.mapIds.get(i);
                                Path mapOut = mapOutputFiles.get(mapId).getOutputFile();
                                MROutputFiles localOutputFile = new MROutputFiles();
                                ((MapOutputFile)localOutputFile).setConf(localConf);
                                Path reduceIn = ((MapOutputFile)localOutputFile).getInputFileForWrite(mapId.getTaskID(), this.localFs.getFileStatus(mapOut).getLen());
                                if (!this.localFs.mkdirs(reduceIn.getParent())) {
                                    throw new IOException("Mkdirs failed to create " + reduceIn.getParent().toString());
                                }
                                if (this.localFs.rename(mapOut, reduceIn)) continue;
                                throw new IOException("Couldn't rename " + mapOut);
                            }
                            throw new InterruptedException();
                        }
                        if (!this.isInterrupted()) {
                            reduce2.setJobFile(this.localJobFile.toString());
                            localConf.setUser(reduce2.getUser());
                            reduce2.localizeConfiguration(localConf);
                            reduce2.setConf(localConf);
                            LocalJobRunner.this.reduce_tasks += 1;
                            LocalJobRunner.this.myMetrics.launchReduce(reduce2.getTaskID());
                            reduce2.run(localConf, this);
                            LocalJobRunner.this.myMetrics.completeReduce(reduce2.getTaskID());
                            LocalJobRunner.this.reduce_tasks -= 1;
                            break block32;
                        }
                        throw new InterruptedException();
                    }
                    finally {
                        for (MapOutputFile output : mapOutputFiles.values()) {
                            output.removeAll();
                        }
                    }
                }
                outputCommitter.commitJob(jContext);
                this.status.setCleanupProgress(1.0f);
                if (this.killed) {
                    this.status.setRunState(org.apache.hadoop.mapred.JobStatus.KILLED);
                } else {
                    this.status.setRunState(org.apache.hadoop.mapred.JobStatus.SUCCEEDED);
                }
                JobEndNotifier.localRunnerNotification(this.job, this.status);
            }
            catch (Throwable t) {
                try {
                    outputCommitter.abortJob(jContext, JobStatus.State.FAILED);
                }
                catch (IOException ioe) {
                    LOG.info((Object)("Error cleaning up job:" + this.id));
                }
                this.status.setCleanupProgress(1.0f);
                if (this.killed) {
                    this.status.setRunState(org.apache.hadoop.mapred.JobStatus.KILLED);
                } else {
                    this.status.setRunState(org.apache.hadoop.mapred.JobStatus.FAILED);
                }
                LOG.warn((Object)this.id, t);
                JobEndNotifier.localRunnerNotification(this.job, this.status);
            }
            finally {
                try {
                    LocalJobRunner.this.fs.delete(this.systemJobFile.getParent(), true);
                    this.localFs.delete(this.localJobFile, true);
                    this.localDistributedCacheManager.close();
                }
                catch (IOException e) {
                    LOG.warn((Object)("Error cleaning up " + this.id + ": " + e));
                }
            }
        }

        @Override
        public JvmTask getTask(JvmContext context) {
            return null;
        }

        @Override
        public synchronized boolean statusUpdate(org.apache.hadoop.mapred.TaskAttemptID taskId, TaskStatus taskStatus) throws IOException, InterruptedException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            taskStatus.write(dos);
            dos.close();
            taskStatus = TaskStatus.createTaskStatus(taskStatus.getIsMap());
            taskStatus.readFields(new DataInputStream(new ByteArrayInputStream(baos.toByteArray())));
            LOG.info((Object)taskStatus.getStateString());
            int taskIndex = this.mapIds.indexOf(taskId);
            if (taskIndex >= 0) {
                float numTasks = this.numMapTasks;
                this.partialMapProgress[taskIndex] = taskStatus.getProgress();
                this.mapCounters[taskIndex] = taskStatus.getCounters();
                float partialProgress = 0.0f;
                for (float f : this.partialMapProgress) {
                    partialProgress += f;
                }
                this.status.setMapProgress(partialProgress / numTasks);
            } else {
                this.reduceCounters = taskStatus.getCounters();
                this.status.setReduceProgress(taskStatus.getProgress());
            }
            return true;
        }

        public synchronized org.apache.hadoop.mapred.Counters getCurrentCounters() {
            if (null == this.mapCounters) {
                return new org.apache.hadoop.mapred.Counters();
            }
            org.apache.hadoop.mapred.Counters current = new org.apache.hadoop.mapred.Counters();
            for (org.apache.hadoop.mapred.Counters c : this.mapCounters) {
                current = org.apache.hadoop.mapred.Counters.sum(current, c);
            }
            current = org.apache.hadoop.mapred.Counters.sum(current, this.reduceCounters);
            return current;
        }

        @Override
        public void commitPending(org.apache.hadoop.mapred.TaskAttemptID taskid, TaskStatus taskStatus) throws IOException, InterruptedException {
            this.statusUpdate(taskid, taskStatus);
        }

        @Override
        public void reportDiagnosticInfo(org.apache.hadoop.mapred.TaskAttemptID taskid, String trace) {
        }

        @Override
        public void reportNextRecordRange(org.apache.hadoop.mapred.TaskAttemptID taskid, SortedRanges.Range range2) throws IOException {
            LOG.info((Object)("Task " + taskid + " reportedNextRecordRange " + range2));
        }

        @Override
        public boolean ping(org.apache.hadoop.mapred.TaskAttemptID taskid) throws IOException {
            return true;
        }

        @Override
        public boolean canCommit(org.apache.hadoop.mapred.TaskAttemptID taskid) throws IOException {
            return true;
        }

        @Override
        public void done(org.apache.hadoop.mapred.TaskAttemptID taskId) throws IOException {
            int taskIndex = this.mapIds.indexOf(taskId);
            if (taskIndex >= 0) {
                this.status.setMapProgress(1.0f);
            } else {
                this.status.setReduceProgress(1.0f);
            }
        }

        @Override
        public synchronized void fsError(org.apache.hadoop.mapred.TaskAttemptID taskId, String message) throws IOException {
            LOG.fatal((Object)("FSError: " + message + "from task: " + taskId));
        }

        @Override
        public void shuffleError(org.apache.hadoop.mapred.TaskAttemptID taskId, String message) throws IOException {
            LOG.fatal((Object)("shuffleError: " + message + "from task: " + taskId));
        }

        @Override
        public synchronized void fatalError(org.apache.hadoop.mapred.TaskAttemptID taskId, String msg) throws IOException {
            LOG.fatal((Object)("Fatal: " + msg + "from task: " + taskId));
        }

        @Override
        public MapTaskCompletionEventsUpdate getMapCompletionEvents(JobID jobId, int fromEventId, int maxLocs, org.apache.hadoop.mapred.TaskAttemptID id) throws IOException {
            return new MapTaskCompletionEventsUpdate(TaskCompletionEvent.EMPTY_ARRAY, false);
        }

        protected class MapTaskRunnable
        implements Runnable {
            private final int taskId;
            private final JobSplit.TaskSplitMetaInfo info;
            private final JobID jobId;
            private final JobConf localConf;
            private final Map<org.apache.hadoop.mapred.TaskAttemptID, MapOutputFile> mapOutputFiles;
            public volatile Throwable storedException;

            public MapTaskRunnable(JobSplit.TaskSplitMetaInfo info, int taskId, JobID jobId, Map<org.apache.hadoop.mapred.TaskAttemptID, MapOutputFile> mapOutputFiles) {
                this.info = info;
                this.taskId = taskId;
                this.mapOutputFiles = mapOutputFiles;
                this.jobId = jobId;
                this.localConf = new JobConf(Job.this.job);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    org.apache.hadoop.mapred.TaskAttemptID mapId = new org.apache.hadoop.mapred.TaskAttemptID(new TaskID((org.apache.hadoop.mapreduce.JobID)this.jobId, TaskType.MAP, this.taskId), 0);
                    LOG.info((Object)("Starting task: " + mapId));
                    Job.this.mapIds.add(mapId);
                    MapTask map2 = new MapTask(Job.this.systemJobFile.toString(), mapId, this.taskId, this.info.getSplitIndex(), 1);
                    map2.setUser(UserGroupInformation.getCurrentUser().getShortUserName());
                    LocalJobRunner.setupChildMapredLocalDirs(map2, this.localConf);
                    MROutputFiles mapOutput = new MROutputFiles();
                    ((MapOutputFile)mapOutput).setConf(this.localConf);
                    this.mapOutputFiles.put(mapId, mapOutput);
                    map2.setJobFile(Job.this.localJobFile.toString());
                    this.localConf.setUser(map2.getUser());
                    map2.localizeConfiguration(this.localConf);
                    map2.setConf(this.localConf);
                    try {
                        LocalJobRunner.this.map_tasks.getAndIncrement();
                        LocalJobRunner.this.myMetrics.launchMap(mapId);
                        map2.run(this.localConf, Job.this);
                        LocalJobRunner.this.myMetrics.completeMap(mapId);
                    }
                    finally {
                        LocalJobRunner.this.map_tasks.getAndDecrement();
                    }
                    LOG.info((Object)("Finishing task: " + mapId));
                }
                catch (Throwable e) {
                    this.storedException = e;
                }
            }
        }
    }
}

