/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web.resources;

import org.apache.hadoop.hdfs.web.resources.Param;

abstract class LongParam
extends Param<Long, Domain> {
    LongParam(Domain domain, Long value2, Long min2, Long max2) {
        super(domain, value2);
        this.checkRange(min2, max2);
    }

    private void checkRange(Long min2, Long max2) {
        if (this.value == null) {
            return;
        }
        if (min2 != null && (Long)this.value < min2) {
            throw new IllegalArgumentException("Invalid parameter range: " + this.getName() + " = " + ((Domain)this.domain).toString((Long)this.value) + " < " + ((Domain)this.domain).toString(min2));
        }
        if (max2 != null && (Long)this.value > max2) {
            throw new IllegalArgumentException("Invalid parameter range: " + this.getName() + " = " + ((Domain)this.domain).toString((Long)this.value) + " > " + ((Domain)this.domain).toString(max2));
        }
    }

    @Override
    public String toString() {
        return this.getName() + "=" + ((Domain)this.domain).toString((Long)this.getValue());
    }

    @Override
    public String getValueString() {
        return ((Domain)this.domain).toString((Long)this.getValue());
    }

    static final class Domain
    extends Param.Domain<Long> {
        final int radix;

        Domain(String paramName) {
            this(paramName, 10);
        }

        Domain(String paramName, int radix) {
            super(paramName);
            this.radix = radix;
        }

        @Override
        public String getDomain() {
            return "<null | long in radix " + this.radix + ">";
        }

        @Override
        Long parse(String str) {
            try {
                return "null".equals(str) ? null : Long.valueOf(Long.parseLong(str, this.radix));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Failed to parse \"" + str + "\" as a radix-" + this.radix + " long integer.", e);
            }
        }

        String toString(Long n) {
            return n == null ? "null" : Long.toString(n, this.radix);
        }
    }
}

