/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web.resources;

import com.sun.jersey.api.ParamException;
import com.sun.jersey.api.container.ContainerException;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.web.JsonUtil;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.authorize.AuthorizationException;

@Provider
public class ExceptionHandler
implements ExceptionMapper<Exception> {
    public static final Log LOG = LogFactory.getLog(ExceptionHandler.class);
    @Context
    private HttpServletResponse response;

    private static Exception toCause(Exception e) {
        Throwable t = e.getCause();
        if (t != null && t instanceof Exception) {
            e = (Exception)e.getCause();
        }
        return e;
    }

    @Override
    public Response toResponse(Exception e) {
        Response.Status s2;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"GOT EXCEPITION", (Throwable)e);
        }
        this.response.setContentType(null);
        if (e instanceof ParamException) {
            ParamException paramexception = (ParamException)e;
            e = new IllegalArgumentException("Invalid value for webhdfs parameter \"" + paramexception.getParameterName() + "\": " + e.getCause().getMessage(), e);
        }
        if (e instanceof ContainerException) {
            e = ExceptionHandler.toCause(e);
        }
        if (e instanceof RemoteException) {
            e = ((RemoteException)e).unwrapRemoteException();
        }
        if (e instanceof SecurityException) {
            s2 = Response.Status.UNAUTHORIZED;
        } else if (e instanceof AuthorizationException) {
            s2 = Response.Status.UNAUTHORIZED;
        } else if (e instanceof FileNotFoundException) {
            s2 = Response.Status.NOT_FOUND;
        } else if (e instanceof IOException) {
            s2 = Response.Status.FORBIDDEN;
        } else if (e instanceof UnsupportedOperationException) {
            s2 = Response.Status.BAD_REQUEST;
        } else if (e instanceof IllegalArgumentException) {
            s2 = Response.Status.BAD_REQUEST;
        } else {
            LOG.warn((Object)"INTERNAL_SERVER_ERROR", (Throwable)e);
            s2 = Response.Status.INTERNAL_SERVER_ERROR;
        }
        String js = JsonUtil.toJsonString(e);
        return Response.status(s2).type("application/json").entity(js).build();
    }
}

