/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.util.AtomicFileOutputStream;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.util.StringUtils;
import org.spark-project.guava.base.Charsets;

public abstract class MD5FileUtils {
    private static final Log LOG = LogFactory.getLog(MD5FileUtils.class);
    public static final String MD5_SUFFIX = ".md5";
    private static final Pattern LINE_REGEX = Pattern.compile("([0-9a-f]{32}) [ \\*](.+)");

    public static void verifySavedMD5(File dataFile, MD5Hash expectedMD5) throws IOException {
        MD5Hash storedHash = MD5FileUtils.readStoredMd5ForFile(dataFile);
        if (!expectedMD5.equals(storedHash)) {
            throw new IOException("File " + dataFile + " did not match stored MD5 checksum " + " (stored: " + storedHash + ", computed: " + expectedMD5);
        }
    }

    public static MD5Hash readStoredMd5ForFile(File dataFile) throws IOException {
        String md5Line;
        File md5File = MD5FileUtils.getDigestFileForFile(dataFile);
        if (!md5File.exists()) {
            return null;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(md5File), Charsets.UTF_8));
        try {
            md5Line = reader.readLine();
            if (md5Line == null) {
                md5Line = "";
            }
            md5Line = md5Line.trim();
        }
        catch (IOException ioe) {
            try {
                throw new IOException("Error reading md5 file at " + md5File, ioe);
            }
            catch (Throwable throwable) {
                IOUtils.cleanup(LOG, reader);
                throw throwable;
            }
        }
        IOUtils.cleanup(LOG, reader);
        Matcher matcher = LINE_REGEX.matcher(md5Line);
        if (!matcher.matches()) {
            throw new IOException("Invalid MD5 file at " + md5File + " (does not match expected pattern)");
        }
        String storedHash = matcher.group(1);
        File referencedFile = new File(matcher.group(2));
        if (!referencedFile.getName().equals(dataFile.getName())) {
            throw new IOException("MD5 file at " + md5File + " references file named " + referencedFile.getName() + " but we expected it to reference " + dataFile);
        }
        return new MD5Hash(storedHash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MD5Hash computeMd5ForFile(File dataFile) throws IOException {
        FileInputStream in = new FileInputStream(dataFile);
        try {
            MessageDigest digester = MD5Hash.getDigester();
            DigestInputStream dis = new DigestInputStream(in, digester);
            IOUtils.copyBytes((InputStream)dis, (OutputStream)new IOUtils.NullOutputStream(), 131072);
            MD5Hash mD5Hash = new MD5Hash(digester.digest());
            return mD5Hash;
        }
        finally {
            IOUtils.closeStream(in);
        }
    }

    public static void saveMD5File(File dataFile, MD5Hash digest) throws IOException {
        File md5File = MD5FileUtils.getDigestFileForFile(dataFile);
        String digestString = StringUtils.byteToHexString(digest.getDigest());
        String md5Line = digestString + " *" + dataFile.getName() + "\n";
        AtomicFileOutputStream afos = new AtomicFileOutputStream(md5File);
        afos.write(md5Line.getBytes(Charsets.UTF_8));
        afos.close();
        LOG.debug((Object)("Saved MD5 " + digest + " to " + md5File));
    }

    public static File getDigestFileForFile(File file) {
        return new File(file.getParentFile(), file.getName() + MD5_SUFFIX);
    }
}

