/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.spark-project.guava.annotations.VisibleForTesting;

@InterfaceAudience.Private
public class DirectBufferPool {
    ConcurrentMap<Integer, Queue<WeakReference<ByteBuffer>>> buffersBySize = new ConcurrentHashMap<Integer, Queue<WeakReference<ByteBuffer>>>();

    public ByteBuffer getBuffer(int size2) {
        WeakReference ref;
        Queue list = (Queue)this.buffersBySize.get(size2);
        if (list == null) {
            return ByteBuffer.allocateDirect(size2);
        }
        while ((ref = (WeakReference)list.poll()) != null) {
            ByteBuffer b = (ByteBuffer)ref.get();
            if (b == null) continue;
            return b;
        }
        return ByteBuffer.allocateDirect(size2);
    }

    public void returnBuffer(ByteBuffer buf) {
        buf.clear();
        int size2 = buf.capacity();
        Queue<WeakReference<ByteBuffer>> list = (ConcurrentLinkedQueue<WeakReference<ByteBuffer>>)this.buffersBySize.get(size2);
        if (list == null) {
            list = new ConcurrentLinkedQueue<WeakReference<ByteBuffer>>();
            Queue prev = this.buffersBySize.putIfAbsent(size2, list);
            if (prev != null) {
                list = prev;
            }
        }
        list.add(new WeakReference<ByteBuffer>(buf));
    }

    @VisibleForTesting
    int countBuffersOfSize(int size2) {
        Queue list = (Queue)this.buffersBySize.get(size2);
        if (list == null) {
            return 0;
        }
        return list.size();
    }
}

