/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.FSImageStorageInspector;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.spark-project.guava.collect.ImmutableList;

class FSImageTransactionalStorageInspector
extends FSImageStorageInspector {
    public static final Log LOG = LogFactory.getLog(FSImageTransactionalStorageInspector.class);
    private boolean needToSave = false;
    private boolean isUpgradeFinalized = true;
    List<FSImageStorageInspector.FSImageFile> foundImages = new ArrayList<FSImageStorageInspector.FSImageFile>();
    private long maxSeenTxId = 0L;
    private static final Pattern IMAGE_REGEX = Pattern.compile(NNStorage.NameNodeFile.IMAGE.getName() + "_(\\d+)");

    FSImageTransactionalStorageInspector() {
    }

    @Override
    public void inspectDirectory(Storage.StorageDirectory sd) throws IOException {
        File[] filesInStorage;
        if (!sd.getVersionFile().exists()) {
            LOG.info((Object)("No version file in " + sd.getRoot()));
            this.needToSave |= true;
            return;
        }
        try {
            this.maxSeenTxId = Math.max(this.maxSeenTxId, NNStorage.readTransactionIdFile(sd));
        }
        catch (IOException ioe) {
            LOG.warn((Object)("Unable to determine the max transaction ID seen by " + sd), (Throwable)ioe);
            return;
        }
        File currentDir = sd.getCurrentDir();
        try {
            filesInStorage = FileUtil.listFiles(currentDir);
        }
        catch (IOException ioe) {
            LOG.warn((Object)("Unable to inspect storage directory " + currentDir), (Throwable)ioe);
            return;
        }
        for (File f : filesInStorage) {
            LOG.debug((Object)("Checking file " + f));
            String name = f.getName();
            Matcher imageMatch = IMAGE_REGEX.matcher(name);
            if (!imageMatch.matches()) continue;
            if (sd.getStorageDirType().isOfType(NNStorage.NameNodeDirType.IMAGE)) {
                try {
                    long txid = Long.valueOf(imageMatch.group(1));
                    this.foundImages.add(new FSImageStorageInspector.FSImageFile(sd, f, txid));
                }
                catch (NumberFormatException nfe) {
                    LOG.error((Object)("Image file " + f + " has improperly formatted " + "transaction ID"));
                }
                continue;
            }
            LOG.warn((Object)("Found image file at " + f + " but storage directory is " + "not configured to contain images."));
        }
        this.isUpgradeFinalized = this.isUpgradeFinalized && !sd.getPreviousDir().exists();
    }

    @Override
    public boolean isUpgradeFinalized() {
        return this.isUpgradeFinalized;
    }

    @Override
    List<FSImageStorageInspector.FSImageFile> getLatestImages() throws IOException {
        LinkedList<FSImageStorageInspector.FSImageFile> ret = new LinkedList<FSImageStorageInspector.FSImageFile>();
        for (FSImageStorageInspector.FSImageFile img : this.foundImages) {
            if (ret.isEmpty()) {
                ret.add(img);
                continue;
            }
            FSImageStorageInspector.FSImageFile cur = ret.getFirst();
            if (cur.txId == img.txId) {
                ret.add(img);
                continue;
            }
            if (cur.txId >= img.txId) continue;
            ret.clear();
            ret.add(img);
        }
        if (ret.isEmpty()) {
            throw new FileNotFoundException("No valid image files found");
        }
        return ret;
    }

    public List<FSImageStorageInspector.FSImageFile> getFoundImages() {
        return ImmutableList.copyOf(this.foundImages);
    }

    @Override
    public boolean needToSave() {
        return this.needToSave;
    }

    @Override
    long getMaxSeenTxId() {
        return this.maxSeenTxId;
    }
}

