/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DeprecatedUTF8;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.LayoutVersion;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoUnderConstruction;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectoryAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeFileAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeFileUnderConstruction;
import org.apache.hadoop.hdfs.server.namenode.INodeReference;
import org.apache.hadoop.hdfs.server.namenode.INodeSymlink;
import org.apache.hadoop.hdfs.server.namenode.snapshot.INodeDirectorySnapshottable;
import org.apache.hadoop.hdfs.server.namenode.snapshot.INodeDirectoryWithSnapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotFSImageFormat;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.ShortWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableUtils;
import org.spark-project.guava.base.Preconditions;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class FSImageSerialization {
    private static final ThreadLocal<TLData> TL_DATA = new ThreadLocal<TLData>(){

        @Override
        protected TLData initialValue() {
            return new TLData();
        }
    };

    private FSImageSerialization() {
    }

    private static void writePermissionStatus(INodeAttributes inode, DataOutput out) throws IOException {
        FsPermission p = FSImageSerialization.TL_DATA.get().FILE_PERM;
        p.fromShort(inode.getFsPermissionShort());
        PermissionStatus.write(out, inode.getUserName(), inode.getGroupName(), p);
    }

    private static void writeBlocks(Block[] blocks, DataOutput out) throws IOException {
        if (blocks == null) {
            out.writeInt(0);
        } else {
            out.writeInt(blocks.length);
            for (Block blk : blocks) {
                blk.write(out);
            }
        }
    }

    static INodeFileUnderConstruction readINodeUnderConstruction(DataInput in, FSNamesystem fsNamesys, int imgVersion) throws IOException {
        byte[] name = FSImageSerialization.readBytes(in);
        long inodeId = LayoutVersion.supports(LayoutVersion.Feature.ADD_INODE_ID, imgVersion) ? in.readLong() : fsNamesys.allocateNewInodeId();
        short blockReplication = in.readShort();
        long modificationTime = in.readLong();
        long preferredBlockSize = in.readLong();
        int numBlocks = in.readInt();
        BlockInfo[] blocks = new BlockInfo[numBlocks];
        Block blk = new Block();
        for (int i = 0; i < numBlocks - 1; ++i) {
            blk.readFields(in);
            blocks[i] = new BlockInfo(blk, blockReplication);
        }
        if (numBlocks > 0) {
            blk.readFields(in);
            blocks[i] = new BlockInfoUnderConstruction(blk, blockReplication, HdfsServerConstants.BlockUCState.UNDER_CONSTRUCTION, null);
        }
        PermissionStatus perm = PermissionStatus.read(in);
        String clientName = FSImageSerialization.readString(in);
        String clientMachine = FSImageSerialization.readString(in);
        int numLocs = in.readInt();
        assert (numLocs == 0) : "Unexpected block locations";
        return new INodeFileUnderConstruction(inodeId, name, blockReplication, modificationTime, preferredBlockSize, blocks, perm, clientName, clientMachine, null);
    }

    static void writeINodeUnderConstruction(DataOutputStream out, INodeFileUnderConstruction cons, String path) throws IOException {
        FSImageSerialization.writeString(path, out);
        out.writeLong(cons.getId());
        out.writeShort(cons.getFileReplication());
        out.writeLong(cons.getModificationTime());
        out.writeLong(cons.getPreferredBlockSize());
        FSImageSerialization.writeBlocks(cons.getBlocks(), out);
        cons.getPermissionStatus().write(out);
        FSImageSerialization.writeString(cons.getClientName(), out);
        FSImageSerialization.writeString(cons.getClientMachine(), out);
        out.writeInt(0);
    }

    public static void writeINodeFile(INodeFile file, DataOutput out, boolean writeUnderConstruction) throws IOException {
        FSImageSerialization.writeLocalName(file, out);
        out.writeLong(file.getId());
        out.writeShort(file.getFileReplication());
        out.writeLong(file.getModificationTime());
        out.writeLong(file.getAccessTime());
        out.writeLong(file.getPreferredBlockSize());
        FSImageSerialization.writeBlocks(file.getBlocks(), out);
        SnapshotFSImageFormat.saveFileDiffList(file, out);
        if (writeUnderConstruction) {
            if (file instanceof INodeFileUnderConstruction) {
                out.writeBoolean(true);
                INodeFileUnderConstruction uc = (INodeFileUnderConstruction)file;
                FSImageSerialization.writeString(uc.getClientName(), out);
                FSImageSerialization.writeString(uc.getClientMachine(), out);
            } else {
                out.writeBoolean(false);
            }
        }
        FSImageSerialization.writePermissionStatus(file, out);
    }

    public static void writeINodeFileAttributes(INodeFileAttributes file, DataOutput out) throws IOException {
        FSImageSerialization.writeLocalName(file, out);
        FSImageSerialization.writePermissionStatus(file, out);
        out.writeLong(file.getModificationTime());
        out.writeLong(file.getAccessTime());
        out.writeShort(file.getFileReplication());
        out.writeLong(file.getPreferredBlockSize());
    }

    public static void writeINodeDirectory(INodeDirectory node, DataOutput out) throws IOException {
        FSImageSerialization.writeLocalName(node, out);
        out.writeLong(node.getId());
        out.writeShort(0);
        out.writeLong(node.getModificationTime());
        out.writeLong(0L);
        out.writeLong(0L);
        out.writeInt(-1);
        out.writeLong(node.getNsQuota());
        out.writeLong(node.getDsQuota());
        if (node instanceof INodeDirectorySnapshottable) {
            out.writeBoolean(true);
        } else {
            out.writeBoolean(false);
            out.writeBoolean(node instanceof INodeDirectoryWithSnapshot);
        }
        FSImageSerialization.writePermissionStatus(node, out);
    }

    public static void writeINodeDirectoryAttributes(INodeDirectoryAttributes a, DataOutput out) throws IOException {
        FSImageSerialization.writeLocalName(a, out);
        FSImageSerialization.writePermissionStatus(a, out);
        out.writeLong(a.getModificationTime());
        out.writeLong(a.getNsQuota());
        out.writeLong(a.getDsQuota());
    }

    private static void writeINodeSymlink(INodeSymlink node, DataOutput out) throws IOException {
        FSImageSerialization.writeLocalName(node, out);
        out.writeLong(node.getId());
        out.writeShort(0);
        out.writeLong(0L);
        out.writeLong(0L);
        out.writeLong(0L);
        out.writeInt(-2);
        Text.writeString(out, node.getSymlinkString());
        FSImageSerialization.writePermissionStatus(node, out);
    }

    private static void writeINodeReference(INodeReference ref, DataOutput out, boolean writeUnderConstruction, SnapshotFSImageFormat.ReferenceMap referenceMap) throws IOException {
        FSImageSerialization.writeLocalName(ref, out);
        out.writeLong(ref.getId());
        out.writeShort(0);
        out.writeLong(0L);
        out.writeLong(0L);
        out.writeLong(0L);
        out.writeInt(-3);
        boolean isWithName = ref instanceof INodeReference.WithName;
        out.writeBoolean(isWithName);
        if (!isWithName) {
            Preconditions.checkState((boolean)(ref instanceof INodeReference.DstReference));
            out.writeInt(((INodeReference.DstReference)ref).getDstSnapshotId());
        } else {
            out.writeInt(((INodeReference.WithName)ref).getLastSnapshotId());
        }
        INodeReference.WithCount withCount = (INodeReference.WithCount)ref.getReferredINode();
        referenceMap.writeINodeReferenceWithCount(withCount, out, writeUnderConstruction);
    }

    public static void saveINode2Image(INode node, DataOutput out, boolean writeUnderConstruction, SnapshotFSImageFormat.ReferenceMap referenceMap) throws IOException {
        if (node.isReference()) {
            FSImageSerialization.writeINodeReference(node.asReference(), out, writeUnderConstruction, referenceMap);
        } else if (node.isDirectory()) {
            FSImageSerialization.writeINodeDirectory(node.asDirectory(), out);
        } else if (node.isSymlink()) {
            FSImageSerialization.writeINodeSymlink(node.asSymlink(), out);
        } else if (node.isFile()) {
            FSImageSerialization.writeINodeFile(node.asFile(), out, writeUnderConstruction);
        }
    }

    public static String readString(DataInput in) throws IOException {
        DeprecatedUTF8 ustr = FSImageSerialization.TL_DATA.get().U_STR;
        ustr.readFields(in);
        return ustr.toStringChecked();
    }

    static String readString_EmptyAsNull(DataInput in) throws IOException {
        String s2 = FSImageSerialization.readString(in);
        return s2.isEmpty() ? null : s2;
    }

    public static void writeString(String str, DataOutput out) throws IOException {
        DeprecatedUTF8 ustr = FSImageSerialization.TL_DATA.get().U_STR;
        ustr.set(str);
        ustr.write(out);
    }

    static long readLong(DataInput in) throws IOException {
        LongWritable uLong = FSImageSerialization.TL_DATA.get().U_LONG;
        uLong.readFields(in);
        return uLong.get();
    }

    static void writeLong(long value2, DataOutputStream out) throws IOException {
        LongWritable uLong = FSImageSerialization.TL_DATA.get().U_LONG;
        uLong.set(value2);
        uLong.write(out);
    }

    static int readInt(DataInput in) throws IOException {
        IntWritable uInt = FSImageSerialization.TL_DATA.get().U_INT;
        uInt.readFields(in);
        return uInt.get();
    }

    static void writeInt(int value2, DataOutputStream out) throws IOException {
        IntWritable uInt = FSImageSerialization.TL_DATA.get().U_INT;
        uInt.set(value2);
        uInt.write(out);
    }

    static short readShort(DataInput in) throws IOException {
        ShortWritable uShort = FSImageSerialization.TL_DATA.get().U_SHORT;
        uShort.readFields(in);
        return uShort.get();
    }

    static void writeShort(short value2, DataOutputStream out) throws IOException {
        ShortWritable uShort = FSImageSerialization.TL_DATA.get().U_SHORT;
        uShort.set(value2);
        uShort.write(out);
    }

    public static byte[] readBytes(DataInput in) throws IOException {
        DeprecatedUTF8 ustr = FSImageSerialization.TL_DATA.get().U_STR;
        ustr.readFields(in);
        int len = ustr.getLength();
        byte[] bytes = new byte[len];
        System.arraycopy(ustr.getBytes(), 0, bytes, 0, len);
        return bytes;
    }

    public static byte[][] readPathComponents(DataInput in) throws IOException {
        DeprecatedUTF8 ustr = FSImageSerialization.TL_DATA.get().U_STR;
        ustr.readFields(in);
        return DFSUtil.bytes2byteArray(ustr.getBytes(), ustr.getLength(), (byte)47);
    }

    public static byte[] readLocalName(DataInput in) throws IOException {
        byte[] createdNodeName = new byte[in.readShort()];
        in.readFully(createdNodeName);
        return createdNodeName;
    }

    private static void writeLocalName(INodeAttributes inode, DataOutput out) throws IOException {
        byte[] name = inode.getLocalNameBytes();
        FSImageSerialization.writeBytes(name, out);
    }

    public static void writeBytes(byte[] data, DataOutput out) throws IOException {
        out.writeShort(data.length);
        out.write(data);
    }

    public static void writeCompactBlockArray(Block[] blocks, DataOutputStream out) throws IOException {
        WritableUtils.writeVInt(out, blocks.length);
        Block prev = null;
        for (Block b : blocks) {
            long szDelta = b.getNumBytes() - (prev != null ? prev.getNumBytes() : 0L);
            long gsDelta = b.getGenerationStamp() - (prev != null ? prev.getGenerationStamp() : 0L);
            out.writeLong(b.getBlockId());
            WritableUtils.writeVLong(out, szDelta);
            WritableUtils.writeVLong(out, gsDelta);
            prev = b;
        }
    }

    public static Block[] readCompactBlockArray(DataInput in, int logVersion) throws IOException {
        int num = WritableUtils.readVInt(in);
        if (num < 0) {
            throw new IOException("Invalid block array length: " + num);
        }
        Block prev = null;
        Block[] ret = new Block[num];
        for (int i = 0; i < num; ++i) {
            long id = in.readLong();
            long sz = WritableUtils.readVLong(in) + (prev != null ? prev.getNumBytes() : 0L);
            long gs = WritableUtils.readVLong(in) + (prev != null ? prev.getGenerationStamp() : 0L);
            ret[i] = new Block(id, sz, gs);
            prev = ret[i];
        }
        return ret;
    }

    private static final class TLData {
        final DeprecatedUTF8 U_STR = new DeprecatedUTF8();
        final ShortWritable U_SHORT = new ShortWritable();
        final IntWritable U_INT = new IntWritable();
        final LongWritable U_LONG = new LongWritable();
        final FsPermission FILE_PERM = new FsPermission(0);

        private TLData() {
        }
    }
}

