/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.UnregisteredNodeException;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenSecretManager;
import org.apache.hadoop.hdfs.security.token.block.DataEncryptionKey;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockCollection;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoUnderConstruction;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlocksMap;
import org.apache.hadoop.hdfs.server.blockmanagement.CorruptReplicasMap;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.HeartbeatManager;
import org.apache.hadoop.hdfs.server.blockmanagement.InvalidateBlocks;
import org.apache.hadoop.hdfs.server.blockmanagement.MutableBlockCollection;
import org.apache.hadoop.hdfs.server.blockmanagement.NumberReplicas;
import org.apache.hadoop.hdfs.server.blockmanagement.PendingDataNodeMessages;
import org.apache.hadoop.hdfs.server.blockmanagement.PendingReplicationBlocks;
import org.apache.hadoop.hdfs.server.blockmanagement.UnderReplicatedBlocks;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.FSClusterStats;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.Namesystem;
import org.apache.hadoop.hdfs.server.namenode.metrics.NameNodeMetrics;
import org.apache.hadoop.hdfs.server.protocol.BlocksWithLocations;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.KeyUpdateCommand;
import org.apache.hadoop.hdfs.server.protocol.ReceivedDeletedBlockInfo;
import org.apache.hadoop.hdfs.util.LightWeightLinkedSet;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.Time;
import org.spark-project.guava.annotations.VisibleForTesting;
import org.spark-project.guava.base.Preconditions;
import org.spark-project.guava.collect.Sets;

@InterfaceAudience.Private
public class BlockManager {
    static final Log LOG = LogFactory.getLog(BlockManager.class);
    public static final Log blockLog = NameNode.blockStateChangeLog;
    public static final float DEFAULT_MAP_LOAD_FACTOR = 0.75f;
    private static final String QUEUE_REASON_CORRUPT_STATE = "it has the wrong state or generation stamp";
    private static final String QUEUE_REASON_FUTURE_GENSTAMP = "generation stamp is in the future";
    private final Namesystem namesystem;
    private final DatanodeManager datanodeManager;
    private final HeartbeatManager heartbeatManager;
    private final BlockTokenSecretManager blockTokenSecretManager;
    private final PendingDataNodeMessages pendingDNMessages = new PendingDataNodeMessages();
    private volatile long pendingReplicationBlocksCount = 0L;
    private volatile long corruptReplicaBlocksCount = 0L;
    private volatile long underReplicatedBlocksCount = 0L;
    private volatile long scheduledReplicationBlocksCount = 0L;
    private AtomicLong excessBlocksCount = new AtomicLong(0L);
    private AtomicLong postponedMisreplicatedBlocksCount = new AtomicLong(0L);
    private final long replicationRecheckInterval;
    final BlocksMap blocksMap;
    final Daemon replicationThread = new Daemon(new ReplicationMonitor());
    final CorruptReplicasMap corruptReplicas = new CorruptReplicasMap();
    private final InvalidateBlocks invalidateBlocks;
    private final Set<Block> postponedMisreplicatedBlocks = Sets.newHashSet();
    public final Map<String, LightWeightLinkedSet<Block>> excessReplicateMap = new TreeMap<String, LightWeightLinkedSet<Block>>();
    public final UnderReplicatedBlocks neededReplications = new UnderReplicatedBlocks();
    @VisibleForTesting
    final PendingReplicationBlocks pendingReplications;
    public final short maxReplication;
    int maxReplicationStreams;
    int replicationStreamsHardLimit;
    public final short minReplication;
    public final int defaultReplication;
    final int maxCorruptFilesReturned;
    final float blocksInvalidateWorkPct;
    final int blocksReplWorkMultiplier;
    final boolean shouldCheckForEnoughRacks;
    final boolean encryptDataTransfer;
    private boolean shouldPostponeBlocksFromFuture = false;
    private BlockPlacementPolicy blockplacement;
    private boolean checkNSRunning = true;

    public long getPendingReplicationBlocksCount() {
        return this.pendingReplicationBlocksCount;
    }

    public long getUnderReplicatedBlocksCount() {
        return this.underReplicatedBlocksCount;
    }

    public long getCorruptReplicaBlocksCount() {
        return this.corruptReplicaBlocksCount;
    }

    public long getScheduledReplicationBlocksCount() {
        return this.scheduledReplicationBlocksCount;
    }

    public long getPendingDeletionBlocksCount() {
        return this.invalidateBlocks.numBlocks();
    }

    public long getExcessBlocksCount() {
        return this.excessBlocksCount.get();
    }

    public long getPostponedMisreplicatedBlocksCount() {
        return this.postponedMisreplicatedBlocksCount.get();
    }

    public int getPendingDataNodeMessageCount() {
        return this.pendingDNMessages.count();
    }

    public BlockManager(Namesystem namesystem, FSClusterStats stats, Configuration conf) throws IOException {
        this.namesystem = namesystem;
        this.datanodeManager = new DatanodeManager(this, namesystem, conf);
        this.heartbeatManager = this.datanodeManager.getHeartbeatManager();
        this.invalidateBlocks = new InvalidateBlocks(this.datanodeManager);
        this.blocksMap = new BlocksMap(0.75f);
        this.blockplacement = BlockPlacementPolicy.getInstance(conf, stats, this.datanodeManager.getNetworkTopology());
        this.pendingReplications = new PendingReplicationBlocks((long)conf.getInt("dfs.namenode.replication.pending.timeout-sec", -1) * 1000L);
        this.blockTokenSecretManager = BlockManager.createBlockTokenSecretManager(conf);
        this.maxCorruptFilesReturned = conf.getInt("dfs.corruptfilesreturned.max", 500);
        this.defaultReplication = conf.getInt("dfs.replication", 3);
        int maxR = conf.getInt("dfs.replication.max", 512);
        int minR = conf.getInt("dfs.namenode.replication.min", 1);
        if (minR <= 0) {
            throw new IOException("Unexpected configuration parameters: dfs.namenode.replication.min = " + minR + " <= 0");
        }
        if (maxR > Short.MAX_VALUE) {
            throw new IOException("Unexpected configuration parameters: dfs.replication.max = " + maxR + " > " + Short.MAX_VALUE);
        }
        if (minR > maxR) {
            throw new IOException("Unexpected configuration parameters: dfs.namenode.replication.min = " + minR + " > " + "dfs.replication.max" + " = " + maxR);
        }
        this.minReplication = (short)minR;
        this.maxReplication = (short)maxR;
        this.maxReplicationStreams = conf.getInt("dfs.namenode.replication.max-streams", 2);
        this.replicationStreamsHardLimit = conf.getInt("dfs.namenode.replication.max-streams-hard-limit", 4);
        this.shouldCheckForEnoughRacks = conf.get("net.topology.script.file.name") != null;
        this.blocksInvalidateWorkPct = DFSUtil.getInvalidateWorkPctPerIteration(conf);
        this.blocksReplWorkMultiplier = DFSUtil.getReplWorkMultiplier(conf);
        this.replicationRecheckInterval = (long)conf.getInt("dfs.namenode.replication.interval", 3) * 1000L;
        this.encryptDataTransfer = conf.getBoolean("dfs.encrypt.data.transfer", false);
        LOG.info((Object)("defaultReplication         = " + this.defaultReplication));
        LOG.info((Object)("maxReplication             = " + this.maxReplication));
        LOG.info((Object)("minReplication             = " + this.minReplication));
        LOG.info((Object)("maxReplicationStreams      = " + this.maxReplicationStreams));
        LOG.info((Object)("shouldCheckForEnoughRacks  = " + this.shouldCheckForEnoughRacks));
        LOG.info((Object)("replicationRecheckInterval = " + this.replicationRecheckInterval));
        LOG.info((Object)("encryptDataTransfer        = " + this.encryptDataTransfer));
    }

    private static BlockTokenSecretManager createBlockTokenSecretManager(Configuration conf) {
        boolean isEnabled = conf.getBoolean("dfs.block.access.token.enable", false);
        LOG.info((Object)("dfs.block.access.token.enable=" + isEnabled));
        if (!isEnabled) {
            return null;
        }
        long updateMin = conf.getLong("dfs.block.access.key.update.interval", 600L);
        long lifetimeMin = conf.getLong("dfs.block.access.token.lifetime", 600L);
        String encryptionAlgorithm = conf.get("dfs.encrypt.data.transfer.algorithm");
        LOG.info((Object)("dfs.block.access.key.update.interval=" + updateMin + " min(s), " + "dfs.block.access.token.lifetime" + "=" + lifetimeMin + " min(s), " + "dfs.encrypt.data.transfer.algorithm" + "=" + encryptionAlgorithm));
        String nsId = DFSUtil.getNamenodeNameServiceId(conf);
        boolean isHaEnabled = HAUtil.isHAEnabled(conf, nsId);
        if (isHaEnabled) {
            String otherNnId;
            String thisNnId = HAUtil.getNameNodeId(conf, nsId);
            return new BlockTokenSecretManager(updateMin * 60L * 1000L, lifetimeMin * 60L * 1000L, thisNnId.compareTo(otherNnId = HAUtil.getNameNodeIdOfOtherNode(conf, nsId)) < 0 ? 0 : 1, null, encryptionAlgorithm);
        }
        return new BlockTokenSecretManager(updateMin * 60L * 1000L, lifetimeMin * 60L * 1000L, 0, null, encryptionAlgorithm);
    }

    public void setBlockPoolId(String blockPoolId) {
        if (this.isBlockTokenEnabled()) {
            this.blockTokenSecretManager.setBlockPoolId(blockPoolId);
        }
    }

    @VisibleForTesting
    public BlockTokenSecretManager getBlockTokenSecretManager() {
        return this.blockTokenSecretManager;
    }

    @VisibleForTesting
    void enableRMTerminationForTesting() {
        this.checkNSRunning = false;
    }

    private boolean isBlockTokenEnabled() {
        return this.blockTokenSecretManager != null;
    }

    boolean shouldUpdateBlockKey(long updateTime) throws IOException {
        return this.isBlockTokenEnabled() ? this.blockTokenSecretManager.updateKeys(updateTime) : false;
    }

    public void activate(Configuration conf) {
        this.pendingReplications.start();
        this.datanodeManager.activate(conf);
        this.replicationThread.start();
    }

    public void close() {
        try {
            if (this.replicationThread != null) {
                this.replicationThread.interrupt();
                this.replicationThread.join(3000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.datanodeManager.close();
        this.pendingReplications.stop();
        this.blocksMap.close();
    }

    public DatanodeManager getDatanodeManager() {
        return this.datanodeManager;
    }

    public BlockPlacementPolicy getBlockPlacementPolicy() {
        return this.blockplacement;
    }

    public void setBlockPlacementPolicy(BlockPlacementPolicy newpolicy) {
        if (newpolicy == null) {
            throw new HadoopIllegalArgumentException("newpolicy == null");
        }
        this.blockplacement = newpolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void metaSave(PrintWriter out) {
        assert (this.namesystem.hasWriteLock());
        ArrayList<DatanodeDescriptor> live = new ArrayList<DatanodeDescriptor>();
        ArrayList<DatanodeDescriptor> dead = new ArrayList<DatanodeDescriptor>();
        this.datanodeManager.fetchDatanodes(live, dead, false);
        out.println("Live Datanodes: " + live.size());
        out.println("Dead Datanodes: " + dead.size());
        UnderReplicatedBlocks underReplicatedBlocks = this.neededReplications;
        synchronized (underReplicatedBlocks) {
            out.println("Metasave: Blocks waiting for replication: " + this.neededReplications.size());
            for (Block block : this.neededReplications) {
                this.dumpBlockMeta(block, out);
            }
        }
        out.println("Mis-replicated blocks that have been postponed:");
        for (Block block : this.postponedMisreplicatedBlocks) {
            this.dumpBlockMeta(block, out);
        }
        this.pendingReplications.metaSave(out);
        this.invalidateBlocks.dump(out);
        this.getDatanodeManager().datanodeDump(out);
    }

    private void dumpBlockMeta(Block block, PrintWriter out) {
        ArrayList<DatanodeDescriptor> containingNodes = new ArrayList<DatanodeDescriptor>();
        ArrayList<DatanodeDescriptor> containingLiveReplicasNodes = new ArrayList<DatanodeDescriptor>();
        NumberReplicas numReplicas = new NumberReplicas();
        this.chooseSourceDatanode(block, containingNodes, containingLiveReplicasNodes, numReplicas, 5);
        assert (containingLiveReplicasNodes.size() == numReplicas.liveReplicas());
        int usableReplicas = numReplicas.liveReplicas() + numReplicas.decommissionedReplicas();
        if (block instanceof BlockInfo) {
            BlockCollection bc = ((BlockInfo)block).getBlockCollection();
            String fileName = bc == null ? "[orphaned]" : bc.getName();
            out.print(fileName + ": ");
        }
        out.print(block + (usableReplicas > 0 ? "" : " MISSING") + " (replicas:" + " l: " + numReplicas.liveReplicas() + " d: " + numReplicas.decommissionedReplicas() + " c: " + numReplicas.corruptReplicas() + " e: " + numReplicas.excessReplicas() + ") ");
        Collection<DatanodeDescriptor> corruptNodes = this.corruptReplicas.getNodes(block);
        Iterator<DatanodeDescriptor> jt = this.blocksMap.nodeIterator(block);
        while (jt.hasNext()) {
            DatanodeDescriptor node = jt.next();
            String state = "";
            if (corruptNodes != null && corruptNodes.contains(node)) {
                state = "(corrupt)";
            } else if (node.isDecommissioned() || node.isDecommissionInProgress()) {
                state = "(decommissioned)";
            }
            if (node.areBlockContentsStale()) {
                state = state + " (block deletions maybe out of date)";
            }
            out.print(" " + node + state + " : ");
        }
        out.println("");
    }

    public int getMaxReplicationStreams() {
        return this.maxReplicationStreams;
    }

    public boolean checkMinReplication(Block block) {
        return this.countNodes(block).liveReplicas() >= this.minReplication;
    }

    private static boolean commitBlock(BlockInfoUnderConstruction block, Block commitBlock) throws IOException {
        if (block.getBlockUCState() == HdfsServerConstants.BlockUCState.COMMITTED) {
            return false;
        }
        assert (block.getNumBytes() <= commitBlock.getNumBytes()) : "commitBlock length is less than the stored one " + commitBlock.getNumBytes() + " vs. " + block.getNumBytes();
        block.commitBlock(commitBlock);
        return true;
    }

    public boolean commitOrCompleteLastBlock(MutableBlockCollection bc, Block commitBlock) throws IOException {
        if (commitBlock == null) {
            return false;
        }
        BlockInfo lastBlock = bc.getLastBlock();
        if (lastBlock == null) {
            return false;
        }
        if (lastBlock.isComplete()) {
            return false;
        }
        boolean b = BlockManager.commitBlock((BlockInfoUnderConstruction)lastBlock, commitBlock);
        if (this.countNodes(lastBlock).liveReplicas() >= this.minReplication) {
            this.completeBlock(bc, bc.numBlocks() - 1, false);
        }
        return b;
    }

    private BlockInfo completeBlock(MutableBlockCollection bc, int blkIndex, boolean force) throws IOException {
        if (blkIndex < 0) {
            return null;
        }
        BlockInfo curBlock = bc.getBlocks()[blkIndex];
        if (curBlock.isComplete()) {
            return curBlock;
        }
        BlockInfoUnderConstruction ucBlock = (BlockInfoUnderConstruction)curBlock;
        int numNodes = ucBlock.numNodes();
        if (!force && numNodes < this.minReplication) {
            throw new IOException("Cannot complete block: block does not satisfy minimal replication requirement.");
        }
        if (!force && ucBlock.getBlockUCState() != HdfsServerConstants.BlockUCState.COMMITTED) {
            throw new IOException("Cannot complete block: block has not been COMMITTED by the client");
        }
        BlockInfo completeBlock = ucBlock.convertToCompleteBlock();
        bc.setBlock(blkIndex, completeBlock);
        this.namesystem.adjustSafeModeBlockTotals(0, 1);
        this.namesystem.incrementSafeBlockCount(Math.min(numNodes, this.minReplication));
        return this.blocksMap.replaceBlock(completeBlock);
    }

    private BlockInfo completeBlock(MutableBlockCollection bc, BlockInfo block, boolean force) throws IOException {
        BlockInfo[] fileBlocks = bc.getBlocks();
        for (int idx = 0; idx < fileBlocks.length; ++idx) {
            if (fileBlocks[idx] != block) continue;
            return this.completeBlock(bc, idx, force);
        }
        return block;
    }

    public BlockInfo forceCompleteBlock(MutableBlockCollection bc, BlockInfoUnderConstruction block) throws IOException {
        block.commitBlock(block);
        return this.completeBlock(bc, block, true);
    }

    public LocatedBlock convertLastBlockToUnderConstruction(MutableBlockCollection bc) throws IOException {
        BlockInfo oldBlock = bc.getLastBlock();
        if (oldBlock == null || bc.getPreferredBlockSize() == oldBlock.getNumBytes()) {
            return null;
        }
        assert (oldBlock == this.getStoredBlock(oldBlock)) : "last block of the file is not in blocksMap";
        DatanodeDescriptor[] targets = this.getNodes(oldBlock);
        BlockInfoUnderConstruction ucBlock = bc.setLastBlock(oldBlock, targets);
        this.blocksMap.replaceBlock(ucBlock);
        NumberReplicas replicas = this.countNodes(ucBlock);
        this.neededReplications.remove(ucBlock, replicas.liveReplicas(), replicas.decommissionedReplicas(), this.getReplication(ucBlock));
        this.pendingReplications.remove(ucBlock);
        for (DatanodeDescriptor dd : targets) {
            String datanodeId = dd.getStorageID();
            this.invalidateBlocks.remove(datanodeId, oldBlock);
        }
        this.namesystem.adjustSafeModeBlockTotals(targets.length >= this.minReplication ? -1 : 0, -1);
        long fileLength = bc.computeContentSummary().getLength();
        long pos = fileLength - ucBlock.getNumBytes();
        return this.createLocatedBlock(ucBlock, pos, BlockTokenSecretManager.AccessMode.WRITE);
    }

    private List<String> getValidLocations(Block block) {
        ArrayList<String> machineSet = new ArrayList<String>(this.blocksMap.numNodes(block));
        Iterator<DatanodeDescriptor> it = this.blocksMap.nodeIterator(block);
        while (it.hasNext()) {
            String storageID = it.next().getStorageID();
            if (this.invalidateBlocks.contains(storageID, block)) continue;
            machineSet.add(storageID);
        }
        return machineSet;
    }

    private List<LocatedBlock> createLocatedBlockList(BlockInfo[] blocks, long offset, long length, int nrBlocksToReturn, BlockTokenSecretManager.AccessMode mode) throws IOException {
        int curBlk = 0;
        long curPos = 0L;
        long blkSize = 0L;
        int nrBlocks = blocks[0].getNumBytes() == 0L ? 0 : blocks.length;
        for (curBlk = 0; curBlk < nrBlocks; ++curBlk) {
            blkSize = blocks[curBlk].getNumBytes();
            assert (blkSize > 0L) : "Block of size 0";
            if (curPos + blkSize > offset) break;
            curPos += blkSize;
        }
        if (nrBlocks > 0 && curBlk == nrBlocks) {
            return Collections.emptyList();
        }
        long endOff = offset + length;
        ArrayList<LocatedBlock> results = new ArrayList<LocatedBlock>(blocks.length);
        do {
            results.add(this.createLocatedBlock(blocks[curBlk], curPos, mode));
        } while ((curPos += blocks[++curBlk].getNumBytes()) < endOff && curBlk < blocks.length && results.size() < nrBlocksToReturn);
        return results;
    }

    private LocatedBlock createLocatedBlock(BlockInfo[] blocks, long endPos, BlockTokenSecretManager.AccessMode mode) throws IOException {
        long blkSize;
        int curBlk = 0;
        long curPos = 0L;
        int nrBlocks = blocks[0].getNumBytes() == 0L ? 0 : blocks.length;
        for (curBlk = 0; curBlk < nrBlocks && curPos + (blkSize = blocks[curBlk].getNumBytes()) < endPos; ++curBlk) {
            curPos += blkSize;
        }
        return this.createLocatedBlock(blocks[curBlk], curPos, mode);
    }

    private LocatedBlock createLocatedBlock(BlockInfo blk, long pos, BlockTokenSecretManager.AccessMode mode) throws IOException {
        LocatedBlock lb = this.createLocatedBlock(blk, pos);
        if (mode != null) {
            this.setBlockToken(lb, mode);
        }
        return lb;
    }

    private LocatedBlock createLocatedBlock(BlockInfo blk, long pos) throws IOException {
        int numNodes;
        int numCorruptReplicas;
        if (blk instanceof BlockInfoUnderConstruction) {
            if (blk.isComplete()) {
                throw new IOException("blk instanceof BlockInfoUnderConstruction && blk.isComplete(), blk=" + blk);
            }
            BlockInfoUnderConstruction uc = (BlockInfoUnderConstruction)blk;
            DatanodeInfo[] locations = uc.getExpectedLocations();
            ExtendedBlock eb = new ExtendedBlock(this.namesystem.getBlockPoolId(), blk);
            return new LocatedBlock(eb, locations, pos, false);
        }
        int numCorruptNodes = this.countNodes(blk).corruptReplicas();
        if (numCorruptNodes != (numCorruptReplicas = this.corruptReplicas.numCorruptReplicas(blk))) {
            LOG.warn((Object)("Inconsistent number of corrupt replicas for " + blk + " blockMap has " + numCorruptNodes + " but corrupt replicas map has " + numCorruptReplicas));
        }
        boolean isCorrupt = numCorruptNodes == (numNodes = this.blocksMap.numNodes(blk));
        int numMachines = isCorrupt ? numNodes : numNodes - numCorruptNodes;
        DatanodeInfo[] machines = new DatanodeDescriptor[numMachines];
        int j = 0;
        if (numMachines > 0) {
            Iterator<DatanodeDescriptor> it = this.blocksMap.nodeIterator(blk);
            while (it.hasNext()) {
                DatanodeDescriptor d = it.next();
                boolean replicaCorrupt = this.corruptReplicas.isReplicaCorrupt(blk, d);
                if (!isCorrupt && (isCorrupt || replicaCorrupt)) continue;
                machines[j++] = d;
            }
        }
        assert (j == machines.length) : "isCorrupt: " + isCorrupt + " numMachines: " + numMachines + " numNodes: " + numNodes + " numCorrupt: " + numCorruptNodes + " numCorruptRepls: " + numCorruptReplicas;
        ExtendedBlock eb = new ExtendedBlock(this.namesystem.getBlockPoolId(), blk);
        return new LocatedBlock(eb, machines, pos, isCorrupt);
    }

    public LocatedBlocks createLocatedBlocks(BlockInfo[] blocks, long fileSizeExcludeBlocksUnderConstruction, boolean isFileUnderConstruction, long offset, long length, boolean needBlockToken, boolean inSnapshot) throws IOException {
        boolean isComplete;
        LocatedBlock lastlb;
        assert (this.namesystem.hasReadOrWriteLock());
        if (blocks == null) {
            return null;
        }
        if (blocks.length == 0) {
            return new LocatedBlocks(0L, isFileUnderConstruction, Collections.<LocatedBlock>emptyList(), null, false);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("blocks = " + Arrays.asList(blocks)));
        }
        BlockTokenSecretManager.AccessMode mode = needBlockToken ? BlockTokenSecretManager.AccessMode.READ : null;
        List<LocatedBlock> locatedblocks = this.createLocatedBlockList(blocks, offset, length, Integer.MAX_VALUE, mode);
        if (!inSnapshot) {
            BlockInfo last2 = blocks[blocks.length - 1];
            long lastPos = last2.isComplete() ? fileSizeExcludeBlocksUnderConstruction - last2.getNumBytes() : fileSizeExcludeBlocksUnderConstruction;
            lastlb = this.createLocatedBlock(last2, lastPos, mode);
            isComplete = last2.isComplete();
        } else {
            lastlb = this.createLocatedBlock(blocks, fileSizeExcludeBlocksUnderConstruction, mode);
            isComplete = true;
        }
        return new LocatedBlocks(fileSizeExcludeBlocksUnderConstruction, isFileUnderConstruction, locatedblocks, lastlb, isComplete);
    }

    public ExportedBlockKeys getBlockKeys() {
        return this.isBlockTokenEnabled() ? this.blockTokenSecretManager.exportKeys() : ExportedBlockKeys.DUMMY_KEYS;
    }

    public void setBlockToken(LocatedBlock b, BlockTokenSecretManager.AccessMode mode) throws IOException {
        if (this.isBlockTokenEnabled()) {
            b.setBlockToken(this.blockTokenSecretManager.generateToken(NameNode.getRemoteUser().getShortUserName(), b.getBlock(), EnumSet.of(mode)));
        }
    }

    void addKeyUpdateCommand(List<DatanodeCommand> cmds, DatanodeDescriptor nodeinfo) {
        if (this.isBlockTokenEnabled() && nodeinfo.needKeyUpdate) {
            cmds.add(new KeyUpdateCommand(this.blockTokenSecretManager.exportKeys()));
            nodeinfo.needKeyUpdate = false;
        }
    }

    public DataEncryptionKey generateDataEncryptionKey() {
        if (this.isBlockTokenEnabled() && this.encryptDataTransfer) {
            return this.blockTokenSecretManager.generateDataEncryptionKey();
        }
        return null;
    }

    public short adjustReplication(short replication) {
        return replication < this.minReplication ? this.minReplication : (replication > this.maxReplication ? this.maxReplication : replication);
    }

    public void verifyReplication(String src, short replication, String clientName) throws IOException {
        if (replication >= this.minReplication && replication <= this.maxReplication) {
            return;
        }
        String text2 = "file " + src + (clientName != null ? " on client " + clientName : "") + ".\n" + "Requested replication " + replication;
        if (replication > this.maxReplication) {
            throw new IOException(text2 + " exceeds maximum " + this.maxReplication);
        }
        if (replication < this.minReplication) {
            throw new IOException(text2 + " is less than the required minimum " + this.minReplication);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlocksWithLocations getBlocks(DatanodeID datanode, long size2) throws IOException {
        this.namesystem.checkOperation(NameNode.OperationCategory.READ);
        this.namesystem.readLock();
        try {
            this.namesystem.checkOperation(NameNode.OperationCategory.READ);
            BlocksWithLocations blocksWithLocations = this.getBlocksWithLocations(datanode, size2);
            return blocksWithLocations;
        }
        finally {
            this.namesystem.readUnlock();
        }
    }

    private BlocksWithLocations getBlocksWithLocations(DatanodeID datanode, long size2) throws UnregisteredNodeException {
        BlockInfo curBlock;
        DatanodeDescriptor node = this.getDatanodeManager().getDatanode(datanode);
        if (node == null) {
            blockLog.warn((Object)("BLOCK* getBlocks: Asking for blocks from an unrecorded node " + datanode));
            throw new HadoopIllegalArgumentException("Datanode " + datanode + " not found.");
        }
        int numBlocks = node.numBlocks();
        if (numBlocks == 0) {
            return new BlocksWithLocations(new BlocksWithLocations.BlockWithLocations[0]);
        }
        Iterator<BlockInfo> iter2 = node.getBlockIterator();
        int startBlock = DFSUtil.getRandom().nextInt(numBlocks);
        for (int i = 0; i < startBlock; ++i) {
            iter2.next();
        }
        ArrayList<BlocksWithLocations.BlockWithLocations> results = new ArrayList<BlocksWithLocations.BlockWithLocations>();
        long totalSize = 0L;
        while (totalSize < size2 && iter2.hasNext()) {
            curBlock = iter2.next();
            if (!curBlock.isComplete()) continue;
            totalSize += this.addBlock(curBlock, results);
        }
        if (totalSize < size2) {
            iter2 = node.getBlockIterator();
            for (int i = 0; i < startBlock && totalSize < size2; ++i) {
                curBlock = iter2.next();
                if (!curBlock.isComplete()) continue;
                totalSize += this.addBlock(curBlock, results);
            }
        }
        return new BlocksWithLocations(results.toArray(new BlocksWithLocations.BlockWithLocations[results.size()]));
    }

    void removeBlocksAssociatedTo(DatanodeDescriptor node) {
        Iterator<BlockInfo> it = node.getBlockIterator();
        while (it.hasNext()) {
            this.removeStoredBlock(it.next(), node);
        }
        node.resetBlocks();
        this.invalidateBlocks.remove(node.getStorageID());
        if (node.areBlockContentsStale()) {
            this.rescanPostponedMisreplicatedBlocks();
        }
    }

    void addToInvalidates(Block block, DatanodeInfo datanode) {
        this.invalidateBlocks.add(block, datanode, true);
    }

    private void addToInvalidates(Block b) {
        StringBuilder datanodes = new StringBuilder();
        Iterator<DatanodeDescriptor> it = this.blocksMap.nodeIterator(b);
        while (it.hasNext()) {
            DatanodeDescriptor node = it.next();
            this.invalidateBlocks.add(b, node, false);
            datanodes.append(node).append(" ");
        }
        if (datanodes.length() != 0) {
            blockLog.info((Object)("BLOCK* addToInvalidates: " + b + " " + datanodes));
        }
    }

    public void findAndMarkBlockAsCorrupt(ExtendedBlock blk, DatanodeInfo dn, String reason) throws IOException {
        assert (this.namesystem.hasWriteLock());
        BlockInfo storedBlock = this.getStoredBlock(blk.getLocalBlock());
        if (storedBlock == null) {
            blockLog.info((Object)("BLOCK* findAndMarkBlockAsCorrupt: " + blk + " not found"));
            return;
        }
        this.markBlockAsCorrupt(new BlockToMarkCorrupt(storedBlock, reason), dn);
    }

    private void markBlockAsCorrupt(BlockToMarkCorrupt b, DatanodeInfo dn) throws IOException {
        DatanodeDescriptor node = this.getDatanodeManager().getDatanode(dn);
        if (node == null) {
            throw new IOException("Cannot mark " + b + " as corrupt because datanode " + dn + " does not exist");
        }
        BlockCollection bc = b.corrupted.getBlockCollection();
        if (bc == null) {
            blockLog.info((Object)("BLOCK markBlockAsCorrupt: " + b + " cannot be marked as corrupt as it does not belong to any file"));
            this.addToInvalidates(b.corrupted, node);
            return;
        }
        node.addBlock(b.stored);
        this.corruptReplicas.addToCorruptReplicasMap(b.corrupted, node, b.reason);
        if (this.countNodes(b.stored).liveReplicas() >= bc.getBlockReplication()) {
            this.invalidateBlock(b, node);
        } else if (this.namesystem.isPopulatingReplQueues()) {
            this.updateNeededReplications(b.stored, -1, 0);
        }
    }

    private boolean invalidateBlock(BlockToMarkCorrupt b, DatanodeInfo dn) throws IOException {
        blockLog.info((Object)("BLOCK* invalidateBlock: " + b + " on " + dn));
        DatanodeDescriptor node = this.getDatanodeManager().getDatanode(dn);
        if (node == null) {
            throw new IOException("Cannot invalidate " + b + " because datanode " + dn + " does not exist.");
        }
        NumberReplicas nr = this.countNodes(b.stored);
        if (nr.replicasOnStaleNodes() > 0) {
            blockLog.info((Object)("BLOCK* invalidateBlocks: postponing invalidation of " + b + " on " + dn + " because " + nr.replicasOnStaleNodes() + " replica(s) are located on nodes " + "with potentially out-of-date block reports"));
            this.postponeBlock(b.corrupted);
            return false;
        }
        if (nr.liveReplicas() >= 1) {
            this.addToInvalidates(b.corrupted, dn);
            this.removeStoredBlock(b.stored, node);
            if (blockLog.isDebugEnabled()) {
                blockLog.debug((Object)("BLOCK* invalidateBlocks: " + b + " on " + dn + " listed for deletion."));
            }
            return true;
        }
        blockLog.info((Object)("BLOCK* invalidateBlocks: " + b + " on " + dn + " is the only copy and was not deleted"));
        return false;
    }

    public void setPostponeBlocksFromFuture(boolean postpone) {
        this.shouldPostponeBlocksFromFuture = postpone;
    }

    private void postponeBlock(Block blk) {
        if (this.postponedMisreplicatedBlocks.add(blk)) {
            this.postponedMisreplicatedBlocksCount.incrementAndGet();
        }
    }

    void updateState() {
        this.pendingReplicationBlocksCount = this.pendingReplications.size();
        this.underReplicatedBlocksCount = this.neededReplications.size();
        this.corruptReplicaBlocksCount = this.corruptReplicas.size();
    }

    public int getUnderReplicatedNotMissingBlocks() {
        return this.neededReplications.getUnderReplicatedBlockCount();
    }

    int computeInvalidateWork(int nodesToProcess) {
        List<String> nodes = this.invalidateBlocks.getStorageIDs();
        Collections.shuffle(nodes);
        nodesToProcess = Math.min(nodes.size(), nodesToProcess);
        int blockCnt = 0;
        for (int nodeCnt = 0; nodeCnt < nodesToProcess; ++nodeCnt) {
            blockCnt += this.invalidateWorkForOneNode(nodes.get(nodeCnt));
        }
        return blockCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int computeReplicationWork(int blocksToProcess) {
        List<List<Block>> blocksToReplicate = null;
        this.namesystem.writeLock();
        try {
            blocksToReplicate = this.neededReplications.chooseUnderReplicatedBlocks(blocksToProcess);
        }
        finally {
            this.namesystem.writeUnlock();
        }
        return this.computeReplicationWorkForBlocks(blocksToReplicate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    int computeReplicationWorkForBlocks(List<List<Block>> blocksToReplicate) {
        block33: {
            block32: {
                bc = null;
                scheduledWork = 0;
                work = new LinkedList<ReplicationWork>();
                this.namesystem.writeLock();
                var5_5 = this.neededReplications;
                synchronized (var5_5) {
                    priority = 0;
lbl9:
                    // 2 sources

                    while (true) {
                        if (priority < blocksToReplicate.size()) {
                            i$ = blocksToReplicate.get(priority).iterator();
                            ** break block31
                        }
                        break block32;
                        break;
                    }
                }
                finally {
                    this.namesystem.writeUnlock();
                }
            }
            excludedNodes = new HashMap<Node, Node>();
            i$ = work.iterator();
            break block33;
lbl-1000:
            // 1 sources

            {
                while (i$.hasNext()) {
                    block = i$.next();
                    bc = this.blocksMap.getBlockCollection(block);
                    if (bc == null || bc instanceof MutableBlockCollection) {
                        this.neededReplications.remove(block, priority);
                        this.neededReplications.decrementReplicationIndex(priority);
                        continue;
                    }
                    requiredReplication = bc.getBlockReplication();
                    containingNodes = new ArrayList<DatanodeDescriptor>();
                    liveReplicaNodes = new ArrayList<DatanodeDescriptor>();
                    numReplicas = new NumberReplicas();
                    srcNode = this.chooseSourceDatanode(block, containingNodes, liveReplicaNodes, numReplicas, priority);
                    if (srcNode == null) {
                        BlockManager.LOG.debug((Object)("Block " + block + " cannot be repl from any node"));
                        continue;
                    }
                    if (!BlockManager.$assertionsDisabled && liveReplicaNodes.size() != numReplicas.liveReplicas()) {
                        throw new AssertionError();
                    }
                    numEffectiveReplicas = numReplicas.liveReplicas() + this.pendingReplications.getNumReplicas(block);
                    if (numEffectiveReplicas >= requiredReplication && (this.pendingReplications.getNumReplicas(block) > 0 || this.blockHasEnoughRacks(block))) {
                        this.neededReplications.remove(block, priority);
                        this.neededReplications.decrementReplicationIndex(priority);
                        BlockManager.blockLog.info((Object)("BLOCK* Removing " + block + " from neededReplications as it has enough replicas"));
                        continue;
                    }
                    additionalReplRequired = numReplicas.liveReplicas() < requiredReplication ? requiredReplication - numEffectiveReplicas : 1;
                    work.add(new ReplicationWork(block, bc, srcNode, containingNodes, liveReplicaNodes, additionalReplRequired, priority));
                }
                ++priority;
                ** continue;
            }
        }
        while (i$.hasNext()) {
            rw = (ReplicationWork)i$.next();
            excludedNodes.clear();
            for (Object dn : ReplicationWork.access$100(rw)) {
                excludedNodes.put((Node)dn, (Node)dn);
            }
            ReplicationWork.access$202(rw, this.blockplacement.chooseTarget(ReplicationWork.access$300(rw), ReplicationWork.access$400(rw), ReplicationWork.access$500(rw), ReplicationWork.access$600(rw), excludedNodes, ReplicationWork.access$700(rw).getNumBytes()));
        }
        this.namesystem.writeLock();
        try {
            for (ReplicationWork rw : work) {
                targets = ReplicationWork.access$200(rw);
                if (targets == null || targets.length == 0) {
                    ReplicationWork.access$202(rw, null);
                    continue;
                }
                dn = this.neededReplications;
                synchronized (dn) {
                    block = ReplicationWork.access$700(rw);
                    priority = ReplicationWork.access$800(rw);
                    bc = this.blocksMap.getBlockCollection(block);
                    if (bc == null || bc instanceof MutableBlockCollection) {
                        this.neededReplications.remove(block, priority);
                        ReplicationWork.access$202(rw, null);
                        this.neededReplications.decrementReplicationIndex(priority);
                        continue;
                    }
                    requiredReplication = bc.getBlockReplication();
                    numReplicas = this.countNodes(block);
                    numEffectiveReplicas = numReplicas.liveReplicas() + this.pendingReplications.getNumReplicas(block);
                    if (numEffectiveReplicas >= requiredReplication && (this.pendingReplications.getNumReplicas(block) > 0 || this.blockHasEnoughRacks(block))) {
                        this.neededReplications.remove(block, priority);
                        this.neededReplications.decrementReplicationIndex(priority);
                        ReplicationWork.access$202(rw, null);
                        BlockManager.blockLog.info((Object)("BLOCK* Removing " + block + " from neededReplications as it has enough replicas"));
                        continue;
                    }
                    if (numReplicas.liveReplicas() >= requiredReplication && !this.blockHasEnoughRacks(block) && ReplicationWork.access$500(rw).getNetworkLocation().equals(targets[0].getNetworkLocation())) {
                        continue;
                    }
                    ReplicationWork.access$500(rw).addBlockToBeReplicated(block, targets);
                    ++scheduledWork;
                    for (DatanodeDescriptor dn : targets) {
                        dn.incBlocksScheduled();
                    }
                    this.pendingReplications.increment(block, targets);
                    if (BlockManager.blockLog.isDebugEnabled()) {
                        BlockManager.blockLog.debug((Object)("BLOCK* block " + block + " is moved from neededReplications to pendingReplications"));
                    }
                    if (numEffectiveReplicas + targets.length >= requiredReplication) {
                        this.neededReplications.remove(block, priority);
                        this.neededReplications.decrementReplicationIndex(priority);
                    }
                }
            }
        }
        finally {
            this.namesystem.writeUnlock();
        }
        if (BlockManager.blockLog.isInfoEnabled()) {
            for (ReplicationWork rw : work) {
                targets = ReplicationWork.access$200(rw);
                if (targets == null || targets.length == 0) continue;
                targetList = new StringBuilder("datanode(s)");
                for (k = 0; k < targets.length; ++k) {
                    targetList.append(' ');
                    targetList.append(targets[k]);
                }
                BlockManager.blockLog.info((Object)("BLOCK* ask " + ReplicationWork.access$500(rw) + " to replicate " + ReplicationWork.access$700(rw) + " to " + targetList));
            }
        }
        if (BlockManager.blockLog.isDebugEnabled()) {
            BlockManager.blockLog.debug((Object)("BLOCK* neededReplications = " + this.neededReplications.size() + " pendingReplications = " + this.pendingReplications.size()));
        }
        return scheduledWork;
    }

    public DatanodeDescriptor[] chooseTarget(String src, int numOfReplicas, DatanodeDescriptor client, HashMap<Node, Node> excludedNodes, long blocksize, List<String> favoredNodes) throws IOException {
        List<DatanodeDescriptor> favoredDatanodeDescriptors = this.getDatanodeDescriptors(favoredNodes);
        DatanodeDescriptor[] targets = this.blockplacement.chooseTarget(src, numOfReplicas, client, excludedNodes, blocksize, favoredDatanodeDescriptors);
        if (targets.length < this.minReplication) {
            throw new IOException("File " + src + " could only be replicated to " + targets.length + " nodes instead of minReplication (=" + this.minReplication + ").  There are " + this.getDatanodeManager().getNetworkTopology().getNumOfLeaves() + " datanode(s) running and " + (excludedNodes == null ? "no" : Integer.valueOf(excludedNodes.size())) + " node(s) are excluded in this operation.");
        }
        return targets;
    }

    List<DatanodeDescriptor> getDatanodeDescriptors(List<String> nodes) {
        ArrayList<DatanodeDescriptor> datanodeDescriptors = null;
        if (nodes != null) {
            datanodeDescriptors = new ArrayList<DatanodeDescriptor>(nodes.size());
            for (int i = 0; i < nodes.size(); ++i) {
                DatanodeDescriptor node = this.datanodeManager.getDatanodeDescriptor(nodes.get(i));
                if (node == null) continue;
                datanodeDescriptors.add(node);
            }
        }
        return datanodeDescriptors;
    }

    @VisibleForTesting
    DatanodeDescriptor chooseSourceDatanode(Block block, List<DatanodeDescriptor> containingNodes, List<DatanodeDescriptor> nodesContainingLiveReplicas, NumberReplicas numReplicas, int priority) {
        containingNodes.clear();
        nodesContainingLiveReplicas.clear();
        DatanodeDescriptor srcNode = null;
        int live = 0;
        int decommissioned = 0;
        int corrupt = 0;
        int excess = 0;
        Iterator<DatanodeDescriptor> it = this.blocksMap.nodeIterator(block);
        Collection<DatanodeDescriptor> nodesCorrupt = this.corruptReplicas.getNodes(block);
        while (it.hasNext()) {
            DatanodeDescriptor node = it.next();
            LightWeightLinkedSet<Block> excessBlocks = this.excessReplicateMap.get(node.getStorageID());
            if (nodesCorrupt != null && nodesCorrupt.contains(node)) {
                ++corrupt;
            } else if (node.isDecommissionInProgress() || node.isDecommissioned()) {
                ++decommissioned;
            } else if (excessBlocks != null && excessBlocks.contains(block)) {
                ++excess;
            } else {
                nodesContainingLiveReplicas.add(node);
                ++live;
            }
            containingNodes.add(node);
            if (nodesCorrupt != null && nodesCorrupt.contains(node) || priority != 0 && node.getNumberOfBlocksToBeReplicated() >= this.maxReplicationStreams || node.getNumberOfBlocksToBeReplicated() >= this.replicationStreamsHardLimit || excessBlocks != null && excessBlocks.contains(block) || node.isDecommissioned()) continue;
            if (node.isDecommissionInProgress() || srcNode == null) {
                srcNode = node;
                continue;
            }
            if (srcNode.isDecommissionInProgress() || !DFSUtil.getRandom().nextBoolean()) continue;
            srcNode = node;
        }
        if (numReplicas != null) {
            numReplicas.initialize(live, decommissioned, corrupt, excess, 0);
        }
        return srcNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPendingReplications() {
        Block[] timedOutItems = this.pendingReplications.getTimedOutBlocks();
        if (timedOutItems != null) {
            this.namesystem.writeLock();
            try {
                for (int i = 0; i < timedOutItems.length; ++i) {
                    NumberReplicas num = this.countNodes(timedOutItems[i]);
                    if (!this.isNeededReplication(timedOutItems[i], this.getReplication(timedOutItems[i]), num.liveReplicas())) continue;
                    this.neededReplications.add(timedOutItems[i], num.liveReplicas(), num.decommissionedReplicas(), this.getReplication(timedOutItems[i]));
                }
            }
            finally {
                this.namesystem.writeUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processReport(DatanodeID nodeID, String poolId, BlockListAsLongs newReport) throws IOException {
        long endTime;
        this.namesystem.writeLock();
        long startTime = Time.now();
        try {
            DatanodeDescriptor node = this.datanodeManager.getDatanode(nodeID);
            if (node == null || !node.isAlive) {
                throw new IOException("ProcessReport from dead or unregistered node: " + nodeID);
            }
            if (this.namesystem.isInStartupSafeMode() && !node.isFirstBlockReport()) {
                blockLog.info((Object)("BLOCK* processReport: discarded non-initial block report from " + nodeID + " because namenode still in startup phase"));
                return;
            }
            if (node.numBlocks() == 0) {
                this.processFirstBlockReport(node, newReport);
            } else {
                this.processReport(node, newReport);
            }
            boolean staleBefore = node.areBlockContentsStale();
            node.receivedBlockReport();
            if (staleBefore && !node.areBlockContentsStale()) {
                LOG.info((Object)("BLOCK* processReport: Received first block report from " + node + " after starting up or becoming active. Its block " + "contents are no longer considered stale"));
                this.rescanPostponedMisreplicatedBlocks();
            }
        }
        finally {
            long endTime2 = Time.now();
            this.namesystem.writeUnlock();
        }
        NameNodeMetrics metrics = NameNode.getNameNodeMetrics();
        if (metrics != null) {
            metrics.addBlockReport((int)(endTime - startTime));
        }
        blockLog.info((Object)("BLOCK* processReport: from " + nodeID + ", blocks: " + newReport.getNumberOfBlocks() + ", processing time: " + (endTime - startTime) + " msecs"));
    }

    private void rescanPostponedMisreplicatedBlocks() {
        Iterator<Block> it = this.postponedMisreplicatedBlocks.iterator();
        while (it.hasNext()) {
            Block b = it.next();
            BlockInfo bi = this.blocksMap.getStoredBlock(b);
            if (bi == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("BLOCK* rescanPostponedMisreplicatedBlocks: Postponed mis-replicated block " + b + " no longer found " + "in block map."));
                }
                it.remove();
                this.postponedMisreplicatedBlocksCount.decrementAndGet();
                continue;
            }
            MisReplicationResult res = this.processMisReplicatedBlock(bi);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("BLOCK* rescanPostponedMisreplicatedBlocks: Re-scanned block " + b + ", result is " + (Object)((Object)res)));
            }
            if (res == MisReplicationResult.POSTPONE) continue;
            it.remove();
            this.postponedMisreplicatedBlocksCount.decrementAndGet();
        }
    }

    private void processReport(DatanodeDescriptor node, BlockListAsLongs report) throws IOException {
        LinkedList<BlockInfo> toAdd = new LinkedList<BlockInfo>();
        LinkedList<Block> toRemove = new LinkedList<Block>();
        LinkedList<Block> toInvalidate = new LinkedList<Block>();
        LinkedList<BlockToMarkCorrupt> toCorrupt = new LinkedList<BlockToMarkCorrupt>();
        LinkedList<StatefulBlockInfo> toUC = new LinkedList<StatefulBlockInfo>();
        this.reportDiff(node, report, toAdd, toRemove, toInvalidate, toCorrupt, toUC);
        for (StatefulBlockInfo statefulBlockInfo : toUC) {
            this.addStoredBlockUnderConstruction(statefulBlockInfo.storedBlock, node, statefulBlockInfo.reportedState);
        }
        for (Block block : toRemove) {
            this.removeStoredBlock(block, node);
        }
        for (BlockInfo blockInfo : toAdd) {
            this.addStoredBlock(blockInfo, node, null, true);
        }
        for (Block block : toInvalidate) {
            blockLog.info((Object)("BLOCK* processReport: " + block + " on " + node + " size " + block.getNumBytes() + " does not belong to any file"));
            this.addToInvalidates(block, node);
        }
        for (BlockToMarkCorrupt blockToMarkCorrupt : toCorrupt) {
            this.markBlockAsCorrupt(blockToMarkCorrupt, node);
        }
    }

    private void processFirstBlockReport(DatanodeDescriptor node, BlockListAsLongs report) throws IOException {
        if (report == null) {
            return;
        }
        assert (this.namesystem.hasWriteLock());
        assert (node.numBlocks() == 0);
        BlockListAsLongs.BlockReportIterator itBR = report.getBlockReportIterator();
        while (itBR.hasNext()) {
            Block iblk = itBR.next();
            HdfsServerConstants.ReplicaState reportedState = itBR.getCurrentReplicaState();
            if (this.shouldPostponeBlocksFromFuture && this.namesystem.isGenStampInFuture(iblk)) {
                this.queueReportedBlock(node, iblk, reportedState, QUEUE_REASON_FUTURE_GENSTAMP);
                continue;
            }
            BlockInfo storedBlock = this.blocksMap.getStoredBlock(iblk);
            if (storedBlock == null) continue;
            HdfsServerConstants.BlockUCState ucState = storedBlock.getBlockUCState();
            BlockToMarkCorrupt c = this.checkReplicaCorrupt(iblk, reportedState, storedBlock, ucState, node);
            if (c != null) {
                if (this.shouldPostponeBlocksFromFuture) {
                    this.queueReportedBlock(node, iblk, reportedState, QUEUE_REASON_CORRUPT_STATE);
                    continue;
                }
                this.markBlockAsCorrupt(c, node);
                continue;
            }
            if (this.isBlockUnderConstruction(storedBlock, ucState, reportedState)) {
                ((BlockInfoUnderConstruction)storedBlock).addReplicaIfNotPresent(node, iblk, reportedState);
            }
            if (reportedState != HdfsServerConstants.ReplicaState.FINALIZED) continue;
            this.addStoredBlockImmediate(storedBlock, node);
        }
    }

    private void reportDiff(DatanodeDescriptor dn, BlockListAsLongs newReport, Collection<BlockInfo> toAdd, Collection<Block> toRemove, Collection<Block> toInvalidate, Collection<BlockToMarkCorrupt> toCorrupt, Collection<StatefulBlockInfo> toUC) {
        BlockInfo delimiter = new BlockInfo(new Block(), 1);
        boolean added = dn.addBlock(delimiter);
        assert (added) : "Delimiting block cannot be present in the node";
        int headIndex = 0;
        if (newReport == null) {
            newReport = new BlockListAsLongs();
        }
        BlockListAsLongs.BlockReportIterator itBR = newReport.getBlockReportIterator();
        while (itBR.hasNext()) {
            int curIndex;
            HdfsServerConstants.ReplicaState iState;
            Block iblk = itBR.next();
            BlockInfo storedBlock = this.processReportedBlock(dn, iblk, iState = itBR.getCurrentReplicaState(), toAdd, toInvalidate, toCorrupt, toUC);
            if (storedBlock == null || (curIndex = storedBlock.findDatanode(dn)) < 0) continue;
            headIndex = dn.moveBlockToHead(storedBlock, curIndex, headIndex);
        }
        DatanodeDescriptor.BlockIterator it = new DatanodeDescriptor.BlockIterator(delimiter.getNext(0), dn);
        while (it.hasNext()) {
            toRemove.add((Block)it.next());
        }
        dn.removeBlock(delimiter);
    }

    private BlockInfo processReportedBlock(DatanodeDescriptor dn, Block block, HdfsServerConstants.ReplicaState reportedState, Collection<BlockInfo> toAdd, Collection<Block> toInvalidate, Collection<BlockToMarkCorrupt> toCorrupt, Collection<StatefulBlockInfo> toUC) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Reported block " + block + " on " + dn + " size " + block.getNumBytes() + " replicaState = " + (Object)((Object)reportedState)));
        }
        if (this.shouldPostponeBlocksFromFuture && this.namesystem.isGenStampInFuture(block)) {
            this.queueReportedBlock(dn, block, reportedState, QUEUE_REASON_FUTURE_GENSTAMP);
            return null;
        }
        BlockInfo storedBlock = this.blocksMap.getStoredBlock(block);
        if (storedBlock == null) {
            toInvalidate.add(new Block(block));
            return null;
        }
        HdfsServerConstants.BlockUCState ucState = storedBlock.getBlockUCState();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("In memory blockUCState = " + (Object)((Object)ucState)));
        }
        if (this.invalidateBlocks.contains(dn.getStorageID(), block)) {
            return storedBlock;
        }
        BlockToMarkCorrupt c = this.checkReplicaCorrupt(block, reportedState, storedBlock, ucState, dn);
        if (c != null) {
            if (this.shouldPostponeBlocksFromFuture) {
                this.queueReportedBlock(dn, storedBlock, reportedState, QUEUE_REASON_CORRUPT_STATE);
            } else {
                toCorrupt.add(c);
            }
            return storedBlock;
        }
        if (this.isBlockUnderConstruction(storedBlock, ucState, reportedState)) {
            toUC.add(new StatefulBlockInfo((BlockInfoUnderConstruction)storedBlock, reportedState));
            return storedBlock;
        }
        if (reportedState == HdfsServerConstants.ReplicaState.FINALIZED && storedBlock.findDatanode(dn) < 0) {
            toAdd.add(storedBlock);
        }
        return storedBlock;
    }

    private void queueReportedBlock(DatanodeDescriptor dn, Block block, HdfsServerConstants.ReplicaState reportedState, String reason) {
        assert (this.shouldPostponeBlocksFromFuture);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Queueing reported block " + block + " in state " + (Object)((Object)reportedState) + " from datanode " + dn + " for later processing " + "because " + reason + "."));
        }
        this.pendingDNMessages.enqueueReportedBlock(dn, block, reportedState);
    }

    public void processQueuedMessagesForBlock(Block b) throws IOException {
        Queue<PendingDataNodeMessages.ReportedBlockInfo> queue = this.pendingDNMessages.takeBlockQueue(b);
        if (queue == null) {
            return;
        }
        this.processQueuedMessages(queue);
    }

    private void processQueuedMessages(Iterable<PendingDataNodeMessages.ReportedBlockInfo> rbis) throws IOException {
        for (PendingDataNodeMessages.ReportedBlockInfo rbi : rbis) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Processing previouly queued message " + rbi));
            }
            this.processAndHandleReportedBlock(rbi.getNode(), rbi.getBlock(), rbi.getReportedState(), null);
        }
    }

    public void processAllPendingDNMessages() throws IOException {
        assert (!this.shouldPostponeBlocksFromFuture) : "processAllPendingDNMessages() should be called after disabling block postponement.";
        int count2 = this.pendingDNMessages.count();
        if (count2 > 0) {
            LOG.info((Object)("Processing " + count2 + " messages from DataNodes " + "that were previously queued during standby state"));
        }
        this.processQueuedMessages(this.pendingDNMessages.takeAll());
        assert (this.pendingDNMessages.count() == 0);
    }

    private BlockToMarkCorrupt checkReplicaCorrupt(Block reported, HdfsServerConstants.ReplicaState reportedState, BlockInfo storedBlock, HdfsServerConstants.BlockUCState ucState, DatanodeDescriptor dn) {
        switch (reportedState) {
            case FINALIZED: {
                switch (ucState) {
                    case COMPLETE: 
                    case COMMITTED: {
                        if (storedBlock.getGenerationStamp() != reported.getGenerationStamp()) {
                            long reportedGS = reported.getGenerationStamp();
                            return new BlockToMarkCorrupt(storedBlock, reportedGS, "block is " + (Object)((Object)ucState) + " and reported genstamp " + reportedGS + " does not match genstamp in block map " + storedBlock.getGenerationStamp());
                        }
                        if (storedBlock.getNumBytes() != reported.getNumBytes()) {
                            return new BlockToMarkCorrupt(storedBlock, "block is " + (Object)((Object)ucState) + " and reported length " + reported.getNumBytes() + " does not match " + "length in block map " + storedBlock.getNumBytes());
                        }
                        return null;
                    }
                }
                return null;
            }
            case RBW: 
            case RWR: {
                if (!storedBlock.isComplete()) {
                    return null;
                }
                if (storedBlock.getGenerationStamp() != reported.getGenerationStamp()) {
                    long reportedGS = reported.getGenerationStamp();
                    return new BlockToMarkCorrupt(storedBlock, reportedGS, "reported " + (Object)((Object)reportedState) + " replica with genstamp " + reportedGS + " does not match COMPLETE block's genstamp in block map " + storedBlock.getGenerationStamp());
                }
                if (reportedState == HdfsServerConstants.ReplicaState.RBW) {
                    LOG.info((Object)("Received an RBW replica for " + storedBlock + " on " + dn + ": ignoring it, since it is " + "complete with the same genstamp"));
                    return null;
                }
                return new BlockToMarkCorrupt(storedBlock, "reported replica has invalid state " + (Object)((Object)reportedState));
            }
        }
        String msg = "Unexpected replica state " + (Object)((Object)reportedState) + " for block: " + storedBlock + " on " + dn + " size " + storedBlock.getNumBytes();
        LOG.warn((Object)msg);
        return new BlockToMarkCorrupt(storedBlock, msg);
    }

    private boolean isBlockUnderConstruction(BlockInfo storedBlock, HdfsServerConstants.BlockUCState ucState, HdfsServerConstants.ReplicaState reportedState) {
        switch (reportedState) {
            case FINALIZED: {
                switch (ucState) {
                    case UNDER_CONSTRUCTION: 
                    case UNDER_RECOVERY: {
                        return true;
                    }
                }
                return false;
            }
            case RBW: 
            case RWR: {
                return !storedBlock.isComplete();
            }
        }
        return false;
    }

    void addStoredBlockUnderConstruction(BlockInfoUnderConstruction block, DatanodeDescriptor node, HdfsServerConstants.ReplicaState reportedState) throws IOException {
        block.addReplicaIfNotPresent(node, block, reportedState);
        if (reportedState == HdfsServerConstants.ReplicaState.FINALIZED && block.findDatanode(node) < 0) {
            this.addStoredBlock(block, node, null, true);
        }
    }

    private void addStoredBlockImmediate(BlockInfo storedBlock, DatanodeDescriptor node) throws IOException {
        assert (storedBlock != null && this.namesystem.hasWriteLock());
        if (!this.namesystem.isInStartupSafeMode() || this.namesystem.isPopulatingReplQueues()) {
            this.addStoredBlock(storedBlock, node, null, false);
            return;
        }
        node.addBlock(storedBlock);
        int numCurrentReplica = this.countLiveNodes(storedBlock);
        if (storedBlock.getBlockUCState() == HdfsServerConstants.BlockUCState.COMMITTED && numCurrentReplica >= this.minReplication) {
            this.completeBlock((MutableBlockCollection)storedBlock.getBlockCollection(), storedBlock, false);
        } else if (storedBlock.isComplete()) {
            this.namesystem.incrementSafeBlockCount(numCurrentReplica);
        }
    }

    private Block addStoredBlock(BlockInfo block, DatanodeDescriptor node, DatanodeDescriptor delNodeHint, boolean logEveryBlock) throws IOException {
        int curReplicaDelta;
        assert (block != null && this.namesystem.hasWriteLock());
        BlockInfo storedBlock = block instanceof BlockInfoUnderConstruction ? this.blocksMap.getStoredBlock(block) : block;
        if (storedBlock == null || storedBlock.getBlockCollection() == null) {
            blockLog.info((Object)("BLOCK* addStoredBlock: " + block + " on " + node + " size " + block.getNumBytes() + " but it does not belong to any file"));
            return block;
        }
        assert (storedBlock != null) : "Block must be stored by now";
        BlockCollection bc = storedBlock.getBlockCollection();
        assert (bc != null) : "Block must belong to a file";
        boolean added = node.addBlock(storedBlock);
        if (added) {
            curReplicaDelta = 1;
            if (logEveryBlock) {
                this.logAddStoredBlock(storedBlock, node);
            }
        } else {
            curReplicaDelta = 0;
            blockLog.warn((Object)("BLOCK* addStoredBlock: Redundant addStoredBlock request received for " + storedBlock + " on " + node + " size " + storedBlock.getNumBytes()));
        }
        NumberReplicas num = this.countNodes(storedBlock);
        int numLiveReplicas = num.liveReplicas();
        int numCurrentReplica = numLiveReplicas + this.pendingReplications.getNumReplicas(storedBlock);
        if (storedBlock.getBlockUCState() == HdfsServerConstants.BlockUCState.COMMITTED && numLiveReplicas >= this.minReplication) {
            storedBlock = this.completeBlock((MutableBlockCollection)bc, storedBlock, false);
        } else if (storedBlock.isComplete()) {
            this.namesystem.incrementSafeBlockCount(numCurrentReplica);
        }
        if (bc instanceof MutableBlockCollection) {
            return storedBlock;
        }
        if (!this.namesystem.isPopulatingReplQueues()) {
            return storedBlock;
        }
        short fileReplication = bc.getBlockReplication();
        if (!this.isNeededReplication(storedBlock, fileReplication, numCurrentReplica)) {
            this.neededReplications.remove(storedBlock, numCurrentReplica, num.decommissionedReplicas(), fileReplication);
        } else {
            this.updateNeededReplications(storedBlock, curReplicaDelta, 0);
        }
        if (numCurrentReplica > fileReplication) {
            this.processOverReplicatedBlock(storedBlock, fileReplication, node, delNodeHint);
        }
        int corruptReplicasCount = this.corruptReplicas.numCorruptReplicas(storedBlock);
        int numCorruptNodes = num.corruptReplicas();
        if (numCorruptNodes != corruptReplicasCount) {
            LOG.warn((Object)("Inconsistent number of corrupt replicas for " + storedBlock + "blockMap has " + numCorruptNodes + " but corrupt replicas map has " + corruptReplicasCount));
        }
        if (corruptReplicasCount > 0 && numLiveReplicas >= fileReplication) {
            this.invalidateCorruptReplicas(storedBlock);
        }
        return storedBlock;
    }

    private void logAddStoredBlock(BlockInfo storedBlock, DatanodeDescriptor node) {
        if (!blockLog.isInfoEnabled()) {
            return;
        }
        StringBuilder sb = new StringBuilder(500);
        sb.append("BLOCK* addStoredBlock: blockMap updated: ").append(node).append(" is added to ");
        storedBlock.appendStringTo(sb);
        sb.append(" size ").append(storedBlock.getNumBytes());
        blockLog.info((Object)sb);
    }

    private void invalidateCorruptReplicas(BlockInfo blk) {
        DatanodeDescriptor[] nodesCopy;
        Collection<DatanodeDescriptor> nodes = this.corruptReplicas.getNodes(blk);
        boolean removedFromBlocksMap = true;
        if (nodes == null) {
            return;
        }
        for (DatanodeDescriptor node : nodesCopy = nodes.toArray(new DatanodeDescriptor[0])) {
            try {
                if (this.invalidateBlock(new BlockToMarkCorrupt(blk, null), node)) continue;
                removedFromBlocksMap = false;
            }
            catch (IOException e) {
                blockLog.info((Object)("invalidateCorruptReplicas error in deleting bad block " + blk + " on " + node), (Throwable)e);
                removedFromBlocksMap = false;
            }
        }
        if (removedFromBlocksMap) {
            this.corruptReplicas.removeFromCorruptReplicasMap(blk);
        }
    }

    public void processMisReplicatedBlocks() {
        assert (this.namesystem.hasWriteLock());
        long nrInvalid = 0L;
        long nrOverReplicated = 0L;
        long nrUnderReplicated = 0L;
        long nrPostponed = 0L;
        long nrUnderConstruction = 0L;
        this.neededReplications.clear();
        block8: for (BlockInfo block : this.blocksMap.getBlocks()) {
            MisReplicationResult res = this.processMisReplicatedBlock(block);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("block " + block + ": " + (Object)((Object)res)));
            }
            switch (res) {
                case UNDER_REPLICATED: {
                    ++nrUnderReplicated;
                    continue block8;
                }
                case OVER_REPLICATED: {
                    ++nrOverReplicated;
                    continue block8;
                }
                case INVALID: {
                    ++nrInvalid;
                    continue block8;
                }
                case POSTPONE: {
                    ++nrPostponed;
                    this.postponeBlock(block);
                    continue block8;
                }
                case UNDER_CONSTRUCTION: {
                    ++nrUnderConstruction;
                    continue block8;
                }
                case OK: {
                    continue block8;
                }
            }
            throw new AssertionError((Object)("Invalid enum value: " + (Object)((Object)res)));
        }
        LOG.info((Object)("Total number of blocks            = " + this.blocksMap.size()));
        LOG.info((Object)("Number of invalid blocks          = " + nrInvalid));
        LOG.info((Object)("Number of under-replicated blocks = " + nrUnderReplicated));
        LOG.info((Object)("Number of  over-replicated blocks = " + nrOverReplicated + (nrPostponed > 0L ? " (" + nrPostponed + " postponed)" : "")));
        LOG.info((Object)("Number of blocks being written    = " + nrUnderConstruction));
    }

    private MisReplicationResult processMisReplicatedBlock(BlockInfo block) {
        NumberReplicas num;
        int numCurrentReplica;
        BlockCollection bc = block.getBlockCollection();
        if (bc == null) {
            this.addToInvalidates(block);
            return MisReplicationResult.INVALID;
        }
        if (!block.isComplete()) {
            return MisReplicationResult.UNDER_CONSTRUCTION;
        }
        short expectedReplication = bc.getBlockReplication();
        if (this.isNeededReplication(block, expectedReplication, numCurrentReplica = (num = this.countNodes(block)).liveReplicas()) && this.neededReplications.add(block, numCurrentReplica, num.decommissionedReplicas(), expectedReplication)) {
            return MisReplicationResult.UNDER_REPLICATED;
        }
        if (numCurrentReplica > expectedReplication) {
            if (num.replicasOnStaleNodes() > 0) {
                return MisReplicationResult.POSTPONE;
            }
            this.processOverReplicatedBlock(block, expectedReplication, null, null);
            return MisReplicationResult.OVER_REPLICATED;
        }
        return MisReplicationResult.OK;
    }

    public void setReplication(short oldRepl, short newRepl, String src, Block ... blocks) {
        if (newRepl == oldRepl) {
            return;
        }
        for (Block b : blocks) {
            this.updateNeededReplications(b, 0, newRepl - oldRepl);
        }
        if (oldRepl > newRepl) {
            LOG.info((Object)("Decreasing replication from " + oldRepl + " to " + newRepl + " for " + src));
            for (Block b : blocks) {
                this.processOverReplicatedBlock(b, newRepl, null, null);
            }
        } else {
            LOG.info((Object)("Increasing replication from " + oldRepl + " to " + newRepl + " for " + src));
        }
    }

    private void processOverReplicatedBlock(Block block, short replication, DatanodeDescriptor addedNode, DatanodeDescriptor delNodeHint) {
        assert (this.namesystem.hasWriteLock());
        if (addedNode == delNodeHint) {
            delNodeHint = null;
        }
        ArrayList<DatanodeDescriptor> nonExcess = new ArrayList<DatanodeDescriptor>();
        Collection<DatanodeDescriptor> corruptNodes = this.corruptReplicas.getNodes(block);
        Iterator<DatanodeDescriptor> it = this.blocksMap.nodeIterator(block);
        while (it.hasNext()) {
            DatanodeDescriptor cur = it.next();
            if (cur.areBlockContentsStale()) {
                LOG.info((Object)("BLOCK* processOverReplicatedBlock: Postponing processing of over-replicated " + block + " since datanode " + cur + " does not yet have up-to-date " + "block information."));
                this.postponeBlock(block);
                return;
            }
            LightWeightLinkedSet<Block> excessBlocks = this.excessReplicateMap.get(cur.getStorageID());
            if (excessBlocks != null && excessBlocks.contains(block) || cur.isDecommissionInProgress() || cur.isDecommissioned() || corruptNodes != null && corruptNodes.contains(cur)) continue;
            nonExcess.add(cur);
        }
        this.chooseExcessReplicates(nonExcess, block, replication, addedNode, delNodeHint, this.blockplacement);
    }

    private void chooseExcessReplicates(Collection<DatanodeDescriptor> nonExcess, Block b, short replication, DatanodeDescriptor addedNode, DatanodeDescriptor delNodeHint, BlockPlacementPolicy replicator) {
        assert (this.namesystem.hasWriteLock());
        BlockCollection bc = this.getBlockCollection(b);
        HashMap<String, List<DatanodeDescriptor>> rackMap = new HashMap<String, List<DatanodeDescriptor>>();
        ArrayList<DatanodeDescriptor> moreThanOne = new ArrayList<DatanodeDescriptor>();
        ArrayList<DatanodeDescriptor> exactlyOne = new ArrayList<DatanodeDescriptor>();
        replicator.splitNodesWithRack(nonExcess, rackMap, moreThanOne, exactlyOne);
        boolean firstOne = true;
        while (nonExcess.size() - replication > 0) {
            DatanodeDescriptor cur = firstOne && delNodeHint != null && nonExcess.contains(delNodeHint) && (moreThanOne.contains(delNodeHint) || addedNode != null && !moreThanOne.contains(addedNode)) ? delNodeHint : replicator.chooseReplicaToDelete(bc, b, replication, moreThanOne, exactlyOne);
            firstOne = false;
            replicator.adjustSetsWithChosenReplica(rackMap, moreThanOne, exactlyOne, cur);
            nonExcess.remove(cur);
            this.addToExcessReplicate(cur, b);
            this.addToInvalidates(b, cur);
            blockLog.info((Object)("BLOCK* chooseExcessReplicates: (" + cur + ", " + b + ") is added to invalidated blocks set"));
        }
    }

    private void addToExcessReplicate(DatanodeInfo dn, Block block) {
        assert (this.namesystem.hasWriteLock());
        LightWeightLinkedSet<Block> excessBlocks = this.excessReplicateMap.get(dn.getStorageID());
        if (excessBlocks == null) {
            excessBlocks = new LightWeightLinkedSet();
            this.excessReplicateMap.put(dn.getStorageID(), excessBlocks);
        }
        if (excessBlocks.add(block)) {
            this.excessBlocksCount.incrementAndGet();
            if (blockLog.isDebugEnabled()) {
                blockLog.debug((Object)("BLOCK* addToExcessReplicate: (" + dn + ", " + block + ") is added to excessReplicateMap"));
            }
        }
    }

    public void removeStoredBlock(Block block, DatanodeDescriptor node) {
        LightWeightLinkedSet<Block> excessBlocks;
        if (blockLog.isDebugEnabled()) {
            blockLog.debug((Object)("BLOCK* removeStoredBlock: " + block + " from " + node));
        }
        assert (this.namesystem.hasWriteLock());
        if (!this.blocksMap.removeNode(block, node)) {
            if (blockLog.isDebugEnabled()) {
                blockLog.debug((Object)("BLOCK* removeStoredBlock: " + block + " has already been removed from node " + node));
            }
            return;
        }
        BlockCollection bc = this.blocksMap.getBlockCollection(block);
        if (bc != null) {
            this.namesystem.decrementSafeBlockCount(block);
            this.updateNeededReplications(block, -1, 0);
        }
        if ((excessBlocks = this.excessReplicateMap.get(node.getStorageID())) != null && excessBlocks.remove(block)) {
            this.excessBlocksCount.decrementAndGet();
            if (blockLog.isDebugEnabled()) {
                blockLog.debug((Object)("BLOCK* removeStoredBlock: " + block + " is removed from excessBlocks"));
            }
            if (excessBlocks.size() == 0) {
                this.excessReplicateMap.remove(node.getStorageID());
            }
        }
        this.corruptReplicas.removeFromCorruptReplicasMap(block, node);
    }

    private long addBlock(Block block, List<BlocksWithLocations.BlockWithLocations> results) {
        List<String> machineSet = this.getValidLocations(block);
        if (machineSet.size() == 0) {
            return 0L;
        }
        results.add(new BlocksWithLocations.BlockWithLocations(block, machineSet.toArray(new String[machineSet.size()])));
        return block.getNumBytes();
    }

    @VisibleForTesting
    void addBlock(DatanodeDescriptor node, Block block, String delHint) throws IOException {
        node.decBlocksScheduled();
        DatanodeDescriptor delHintNode = null;
        if (delHint != null && delHint.length() != 0 && (delHintNode = this.datanodeManager.getDatanode(delHint)) == null) {
            blockLog.warn((Object)("BLOCK* blockReceived: " + block + " is expected to be removed from an unrecorded node " + delHint));
        }
        this.pendingReplications.decrement(block, node);
        this.processAndHandleReportedBlock(node, block, HdfsServerConstants.ReplicaState.FINALIZED, delHintNode);
    }

    private void processAndHandleReportedBlock(DatanodeDescriptor node, Block block, HdfsServerConstants.ReplicaState reportedState, DatanodeDescriptor delHintNode) throws IOException {
        LinkedList<BlockInfo> toAdd = new LinkedList<BlockInfo>();
        LinkedList<Block> toInvalidate = new LinkedList<Block>();
        LinkedList<BlockToMarkCorrupt> toCorrupt = new LinkedList<BlockToMarkCorrupt>();
        LinkedList<StatefulBlockInfo> toUC = new LinkedList<StatefulBlockInfo>();
        this.processReportedBlock(node, block, reportedState, toAdd, toInvalidate, toCorrupt, toUC);
        assert (toUC.size() + toAdd.size() + toInvalidate.size() + toCorrupt.size() <= 1) : "The block should be only in one of the lists.";
        for (StatefulBlockInfo statefulBlockInfo : toUC) {
            this.addStoredBlockUnderConstruction(statefulBlockInfo.storedBlock, node, statefulBlockInfo.reportedState);
        }
        for (BlockInfo blockInfo : toAdd) {
            this.addStoredBlock(blockInfo, node, delHintNode, true);
        }
        for (Block block2 : toInvalidate) {
            blockLog.info((Object)("BLOCK* addBlock: block " + block2 + " on " + node + " size " + block2.getNumBytes() + " does not belong to any file"));
            this.addToInvalidates(block2, node);
        }
        for (BlockToMarkCorrupt blockToMarkCorrupt : toCorrupt) {
            this.markBlockAsCorrupt(blockToMarkCorrupt, node);
        }
    }

    public void processIncrementalBlockReport(DatanodeID nodeID, String poolId, ReceivedDeletedBlockInfo[] blockInfos) throws IOException {
        assert (this.namesystem.hasWriteLock());
        int received = 0;
        int deleted = 0;
        int receiving = 0;
        DatanodeDescriptor node = this.datanodeManager.getDatanode(nodeID);
        if (node == null || !node.isAlive) {
            blockLog.warn((Object)("BLOCK* processIncrementalBlockReport is received from dead or unregistered node " + nodeID));
            throw new IOException("Got incremental block report from unregistered or dead node");
        }
        for (ReceivedDeletedBlockInfo rdbi : blockInfos) {
            switch (rdbi.getStatus()) {
                case DELETED_BLOCK: {
                    this.removeStoredBlock(rdbi.getBlock(), node);
                    ++deleted;
                    break;
                }
                case RECEIVED_BLOCK: {
                    this.addBlock(node, rdbi.getBlock(), rdbi.getDelHints());
                    ++received;
                    break;
                }
                case RECEIVING_BLOCK: {
                    ++receiving;
                    this.processAndHandleReportedBlock(node, rdbi.getBlock(), HdfsServerConstants.ReplicaState.RBW, null);
                    break;
                }
                default: {
                    String msg = "Unknown block status code reported by " + nodeID + ": " + rdbi;
                    blockLog.warn((Object)msg);
                    assert (false) : msg;
                    break;
                }
            }
            if (!blockLog.isDebugEnabled()) continue;
            blockLog.debug((Object)("BLOCK* block " + (Object)((Object)rdbi.getStatus()) + ": " + rdbi.getBlock() + " is received from " + nodeID));
        }
        blockLog.debug((Object)("*BLOCK* NameNode.processIncrementalBlockReport: from " + nodeID + " receiving: " + receiving + ", " + " received: " + received + ", " + " deleted: " + deleted));
    }

    public NumberReplicas countNodes(Block b) {
        int decommissioned = 0;
        int live = 0;
        int corrupt = 0;
        int excess = 0;
        int stale = 0;
        Iterator<DatanodeDescriptor> nodeIter = this.blocksMap.nodeIterator(b);
        Collection<DatanodeDescriptor> nodesCorrupt = this.corruptReplicas.getNodes(b);
        while (nodeIter.hasNext()) {
            DatanodeDescriptor node = nodeIter.next();
            if (nodesCorrupt != null && nodesCorrupt.contains(node)) {
                ++corrupt;
            } else if (node.isDecommissionInProgress() || node.isDecommissioned()) {
                ++decommissioned;
            } else {
                LightWeightLinkedSet<Block> blocksExcess = this.excessReplicateMap.get(node.getStorageID());
                if (blocksExcess != null && blocksExcess.contains(b)) {
                    ++excess;
                } else {
                    ++live;
                }
            }
            if (!node.areBlockContentsStale()) continue;
            ++stale;
        }
        return new NumberReplicas(live, decommissioned, corrupt, excess, stale);
    }

    int countLiveNodes(BlockInfo b) {
        if (!this.namesystem.isInStartupSafeMode()) {
            return this.countNodes(b).liveReplicas();
        }
        int live = 0;
        Iterator<DatanodeDescriptor> nodeIter = this.blocksMap.nodeIterator(b);
        Collection<DatanodeDescriptor> nodesCorrupt = this.corruptReplicas.getNodes(b);
        while (nodeIter.hasNext()) {
            DatanodeDescriptor node = nodeIter.next();
            if (nodesCorrupt != null && nodesCorrupt.contains(node)) continue;
            ++live;
        }
        return live;
    }

    private void logBlockReplicationInfo(Block block, DatanodeDescriptor srcNode, NumberReplicas num) {
        int curReplicas = num.liveReplicas();
        int curExpectedReplicas = this.getReplication(block);
        BlockCollection bc = this.blocksMap.getBlockCollection(block);
        Iterator<DatanodeDescriptor> nodeIter = this.blocksMap.nodeIterator(block);
        StringBuilder nodeList = new StringBuilder();
        while (nodeIter.hasNext()) {
            DatanodeDescriptor node = nodeIter.next();
            nodeList.append(node);
            nodeList.append(" ");
        }
        LOG.info((Object)("Block: " + block + ", Expected Replicas: " + curExpectedReplicas + ", live replicas: " + curReplicas + ", corrupt replicas: " + num.corruptReplicas() + ", decommissioned replicas: " + num.decommissionedReplicas() + ", excess replicas: " + num.excessReplicas() + ", Is Open File: " + (bc instanceof MutableBlockCollection) + ", Datanodes having this block: " + nodeList + ", Current Datanode: " + srcNode + ", Is current datanode decommissioning: " + srcNode.isDecommissionInProgress()));
    }

    void processOverReplicatedBlocksOnReCommission(DatanodeDescriptor srcNode) {
        Iterator<BlockInfo> it = srcNode.getBlockIterator();
        int numOverReplicated = 0;
        while (it.hasNext()) {
            Block block = it.next();
            BlockCollection bc = this.blocksMap.getBlockCollection(block);
            short expectedReplication = bc.getBlockReplication();
            NumberReplicas num = this.countNodes(block);
            int numCurrentReplica = num.liveReplicas();
            if (numCurrentReplica <= expectedReplication) continue;
            this.processOverReplicatedBlock(block, expectedReplication, null, null);
            ++numOverReplicated;
        }
        LOG.info((Object)("Invalidated " + numOverReplicated + " over-replicated blocks on " + srcNode + " during recommissioning"));
    }

    boolean isReplicationInProgress(DatanodeDescriptor srcNode) {
        boolean status = false;
        int underReplicatedBlocks = 0;
        int decommissionOnlyReplicas = 0;
        int underReplicatedInOpenFiles = 0;
        Iterator<BlockInfo> it = srcNode.getBlockIterator();
        while (it.hasNext()) {
            Block block = it.next();
            BlockCollection bc = this.blocksMap.getBlockCollection(block);
            if (bc == null) continue;
            NumberReplicas num = this.countNodes(block);
            int curReplicas = num.liveReplicas();
            int curExpectedReplicas = this.getReplication(block);
            if (!this.isNeededReplication(block, curExpectedReplicas, curReplicas)) continue;
            if (curExpectedReplicas > curReplicas) {
                if (!status) {
                    status = true;
                    this.logBlockReplicationInfo(block, srcNode, num);
                }
                ++underReplicatedBlocks;
                if (curReplicas == 0 && num.decommissionedReplicas() > 0) {
                    ++decommissionOnlyReplicas;
                }
                if (bc instanceof MutableBlockCollection) {
                    ++underReplicatedInOpenFiles;
                }
            }
            if (this.neededReplications.contains(block) || this.pendingReplications.getNumReplicas(block) != 0) continue;
            this.neededReplications.add(block, curReplicas, num.decommissionedReplicas(), curExpectedReplicas);
        }
        srcNode.decommissioningStatus.set(underReplicatedBlocks, decommissionOnlyReplicas, underReplicatedInOpenFiles);
        return status;
    }

    public int getActiveBlockCount() {
        return this.blocksMap.size();
    }

    public DatanodeDescriptor[] getNodes(BlockInfo block) {
        DatanodeDescriptor[] nodes = new DatanodeDescriptor[block.numNodes()];
        Iterator<DatanodeDescriptor> it = this.blocksMap.nodeIterator(block);
        int i = 0;
        while (it != null && it.hasNext()) {
            nodes[i] = it.next();
            ++i;
        }
        return nodes;
    }

    public int getTotalBlocks() {
        return this.blocksMap.size();
    }

    public void removeBlock(Block block) {
        assert (this.namesystem.hasWriteLock());
        block.setNumBytes(Long.MAX_VALUE);
        this.addToInvalidates(block);
        this.corruptReplicas.removeFromCorruptReplicasMap(block);
        this.blocksMap.removeBlock(block);
        this.pendingReplications.remove(block);
        this.neededReplications.remove(block, 5);
        if (this.postponedMisreplicatedBlocks.remove(block)) {
            this.postponedMisreplicatedBlocksCount.decrementAndGet();
        }
    }

    public BlockInfo getStoredBlock(Block block) {
        return this.blocksMap.getStoredBlock(block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNeededReplications(Block block, int curReplicasDelta, int expectedReplicasDelta) {
        this.namesystem.writeLock();
        try {
            if (!this.namesystem.isPopulatingReplQueues()) {
                return;
            }
            NumberReplicas repl = this.countNodes(block);
            int curExpectedReplicas = this.getReplication(block);
            if (this.isNeededReplication(block, curExpectedReplicas, repl.liveReplicas())) {
                this.neededReplications.update(block, repl.liveReplicas(), repl.decommissionedReplicas(), curExpectedReplicas, curReplicasDelta, expectedReplicasDelta);
            } else {
                int oldReplicas = repl.liveReplicas() - curReplicasDelta;
                int oldExpectedReplicas = curExpectedReplicas - expectedReplicasDelta;
                this.neededReplications.remove(block, oldReplicas, repl.decommissionedReplicas(), oldExpectedReplicas);
            }
        }
        finally {
            this.namesystem.writeUnlock();
        }
    }

    public void checkReplication(BlockCollection bc) {
        short expected = bc.getBlockReplication();
        for (BlockInfo block : bc.getBlocks()) {
            NumberReplicas n = this.countNodes(block);
            if (this.isNeededReplication(block, expected, n.liveReplicas())) {
                this.neededReplications.add(block, n.liveReplicas(), n.decommissionedReplicas(), expected);
                continue;
            }
            if (n.liveReplicas() <= expected) continue;
            this.processOverReplicatedBlock(block, expected, null, null);
        }
    }

    private int getReplication(Block block) {
        BlockCollection bc = this.blocksMap.getBlockCollection(block);
        return bc == null ? (short)0 : bc.getBlockReplication();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int invalidateWorkForOneNode(String nodeId) {
        this.namesystem.writeLock();
        try {
            if (this.namesystem.isInSafeMode()) {
                LOG.debug((Object)"In safemode, not computing replication work");
                int n = 0;
                return n;
            }
            assert (nodeId != null);
            int n = this.invalidateBlocks.invalidateWork(nodeId);
            return n;
        }
        finally {
            this.namesystem.writeUnlock();
        }
    }

    boolean blockHasEnoughRacks(Block b) {
        if (!this.shouldCheckForEnoughRacks) {
            return true;
        }
        boolean enoughRacks = false;
        Collection<DatanodeDescriptor> corruptNodes = this.corruptReplicas.getNodes(b);
        int numExpectedReplicas = this.getReplication(b);
        String rackName = null;
        Iterator<DatanodeDescriptor> it = this.blocksMap.nodeIterator(b);
        while (it.hasNext()) {
            DatanodeDescriptor cur = it.next();
            if (cur.isDecommissionInProgress() || cur.isDecommissioned() || corruptNodes != null && corruptNodes.contains(cur)) continue;
            if (numExpectedReplicas == 1 || numExpectedReplicas > 1 && !this.datanodeManager.hasClusterEverBeenMultiRack()) {
                enoughRacks = true;
                break;
            }
            String rackNameNew = cur.getNetworkLocation();
            if (rackName == null) {
                rackName = rackNameNew;
                continue;
            }
            if (rackName.equals(rackNameNew)) continue;
            enoughRacks = true;
            break;
        }
        return enoughRacks;
    }

    private boolean isNeededReplication(Block b, int expected, int current) {
        return current < expected || !this.blockHasEnoughRacks(b);
    }

    public long getMissingBlocksCount() {
        return this.neededReplications.getCorruptBlockSize();
    }

    public BlockInfo addBlockCollection(BlockInfo block, BlockCollection bc) {
        return this.blocksMap.addBlockCollection(block, bc);
    }

    public BlockCollection getBlockCollection(Block b) {
        return this.blocksMap.getBlockCollection(b);
    }

    public Iterator<DatanodeDescriptor> datanodeIterator(Block block) {
        return this.blocksMap.nodeIterator(block);
    }

    public int numCorruptReplicas(Block block) {
        return this.corruptReplicas.numCorruptReplicas(block);
    }

    public void removeBlockFromMap(Block block) {
        this.blocksMap.removeBlock(block);
        this.corruptReplicas.removeFromCorruptReplicasMap(block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCapacity() {
        this.namesystem.readLock();
        try {
            int n = this.blocksMap.getCapacity();
            return n;
        }
        finally {
            this.namesystem.readUnlock();
        }
    }

    public long[] getCorruptReplicaBlockIds(int numExpectedBlocks, Long startingBlockId) {
        return this.corruptReplicas.getCorruptReplicaBlockIds(numExpectedBlocks, startingBlockId);
    }

    public Iterator<Block> getCorruptReplicaBlockIterator() {
        return this.neededReplications.iterator(4);
    }

    public int numOfUnderReplicatedBlocks() {
        return this.neededReplications.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int computeDatanodeWork() {
        if (this.namesystem.isInSafeMode()) {
            return 0;
        }
        int numlive = this.heartbeatManager.getLiveDatanodeCount();
        int blocksToProcess = numlive * this.blocksReplWorkMultiplier;
        int nodesToProcess = (int)Math.ceil((float)numlive * this.blocksInvalidateWorkPct);
        int workFound = this.computeReplicationWork(blocksToProcess);
        this.namesystem.writeLock();
        try {
            this.updateState();
            this.scheduledReplicationBlocksCount = workFound;
        }
        finally {
            this.namesystem.writeUnlock();
        }
        return workFound += this.computeInvalidateWork(nodesToProcess);
    }

    public void clearQueues() {
        this.neededReplications.clear();
        this.pendingReplications.clear();
        this.excessReplicateMap.clear();
        this.invalidateBlocks.clear();
        this.datanodeManager.clearPendingQueues();
    }

    public void shutdown() {
        this.blocksMap.close();
    }

    static enum MisReplicationResult {
        INVALID,
        UNDER_REPLICATED,
        OVER_REPLICATED,
        POSTPONE,
        UNDER_CONSTRUCTION,
        OK;

    }

    private static class ReplicationWork {
        private Block block;
        private BlockCollection bc;
        private DatanodeDescriptor srcNode;
        private List<DatanodeDescriptor> containingNodes;
        private List<DatanodeDescriptor> liveReplicaNodes;
        private int additionalReplRequired;
        private DatanodeDescriptor[] targets;
        private int priority;

        public ReplicationWork(Block block, BlockCollection bc, DatanodeDescriptor srcNode, List<DatanodeDescriptor> containingNodes, List<DatanodeDescriptor> liveReplicaNodes, int additionalReplRequired, int priority) {
            this.block = block;
            this.bc = bc;
            this.srcNode = srcNode;
            this.containingNodes = containingNodes;
            this.liveReplicaNodes = liveReplicaNodes;
            this.additionalReplRequired = additionalReplRequired;
            this.priority = priority;
            this.targets = null;
        }

        static /* synthetic */ List access$100(ReplicationWork x0) {
            return x0.containingNodes;
        }

        static /* synthetic */ DatanodeDescriptor[] access$202(ReplicationWork x0, DatanodeDescriptor[] x1) {
            x0.targets = x1;
            return x1;
        }

        static /* synthetic */ BlockCollection access$300(ReplicationWork x0) {
            return x0.bc;
        }

        static /* synthetic */ int access$400(ReplicationWork x0) {
            return x0.additionalReplRequired;
        }

        static /* synthetic */ DatanodeDescriptor access$500(ReplicationWork x0) {
            return x0.srcNode;
        }

        static /* synthetic */ List access$600(ReplicationWork x0) {
            return x0.liveReplicaNodes;
        }

        static /* synthetic */ Block access$700(ReplicationWork x0) {
            return x0.block;
        }

        static /* synthetic */ DatanodeDescriptor[] access$200(ReplicationWork x0) {
            return x0.targets;
        }

        static /* synthetic */ int access$800(ReplicationWork x0) {
            return x0.priority;
        }
    }

    private class ReplicationMonitor
    implements Runnable {
        private ReplicationMonitor() {
        }

        @Override
        public void run() {
            while (BlockManager.this.namesystem.isRunning()) {
                try {
                    BlockManager.this.computeDatanodeWork();
                    BlockManager.this.processPendingReplications();
                    Thread.sleep(BlockManager.this.replicationRecheckInterval);
                }
                catch (Throwable t) {
                    if (!BlockManager.this.namesystem.isRunning()) {
                        LOG.info((Object)"Stopping ReplicationMonitor.");
                        if (t instanceof InterruptedException) break;
                        LOG.info((Object)"ReplicationMonitor received an exception while shutting down.", t);
                        break;
                    }
                    if (!BlockManager.this.checkNSRunning && t instanceof InterruptedException) {
                        LOG.info((Object)"Stopping ReplicationMonitor for testing.");
                        break;
                    }
                    LOG.fatal((Object)"ReplicationMonitor thread received Runtime exception. ", t);
                    ExitUtil.terminate(1, t);
                }
            }
        }
    }

    private static class BlockToMarkCorrupt {
        final BlockInfo corrupted;
        final BlockInfo stored;
        final String reason;

        BlockToMarkCorrupt(BlockInfo corrupted, BlockInfo stored, String reason) {
            Preconditions.checkNotNull((Object)corrupted, (Object)"corrupted is null");
            Preconditions.checkNotNull((Object)stored, (Object)"stored is null");
            this.corrupted = corrupted;
            this.stored = stored;
            this.reason = reason;
        }

        BlockToMarkCorrupt(BlockInfo stored, String reason) {
            this(stored, stored, reason);
        }

        BlockToMarkCorrupt(BlockInfo stored, long gs, String reason) {
            this(new BlockInfo(stored), stored, reason);
            this.corrupted.setGenerationStamp(gs);
        }

        public String toString() {
            return this.corrupted + "(" + (this.corrupted == this.stored ? "same as stored" : "stored=" + this.stored) + ")";
        }
    }

    private static class StatefulBlockInfo {
        final BlockInfoUnderConstruction storedBlock;
        final HdfsServerConstants.ReplicaState reportedState;

        StatefulBlockInfo(BlockInfoUnderConstruction storedBlock, HdfsServerConstants.ReplicaState reportedState) {
            this.storedBlock = storedBlock;
            this.reportedState = reportedState;
        }
    }
}

