/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.util.Arrays;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.security.token.Token;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class LocatedBlock {
    private ExtendedBlock b;
    private long offset;
    private DatanodeInfo[] locs;
    private boolean corrupt;
    private Token<BlockTokenIdentifier> blockToken = new Token();

    public LocatedBlock(ExtendedBlock b, DatanodeInfo[] locs) {
        this(b, locs, -1L, false);
    }

    public LocatedBlock(ExtendedBlock b, DatanodeInfo[] locs, long startOffset) {
        this(b, locs, startOffset, false);
    }

    public LocatedBlock(ExtendedBlock b, DatanodeInfo[] locs, long startOffset, boolean corrupt) {
        this.b = b;
        this.offset = startOffset;
        this.corrupt = corrupt;
        this.locs = locs == null ? new DatanodeInfo[0] : locs;
    }

    public Token<BlockTokenIdentifier> getBlockToken() {
        return this.blockToken;
    }

    public void setBlockToken(Token<BlockTokenIdentifier> token2) {
        this.blockToken = token2;
    }

    public ExtendedBlock getBlock() {
        return this.b;
    }

    public DatanodeInfo[] getLocations() {
        return this.locs;
    }

    public long getStartOffset() {
        return this.offset;
    }

    public long getBlockSize() {
        return this.b.getNumBytes();
    }

    void setStartOffset(long value2) {
        this.offset = value2;
    }

    void setCorrupt(boolean corrupt) {
        this.corrupt = corrupt;
    }

    public boolean isCorrupt() {
        return this.corrupt;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.b + "; getBlockSize()=" + this.getBlockSize() + "; corrupt=" + this.corrupt + "; offset=" + this.offset + "; locs=" + Arrays.asList(this.locs) + "}";
    }
}

