/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ha;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.ha.ServiceFailedException;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.ZKUtil;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKUtil;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.spark-project.guava.annotations.VisibleForTesting;
import org.spark-project.guava.base.Preconditions;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ActiveStandbyElector
implements AsyncCallback.StatCallback,
AsyncCallback.StringCallback {
    @VisibleForTesting
    protected static final String LOCK_FILENAME = "ActiveStandbyElectorLock";
    @VisibleForTesting
    protected static final String BREADCRUMB_FILENAME = "ActiveBreadCrumb";
    public static final Log LOG = LogFactory.getLog(ActiveStandbyElector.class);
    static int NUM_RETRIES = 3;
    private static final int SLEEP_AFTER_FAILURE_TO_BECOME_ACTIVE = 1000;
    private State state = State.INIT;
    private int createRetryCount = 0;
    private int statRetryCount = 0;
    private ZooKeeper zkClient;
    private WatcherWithClientRef watcher;
    private ConnectionState zkConnectionState = ConnectionState.TERMINATED;
    private final ActiveStandbyElectorCallback appClient;
    private final String zkHostPort;
    private final int zkSessionTimeout;
    private final List<ACL> zkAcl;
    private final List<ZKUtil.ZKAuthInfo> zkAuthInfo;
    private byte[] appData;
    private final String zkLockFilePath;
    private final String zkBreadCrumbPath;
    private final String znodeWorkingDir;
    private Lock sessionReestablishLockForTests = new ReentrantLock();
    private boolean wantToBeInElection;

    public ActiveStandbyElector(String zookeeperHostPorts, int zookeeperSessionTimeout, String parentZnodeName, List<ACL> acl, List<ZKUtil.ZKAuthInfo> authInfo, ActiveStandbyElectorCallback app) throws IOException, HadoopIllegalArgumentException, KeeperException {
        if (app == null || acl == null || parentZnodeName == null || zookeeperHostPorts == null || zookeeperSessionTimeout <= 0) {
            throw new HadoopIllegalArgumentException("Invalid argument");
        }
        this.zkHostPort = zookeeperHostPorts;
        this.zkSessionTimeout = zookeeperSessionTimeout;
        this.zkAcl = acl;
        this.zkAuthInfo = authInfo;
        this.appClient = app;
        this.znodeWorkingDir = parentZnodeName;
        this.zkLockFilePath = this.znodeWorkingDir + "/" + LOCK_FILENAME;
        this.zkBreadCrumbPath = this.znodeWorkingDir + "/" + BREADCRUMB_FILENAME;
        this.createConnection();
    }

    public synchronized void joinElection(byte[] data) throws HadoopIllegalArgumentException {
        if (data == null) {
            throw new HadoopIllegalArgumentException("data cannot be null");
        }
        if (this.wantToBeInElection) {
            LOG.info((Object)"Already in election. Not re-connecting.");
            return;
        }
        this.appData = new byte[data.length];
        System.arraycopy(data, 0, this.appData, 0, data.length);
        LOG.debug((Object)("Attempting active election for " + this));
        this.joinElectionInternal();
    }

    public synchronized boolean parentZNodeExists() throws IOException, InterruptedException {
        Preconditions.checkState((this.zkClient != null ? 1 : 0) != 0);
        try {
            return this.zkClient.exists(this.znodeWorkingDir, false) != null;
        }
        catch (KeeperException e) {
            throw new IOException("Couldn't determine existence of znode '" + this.znodeWorkingDir + "'", e);
        }
    }

    public synchronized void ensureParentZNode() throws IOException, InterruptedException {
        Preconditions.checkState((!this.wantToBeInElection ? 1 : 0) != 0, (Object)"ensureParentZNode() may not be called while in the election");
        String[] pathParts = this.znodeWorkingDir.split("/");
        Preconditions.checkArgument((pathParts.length >= 1 && pathParts[0].isEmpty() ? 1 : 0) != 0, (String)"Invalid path: %s", (Object[])new Object[]{this.znodeWorkingDir});
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < pathParts.length; ++i) {
            sb.append("/").append(pathParts[i]);
            String prefixPath = sb.toString();
            LOG.debug((Object)("Ensuring existence of " + prefixPath));
            try {
                this.createWithRetries(prefixPath, new byte[0], this.zkAcl, CreateMode.PERSISTENT);
                continue;
            }
            catch (KeeperException e) {
                if (ActiveStandbyElector.isNodeExists(e.code())) continue;
                throw new IOException("Couldn't create " + prefixPath, e);
            }
        }
        LOG.info((Object)("Successfully created " + this.znodeWorkingDir + " in ZK."));
    }

    public synchronized void clearParentZNode() throws IOException, InterruptedException {
        Preconditions.checkState((!this.wantToBeInElection ? 1 : 0) != 0, (Object)"clearParentZNode() may not be called while in the election");
        try {
            LOG.info((Object)("Recursively deleting " + this.znodeWorkingDir + " from ZK..."));
            ActiveStandbyElector.zkDoWithRetries(new ZKAction<Void>(){

                @Override
                public Void run() throws KeeperException, InterruptedException {
                    ZKUtil.deleteRecursive(ActiveStandbyElector.this.zkClient, ActiveStandbyElector.this.znodeWorkingDir);
                    return null;
                }
            });
        }
        catch (KeeperException e) {
            throw new IOException("Couldn't clear parent znode " + this.znodeWorkingDir, e);
        }
        LOG.info((Object)("Successfully deleted " + this.znodeWorkingDir + " from ZK."));
    }

    public synchronized void quitElection(boolean needFence) {
        LOG.info((Object)"Yielding from election");
        if (!needFence && this.state == State.ACTIVE) {
            this.tryDeleteOwnBreadCrumbNode();
        }
        this.reset();
        this.wantToBeInElection = false;
    }

    public synchronized byte[] getActiveData() throws ActiveNotFoundException, KeeperException, InterruptedException, IOException {
        try {
            if (this.zkClient == null) {
                this.createConnection();
            }
            Stat stat = new Stat();
            return this.getDataWithRetries(this.zkLockFilePath, false, stat);
        }
        catch (KeeperException e) {
            KeeperException.Code code = e.code();
            if (ActiveStandbyElector.isNodeDoesNotExist(code)) {
                throw new ActiveNotFoundException();
            }
            throw e;
        }
    }

    @Override
    public synchronized void processResult(int rc, String path, Object ctx, String name) {
        if (this.isStaleClient(ctx)) {
            return;
        }
        LOG.debug((Object)("CreateNode result: " + rc + " for path: " + path + " connectionState: " + (Object)((Object)this.zkConnectionState) + "  for " + this));
        KeeperException.Code code = KeeperException.Code.get(rc);
        if (ActiveStandbyElector.isSuccess(code)) {
            if (this.becomeActive()) {
                this.monitorActiveStatus();
            } else {
                this.reJoinElectionAfterFailureToBecomeActive();
            }
            return;
        }
        if (ActiveStandbyElector.isNodeExists(code)) {
            if (this.createRetryCount == 0) {
                this.becomeStandby();
            }
            this.monitorActiveStatus();
            return;
        }
        String errorMessage = "Received create error from Zookeeper. code:" + code.toString() + " for path " + path;
        LOG.debug((Object)errorMessage);
        if (ActiveStandbyElector.shouldRetry(code)) {
            if (this.createRetryCount < NUM_RETRIES) {
                LOG.debug((Object)("Retrying createNode createRetryCount: " + this.createRetryCount));
                ++this.createRetryCount;
                this.createLockNodeAsync();
                return;
            }
            errorMessage = errorMessage + ". Not retrying further znode create connection errors.";
        } else if (ActiveStandbyElector.isSessionExpired(code)) {
            LOG.warn((Object)"Lock acquisition failed because session was lost");
            return;
        }
        this.fatalError(errorMessage);
    }

    @Override
    public synchronized void processResult(int rc, String path, Object ctx, Stat stat) {
        if (this.isStaleClient(ctx)) {
            return;
        }
        assert (this.wantToBeInElection) : "Got a StatNode result after quitting election";
        LOG.debug((Object)("StatNode result: " + rc + " for path: " + path + " connectionState: " + (Object)((Object)this.zkConnectionState) + " for " + this));
        KeeperException.Code code = KeeperException.Code.get(rc);
        if (ActiveStandbyElector.isSuccess(code)) {
            if (stat.getEphemeralOwner() == this.zkClient.getSessionId()) {
                if (!this.becomeActive()) {
                    this.reJoinElectionAfterFailureToBecomeActive();
                }
            } else {
                this.becomeStandby();
            }
            return;
        }
        if (ActiveStandbyElector.isNodeDoesNotExist(code)) {
            this.enterNeutralMode();
            this.joinElectionInternal();
            return;
        }
        String errorMessage = "Received stat error from Zookeeper. code:" + code.toString();
        LOG.debug((Object)errorMessage);
        if (ActiveStandbyElector.shouldRetry(code)) {
            if (this.statRetryCount < NUM_RETRIES) {
                ++this.statRetryCount;
                this.monitorLockNodeAsync();
                return;
            }
            errorMessage = errorMessage + ". Not retrying further znode monitoring connection errors.";
        } else if (ActiveStandbyElector.isSessionExpired(code)) {
            LOG.warn((Object)"Lock monitoring failed because session was lost");
            return;
        }
        this.fatalError(errorMessage);
    }

    private void reJoinElectionAfterFailureToBecomeActive() {
        this.reJoinElection(1000);
    }

    synchronized void processWatchEvent(ZooKeeper zk, WatchedEvent event) {
        Watcher.Event.EventType eventType = event.getType();
        if (this.isStaleClient(zk)) {
            return;
        }
        LOG.debug((Object)("Watcher event type: " + (Object)((Object)eventType) + " with state:" + (Object)((Object)event.getState()) + " for path:" + event.getPath() + " connectionState: " + (Object)((Object)this.zkConnectionState) + " for " + this));
        if (eventType == Watcher.Event.EventType.None) {
            switch (event.getState()) {
                case SyncConnected: {
                    LOG.info((Object)"Session connected.");
                    ConnectionState prevConnectionState = this.zkConnectionState;
                    this.zkConnectionState = ConnectionState.CONNECTED;
                    if (prevConnectionState != ConnectionState.DISCONNECTED || !this.wantToBeInElection) break;
                    this.monitorActiveStatus();
                    break;
                }
                case Disconnected: {
                    LOG.info((Object)"Session disconnected. Entering neutral mode...");
                    this.zkConnectionState = ConnectionState.DISCONNECTED;
                    this.enterNeutralMode();
                    break;
                }
                case Expired: {
                    LOG.info((Object)"Session expired. Entering neutral mode and rejoining...");
                    this.enterNeutralMode();
                    this.reJoinElection(0);
                    break;
                }
                case SaslAuthenticated: {
                    LOG.info((Object)"Successfully authenticated to ZooKeeper using SASL.");
                    break;
                }
                default: {
                    this.fatalError("Unexpected Zookeeper watch event state: " + (Object)((Object)event.getState()));
                }
            }
            return;
        }
        String path = event.getPath();
        if (path != null) {
            switch (eventType) {
                case NodeDeleted: {
                    if (this.state == State.ACTIVE) {
                        this.enterNeutralMode();
                    }
                    this.joinElectionInternal();
                    break;
                }
                case NodeDataChanged: {
                    this.monitorActiveStatus();
                    break;
                }
                default: {
                    LOG.debug((Object)("Unexpected node event: " + (Object)((Object)eventType) + " for path: " + path));
                    this.monitorActiveStatus();
                }
            }
            return;
        }
        this.fatalError("Unexpected watch error from Zookeeper");
    }

    protected synchronized ZooKeeper getNewZooKeeper() throws IOException, KeeperException {
        this.watcher = new WatcherWithClientRef();
        ZooKeeper zk = new ZooKeeper(this.zkHostPort, this.zkSessionTimeout, this.watcher);
        this.watcher.setZooKeeperRef(zk);
        this.watcher.waitForZKConnectionEvent(this.zkSessionTimeout);
        for (ZKUtil.ZKAuthInfo auth : this.zkAuthInfo) {
            zk.addAuthInfo(auth.getScheme(), auth.getAuth());
        }
        return zk;
    }

    private void fatalError(String errorMessage) {
        LOG.fatal((Object)errorMessage);
        this.reset();
        this.appClient.notifyFatalError(errorMessage);
    }

    private void monitorActiveStatus() {
        assert (this.wantToBeInElection);
        LOG.debug((Object)("Monitoring active leader for " + this));
        this.statRetryCount = 0;
        this.monitorLockNodeAsync();
    }

    private void joinElectionInternal() {
        Preconditions.checkState((this.appData != null ? 1 : 0) != 0, (Object)"trying to join election without any app data");
        if (this.zkClient == null && !this.reEstablishSession()) {
            this.fatalError("Failed to reEstablish connection with ZooKeeper");
            return;
        }
        this.createRetryCount = 0;
        this.wantToBeInElection = true;
        this.createLockNodeAsync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reJoinElection(int sleepTime) {
        LOG.info((Object)"Trying to re-establish ZK session");
        this.sessionReestablishLockForTests.lock();
        try {
            this.terminateConnection();
            this.sleepFor(sleepTime);
            if (this.appData != null) {
                this.joinElectionInternal();
            } else {
                LOG.info((Object)"Not joining election since service has not yet been reported as healthy.");
            }
        }
        finally {
            this.sessionReestablishLockForTests.unlock();
        }
    }

    @VisibleForTesting
    protected void sleepFor(int sleepMs) {
        if (sleepMs > 0) {
            try {
                Thread.sleep(sleepMs);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @VisibleForTesting
    void preventSessionReestablishmentForTests() {
        this.sessionReestablishLockForTests.lock();
    }

    @VisibleForTesting
    void allowSessionReestablishmentForTests() {
        this.sessionReestablishLockForTests.unlock();
    }

    @VisibleForTesting
    synchronized long getZKSessionIdForTests() {
        if (this.zkClient != null) {
            return this.zkClient.getSessionId();
        }
        return -1L;
    }

    @VisibleForTesting
    synchronized State getStateForTests() {
        return this.state;
    }

    private boolean reEstablishSession() {
        boolean success2 = false;
        for (int connectionRetryCount = 0; !success2 && connectionRetryCount < NUM_RETRIES; ++connectionRetryCount) {
            LOG.debug((Object)("Establishing zookeeper connection for " + this));
            try {
                this.createConnection();
                success2 = true;
                continue;
            }
            catch (IOException e) {
                LOG.warn((Object)e);
                this.sleepFor(5000);
                continue;
            }
            catch (KeeperException e) {
                LOG.warn((Object)e);
                this.sleepFor(5000);
            }
        }
        return success2;
    }

    private void createConnection() throws IOException, KeeperException {
        if (this.zkClient != null) {
            try {
                this.zkClient.close();
            }
            catch (InterruptedException e) {
                throw new IOException("Interrupted while closing ZK", e);
            }
            this.zkClient = null;
            this.watcher = null;
        }
        this.zkClient = this.getNewZooKeeper();
        LOG.debug((Object)("Created new connection for " + this));
    }

    void terminateConnection() {
        if (this.zkClient == null) {
            return;
        }
        LOG.debug((Object)("Terminating ZK connection for " + this));
        ZooKeeper tempZk = this.zkClient;
        this.zkClient = null;
        this.watcher = null;
        try {
            tempZk.close();
        }
        catch (InterruptedException e) {
            LOG.warn((Object)e);
        }
        this.zkConnectionState = ConnectionState.TERMINATED;
        this.wantToBeInElection = false;
    }

    private void reset() {
        this.state = State.INIT;
        this.terminateConnection();
    }

    private boolean becomeActive() {
        assert (this.wantToBeInElection);
        if (this.state == State.ACTIVE) {
            return true;
        }
        try {
            Stat oldBreadcrumbStat = this.fenceOldActive();
            this.writeBreadCrumbNode(oldBreadcrumbStat);
            LOG.debug((Object)("Becoming active for " + this));
            this.appClient.becomeActive();
            this.state = State.ACTIVE;
            return true;
        }
        catch (Exception e) {
            LOG.warn((Object)"Exception handling the winning of election", (Throwable)e);
            return false;
        }
    }

    private void writeBreadCrumbNode(Stat oldBreadcrumbStat) throws KeeperException, InterruptedException {
        Preconditions.checkState((this.appData != null ? 1 : 0) != 0, (Object)"no appdata");
        LOG.info((Object)("Writing znode " + this.zkBreadCrumbPath + " to indicate that the local node is the most recent active..."));
        if (oldBreadcrumbStat == null) {
            this.createWithRetries(this.zkBreadCrumbPath, this.appData, this.zkAcl, CreateMode.PERSISTENT);
        } else {
            this.setDataWithRetries(this.zkBreadCrumbPath, this.appData, oldBreadcrumbStat.getVersion());
        }
    }

    private void tryDeleteOwnBreadCrumbNode() {
        assert (this.state == State.ACTIVE);
        LOG.info((Object)"Deleting bread-crumb of active node...");
        Stat stat = new Stat();
        byte[] data = null;
        try {
            data = this.zkClient.getData(this.zkBreadCrumbPath, false, stat);
            if (!Arrays.equals(data, this.appData)) {
                throw new IllegalStateException("We thought we were active, but in fact the active znode had the wrong data: " + StringUtils.byteToHexString(data) + " (stat=" + stat + ")");
            }
            this.deleteWithRetries(this.zkBreadCrumbPath, stat.getVersion());
        }
        catch (Exception e) {
            LOG.warn((Object)("Unable to delete our own bread-crumb of being active at " + this.zkBreadCrumbPath + ": " + e.getLocalizedMessage() + ". " + "Expecting to be fenced by the next active."));
        }
    }

    private Stat fenceOldActive() throws InterruptedException, KeeperException {
        byte[] data;
        final Stat stat = new Stat();
        LOG.info((Object)"Checking for any old active which needs to be fenced...");
        try {
            data = ActiveStandbyElector.zkDoWithRetries(new ZKAction<byte[]>(){

                @Override
                public byte[] run() throws KeeperException, InterruptedException {
                    return ActiveStandbyElector.this.zkClient.getData(ActiveStandbyElector.this.zkBreadCrumbPath, false, stat);
                }
            });
        }
        catch (KeeperException ke) {
            if (ActiveStandbyElector.isNodeDoesNotExist(ke.code())) {
                LOG.info((Object)"No old node to fence");
                return null;
            }
            throw ke;
        }
        LOG.info((Object)("Old node exists: " + StringUtils.byteToHexString(data)));
        if (Arrays.equals(data, this.appData)) {
            LOG.info((Object)"But old node has our own data, so don't need to fence it.");
        } else {
            this.appClient.fenceOldActive(data);
        }
        return stat;
    }

    private void becomeStandby() {
        if (this.state != State.STANDBY) {
            LOG.debug((Object)("Becoming standby for " + this));
            this.state = State.STANDBY;
            this.appClient.becomeStandby();
        }
    }

    private void enterNeutralMode() {
        if (this.state != State.NEUTRAL) {
            LOG.debug((Object)("Entering neutral mode for " + this));
            this.state = State.NEUTRAL;
            this.appClient.enterNeutralMode();
        }
    }

    private void createLockNodeAsync() {
        this.zkClient.create(this.zkLockFilePath, this.appData, this.zkAcl, CreateMode.EPHEMERAL, this, this.zkClient);
    }

    private void monitorLockNodeAsync() {
        this.zkClient.exists(this.zkLockFilePath, this.watcher, (AsyncCallback.StatCallback)this, (Object)this.zkClient);
    }

    private String createWithRetries(final String path, final byte[] data, final List<ACL> acl, final CreateMode mode) throws InterruptedException, KeeperException {
        return ActiveStandbyElector.zkDoWithRetries(new ZKAction<String>(){

            @Override
            public String run() throws KeeperException, InterruptedException {
                return ActiveStandbyElector.this.zkClient.create(path, data, acl, mode);
            }
        });
    }

    private byte[] getDataWithRetries(final String path, final boolean watch, final Stat stat) throws InterruptedException, KeeperException {
        return ActiveStandbyElector.zkDoWithRetries(new ZKAction<byte[]>(){

            @Override
            public byte[] run() throws KeeperException, InterruptedException {
                return ActiveStandbyElector.this.zkClient.getData(path, watch, stat);
            }
        });
    }

    private Stat setDataWithRetries(final String path, final byte[] data, final int version) throws InterruptedException, KeeperException {
        return ActiveStandbyElector.zkDoWithRetries(new ZKAction<Stat>(){

            @Override
            public Stat run() throws KeeperException, InterruptedException {
                return ActiveStandbyElector.this.zkClient.setData(path, data, version);
            }
        });
    }

    private void deleteWithRetries(final String path, final int version) throws KeeperException, InterruptedException {
        ActiveStandbyElector.zkDoWithRetries(new ZKAction<Void>(){

            @Override
            public Void run() throws KeeperException, InterruptedException {
                ActiveStandbyElector.this.zkClient.delete(path, version);
                return null;
            }
        });
    }

    private static <T> T zkDoWithRetries(ZKAction<T> action) throws KeeperException, InterruptedException {
        int retry = 0;
        while (true) {
            try {
                return action.run();
            }
            catch (KeeperException ke) {
                if (ActiveStandbyElector.shouldRetry(ke.code()) && ++retry < NUM_RETRIES) continue;
                throw ke;
            }
            break;
        }
    }

    private synchronized boolean isStaleClient(Object ctx) {
        Preconditions.checkNotNull((Object)ctx);
        if (this.zkClient != (ZooKeeper)ctx) {
            LOG.warn((Object)("Ignoring stale result from old client with sessionId " + String.format("0x%08x", ((ZooKeeper)ctx).getSessionId())));
            return true;
        }
        return false;
    }

    private static boolean isSuccess(KeeperException.Code code) {
        return code == KeeperException.Code.OK;
    }

    private static boolean isNodeExists(KeeperException.Code code) {
        return code == KeeperException.Code.NODEEXISTS;
    }

    private static boolean isNodeDoesNotExist(KeeperException.Code code) {
        return code == KeeperException.Code.NONODE;
    }

    private static boolean isSessionExpired(KeeperException.Code code) {
        return code == KeeperException.Code.SESSIONEXPIRED;
    }

    private static boolean shouldRetry(KeeperException.Code code) {
        switch (code) {
            case CONNECTIONLOSS: 
            case OPERATIONTIMEOUT: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "elector id=" + System.identityHashCode(this) + " appData=" + (this.appData == null ? "null" : StringUtils.byteToHexString(this.appData)) + " cb=" + this.appClient;
    }

    private final class WatcherWithClientRef
    implements Watcher {
        private ZooKeeper zk;
        private CountDownLatch hasReceivedEvent = new CountDownLatch(1);
        private CountDownLatch hasSetZooKeeper = new CountDownLatch(1);

        private WatcherWithClientRef() {
        }

        private void waitForZKConnectionEvent(int connectionTimeoutMs) throws KeeperException, IOException {
            try {
                if (!this.hasReceivedEvent.await(connectionTimeoutMs, TimeUnit.MILLISECONDS)) {
                    LOG.error((Object)("Connection timed out: couldn't connect to ZooKeeper in " + connectionTimeoutMs + " milliseconds"));
                    this.zk.close();
                    throw KeeperException.create(KeeperException.Code.CONNECTIONLOSS);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Interrupted when connecting to zookeeper server", e);
            }
        }

        private void setZooKeeperRef(ZooKeeper zk) {
            Preconditions.checkState((this.zk == null ? 1 : 0) != 0, (Object)"zk already set -- must be set exactly once");
            this.zk = zk;
            this.hasSetZooKeeper.countDown();
        }

        @Override
        public void process(WatchedEvent event) {
            this.hasReceivedEvent.countDown();
            try {
                this.hasSetZooKeeper.await(ActiveStandbyElector.this.zkSessionTimeout, TimeUnit.MILLISECONDS);
                ActiveStandbyElector.this.processWatchEvent(this.zk, event);
            }
            catch (Throwable t) {
                ActiveStandbyElector.this.fatalError("Failed to process watcher event " + event + ": " + StringUtils.stringifyException(t));
            }
        }
    }

    private static interface ZKAction<T> {
        public T run() throws KeeperException, InterruptedException;
    }

    public static class ActiveNotFoundException
    extends Exception {
        private static final long serialVersionUID = 3505396722342846462L;
    }

    static enum State {
        INIT,
        ACTIVE,
        STANDBY,
        NEUTRAL;

    }

    private static enum ConnectionState {
        DISCONNECTED,
        CONNECTED,
        TERMINATED;

    }

    public static interface ActiveStandbyElectorCallback {
        public void becomeActive() throws ServiceFailedException;

        public void becomeStandby();

        public void enterNeutralMode();

        public void notifyFatalError(String var1);

        public void fenceOldActive(byte[] var1);
    }
}

