/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.Progressable;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class Options {

    public static class ChecksumOpt {
        private final int crcBlockSize;
        private final DataChecksum.Type crcType;

        public ChecksumOpt() {
            this.crcBlockSize = -1;
            this.crcType = DataChecksum.Type.DEFAULT;
        }

        public ChecksumOpt(DataChecksum.Type type, int size2) {
            this.crcBlockSize = size2;
            this.crcType = type;
        }

        public int getBytesPerChecksum() {
            return this.crcBlockSize;
        }

        public DataChecksum.Type getChecksumType() {
            return this.crcType;
        }

        public static ChecksumOpt createDisabled() {
            return new ChecksumOpt(DataChecksum.Type.NULL, -1);
        }

        public static ChecksumOpt processChecksumOpt(ChecksumOpt defaultOpt, ChecksumOpt userOpt, int userBytesPerChecksum) {
            DataChecksum.Type type;
            int whichSize = userBytesPerChecksum > 0 ? 1 : (userOpt != null && userOpt.getBytesPerChecksum() > 0 ? 2 : 0);
            boolean useDefaultType = userOpt == null || userOpt.getChecksumType() == DataChecksum.Type.DEFAULT;
            if (whichSize == 0 && useDefaultType) {
                return defaultOpt;
            }
            if (whichSize == 2 && !useDefaultType) {
                return userOpt;
            }
            DataChecksum.Type type2 = type = useDefaultType ? defaultOpt.getChecksumType() : userOpt.getChecksumType();
            if (whichSize == 0) {
                return new ChecksumOpt(type, defaultOpt.getBytesPerChecksum());
            }
            if (whichSize == 1) {
                return new ChecksumOpt(type, userBytesPerChecksum);
            }
            return new ChecksumOpt(type, userOpt.getBytesPerChecksum());
        }

        public static ChecksumOpt processChecksumOpt(ChecksumOpt defaultOpt, ChecksumOpt userOpt) {
            return ChecksumOpt.processChecksumOpt(defaultOpt, userOpt, -1);
        }
    }

    public static enum Rename {
        NONE(0),
        OVERWRITE(1);

        private final byte code;

        private Rename(byte code) {
            this.code = code;
        }

        public static Rename valueOf(byte code) {
            return code < 0 || code >= Rename.values().length ? null : Rename.values()[code];
        }

        public byte value() {
            return this.code;
        }
    }

    public static class CreateOpts {
        private CreateOpts() {
        }

        public static BlockSize blockSize(long bs) {
            return new BlockSize(bs);
        }

        public static BufferSize bufferSize(int bs) {
            return new BufferSize(bs);
        }

        public static ReplicationFactor repFac(short rf) {
            return new ReplicationFactor(rf);
        }

        public static BytesPerChecksum bytesPerChecksum(short crc) {
            return new BytesPerChecksum(crc);
        }

        public static ChecksumParam checksumParam(ChecksumOpt csumOpt) {
            return new ChecksumParam(csumOpt);
        }

        public static Perms perms(FsPermission perm) {
            return new Perms(perm);
        }

        public static CreateParent createParent() {
            return new CreateParent(true);
        }

        public static CreateParent donotCreateParent() {
            return new CreateParent(false);
        }

        protected static CreateOpts getOpt(Class<? extends CreateOpts> theClass, CreateOpts ... opts) {
            if (opts == null) {
                throw new IllegalArgumentException("Null opt");
            }
            CreateOpts result2 = null;
            for (int i = 0; i < opts.length; ++i) {
                if (opts[i].getClass() != theClass) continue;
                if (result2 != null) {
                    throw new IllegalArgumentException("multiple blocksize varargs");
                }
                result2 = opts[i];
            }
            return result2;
        }

        protected static <T extends CreateOpts> CreateOpts[] setOpt(T newValue, CreateOpts ... opts) {
            boolean alreadyInOpts = false;
            if (opts != null) {
                for (int i = 0; i < opts.length; ++i) {
                    if (opts[i].getClass() != newValue.getClass()) continue;
                    if (alreadyInOpts) {
                        throw new IllegalArgumentException("multiple opts varargs");
                    }
                    alreadyInOpts = true;
                    opts[i] = newValue;
                }
            }
            CreateOpts[] resultOpt = opts;
            if (!alreadyInOpts) {
                CreateOpts[] newOpts = new CreateOpts[opts.length + 1];
                System.arraycopy(opts, 0, newOpts, 0, opts.length);
                newOpts[opts.length] = newValue;
                resultOpt = newOpts;
            }
            return resultOpt;
        }

        public static class CreateParent
        extends CreateOpts {
            private final boolean createParent;

            protected CreateParent(boolean createPar) {
                this.createParent = createPar;
            }

            public boolean getValue() {
                return this.createParent;
            }
        }

        public static class Progress
        extends CreateOpts {
            private final Progressable progress;

            protected Progress(Progressable prog) {
                if (prog == null) {
                    throw new IllegalArgumentException("Progress must not be null");
                }
                this.progress = prog;
            }

            public Progressable getValue() {
                return this.progress;
            }
        }

        public static class Perms
        extends CreateOpts {
            private final FsPermission permissions;

            protected Perms(FsPermission perm) {
                if (perm == null) {
                    throw new IllegalArgumentException("Permissions must not be null");
                }
                this.permissions = perm;
            }

            public FsPermission getValue() {
                return this.permissions;
            }
        }

        public static class ChecksumParam
        extends CreateOpts {
            private final ChecksumOpt checksumOpt;

            protected ChecksumParam(ChecksumOpt csumOpt) {
                this.checksumOpt = csumOpt;
            }

            public ChecksumOpt getValue() {
                return this.checksumOpt;
            }
        }

        public static class BytesPerChecksum
        extends CreateOpts {
            private final int bytesPerChecksum;

            protected BytesPerChecksum(short bpc) {
                if (bpc <= 0) {
                    throw new IllegalArgumentException("Bytes per checksum must be greater than 0");
                }
                this.bytesPerChecksum = bpc;
            }

            public int getValue() {
                return this.bytesPerChecksum;
            }
        }

        public static class BufferSize
        extends CreateOpts {
            private final int bufferSize;

            protected BufferSize(int bs) {
                if (bs <= 0) {
                    throw new IllegalArgumentException("Buffer size must be greater than 0");
                }
                this.bufferSize = bs;
            }

            public int getValue() {
                return this.bufferSize;
            }
        }

        public static class ReplicationFactor
        extends CreateOpts {
            private final short replication;

            protected ReplicationFactor(short rf) {
                if (rf <= 0) {
                    throw new IllegalArgumentException("Replication must be greater than 0");
                }
                this.replication = rf;
            }

            public short getValue() {
                return this.replication;
            }
        }

        public static class BlockSize
        extends CreateOpts {
            private final long blockSize;

            protected BlockSize(long bs) {
                if (bs <= 0L) {
                    throw new IllegalArgumentException("Block size must be greater than 0");
                }
                this.blockSize = bs;
            }

            public long getValue() {
                return this.blockSize;
            }
        }
    }
}

