/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive.moment;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.math.DimensionMismatchException;
import org.apache.commons.math.stat.descriptive.moment.Mean;

public class VectorialMean
implements Serializable {
    private static final long serialVersionUID = 8223009086481006892L;
    private final Mean[] means;

    public VectorialMean(int dimension) {
        this.means = new Mean[dimension];
        for (int i = 0; i < dimension; ++i) {
            this.means[i] = new Mean();
        }
    }

    public void increment(double[] v) throws DimensionMismatchException {
        if (v.length != this.means.length) {
            throw new DimensionMismatchException(v.length, this.means.length);
        }
        for (int i = 0; i < v.length; ++i) {
            this.means[i].increment(v[i]);
        }
    }

    public double[] getResult() {
        double[] result2 = new double[this.means.length];
        for (int i = 0; i < result2.length; ++i) {
            result2[i] = this.means[i].getResult();
        }
        return result2;
    }

    public long getN() {
        return this.means.length == 0 ? 0L : this.means[0].getN();
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + Arrays.hashCode(this.means);
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VectorialMean)) {
            return false;
        }
        VectorialMean other = (VectorialMean)obj;
        return Arrays.equals(this.means, other.means);
    }
}

