/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat;

import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.commons.math.MathRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Frequency
implements Serializable {
    private static final long serialVersionUID = -3845586908418844111L;
    private final TreeMap<Comparable<?>, Long> freqTable;

    public Frequency() {
        this.freqTable = new TreeMap();
    }

    public Frequency(Comparator<?> comparator) {
        this.freqTable = new TreeMap(comparator);
    }

    public String toString() {
        NumberFormat nf = NumberFormat.getPercentInstance();
        StringBuffer outBuffer = new StringBuffer();
        outBuffer.append("Value \t Freq. \t Pct. \t Cum Pct. \n");
        for (Comparable<?> value2 : this.freqTable.keySet()) {
            outBuffer.append(value2);
            outBuffer.append('\t');
            outBuffer.append(this.getCount(value2));
            outBuffer.append('\t');
            outBuffer.append(nf.format(this.getPct(value2)));
            outBuffer.append('\t');
            outBuffer.append(nf.format(this.getCumPct(value2)));
            outBuffer.append('\n');
        }
        return outBuffer.toString();
    }

    @Deprecated
    public void addValue(Object v) {
        if (!(v instanceof Comparable)) {
            throw MathRuntimeException.createIllegalArgumentException("class ({0}) does not implement Comparable", v.getClass().getName());
        }
        this.addValue((Comparable)v);
    }

    public void addValue(Comparable<?> v) {
        Long obj = v;
        if (v instanceof Integer) {
            obj = ((Integer)((Object)v)).longValue();
        }
        try {
            Long count2 = this.freqTable.get(obj);
            if (count2 == null) {
                this.freqTable.put(obj, 1L);
            } else {
                this.freqTable.put(obj, count2 + 1L);
            }
        }
        catch (ClassCastException ex) {
            throw MathRuntimeException.createIllegalArgumentException("instance of class {0} not comparable to existing values", v.getClass().getName());
        }
    }

    public void addValue(int v) {
        this.addValue(Long.valueOf(v));
    }

    @Deprecated
    public void addValue(Integer v) {
        this.addValue(Long.valueOf(v.longValue()));
    }

    public void addValue(long v) {
        this.addValue(Long.valueOf(v));
    }

    public void addValue(char v) {
        this.addValue(Character.valueOf(v));
    }

    public void clear() {
        this.freqTable.clear();
    }

    public Iterator<Comparable<?>> valuesIterator() {
        return this.freqTable.keySet().iterator();
    }

    public long getSumFreq() {
        long result2 = 0L;
        Iterator<Long> iterator2 = this.freqTable.values().iterator();
        while (iterator2.hasNext()) {
            result2 += iterator2.next().longValue();
        }
        return result2;
    }

    @Deprecated
    public long getCount(Object v) {
        return this.getCount((Comparable)v);
    }

    public long getCount(Comparable<?> v) {
        if (v instanceof Integer) {
            return this.getCount(((Integer)v).longValue());
        }
        long result2 = 0L;
        try {
            Long count2 = this.freqTable.get(v);
            if (count2 != null) {
                result2 = count2;
            }
        }
        catch (ClassCastException ex) {
            // empty catch block
        }
        return result2;
    }

    public long getCount(int v) {
        return this.getCount(Long.valueOf(v));
    }

    public long getCount(long v) {
        return this.getCount(Long.valueOf(v));
    }

    public long getCount(char v) {
        return this.getCount(Character.valueOf(v));
    }

    @Deprecated
    public double getPct(Object v) {
        return this.getPct((Comparable)v);
    }

    public double getPct(Comparable<?> v) {
        long sumFreq = this.getSumFreq();
        if (sumFreq == 0L) {
            return Double.NaN;
        }
        return (double)this.getCount(v) / (double)sumFreq;
    }

    public double getPct(int v) {
        return this.getPct(Long.valueOf(v));
    }

    public double getPct(long v) {
        return this.getPct(Long.valueOf(v));
    }

    public double getPct(char v) {
        return this.getPct(Character.valueOf(v));
    }

    @Deprecated
    public long getCumFreq(Object v) {
        return this.getCumFreq((Comparable)v);
    }

    public long getCumFreq(Comparable<?> v) {
        if (this.getSumFreq() == 0L) {
            return 0L;
        }
        if (v instanceof Integer) {
            return this.getCumFreq(((Integer)v).longValue());
        }
        Comparator<Comparable<?>> c = this.freqTable.comparator();
        if (c == null) {
            c = new NaturalComparator();
        }
        long result2 = 0L;
        try {
            Long value2 = this.freqTable.get(v);
            if (value2 != null) {
                result2 = value2;
            }
        }
        catch (ClassCastException ex) {
            return result2;
        }
        if (c.compare(v, this.freqTable.firstKey()) < 0) {
            return 0L;
        }
        if (c.compare(v, this.freqTable.lastKey()) >= 0) {
            return this.getSumFreq();
        }
        Iterator<Comparable<?>> values = this.valuesIterator();
        while (values.hasNext()) {
            Comparable<?> nextValue = values.next();
            if (c.compare(v, nextValue) > 0) {
                result2 += this.getCount(nextValue);
                continue;
            }
            return result2;
        }
        return result2;
    }

    public long getCumFreq(int v) {
        return this.getCumFreq(Long.valueOf(v));
    }

    public long getCumFreq(long v) {
        return this.getCumFreq(Long.valueOf(v));
    }

    public long getCumFreq(char v) {
        return this.getCumFreq(Character.valueOf(v));
    }

    @Deprecated
    public double getCumPct(Object v) {
        return this.getCumPct((Comparable)v);
    }

    public double getCumPct(Comparable<?> v) {
        long sumFreq = this.getSumFreq();
        if (sumFreq == 0L) {
            return Double.NaN;
        }
        return (double)this.getCumFreq(v) / (double)sumFreq;
    }

    public double getCumPct(int v) {
        return this.getCumPct(Long.valueOf(v));
    }

    public double getCumPct(long v) {
        return this.getCumPct(Long.valueOf(v));
    }

    public double getCumPct(char v) {
        return this.getCumPct(Character.valueOf(v));
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.freqTable == null ? 0 : this.freqTable.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Frequency)) {
            return false;
        }
        Frequency other = (Frequency)obj;
        return !(this.freqTable == null ? other.freqTable != null : !this.freqTable.equals(other.freqTable));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NaturalComparator<T extends Comparable<T>>
    implements Comparator<Comparable<T>>,
    Serializable {
        private static final long serialVersionUID = -3852193713161395148L;

        private NaturalComparator() {
        }

        @Override
        public int compare(Comparable<T> o1, Comparable<T> o2) {
            return o1.compareTo(o2);
        }
    }
}

