/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.math;

import org.apache.commons.lang.math.NumberUtils;

public abstract class Range {
    public abstract Number getMinimumNumber();

    public long getMinimumLong() {
        return this.getMinimumNumber().longValue();
    }

    public int getMinimumInteger() {
        return this.getMinimumNumber().intValue();
    }

    public double getMinimumDouble() {
        return this.getMinimumNumber().doubleValue();
    }

    public float getMinimumFloat() {
        return this.getMinimumNumber().floatValue();
    }

    public abstract Number getMaximumNumber();

    public long getMaximumLong() {
        return this.getMaximumNumber().longValue();
    }

    public int getMaximumInteger() {
        return this.getMaximumNumber().intValue();
    }

    public double getMaximumDouble() {
        return this.getMaximumNumber().doubleValue();
    }

    public float getMaximumFloat() {
        return this.getMaximumNumber().floatValue();
    }

    public abstract boolean containsNumber(Number var1);

    public boolean containsLong(Number value2) {
        if (value2 == null) {
            return false;
        }
        return this.containsLong(value2.longValue());
    }

    public boolean containsLong(long value2) {
        return value2 >= this.getMinimumLong() && value2 <= this.getMaximumLong();
    }

    public boolean containsInteger(Number value2) {
        if (value2 == null) {
            return false;
        }
        return this.containsInteger(value2.intValue());
    }

    public boolean containsInteger(int value2) {
        return value2 >= this.getMinimumInteger() && value2 <= this.getMaximumInteger();
    }

    public boolean containsDouble(Number value2) {
        if (value2 == null) {
            return false;
        }
        return this.containsDouble(value2.doubleValue());
    }

    public boolean containsDouble(double value2) {
        int compareMin = NumberUtils.compare(this.getMinimumDouble(), value2);
        int compareMax = NumberUtils.compare(this.getMaximumDouble(), value2);
        return compareMin <= 0 && compareMax >= 0;
    }

    public boolean containsFloat(Number value2) {
        if (value2 == null) {
            return false;
        }
        return this.containsFloat(value2.floatValue());
    }

    public boolean containsFloat(float value2) {
        int compareMin = NumberUtils.compare(this.getMinimumFloat(), value2);
        int compareMax = NumberUtils.compare(this.getMaximumFloat(), value2);
        return compareMin <= 0 && compareMax >= 0;
    }

    public boolean containsRange(Range range2) {
        if (range2 == null) {
            return false;
        }
        return this.containsNumber(range2.getMinimumNumber()) && this.containsNumber(range2.getMaximumNumber());
    }

    public boolean overlapsRange(Range range2) {
        if (range2 == null) {
            return false;
        }
        return range2.containsNumber(this.getMinimumNumber()) || range2.containsNumber(this.getMaximumNumber()) || this.containsNumber(range2.getMinimumNumber());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Range range2 = (Range)obj;
        return this.getMinimumNumber().equals(range2.getMinimumNumber()) && this.getMaximumNumber().equals(range2.getMaximumNumber());
    }

    public int hashCode() {
        int result2 = 17;
        result2 = 37 * result2 + this.getClass().hashCode();
        result2 = 37 * result2 + this.getMinimumNumber().hashCode();
        result2 = 37 * result2 + this.getMaximumNumber().hashCode();
        return result2;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(32);
        buf.append("Range[");
        buf.append(this.getMinimumNumber());
        buf.append(',');
        buf.append(this.getMaximumNumber());
        buf.append(']');
        return buf.toString();
    }
}

