/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.params;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.commons.httpclient.params.DefaultHttpParamsFactory;
import org.apache.commons.httpclient.params.HttpParams;
import org.apache.commons.httpclient.params.HttpParamsFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultHttpParams
implements HttpParams,
Serializable,
Cloneable {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$commons$httpclient$params$DefaultHttpParams == null ? (class$org$apache$commons$httpclient$params$DefaultHttpParams = DefaultHttpParams.class$("org.apache.commons.httpclient.params.DefaultHttpParams")) : class$org$apache$commons$httpclient$params$DefaultHttpParams));
    private static HttpParamsFactory httpParamsFactory = new DefaultHttpParamsFactory();
    private HttpParams defaults = null;
    private HashMap parameters = null;
    static /* synthetic */ Class class$org$apache$commons$httpclient$params$DefaultHttpParams;

    public static HttpParams getDefaultParams() {
        return httpParamsFactory.getDefaultParams();
    }

    public static void setHttpParamsFactory(HttpParamsFactory httpParamsFactory) {
        if (httpParamsFactory == null) {
            throw new IllegalArgumentException("httpParamsFactory may not be null");
        }
        DefaultHttpParams.httpParamsFactory = httpParamsFactory;
    }

    public DefaultHttpParams(HttpParams defaults) {
        this.defaults = defaults;
    }

    public DefaultHttpParams() {
        this(DefaultHttpParams.getDefaultParams());
    }

    public synchronized HttpParams getDefaults() {
        return this.defaults;
    }

    public synchronized void setDefaults(HttpParams params) {
        this.defaults = params;
    }

    public synchronized Object getParameter(String name) {
        Object param2 = null;
        if (this.parameters != null) {
            param2 = this.parameters.get(name);
        }
        if (param2 != null) {
            return param2;
        }
        if (this.defaults != null) {
            return this.defaults.getParameter(name);
        }
        return null;
    }

    public synchronized void setParameter(String name, Object value2) {
        if (this.parameters == null) {
            this.parameters = new HashMap();
        }
        this.parameters.put(name, value2);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Set parameter " + name + " = " + value2));
        }
    }

    public synchronized void setParameters(String[] names, Object value2) {
        for (int i = 0; i < names.length; ++i) {
            this.setParameter(names[i], value2);
        }
    }

    public long getLongParameter(String name, long defaultValue) {
        Object param2 = this.getParameter(name);
        if (param2 == null) {
            return defaultValue;
        }
        return (Long)param2;
    }

    public void setLongParameter(String name, long value2) {
        this.setParameter(name, new Long(value2));
    }

    public int getIntParameter(String name, int defaultValue) {
        Object param2 = this.getParameter(name);
        if (param2 == null) {
            return defaultValue;
        }
        return (Integer)param2;
    }

    public void setIntParameter(String name, int value2) {
        this.setParameter(name, new Integer(value2));
    }

    public double getDoubleParameter(String name, double defaultValue) {
        Object param2 = this.getParameter(name);
        if (param2 == null) {
            return defaultValue;
        }
        return (Double)param2;
    }

    public void setDoubleParameter(String name, double value2) {
        this.setParameter(name, new Double(value2));
    }

    public boolean getBooleanParameter(String name, boolean defaultValue) {
        Object param2 = this.getParameter(name);
        if (param2 == null) {
            return defaultValue;
        }
        return (Boolean)param2;
    }

    public void setBooleanParameter(String name, boolean value2) {
        this.setParameter(name, value2 ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean isParameterSet(String name) {
        return this.getParameter(name) != null;
    }

    public boolean isParameterSetLocally(String name) {
        return this.parameters != null && this.parameters.get(name) != null;
    }

    public boolean isParameterTrue(String name) {
        return this.getBooleanParameter(name, false);
    }

    public boolean isParameterFalse(String name) {
        return !this.getBooleanParameter(name, false);
    }

    public void clear() {
        this.parameters = null;
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultHttpParams clone2 = (DefaultHttpParams)super.clone();
        if (this.parameters != null) {
            clone2.parameters = (HashMap)this.parameters.clone();
        }
        clone2.setDefaults(this.defaults);
        return clone2;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

