/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.collections.KeyValue;

public final class DoubleOrderedMap
extends AbstractMap {
    private static final int KEY = 0;
    private static final int VALUE = 1;
    private static final int SUM_OF_INDICES = 1;
    private static final int FIRST_INDEX = 0;
    private static final int NUMBER_OF_INDICES = 2;
    private static final String[] dataName = new String[]{"key", "value"};
    private Node[] rootNode = new Node[]{null, null};
    private int nodeCount = 0;
    private int modifications = 0;
    private Set[] setOfKeys = new Set[]{null, null};
    private Set[] setOfEntries = new Set[]{null, null};
    private Collection[] collectionOfValues = new Collection[]{null, null};

    public DoubleOrderedMap() {
    }

    public DoubleOrderedMap(Map map2) throws ClassCastException, NullPointerException, IllegalArgumentException {
        this.putAll(map2);
    }

    public Object getKeyForValue(Object value2) throws ClassCastException, NullPointerException {
        return this.doGet((Comparable)value2, 1);
    }

    public Object removeValue(Object value2) {
        return this.doRemove((Comparable)value2, 1);
    }

    public Set entrySetByValue() {
        if (this.setOfEntries[1] == null) {
            this.setOfEntries[1] = new AbstractSet(){

                public Iterator iterator() {
                    return new DoubleOrderedMapIterator(1){

                        protected Object doGetNext() {
                            return this.lastReturnedNode;
                        }
                    };
                }

                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry2 = (Map.Entry)o;
                    Object key = entry2.getKey();
                    Node node = DoubleOrderedMap.this.lookup((Comparable)entry2.getValue(), 1);
                    return node != null && node.getData(0).equals(key);
                }

                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry2 = (Map.Entry)o;
                    Object key = entry2.getKey();
                    Node node = DoubleOrderedMap.this.lookup((Comparable)entry2.getValue(), 1);
                    if (node != null && node.getData(0).equals(key)) {
                        DoubleOrderedMap.this.doRedBlackDelete(node);
                        return true;
                    }
                    return false;
                }

                public int size() {
                    return DoubleOrderedMap.this.size();
                }

                public void clear() {
                    DoubleOrderedMap.this.clear();
                }

                static /* synthetic */ DoubleOrderedMap access$000(1 x0) {
                    return x0.DoubleOrderedMap.this;
                }
            };
        }
        return this.setOfEntries[1];
    }

    public Set keySetByValue() {
        if (this.setOfKeys[1] == null) {
            this.setOfKeys[1] = new AbstractSet(){

                public Iterator iterator() {
                    return new DoubleOrderedMapIterator(1){

                        protected Object doGetNext() {
                            return this.lastReturnedNode.getData(0);
                        }
                    };
                }

                public int size() {
                    return DoubleOrderedMap.this.size();
                }

                public boolean contains(Object o) {
                    return DoubleOrderedMap.this.containsKey(o);
                }

                public boolean remove(Object o) {
                    int oldnodeCount = DoubleOrderedMap.this.nodeCount;
                    DoubleOrderedMap.this.remove(o);
                    return DoubleOrderedMap.this.nodeCount != oldnodeCount;
                }

                public void clear() {
                    DoubleOrderedMap.this.clear();
                }

                static /* synthetic */ DoubleOrderedMap access$400(2 x0) {
                    return x0.DoubleOrderedMap.this;
                }
            };
        }
        return this.setOfKeys[1];
    }

    public Collection valuesByValue() {
        if (this.collectionOfValues[1] == null) {
            this.collectionOfValues[1] = new AbstractCollection(){

                public Iterator iterator() {
                    return new DoubleOrderedMapIterator(1){

                        protected Object doGetNext() {
                            return this.lastReturnedNode.getData(1);
                        }
                    };
                }

                public int size() {
                    return DoubleOrderedMap.this.size();
                }

                public boolean contains(Object o) {
                    return DoubleOrderedMap.this.containsValue(o);
                }

                public boolean remove(Object o) {
                    int oldnodeCount = DoubleOrderedMap.this.nodeCount;
                    DoubleOrderedMap.this.removeValue(o);
                    return DoubleOrderedMap.this.nodeCount != oldnodeCount;
                }

                public boolean removeAll(Collection c) {
                    boolean modified = false;
                    Iterator iter2 = c.iterator();
                    while (iter2.hasNext()) {
                        if (DoubleOrderedMap.this.removeValue(iter2.next()) == null) continue;
                        modified = true;
                    }
                    return modified;
                }

                public void clear() {
                    DoubleOrderedMap.this.clear();
                }

                static /* synthetic */ DoubleOrderedMap access$600(3 x0) {
                    return x0.DoubleOrderedMap.this;
                }
            };
        }
        return this.collectionOfValues[1];
    }

    private Object doRemove(Comparable o, int index2) {
        Node node = this.lookup(o, index2);
        Comparable rval = null;
        if (node != null) {
            rval = node.getData(this.oppositeIndex(index2));
            this.doRedBlackDelete(node);
        }
        return rval;
    }

    private Object doGet(Comparable o, int index2) {
        DoubleOrderedMap.checkNonNullComparable(o, index2);
        Node node = this.lookup(o, index2);
        return node == null ? null : node.getData(this.oppositeIndex(index2));
    }

    private int oppositeIndex(int index2) {
        return 1 - index2;
    }

    private Node lookup(Comparable data, int index2) {
        Node rval = null;
        Node node = this.rootNode[index2];
        while (node != null) {
            int cmp = DoubleOrderedMap.compare(data, node.getData(index2));
            if (cmp == 0) {
                rval = node;
                break;
            }
            node = cmp < 0 ? node.getLeft(index2) : node.getRight(index2);
        }
        return rval;
    }

    private static int compare(Comparable o1, Comparable o2) {
        return o1.compareTo(o2);
    }

    private static Node leastNode(Node node, int index2) {
        Node rval = node;
        if (rval != null) {
            while (rval.getLeft(index2) != null) {
                rval = rval.getLeft(index2);
            }
        }
        return rval;
    }

    private Node nextGreater(Node node, int index2) {
        Node rval = null;
        if (node == null) {
            rval = null;
        } else if (node.getRight(index2) != null) {
            rval = DoubleOrderedMap.leastNode(node.getRight(index2), index2);
        } else {
            Node parent = node.getParent(index2);
            Node child = node;
            while (parent != null && child == parent.getRight(index2)) {
                child = parent;
                parent = parent.getParent(index2);
            }
            rval = parent;
        }
        return rval;
    }

    private static void copyColor(Node from2, Node to2, int index2) {
        if (to2 != null) {
            if (from2 == null) {
                to2.setBlack(index2);
            } else {
                to2.copyColor(from2, index2);
            }
        }
    }

    private static boolean isRed(Node node, int index2) {
        return node == null ? false : node.isRed(index2);
    }

    private static boolean isBlack(Node node, int index2) {
        return node == null ? true : node.isBlack(index2);
    }

    private static void makeRed(Node node, int index2) {
        if (node != null) {
            node.setRed(index2);
        }
    }

    private static void makeBlack(Node node, int index2) {
        if (node != null) {
            node.setBlack(index2);
        }
    }

    private static Node getGrandParent(Node node, int index2) {
        return DoubleOrderedMap.getParent(DoubleOrderedMap.getParent(node, index2), index2);
    }

    private static Node getParent(Node node, int index2) {
        return node == null ? null : node.getParent(index2);
    }

    private static Node getRightChild(Node node, int index2) {
        return node == null ? null : node.getRight(index2);
    }

    private static Node getLeftChild(Node node, int index2) {
        return node == null ? null : node.getLeft(index2);
    }

    private static boolean isLeftChild(Node node, int index2) {
        return node == null ? true : (node.getParent(index2) == null ? false : node == node.getParent(index2).getLeft(index2));
    }

    private static boolean isRightChild(Node node, int index2) {
        return node == null ? true : (node.getParent(index2) == null ? false : node == node.getParent(index2).getRight(index2));
    }

    private void rotateLeft(Node node, int index2) {
        Node rightChild = node.getRight(index2);
        node.setRight(rightChild.getLeft(index2), index2);
        if (rightChild.getLeft(index2) != null) {
            rightChild.getLeft(index2).setParent(node, index2);
        }
        rightChild.setParent(node.getParent(index2), index2);
        if (node.getParent(index2) == null) {
            this.rootNode[index2] = rightChild;
        } else if (node.getParent(index2).getLeft(index2) == node) {
            node.getParent(index2).setLeft(rightChild, index2);
        } else {
            node.getParent(index2).setRight(rightChild, index2);
        }
        rightChild.setLeft(node, index2);
        node.setParent(rightChild, index2);
    }

    private void rotateRight(Node node, int index2) {
        Node leftChild = node.getLeft(index2);
        node.setLeft(leftChild.getRight(index2), index2);
        if (leftChild.getRight(index2) != null) {
            leftChild.getRight(index2).setParent(node, index2);
        }
        leftChild.setParent(node.getParent(index2), index2);
        if (node.getParent(index2) == null) {
            this.rootNode[index2] = leftChild;
        } else if (node.getParent(index2).getRight(index2) == node) {
            node.getParent(index2).setRight(leftChild, index2);
        } else {
            node.getParent(index2).setLeft(leftChild, index2);
        }
        leftChild.setRight(node, index2);
        node.setParent(leftChild, index2);
    }

    private void doRedBlackInsert(Node insertedNode, int index2) {
        Node currentNode = insertedNode;
        DoubleOrderedMap.makeRed(currentNode, index2);
        while (currentNode != null && currentNode != this.rootNode[index2] && DoubleOrderedMap.isRed(currentNode.getParent(index2), index2)) {
            Node y;
            if (DoubleOrderedMap.isLeftChild(DoubleOrderedMap.getParent(currentNode, index2), index2)) {
                y = DoubleOrderedMap.getRightChild(DoubleOrderedMap.getGrandParent(currentNode, index2), index2);
                if (DoubleOrderedMap.isRed(y, index2)) {
                    DoubleOrderedMap.makeBlack(DoubleOrderedMap.getParent(currentNode, index2), index2);
                    DoubleOrderedMap.makeBlack(y, index2);
                    DoubleOrderedMap.makeRed(DoubleOrderedMap.getGrandParent(currentNode, index2), index2);
                    currentNode = DoubleOrderedMap.getGrandParent(currentNode, index2);
                    continue;
                }
                if (DoubleOrderedMap.isRightChild(currentNode, index2)) {
                    currentNode = DoubleOrderedMap.getParent(currentNode, index2);
                    this.rotateLeft(currentNode, index2);
                }
                DoubleOrderedMap.makeBlack(DoubleOrderedMap.getParent(currentNode, index2), index2);
                DoubleOrderedMap.makeRed(DoubleOrderedMap.getGrandParent(currentNode, index2), index2);
                if (DoubleOrderedMap.getGrandParent(currentNode, index2) == null) continue;
                this.rotateRight(DoubleOrderedMap.getGrandParent(currentNode, index2), index2);
                continue;
            }
            y = DoubleOrderedMap.getLeftChild(DoubleOrderedMap.getGrandParent(currentNode, index2), index2);
            if (DoubleOrderedMap.isRed(y, index2)) {
                DoubleOrderedMap.makeBlack(DoubleOrderedMap.getParent(currentNode, index2), index2);
                DoubleOrderedMap.makeBlack(y, index2);
                DoubleOrderedMap.makeRed(DoubleOrderedMap.getGrandParent(currentNode, index2), index2);
                currentNode = DoubleOrderedMap.getGrandParent(currentNode, index2);
                continue;
            }
            if (DoubleOrderedMap.isLeftChild(currentNode, index2)) {
                currentNode = DoubleOrderedMap.getParent(currentNode, index2);
                this.rotateRight(currentNode, index2);
            }
            DoubleOrderedMap.makeBlack(DoubleOrderedMap.getParent(currentNode, index2), index2);
            DoubleOrderedMap.makeRed(DoubleOrderedMap.getGrandParent(currentNode, index2), index2);
            if (DoubleOrderedMap.getGrandParent(currentNode, index2) == null) continue;
            this.rotateLeft(DoubleOrderedMap.getGrandParent(currentNode, index2), index2);
        }
        DoubleOrderedMap.makeBlack(this.rootNode[index2], index2);
    }

    private void doRedBlackDelete(Node deletedNode) {
        for (int index2 = 0; index2 < 2; ++index2) {
            Node replacement;
            if (deletedNode.getLeft(index2) != null && deletedNode.getRight(index2) != null) {
                this.swapPosition(this.nextGreater(deletedNode, index2), deletedNode, index2);
            }
            Node node = replacement = deletedNode.getLeft(index2) != null ? deletedNode.getLeft(index2) : deletedNode.getRight(index2);
            if (replacement != null) {
                replacement.setParent(deletedNode.getParent(index2), index2);
                if (deletedNode.getParent(index2) == null) {
                    this.rootNode[index2] = replacement;
                } else if (deletedNode == deletedNode.getParent(index2).getLeft(index2)) {
                    deletedNode.getParent(index2).setLeft(replacement, index2);
                } else {
                    deletedNode.getParent(index2).setRight(replacement, index2);
                }
                deletedNode.setLeft(null, index2);
                deletedNode.setRight(null, index2);
                deletedNode.setParent(null, index2);
                if (!DoubleOrderedMap.isBlack(deletedNode, index2)) continue;
                this.doRedBlackDeleteFixup(replacement, index2);
                continue;
            }
            if (deletedNode.getParent(index2) == null) {
                this.rootNode[index2] = null;
                continue;
            }
            if (DoubleOrderedMap.isBlack(deletedNode, index2)) {
                this.doRedBlackDeleteFixup(deletedNode, index2);
            }
            if (deletedNode.getParent(index2) == null) continue;
            if (deletedNode == deletedNode.getParent(index2).getLeft(index2)) {
                deletedNode.getParent(index2).setLeft(null, index2);
            } else {
                deletedNode.getParent(index2).setRight(null, index2);
            }
            deletedNode.setParent(null, index2);
        }
        this.shrink();
    }

    private void doRedBlackDeleteFixup(Node replacementNode, int index2) {
        Node currentNode = replacementNode;
        while (currentNode != this.rootNode[index2] && DoubleOrderedMap.isBlack(currentNode, index2)) {
            Node siblingNode;
            if (DoubleOrderedMap.isLeftChild(currentNode, index2)) {
                siblingNode = DoubleOrderedMap.getRightChild(DoubleOrderedMap.getParent(currentNode, index2), index2);
                if (DoubleOrderedMap.isRed(siblingNode, index2)) {
                    DoubleOrderedMap.makeBlack(siblingNode, index2);
                    DoubleOrderedMap.makeRed(DoubleOrderedMap.getParent(currentNode, index2), index2);
                    this.rotateLeft(DoubleOrderedMap.getParent(currentNode, index2), index2);
                    siblingNode = DoubleOrderedMap.getRightChild(DoubleOrderedMap.getParent(currentNode, index2), index2);
                }
                if (DoubleOrderedMap.isBlack(DoubleOrderedMap.getLeftChild(siblingNode, index2), index2) && DoubleOrderedMap.isBlack(DoubleOrderedMap.getRightChild(siblingNode, index2), index2)) {
                    DoubleOrderedMap.makeRed(siblingNode, index2);
                    currentNode = DoubleOrderedMap.getParent(currentNode, index2);
                    continue;
                }
                if (DoubleOrderedMap.isBlack(DoubleOrderedMap.getRightChild(siblingNode, index2), index2)) {
                    DoubleOrderedMap.makeBlack(DoubleOrderedMap.getLeftChild(siblingNode, index2), index2);
                    DoubleOrderedMap.makeRed(siblingNode, index2);
                    this.rotateRight(siblingNode, index2);
                    siblingNode = DoubleOrderedMap.getRightChild(DoubleOrderedMap.getParent(currentNode, index2), index2);
                }
                DoubleOrderedMap.copyColor(DoubleOrderedMap.getParent(currentNode, index2), siblingNode, index2);
                DoubleOrderedMap.makeBlack(DoubleOrderedMap.getParent(currentNode, index2), index2);
                DoubleOrderedMap.makeBlack(DoubleOrderedMap.getRightChild(siblingNode, index2), index2);
                this.rotateLeft(DoubleOrderedMap.getParent(currentNode, index2), index2);
                currentNode = this.rootNode[index2];
                continue;
            }
            siblingNode = DoubleOrderedMap.getLeftChild(DoubleOrderedMap.getParent(currentNode, index2), index2);
            if (DoubleOrderedMap.isRed(siblingNode, index2)) {
                DoubleOrderedMap.makeBlack(siblingNode, index2);
                DoubleOrderedMap.makeRed(DoubleOrderedMap.getParent(currentNode, index2), index2);
                this.rotateRight(DoubleOrderedMap.getParent(currentNode, index2), index2);
                siblingNode = DoubleOrderedMap.getLeftChild(DoubleOrderedMap.getParent(currentNode, index2), index2);
            }
            if (DoubleOrderedMap.isBlack(DoubleOrderedMap.getRightChild(siblingNode, index2), index2) && DoubleOrderedMap.isBlack(DoubleOrderedMap.getLeftChild(siblingNode, index2), index2)) {
                DoubleOrderedMap.makeRed(siblingNode, index2);
                currentNode = DoubleOrderedMap.getParent(currentNode, index2);
                continue;
            }
            if (DoubleOrderedMap.isBlack(DoubleOrderedMap.getLeftChild(siblingNode, index2), index2)) {
                DoubleOrderedMap.makeBlack(DoubleOrderedMap.getRightChild(siblingNode, index2), index2);
                DoubleOrderedMap.makeRed(siblingNode, index2);
                this.rotateLeft(siblingNode, index2);
                siblingNode = DoubleOrderedMap.getLeftChild(DoubleOrderedMap.getParent(currentNode, index2), index2);
            }
            DoubleOrderedMap.copyColor(DoubleOrderedMap.getParent(currentNode, index2), siblingNode, index2);
            DoubleOrderedMap.makeBlack(DoubleOrderedMap.getParent(currentNode, index2), index2);
            DoubleOrderedMap.makeBlack(DoubleOrderedMap.getLeftChild(siblingNode, index2), index2);
            this.rotateRight(DoubleOrderedMap.getParent(currentNode, index2), index2);
            currentNode = this.rootNode[index2];
        }
        DoubleOrderedMap.makeBlack(currentNode, index2);
    }

    private void swapPosition(Node x, Node y, int index2) {
        boolean yWasLeftChild;
        Node xFormerParent = x.getParent(index2);
        Node xFormerLeftChild = x.getLeft(index2);
        Node xFormerRightChild = x.getRight(index2);
        Node yFormerParent = y.getParent(index2);
        Node yFormerLeftChild = y.getLeft(index2);
        Node yFormerRightChild = y.getRight(index2);
        boolean xWasLeftChild = x.getParent(index2) != null && x == x.getParent(index2).getLeft(index2);
        boolean bl = yWasLeftChild = y.getParent(index2) != null && y == y.getParent(index2).getLeft(index2);
        if (x == yFormerParent) {
            x.setParent(y, index2);
            if (yWasLeftChild) {
                y.setLeft(x, index2);
                y.setRight(xFormerRightChild, index2);
            } else {
                y.setRight(x, index2);
                y.setLeft(xFormerLeftChild, index2);
            }
        } else {
            x.setParent(yFormerParent, index2);
            if (yFormerParent != null) {
                if (yWasLeftChild) {
                    yFormerParent.setLeft(x, index2);
                } else {
                    yFormerParent.setRight(x, index2);
                }
            }
            y.setLeft(xFormerLeftChild, index2);
            y.setRight(xFormerRightChild, index2);
        }
        if (y == xFormerParent) {
            y.setParent(x, index2);
            if (xWasLeftChild) {
                x.setLeft(y, index2);
                x.setRight(yFormerRightChild, index2);
            } else {
                x.setRight(y, index2);
                x.setLeft(yFormerLeftChild, index2);
            }
        } else {
            y.setParent(xFormerParent, index2);
            if (xFormerParent != null) {
                if (xWasLeftChild) {
                    xFormerParent.setLeft(y, index2);
                } else {
                    xFormerParent.setRight(y, index2);
                }
            }
            x.setLeft(yFormerLeftChild, index2);
            x.setRight(yFormerRightChild, index2);
        }
        if (x.getLeft(index2) != null) {
            x.getLeft(index2).setParent(x, index2);
        }
        if (x.getRight(index2) != null) {
            x.getRight(index2).setParent(x, index2);
        }
        if (y.getLeft(index2) != null) {
            y.getLeft(index2).setParent(y, index2);
        }
        if (y.getRight(index2) != null) {
            y.getRight(index2).setParent(y, index2);
        }
        x.swapColors(y, index2);
        if (this.rootNode[index2] == x) {
            this.rootNode[index2] = y;
        } else if (this.rootNode[index2] == y) {
            this.rootNode[index2] = x;
        }
    }

    private static void checkNonNullComparable(Object o, int index2) {
        if (o == null) {
            throw new NullPointerException(dataName[index2] + " cannot be null");
        }
        if (!(o instanceof Comparable)) {
            throw new ClassCastException(dataName[index2] + " must be Comparable");
        }
    }

    private static void checkKey(Object key) {
        DoubleOrderedMap.checkNonNullComparable(key, 0);
    }

    private static void checkValue(Object value2) {
        DoubleOrderedMap.checkNonNullComparable(value2, 1);
    }

    private static void checkKeyAndValue(Object key, Object value2) {
        DoubleOrderedMap.checkKey(key);
        DoubleOrderedMap.checkValue(value2);
    }

    private void modify() {
        ++this.modifications;
    }

    private void grow() {
        this.modify();
        ++this.nodeCount;
    }

    private void shrink() {
        this.modify();
        --this.nodeCount;
    }

    private void insertValue(Node newNode) throws IllegalArgumentException {
        block4: {
            Node node = this.rootNode[1];
            while (true) {
                int cmp;
                if ((cmp = DoubleOrderedMap.compare(newNode.getData(1), node.getData(1))) == 0) {
                    throw new IllegalArgumentException("Cannot store a duplicate value (\"" + newNode.getData(1) + "\") in this Map");
                }
                if (cmp < 0) {
                    if (node.getLeft(1) != null) {
                        node = node.getLeft(1);
                        continue;
                    }
                    node.setLeft(newNode, 1);
                    newNode.setParent(node, 1);
                    this.doRedBlackInsert(newNode, 1);
                    break block4;
                }
                if (node.getRight(1) == null) break;
                node = node.getRight(1);
            }
            node.setRight(newNode, 1);
            newNode.setParent(node, 1);
            this.doRedBlackInsert(newNode, 1);
        }
    }

    public int size() {
        return this.nodeCount;
    }

    public boolean containsKey(Object key) throws ClassCastException, NullPointerException {
        DoubleOrderedMap.checkKey(key);
        return this.lookup((Comparable)key, 0) != null;
    }

    public boolean containsValue(Object value2) {
        DoubleOrderedMap.checkValue(value2);
        return this.lookup((Comparable)value2, 1) != null;
    }

    public Object get(Object key) throws ClassCastException, NullPointerException {
        return this.doGet((Comparable)key, 0);
    }

    public Object put(Object key, Object value2) throws ClassCastException, NullPointerException, IllegalArgumentException {
        block6: {
            DoubleOrderedMap.checkKeyAndValue(key, value2);
            Node node = this.rootNode[0];
            if (node == null) {
                Node root2;
                this.rootNode[0] = root2 = new Node((Comparable)key, (Comparable)value2);
                this.rootNode[1] = root2;
                this.grow();
            } else {
                while (true) {
                    int cmp;
                    if ((cmp = DoubleOrderedMap.compare((Comparable)key, node.getData(0))) == 0) {
                        throw new IllegalArgumentException("Cannot store a duplicate key (\"" + key + "\") in this Map");
                    }
                    if (cmp < 0) {
                        if (node.getLeft(0) != null) {
                            node = node.getLeft(0);
                            continue;
                        }
                        Node newNode = new Node((Comparable)key, (Comparable)value2);
                        this.insertValue(newNode);
                        node.setLeft(newNode, 0);
                        newNode.setParent(node, 0);
                        this.doRedBlackInsert(newNode, 0);
                        this.grow();
                        break block6;
                    }
                    if (node.getRight(0) == null) break;
                    node = node.getRight(0);
                }
                Node newNode = new Node((Comparable)key, (Comparable)value2);
                this.insertValue(newNode);
                node.setRight(newNode, 0);
                newNode.setParent(node, 0);
                this.doRedBlackInsert(newNode, 0);
                this.grow();
            }
        }
        return null;
    }

    public Object remove(Object key) {
        return this.doRemove((Comparable)key, 0);
    }

    public void clear() {
        this.modify();
        this.nodeCount = 0;
        this.rootNode[0] = null;
        this.rootNode[1] = null;
    }

    public Set keySet() {
        if (this.setOfKeys[0] == null) {
            this.setOfKeys[0] = new AbstractSet(){

                public Iterator iterator() {
                    return new DoubleOrderedMapIterator(0){

                        protected Object doGetNext() {
                            return this.lastReturnedNode.getData(0);
                        }
                    };
                }

                public int size() {
                    return DoubleOrderedMap.this.size();
                }

                public boolean contains(Object o) {
                    return DoubleOrderedMap.this.containsKey(o);
                }

                public boolean remove(Object o) {
                    int oldNodeCount = DoubleOrderedMap.this.nodeCount;
                    DoubleOrderedMap.this.remove(o);
                    return DoubleOrderedMap.this.nodeCount != oldNodeCount;
                }

                public void clear() {
                    DoubleOrderedMap.this.clear();
                }

                static /* synthetic */ DoubleOrderedMap access$1900(4 x0) {
                    return x0.DoubleOrderedMap.this;
                }
            };
        }
        return this.setOfKeys[0];
    }

    public Collection values() {
        if (this.collectionOfValues[0] == null) {
            this.collectionOfValues[0] = new AbstractCollection(){

                public Iterator iterator() {
                    return new DoubleOrderedMapIterator(0){

                        protected Object doGetNext() {
                            return this.lastReturnedNode.getData(1);
                        }
                    };
                }

                public int size() {
                    return DoubleOrderedMap.this.size();
                }

                public boolean contains(Object o) {
                    return DoubleOrderedMap.this.containsValue(o);
                }

                public boolean remove(Object o) {
                    int oldNodeCount = DoubleOrderedMap.this.nodeCount;
                    DoubleOrderedMap.this.removeValue(o);
                    return DoubleOrderedMap.this.nodeCount != oldNodeCount;
                }

                public boolean removeAll(Collection c) {
                    boolean modified = false;
                    Iterator iter2 = c.iterator();
                    while (iter2.hasNext()) {
                        if (DoubleOrderedMap.this.removeValue(iter2.next()) == null) continue;
                        modified = true;
                    }
                    return modified;
                }

                public void clear() {
                    DoubleOrderedMap.this.clear();
                }

                static /* synthetic */ DoubleOrderedMap access$2000(5 x0) {
                    return x0.DoubleOrderedMap.this;
                }
            };
        }
        return this.collectionOfValues[0];
    }

    public Set entrySet() {
        if (this.setOfEntries[0] == null) {
            this.setOfEntries[0] = new AbstractSet(){

                public Iterator iterator() {
                    return new DoubleOrderedMapIterator(0){

                        protected Object doGetNext() {
                            return this.lastReturnedNode;
                        }
                    };
                }

                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry2 = (Map.Entry)o;
                    Object value2 = entry2.getValue();
                    Node node = DoubleOrderedMap.this.lookup((Comparable)entry2.getKey(), 0);
                    return node != null && node.getData(1).equals(value2);
                }

                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry2 = (Map.Entry)o;
                    Object value2 = entry2.getValue();
                    Node node = DoubleOrderedMap.this.lookup((Comparable)entry2.getKey(), 0);
                    if (node != null && node.getData(1).equals(value2)) {
                        DoubleOrderedMap.this.doRedBlackDelete(node);
                        return true;
                    }
                    return false;
                }

                public int size() {
                    return DoubleOrderedMap.this.size();
                }

                public void clear() {
                    DoubleOrderedMap.this.clear();
                }

                static /* synthetic */ DoubleOrderedMap access$2100(6 x0) {
                    return x0.DoubleOrderedMap.this;
                }
            };
        }
        return this.setOfEntries[0];
    }

    private static final class Node
    implements Map.Entry,
    KeyValue {
        private Comparable[] data;
        private Node[] leftNode;
        private Node[] rightNode;
        private Node[] parentNode;
        private boolean[] blackColor;
        private int hashcodeValue;
        private boolean calculatedHashCode;

        Node(Comparable key, Comparable value2) {
            this.data = new Comparable[]{key, value2};
            this.leftNode = new Node[]{null, null};
            this.rightNode = new Node[]{null, null};
            this.parentNode = new Node[]{null, null};
            this.blackColor = new boolean[]{true, true};
            this.calculatedHashCode = false;
        }

        private Comparable getData(int index2) {
            return this.data[index2];
        }

        private void setLeft(Node node, int index2) {
            this.leftNode[index2] = node;
        }

        private Node getLeft(int index2) {
            return this.leftNode[index2];
        }

        private void setRight(Node node, int index2) {
            this.rightNode[index2] = node;
        }

        private Node getRight(int index2) {
            return this.rightNode[index2];
        }

        private void setParent(Node node, int index2) {
            this.parentNode[index2] = node;
        }

        private Node getParent(int index2) {
            return this.parentNode[index2];
        }

        private void swapColors(Node node, int index2) {
            int n = index2;
            this.blackColor[n] = this.blackColor[n] ^ node.blackColor[index2];
            int n2 = index2;
            node.blackColor[n2] = node.blackColor[n2] ^ this.blackColor[index2];
            int n3 = index2;
            this.blackColor[n3] = this.blackColor[n3] ^ node.blackColor[index2];
        }

        private boolean isBlack(int index2) {
            return this.blackColor[index2];
        }

        private boolean isRed(int index2) {
            return !this.blackColor[index2];
        }

        private void setBlack(int index2) {
            this.blackColor[index2] = true;
        }

        private void setRed(int index2) {
            this.blackColor[index2] = false;
        }

        private void copyColor(Node node, int index2) {
            this.blackColor[index2] = node.blackColor[index2];
        }

        public Object getKey() {
            return this.data[0];
        }

        public Object getValue() {
            return this.data[1];
        }

        public Object setValue(Object ignored) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Map.Entry.setValue is not supported");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.data[0].equals(e.getKey()) && this.data[1].equals(e.getValue());
        }

        public int hashCode() {
            if (!this.calculatedHashCode) {
                this.hashcodeValue = this.data[0].hashCode() ^ this.data[1].hashCode();
                this.calculatedHashCode = true;
            }
            return this.hashcodeValue;
        }
    }

    private abstract class DoubleOrderedMapIterator
    implements Iterator {
        private int expectedModifications;
        protected Node lastReturnedNode;
        private Node nextNode;
        private int iteratorType;

        DoubleOrderedMapIterator(int type) {
            this.iteratorType = type;
            this.expectedModifications = DoubleOrderedMap.this.modifications;
            this.lastReturnedNode = null;
            this.nextNode = DoubleOrderedMap.leastNode(DoubleOrderedMap.this.rootNode[this.iteratorType], this.iteratorType);
        }

        protected abstract Object doGetNext();

        public final boolean hasNext() {
            return this.nextNode != null;
        }

        public final Object next() throws NoSuchElementException, ConcurrentModificationException {
            if (this.nextNode == null) {
                throw new NoSuchElementException();
            }
            if (DoubleOrderedMap.this.modifications != this.expectedModifications) {
                throw new ConcurrentModificationException();
            }
            this.lastReturnedNode = this.nextNode;
            this.nextNode = DoubleOrderedMap.this.nextGreater(this.nextNode, this.iteratorType);
            return this.doGetNext();
        }

        public final void remove() throws IllegalStateException, ConcurrentModificationException {
            if (this.lastReturnedNode == null) {
                throw new IllegalStateException();
            }
            if (DoubleOrderedMap.this.modifications != this.expectedModifications) {
                throw new ConcurrentModificationException();
            }
            DoubleOrderedMap.this.doRedBlackDelete(this.lastReturnedNode);
            ++this.expectedModifications;
            this.lastReturnedNode = null;
        }
    }
}

