/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;

public final class LongConverter
implements Converter {
    private Object defaultValue = null;
    private boolean useDefault = true;

    public LongConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public LongConverter(Object defaultValue) {
        this.defaultValue = defaultValue;
        this.useDefault = true;
    }

    public Object convert(Class type, Object value2) {
        if (value2 == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        if (value2 instanceof Long) {
            return value2;
        }
        if (value2 instanceof Number) {
            return new Long(((Number)value2).longValue());
        }
        try {
            return new Long(value2.toString());
        }
        catch (Exception e) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException(e);
        }
    }
}

