/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;

public final class CharacterConverter
implements Converter {
    private Object defaultValue = null;
    private boolean useDefault = true;

    public CharacterConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public CharacterConverter(Object defaultValue) {
        this.defaultValue = defaultValue;
        this.useDefault = true;
    }

    public Object convert(Class type, Object value2) {
        if (value2 == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        if (value2 instanceof Character) {
            return value2;
        }
        try {
            return new Character(value2.toString().charAt(0));
        }
        catch (Exception e) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException(e);
        }
    }
}

