/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.OutputStream;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ImportZkOffsets$
implements Logging {
    public static final ImportZkOffsets$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new ImportZkOffsets$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ImportZkOffsets$ importZkOffsets$ = this;
        synchronized (importZkOffsets$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public void main(String[] args) {
        OptionSet options;
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec zkConnectOpt = parser.accepts("zkconnect", "ZooKeeper connect string.").withRequiredArg().defaultsTo((Object)"localhost:2181", (Object[])new String[0]).ofType(String.class);
        ArgumentAcceptingOptionSpec inFileOpt = parser.accepts("input-file", "Input file").withRequiredArg().ofType(String.class);
        parser.accepts("help", "Print this message.");
        if (args.length == 0) {
            CommandLineUtils$.MODULE$.printUsageAndDie(parser, "Import offsets to zookeeper from files.");
        }
        if ((options = parser.parse(args)).has("help")) {
            parser.printHelpOn((OutputStream)System.out);
            System.exit(0);
        }
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{inFileOpt}));
        String zkConnect = (String)options.valueOf((OptionSpec)zkConnectOpt);
        String partitionOffsetFile = (String)options.valueOf((OptionSpec)inFileOpt);
        ZkClient zkClient = new ZkClient(zkConnect, 30000, 30000, ZKStringSerializer$.MODULE$);
        Map<String, String> partitionOffsets = this.getPartitionOffsetsFromFile(partitionOffsetFile);
        this.updateZkOffsets(zkClient, partitionOffsets);
    }

    private Map<String, String> getPartitionOffsetsFromFile(String filename) {
        FileReader fr = new FileReader(filename);
        BufferedReader br = new BufferedReader(fr);
        Map<String, String> partOffsetsMap = (Map<String, String>)Predef$.MODULE$.Map().apply(Nil$.MODULE$);
        ObjectRef<String> s2 = ObjectRef.create(br.readLine());
        while ((String)s2.elem != null && ((String)s2.elem).length() >= 1) {
            String[] tokens = ((String)s2.elem).split(":");
            partOffsetsMap = partOffsetsMap.$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tokens[0]), tokens[1]));
            this.debug((Function0<String>)((Object)new Serializable(s2){
                public static final long serialVersionUID = 0L;
                private final ObjectRef s$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"adding node path [").append((Object)((String)this.s$1.elem)).append((Object)"]").toString();
                }
                {
                    this.s$1 = s$1;
                }
            }));
            s2.elem = br.readLine();
        }
        return partOffsetsMap;
    }

    private void updateZkOffsets(ZkClient zkClient, Map<String, String> partitionOffsets) {
        partitionOffsets.withFilter((Function1<String, Object>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> check$ifrefutable$1) {
                Tuple2<String, String> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        })).foreach(new Serializable(zkClient){
            public static final long serialVersionUID = 0L;
            private final ZkClient zkClient$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final void apply(Tuple2<String, String> x$1) {
                BoxedUnit boxedUnit;
                Tuple2<String, String> tuple2 = x$1;
                if (tuple2 == null) throw new MatchError(tuple2);
                String partition2 = tuple2._1();
                String offset = tuple2._2();
                ImportZkOffsets$.MODULE$.debug((Function0<String>)((Object)new Serializable(this, partition2, offset){
                    public static final long serialVersionUID = 0L;
                    private final String partition$1;
                    private final String offset$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"updating [").append((Object)this.partition$1).append((Object)"] with offset [").append((Object)this.offset$1).append((Object)"]").toString();
                    }
                    {
                        this.partition$1 = partition$1;
                        this.offset$1 = offset$1;
                    }
                }));
                try {
                    ZkUtils$.MODULE$.updatePersistentPath(this.zkClient$1, partition2, offset.toString());
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            }
            {
                this.zkClient$1 = zkClient$1;
            }
        });
    }

    private ImportZkOffsets$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

