/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.InvalidOffsetException;
import kafka.log.OffsetIndex$;
import kafka.log.OffsetPosition;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Os$;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import sun.nio.ch.DirectBuffer;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t\u0015b\u0001B\u0001\u0003\u0001\u001d\u00111b\u00144gg\u0016$\u0018J\u001c3fq*\u00111\u0001B\u0001\u0004Y><'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\b\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g!\ty!#D\u0001\u0011\u0015\t\tB!A\u0003vi&d7/\u0003\u0002\u0014!\t9Aj\\4hS:<\u0007\u0002C\u000b\u0001\u0005\u0003\u0007I\u0011\u0001\f\u0002\t\u0019LG.Z\u000b\u0002/A\u0011\u0001$H\u0007\u00023)\u0011!dG\u0001\u0003S>T\u0011\u0001H\u0001\u0005U\u00064\u0018-\u0003\u0002\u001f3\t!a)\u001b7f\u0011!\u0001\u0003A!a\u0001\n\u0003\t\u0013\u0001\u00034jY\u0016|F%Z9\u0015\u0005\t*\u0003CA\u0005$\u0013\t!#B\u0001\u0003V]&$\bb\u0002\u0014 \u0003\u0003\u0005\raF\u0001\u0004q\u0012\n\u0004\u0002\u0003\u0015\u0001\u0005\u0003\u0005\u000b\u0015B\f\u0002\u000b\u0019LG.\u001a\u0011)\u0005\u001dR\u0003CA\u0005,\u0013\ta#B\u0001\u0005w_2\fG/\u001b7f\u0011!q\u0003A!b\u0001\n\u0003y\u0013A\u00032bg\u0016|eMZ:fiV\t\u0001\u0007\u0005\u0002\nc%\u0011!G\u0003\u0002\u0005\u0019>tw\r\u0003\u00055\u0001\t\u0005\t\u0015!\u00031\u0003-\u0011\u0017m]3PM\u001a\u001cX\r\u001e\u0011\t\u0011Y\u0002!Q1A\u0005\u0002]\nA\"\\1y\u0013:$W\r_*ju\u0016,\u0012\u0001\u000f\t\u0003\u0013eJ!A\u000f\u0006\u0003\u0007%sG\u000f\u0003\u0005=\u0001\t\u0005\t\u0015!\u00039\u00035i\u0017\r_%oI\u0016D8+\u001b>fA!)a\b\u0001C\u0001\u007f\u00051A(\u001b8jiz\"B\u0001\u0011\"D\tB\u0011\u0011\tA\u0007\u0002\u0005!)Q#\u0010a\u0001/!)a&\u0010a\u0001a!9a'\u0010I\u0001\u0002\u0004A\u0004b\u0002$\u0001\u0005\u0004%IaR\u0001\u0005Y>\u001c7.F\u0001I!\tI\u0005+D\u0001K\u0015\tYE*A\u0003m_\u000e\\7O\u0003\u0002N\u001d\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005=[\u0012\u0001B;uS2L!!\u0015&\u0003\u001bI+WM\u001c;sC:$Hj\\2l\u0011\u0019\u0019\u0006\u0001)A\u0005\u0011\u0006)An\\2lA!9Q\u000b\u0001a\u0001\n\u00131\u0016\u0001B7nCB,\u0012a\u0016\t\u00031nk\u0011!\u0017\u0006\u00035n\t1A\\5p\u0013\ta\u0016L\u0001\tNCB\u0004X\r\u001a\"zi\u0016\u0014UO\u001a4fe\"9a\f\u0001a\u0001\n\u0013y\u0016\u0001C7nCB|F%Z9\u0015\u0005\t\u0002\u0007b\u0002\u0014^\u0003\u0003\u0005\ra\u0016\u0005\u0007E\u0002\u0001\u000b\u0015B,\u0002\u000b5l\u0017\r\u001d\u0011\t\u000f\u0011\u0004\u0001\u0019!C\u0005K\u0006!1/\u001b>f+\u00051\u0007CA4k\u001b\u0005A'BA5M\u0003\u0019\tGo\\7jG&\u00111\u000e\u001b\u0002\u000e\u0003R|W.[2J]R,w-\u001a:\t\u000f5\u0004\u0001\u0019!C\u0005]\u0006A1/\u001b>f?\u0012*\u0017\u000f\u0006\u0002#_\"9a\u0005\\A\u0001\u0002\u00041\u0007BB9\u0001A\u0003&a-A\u0003tSj,\u0007\u0005C\u0004t\u0001\u0001\u0007I\u0011A\u001c\u0002\u00155\f\u00070\u00128ue&,7\u000fC\u0004v\u0001\u0001\u0007I\u0011\u0001<\u0002\u001d5\f\u00070\u00128ue&,7o\u0018\u0013fcR\u0011!e\u001e\u0005\bMQ\f\t\u00111\u00019\u0011\u0019I\b\u0001)Q\u0005q\u0005YQ.\u0019=F]R\u0014\u0018.Z:!Q\tA(\u0006C\u0004}\u0001\u0001\u0007I\u0011A\u0018\u0002\u00151\f7\u000f^(gMN,G\u000fC\u0004\u007f\u0001\u0001\u0007I\u0011A@\u0002\u001d1\f7\u000f^(gMN,Go\u0018\u0013fcR\u0019!%!\u0001\t\u000f\u0019j\u0018\u0011!a\u0001a!9\u0011Q\u0001\u0001!B\u0013\u0001\u0014a\u00037bgR|eMZ:fi\u0002Bq!!\u0003\u0001\t\u0003\tY!A\u0007sK\u0006$G*Y:u\u000b:$(/\u001f\u000b\u0003\u0003\u001b\u00012!QA\b\u0013\r\t\tB\u0001\u0002\u000f\u001f\u001a47/\u001a;Q_NLG/[8o\u0011\u001d\t)\u0002\u0001C\u0001\u0003/\ta\u0001\\8pWV\u0004H\u0003BA\u0007\u00033Aq!a\u0007\u0002\u0014\u0001\u0007\u0001'\u0001\u0007uCJ<W\r^(gMN,G\u000fC\u0004\u0002 \u0001!I!!\t\u0002\u0019%tG-\u001a=TY>$hi\u001c:\u0015\u000ba\n\u0019#!\f\t\u0011\u0005\u0015\u0012Q\u0004a\u0001\u0003O\t1!\u001b3y!\rA\u0016\u0011F\u0005\u0004\u0003WI&A\u0003\"zi\u0016\u0014UO\u001a4fe\"9\u00111DA\u000f\u0001\u0004\u0001\u0004bBA\u0019\u0001\u0011%\u00111G\u0001\u000fe\u0016d\u0017\r^5wK>3gm]3u)\u0015A\u0014QGA\u001d\u0011!\t9$a\fA\u0002\u0005\u001d\u0012A\u00022vM\u001a,'\u000fC\u0004\u0002<\u0005=\u0002\u0019\u0001\u001d\u0002\u00039Dq!a\u0010\u0001\t\u0013\t\t%\u0001\u0005qQf\u001c\u0018nY1m)\u0015A\u00141IA#\u0011!\t9$!\u0010A\u0002\u0005\u001d\u0002bBA\u001e\u0003{\u0001\r\u0001\u000f\u0005\b\u0003\u0013\u0002A\u0011AA&\u0003\u0015)g\u000e\u001e:z)\u0011\ti!!\u0014\t\u000f\u0005m\u0012q\ta\u0001q!9\u0011\u0011\u000b\u0001\u0005\u0002\u0005M\u0013AB1qa\u0016tG\rF\u0003#\u0003+\nI\u0006C\u0004\u0002X\u0005=\u0003\u0019\u0001\u0019\u0002\r=4gm]3u\u0011\u001d\tY&a\u0014A\u0002a\n\u0001\u0002]8tSRLwN\u001c\u0005\b\u0003?\u0002A\u0011AA1\u0003\u0019I7OR;mYV\u0011\u00111\r\t\u0004\u0013\u0005\u0015\u0014bAA4\u0015\t9!i\\8mK\u0006t\u0007bBA6\u0001\u0011\u0005\u0011QN\u0001\tiJ,hnY1uKR\t!\u0005C\u0004\u0002r\u0001!\t!a\u001d\u0002\u0015Q\u0014XO\\2bi\u0016$v\u000eF\u0002#\u0003kBq!a\u0016\u0002p\u0001\u0007\u0001\u0007C\u0004\u0002z\u0001!I!a\u001f\u0002#Q\u0014XO\\2bi\u0016$v.\u00128ue&,7\u000fF\u0002#\u0003{Bq!a \u0002x\u0001\u0007\u0001(A\u0004f]R\u0014\u0018.Z:\t\u000f\u0005\r\u0005\u0001\"\u0001\u0002n\u0005yAO]5n)>4\u0016\r\\5e'&TX\rC\u0004\u0002\b\u0002!\t!!#\u0002\rI,7/\u001b>f)\r\u0011\u00131\u0012\u0005\b\u0003\u001b\u000b)\t1\u00019\u0003\u001dqWm^*ju\u0016Dq!!%\u0001\t\u0013\t\u0019*\u0001\u0006g_J\u001cW-\u00168nCB$2AIAK\u0011\u001d\t9*a$A\u0002]\u000b\u0011!\u001c\u0005\b\u00037\u0003A\u0011AA7\u0003\u00151G.^:i\u0011\u001d\ty\n\u0001C\u0001\u0003C\u000ba\u0001Z3mKR,GCAA2\u0011\u001d\ty\b\u0001C\u0001\u0003K#\u0012\u0001\u000f\u0005\b\u0003S\u0003A\u0011AAS\u0003-\u0019\u0018N_3J]\nKH/Z:\t\u000f\u00055\u0006\u0001\"\u0001\u0002n\u0005)1\r\\8tK\"9\u0011\u0011\u0017\u0001\u0005\u0002\u0005M\u0016\u0001\u0003:f]\u0006lW\rV8\u0015\t\u0005\r\u0014Q\u0017\u0005\b\u0003o\u000by\u000b1\u0001\u0018\u0003\u00051\u0007bBA^\u0001\u0011\u0005\u0011QN\u0001\fg\u0006t\u0017\u000e^=DQ\u0016\u001c7\u000eC\u0004\u0002@\u0002!I!!1\u0002)I|WO\u001c3U_\u0016C\u0018m\u0019;Nk2$\u0018\u000e\u001d7f)\u0015A\u00141YAd\u0011\u001d\t)-!0A\u0002a\naA\\;nE\u0016\u0014\bbBAe\u0003{\u0003\r\u0001O\u0001\u0007M\u0006\u001cGo\u001c:\t\u000f\u00055\u0007\u0001\"\u0003\u0002P\u0006IQ.Y=cK2{7m[\u000b\u0005\u0003#\fI\u000e\u0006\u0003\u0002T\u0006UH\u0003BAk\u0003W\u0004B!a6\u0002Z2\u0001A\u0001CAn\u0003\u0017\u0014\r!!8\u0003\u0003Q\u000bB!a8\u0002fB\u0019\u0011\"!9\n\u0007\u0005\r(BA\u0004O_RD\u0017N\\4\u0011\u0007%\t9/C\u0002\u0002j*\u00111!\u00118z\u0011%\ti/a3\u0005\u0002\u0004\ty/A\u0002gk:\u0004R!CAy\u0003+L1!a=\u000b\u0005!a$-\u001f8b[\u0016t\u0004b\u0002$\u0002L\u0002\u0007\u0011q\u001f\t\u0004\u0013\u0006e\u0018bAA~\u0015\n!Aj\\2l\u000f%\tyPAA\u0001\u0012\u0003\u0011\t!A\u0006PM\u001a\u001cX\r^%oI\u0016D\bcA!\u0003\u0004\u0019A\u0011AAA\u0001\u0012\u0003\u0011)aE\u0002\u0003\u0004!AqA\u0010B\u0002\t\u0003\u0011I\u0001\u0006\u0002\u0003\u0002!Q!Q\u0002B\u0002#\u0003%\tAa\u0004\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011\tBK\u00029\u0005'Y#A!\u0006\u0011\t\t]!\u0011E\u0007\u0003\u00053QAAa\u0007\u0003\u001e\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005?Q\u0011AC1o]>$\u0018\r^5p]&!!1\u0005B\r\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class OffsetIndex
implements Logging {
    private volatile File file;
    private final long baseOffset;
    private final int maxIndexSize;
    private final ReentrantLock lock;
    private MappedByteBuffer kafka$log$OffsetIndex$$mmap;
    private AtomicInteger kafka$log$OffsetIndex$$size;
    private volatile int maxEntries;
    private long lastOffset;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static int $lessinit$greater$default$3() {
        return OffsetIndex$.MODULE$.$lessinit$greater$default$3();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        OffsetIndex offsetIndex = this;
        synchronized (offsetIndex) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public File file() {
        return this.file;
    }

    public void file_$eq(File x$1) {
        this.file = x$1;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int maxIndexSize() {
        return this.maxIndexSize;
    }

    private ReentrantLock lock() {
        return this.lock;
    }

    public MappedByteBuffer kafka$log$OffsetIndex$$mmap() {
        return this.kafka$log$OffsetIndex$$mmap;
    }

    public void kafka$log$OffsetIndex$$mmap_$eq(MappedByteBuffer x$1) {
        this.kafka$log$OffsetIndex$$mmap = x$1;
    }

    public AtomicInteger kafka$log$OffsetIndex$$size() {
        return this.kafka$log$OffsetIndex$$size;
    }

    private void kafka$log$OffsetIndex$$size_$eq(AtomicInteger x$1) {
        this.kafka$log$OffsetIndex$$size = x$1;
    }

    public int maxEntries() {
        return this.maxEntries;
    }

    public void maxEntries_$eq(int x$1) {
        this.maxEntries = x$1;
    }

    public long lastOffset() {
        return this.lastOffset;
    }

    public void lastOffset_$eq(long x$1) {
        this.lastOffset = x$1;
    }

    public OffsetPosition readLastEntry() {
        return Utils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;

            public final OffsetPosition apply() {
                OffsetPosition offsetPosition;
                int n = this.$outer.kafka$log$OffsetIndex$$size().get();
                switch (n) {
                    default: {
                        offsetPosition = new OffsetPosition(this.$outer.baseOffset() + (long)this.$outer.kafka$log$OffsetIndex$$relativeOffset(this.$outer.kafka$log$OffsetIndex$$mmap(), n - 1), this.$outer.kafka$log$OffsetIndex$$physical(this.$outer.kafka$log$OffsetIndex$$mmap(), n - 1));
                        break;
                    }
                    case 0: {
                        offsetPosition = new OffsetPosition(this.$outer.baseOffset(), 0);
                    }
                }
                return offsetPosition;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public OffsetPosition lookup(long targetOffset) {
        return this.maybeLock(this.lock(), (Function0)((Object)new Serializable(this, targetOffset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            private final long targetOffset$1;

            public final OffsetPosition apply() {
                ByteBuffer idx = this.$outer.kafka$log$OffsetIndex$$mmap().duplicate();
                int slot = this.$outer.kafka$log$OffsetIndex$$indexSlotFor(idx, this.targetOffset$1);
                return slot == -1 ? new OffsetPosition(this.$outer.baseOffset(), 0) : new OffsetPosition(this.$outer.baseOffset() + (long)this.$outer.kafka$log$OffsetIndex$$relativeOffset(idx, slot), this.$outer.kafka$log$OffsetIndex$$physical(idx, slot));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.targetOffset$1 = targetOffset$1;
            }
        }));
    }

    public int kafka$log$OffsetIndex$$indexSlotFor(ByteBuffer idx, long targetOffset) {
        long relOffset = targetOffset - this.baseOffset();
        if (this.entries() == 0) {
            return -1;
        }
        if ((long)this.kafka$log$OffsetIndex$$relativeOffset(idx, 0) > relOffset) {
            return -1;
        }
        int lo = 0;
        int hi = this.entries() - 1;
        while (lo < hi) {
            int mid = (int)package$.MODULE$.ceil((double)hi / 2.0 + (double)lo / 2.0);
            int found = this.kafka$log$OffsetIndex$$relativeOffset(idx, mid);
            if ((long)found == relOffset) {
                return mid;
            }
            if ((long)found < relOffset) {
                lo = mid;
                continue;
            }
            hi = mid - 1;
        }
        return lo;
    }

    public int kafka$log$OffsetIndex$$relativeOffset(ByteBuffer buffer, int n) {
        return buffer.getInt(n * 8);
    }

    public int kafka$log$OffsetIndex$$physical(ByteBuffer buffer, int n) {
        return buffer.getInt(n * 8 + 4);
    }

    public OffsetPosition entry(int n) {
        return this.maybeLock(this.lock(), (Function0)((Object)new Serializable(this, n){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            private final int n$1;

            public final OffsetPosition apply() {
                if (this.n$1 >= this.$outer.entries()) {
                    throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Attempt to fetch the %dth entry from an index of size %d.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.n$1), BoxesRunTime.boxToInteger(this.$outer.entries())})));
                }
                ByteBuffer idx = this.$outer.kafka$log$OffsetIndex$$mmap().duplicate();
                return new OffsetPosition(this.$outer.kafka$log$OffsetIndex$$relativeOffset(idx, this.n$1), this.$outer.kafka$log$OffsetIndex$$physical(idx, this.n$1));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.n$1 = n$1;
            }
        }));
    }

    public void append(long offset, int position) {
        Utils$.MODULE$.inLock(this.lock(), new Serializable(this, offset, position){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            public final long offset$1;
            public final int position$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Predef$.MODULE$.require(!this.$outer.isFull(), (Function0<Object>)((Object)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$append$1 $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Attempt to append to a full index (size = ").append(this.$outer.kafka$log$OffsetIndex$$anonfun$$$outer().kafka$log$OffsetIndex$$size()).append((Object)").").toString();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }));
                if (this.$outer.kafka$log$OffsetIndex$$size().get() == 0 || this.offset$1 > this.$outer.lastOffset()) {
                    this.$outer.debug((Function0<String>)((Object)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$append$1 $outer;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Adding index entry %d => %d to %s.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.$outer.offset$1), BoxesRunTime.boxToInteger(this.$outer.position$1), this.$outer.kafka$log$OffsetIndex$$anonfun$$$outer().file().getName()}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }));
                    this.$outer.kafka$log$OffsetIndex$$mmap().putInt((int)(this.offset$1 - this.$outer.baseOffset()));
                    this.$outer.kafka$log$OffsetIndex$$mmap().putInt(this.position$1);
                    this.$outer.kafka$log$OffsetIndex$$size().incrementAndGet();
                    this.$outer.lastOffset_$eq(this.offset$1);
                    Predef$.MODULE$.require(this.$outer.entries() * 8 == this.$outer.kafka$log$OffsetIndex$$mmap().position(), (Function0<Object>)((Object)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$append$1 $outer;

                        public final String apply() {
                            return new StringBuilder().append(this.$outer.kafka$log$OffsetIndex$$anonfun$$$outer().entries()).append((Object)" entries but file position in index is ").append(BoxesRunTime.boxToInteger(this.$outer.kafka$log$OffsetIndex$$anonfun$$$outer().kafka$log$OffsetIndex$$mmap().position())).append((Object)".").toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }));
                    return;
                }
                throw new InvalidOffsetException(new StringOps(Predef$.MODULE$.augmentString("Attempt to append an offset (%d) to position %d no larger than the last offset appended (%d) to %s.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.offset$1), BoxesRunTime.boxToInteger(this.$outer.entries()), BoxesRunTime.boxToLong(this.$outer.lastOffset()), this.$outer.file().getAbsolutePath()})));
            }

            public /* synthetic */ OffsetIndex kafka$log$OffsetIndex$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offset$1 = offset$1;
                this.position$1 = position$1;
            }
        });
    }

    public boolean isFull() {
        return this.entries() >= this.maxEntries();
    }

    public void truncate() {
        this.kafka$log$OffsetIndex$$truncateToEntries(0);
    }

    public void truncateTo(long offset) {
        Utils$.MODULE$.inLock(this.lock(), new Serializable(this, offset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            private final long offset$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ByteBuffer idx = this.$outer.kafka$log$OffsetIndex$$mmap().duplicate();
                int slot = this.$outer.kafka$log$OffsetIndex$$indexSlotFor(idx, this.offset$2);
                int newEntries = slot < 0 ? 0 : ((long)this.$outer.kafka$log$OffsetIndex$$relativeOffset(idx, slot) == this.offset$2 - this.$outer.baseOffset() ? slot : slot + 1);
                this.$outer.kafka$log$OffsetIndex$$truncateToEntries(newEntries);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offset$2 = offset$2;
            }
        });
    }

    public void kafka$log$OffsetIndex$$truncateToEntries(int entries) {
        Utils$.MODULE$.inLock(this.lock(), new Serializable(this, entries){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            private final int entries$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$log$OffsetIndex$$size().set(this.entries$1);
                this.$outer.kafka$log$OffsetIndex$$mmap().position(this.$outer.kafka$log$OffsetIndex$$size().get() * 8);
                this.$outer.lastOffset_$eq(this.$outer.readLastEntry().offset());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.entries$1 = entries$1;
            }
        });
    }

    public void trimToValidSize() {
        Utils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.resize(this.$outer.entries() * 8);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void resize(int newSize) {
        Utils$.MODULE$.inLock(this.lock(), new Serializable(this, newSize){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            private final int newSize$1;

            /*
             * WARNING - void declaration
             */
            public final Buffer apply() {
                Buffer buffer;
                RandomAccessFile raf = new RandomAccessFile(this.$outer.file(), "rws");
                int roundedNewSize = this.$outer.kafka$log$OffsetIndex$$roundToExactMultiple(this.newSize$1, 8);
                int position = this.$outer.kafka$log$OffsetIndex$$mmap().position();
                if (Os$.MODULE$.isWindows()) {
                    this.$outer.kafka$log$OffsetIndex$$forceUnmap(this.$outer.kafka$log$OffsetIndex$$mmap());
                }
                try {
                    raf.setLength(roundedNewSize);
                    this.$outer.kafka$log$OffsetIndex$$mmap_$eq(raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, roundedNewSize));
                    this.$outer.maxEntries_$eq(this.$outer.kafka$log$OffsetIndex$$mmap().limit() / 8);
                    buffer = this.$outer.kafka$log$OffsetIndex$$mmap().position(position);
                    Utils$.MODULE$.swallow((Function0<BoxedUnit>)((Object)new Serializable(this, raf){
                        public static final long serialVersionUID = 0L;
                        private final RandomAccessFile raf$2;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.raf$2.close();
                        }
                        {
                            this.raf$2 = raf$2;
                        }
                    }));
                }
                catch (Throwable throwable) {
                    void var1_1;
                    Utils$.MODULE$.swallow((Function0<BoxedUnit>)((Object)new /* invalid duplicate definition of identical inner class */));
                    throw throwable;
                }
                return buffer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newSize$1 = newSize$1;
            }
        });
    }

    public void kafka$log$OffsetIndex$$forceUnmap(MappedByteBuffer m) {
        try {
            if (m instanceof DirectBuffer) {
                ((DirectBuffer)((Object)m)).cleaner().clean();
            }
        }
        catch (Throwable throwable) {
            this.warn((Function0<String>)((Object)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Error when freeing index buffer";
                }
            }), (Function0<Throwable>)((Object)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$1;

                public final Throwable apply() {
                    return this.t$1;
                }
                {
                    this.t$1 = t$1;
                }
            }));
        }
    }

    public void flush() {
        Utils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;

            public final MappedByteBuffer apply() {
                return this.$outer.kafka$log$OffsetIndex$$mmap().force();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public boolean delete() {
        this.info((Function0<String>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"Deleting index ").append((Object)this.$outer.file().getAbsolutePath()).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        return this.file().delete();
    }

    public int entries() {
        return this.kafka$log$OffsetIndex$$size().get();
    }

    public int sizeInBytes() {
        return 8 * this.entries();
    }

    public void close() {
        this.trimToValidSize();
    }

    /*
     * WARNING - void declaration
     */
    public boolean renameTo(File f) {
        void var2_2;
        boolean success2 = this.file().renameTo(f);
        this.file_$eq(f);
        return (boolean)var2_2;
    }

    public void sanityCheck() {
        Predef$.MODULE$.require(this.entries() == 0 || this.lastOffset() > this.baseOffset(), (Function0<Object>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Corrupt index found, index file (%s) has non-zero size but the last offset is %d and the base offset is %d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.file().getAbsolutePath(), BoxesRunTime.boxToLong(this.$outer.lastOffset()), BoxesRunTime.boxToLong(this.$outer.baseOffset())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        long len = this.file().length();
        Predef$.MODULE$.require(len % 8L == 0L, (Function0<Object>)((Object)new Serializable(this, len){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            private final long len$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Index file ").append((Object)this.$outer.file().getName()).append((Object)" is corrupt, found ").append(BoxesRunTime.boxToLong(this.len$1)).append((Object)" bytes which is not positive or not a multiple of 8.").toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.len$1 = len$1;
            }
        }));
    }

    public int kafka$log$OffsetIndex$$roundToExactMultiple(int number2, int factor) {
        return factor * (number2 / factor);
    }

    private <T> T maybeLock(Lock lock2, Function0<T> fun) {
        if (Os$.MODULE$.isWindows()) {
            lock2.lock();
        }
        try {
            return fun.apply();
        }
        finally {
            if (Os$.MODULE$.isWindows()) {
                lock2.unlock();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public OffsetIndex(File file, long baseOffset, int maxIndexSize) {
        this.file = file;
        this.baseOffset = baseOffset;
        this.maxIndexSize = maxIndexSize;
        Logging$class.$init$(this);
        this.lock = new ReentrantLock();
        boolean newlyCreated = this.file().createNewFile();
        RandomAccessFile raf = new RandomAccessFile(this.file(), "rw");
        try {
            if (newlyCreated) {
                if (maxIndexSize < 8) {
                    throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid max index size: ").append(BoxesRunTime.boxToInteger(maxIndexSize)).toString());
                }
                raf.setLength(this.kafka$log$OffsetIndex$$roundToExactMultiple(maxIndexSize, 8));
            }
            long len = raf.length();
            MappedByteBuffer idx = raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, len);
            Buffer buffer = newlyCreated ? idx.position(0) : idx.position(this.kafka$log$OffsetIndex$$roundToExactMultiple(idx.limit(), 8));
            Utils$.MODULE$.swallow((Function0<BoxedUnit>)((Object)new Serializable(this, raf){
                public static final long serialVersionUID = 0L;
                private final RandomAccessFile raf$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.raf$1.close();
                }
                {
                    this.raf$1 = raf$1;
                }
            }));
            this.kafka$log$OffsetIndex$$mmap = idx;
        }
        catch (Throwable throwable) {
            void var6_5;
            Utils$.MODULE$.swallow((Function0<BoxedUnit>)((Object)new /* invalid duplicate definition of identical inner class */));
            throw throwable;
        }
        this.kafka$log$OffsetIndex$$size = new AtomicInteger(this.kafka$log$OffsetIndex$$mmap().position() / 8);
        this.maxEntries = this.kafka$log$OffsetIndex$$mmap().limit() / 8;
        this.lastOffset = this.readLastEntry().offset();
        this.debug((Function0<String>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Loaded index file %s with maxEntries = %d, maxIndexSize = %d, entries = %d, lastOffset = %d, file position = %d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.file().getAbsolutePath(), BoxesRunTime.boxToInteger(this.$outer.maxEntries()), BoxesRunTime.boxToInteger(this.$outer.maxIndexSize()), BoxesRunTime.boxToInteger(this.$outer.entries()), BoxesRunTime.boxToLong(this.$outer.lastOffset()), BoxesRunTime.boxToInteger(this.$outer.kafka$log$OffsetIndex$$mmap().position())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
    }
}

