/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.wadl;

import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.api.model.AbstractResource;
import com.sun.jersey.api.uri.UriTemplate;
import com.sun.jersey.core.header.MediaTypes;
import com.sun.jersey.server.impl.model.method.ResourceHttpOptionsMethod;
import com.sun.jersey.server.impl.model.method.ResourceMethod;
import com.sun.jersey.server.wadl.WadlApplicationContext;
import com.sun.research.ws.wadl.Application;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;

final class WadlMethodFactory {
    WadlMethodFactory() {
    }

    private static final class WadlOptionsMethodDispatcher
    extends ResourceHttpOptionsMethod.OptionsRequestDispatcher {
        private final AbstractResource resource;
        private final String path;
        private final WadlApplicationContext wadlApplicationContext;

        WadlOptionsMethodDispatcher(Map<String, List<ResourceMethod>> methods, AbstractResource resource, String path, WadlApplicationContext wadlApplicationContext) {
            super(methods);
            this.resource = resource;
            this.path = path;
            this.wadlApplicationContext = wadlApplicationContext;
        }

        @Override
        public void dispatch(Object o, HttpContext context) {
            if (this.wadlApplicationContext.isWadlGenerationEnabled()) {
                Application a = this.wadlApplicationContext.getApplication(context.getUriInfo(), this.resource, this.path);
                context.getResponse().setResponse(Response.ok((Object)a, MediaTypes.WADL).header("Allow", this.allow).build());
            } else {
                context.getResponse().setResponse(Response.status(Response.Status.NO_CONTENT).header("Allow", this.allow).build());
            }
        }
    }

    public static final class WadlOptionsMethod
    extends ResourceMethod {
        public WadlOptionsMethod(Map<String, List<ResourceMethod>> methods, AbstractResource resource, String path, WadlApplicationContext wadlApplicationContext) {
            super("OPTIONS", UriTemplate.EMPTY, MediaTypes.GENERAL_MEDIA_TYPE_LIST, MediaTypes.GENERAL_MEDIA_TYPE_LIST, false, new WadlOptionsMethodDispatcher(methods, resource, path, wadlApplicationContext));
        }

        public String toString() {
            return "WADL OPTIONS method";
        }
    }
}

