/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.wadl;

import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.api.model.AbstractResource;
import com.sun.jersey.api.wadl.config.WadlGeneratorConfig;
import com.sun.jersey.api.wadl.config.WadlGeneratorConfigLoader;
import com.sun.jersey.server.wadl.ApplicationDescription;
import com.sun.jersey.server.wadl.WadlApplicationContext;
import com.sun.jersey.server.wadl.WadlBuilder;
import com.sun.jersey.server.wadl.WadlGenerator;
import com.sun.research.ws.wadl.Application;
import com.sun.research.ws.wadl.Doc;
import com.sun.research.ws.wadl.Grammars;
import com.sun.research.ws.wadl.Include;
import com.sun.research.ws.wadl.Resource;
import com.sun.research.ws.wadl.Resources;
import java.net.URI;
import java.util.Set;
import java.util.logging.Logger;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;

public class WadlApplicationContextImpl
implements WadlApplicationContext {
    private static final Logger LOG = Logger.getLogger(WadlApplicationContextImpl.class.getName());
    private boolean wadlGenerationEnabled = true;
    private final Set<AbstractResource> rootResources;
    private final WadlGeneratorConfig wadlGeneratorConfig;
    private JAXBContext jaxbContext;

    public WadlApplicationContextImpl(Set<AbstractResource> rootResources, ResourceConfig resourceConfig) {
        this.rootResources = rootResources;
        this.wadlGeneratorConfig = WadlGeneratorConfigLoader.loadWadlGeneratorsFromConfig(resourceConfig);
        try {
            this.jaxbContext = JAXBContext.newInstance(this.wadlGeneratorConfig.createWadlGenerator().getRequiredJaxbContextPath());
        }
        catch (JAXBException ex) {
            this.jaxbContext = null;
        }
    }

    @Override
    public ApplicationDescription getApplication(UriInfo ui) {
        ApplicationDescription a = this.getWadlBuilder().generate(this.rootResources);
        Application application = a.getApplication();
        for (Resources resources : application.getResources()) {
            resources.setBase(ui.getBaseUri().toString());
        }
        this.attachExternalGrammar(application, a, ui.getRequestUri());
        return a;
    }

    @Override
    public Application getApplication(UriInfo info, AbstractResource resource, String path) {
        ApplicationDescription description = this.getApplication(info);
        WadlGenerator wadlGenerator = this.wadlGeneratorConfig.createWadlGenerator();
        Application a = path == null ? new WadlBuilder(wadlGenerator).generate(description, resource) : new WadlBuilder(wadlGenerator).generate(description, resource, path);
        for (Resources resources : a.getResources()) {
            resources.setBase(info.getBaseUri().toString());
        }
        this.attachExternalGrammar(a, description, info.getRequestUri());
        for (Resources resources : a.getResources()) {
            Resource r = resources.getResource().get(0);
            r.setPath(info.getBaseUri().relativize(info.getAbsolutePath()).toString());
            r.getParam().clear();
        }
        return a;
    }

    @Override
    public JAXBContext getJAXBContext() {
        return this.jaxbContext;
    }

    private WadlBuilder getWadlBuilder() {
        return this.wadlGenerationEnabled ? new WadlBuilder(this.wadlGeneratorConfig.createWadlGenerator()) : null;
    }

    @Override
    public void setWadlGenerationEnabled(boolean wadlGenerationEnabled) {
        this.wadlGenerationEnabled = wadlGenerationEnabled;
    }

    @Override
    public boolean isWadlGenerationEnabled() {
        return this.wadlGenerationEnabled;
    }

    private void attachExternalGrammar(Application application, ApplicationDescription applicationDescription, URI requestURI) {
        Grammars grammars;
        URI rootURI;
        String root2;
        String requestURIPath = requestURI.getPath();
        if (requestURIPath.endsWith("application.wadl")) {
            requestURI = UriBuilder.fromUri(requestURI).replacePath(requestURIPath.substring(0, requestURIPath.lastIndexOf(47) + 1)).build(new Object[0]);
        }
        UriBuilder extendedPath = (root2 = application.getResources().get(0).getBase()) != null ? UriBuilder.fromPath(root2).path("/application.wadl/") : UriBuilder.fromPath("./application.wadl/");
        URI uRI = rootURI = root2 != null ? UriBuilder.fromPath(root2).build(new Object[0]) : null;
        if (application.getGrammars() != null) {
            LOG.info("The wadl application already contains a grammars element, we're adding elements of the provided grammars file.");
            grammars = application.getGrammars();
        } else {
            grammars = new Grammars();
            application.setGrammars(grammars);
        }
        for (String path : applicationDescription.getExternalMetadataKeys()) {
            URI schemaURI = extendedPath.clone().path(path).build(new Object[0]);
            String schemaURIS = schemaURI.toString();
            String requestURIs = requestURI.toString();
            String schemaPath = rootURI != null ? requestURI.relativize(schemaURI).toString() : schemaURI.toString();
            Include include = new Include();
            include.setHref(schemaPath);
            Doc doc = new Doc();
            doc.setLang("en");
            doc.setTitle("Generated");
            include.getDoc().add(doc);
            grammars.getInclude().add(include);
        }
    }
}

