/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.UnmodifiableLazyStringList;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyStringArrayList
extends AbstractList<String>
implements LazyStringList,
RandomAccess {
    public static final LazyStringList EMPTY = new UnmodifiableLazyStringList(new LazyStringArrayList());
    private final List<Object> list;

    public LazyStringArrayList() {
        this.list = new ArrayList<Object>();
    }

    public LazyStringArrayList(LazyStringList from2) {
        this.list = new ArrayList<Object>(from2.size());
        this.addAll(from2);
    }

    public LazyStringArrayList(List<String> from2) {
        this.list = new ArrayList<String>(from2);
    }

    @Override
    public String get(int index2) {
        Object o = this.list.get(index2);
        if (o instanceof String) {
            return (String)o;
        }
        ByteString bs = (ByteString)o;
        String s2 = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
            this.list.set(index2, s2);
        }
        return s2;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public String set(int index2, String s2) {
        Object o = this.list.set(index2, s2);
        return this.asString(o);
    }

    @Override
    public void add(int index2, String element) {
        this.list.add(index2, element);
        ++this.modCount;
    }

    @Override
    public boolean addAll(Collection<? extends String> c) {
        return this.addAll(this.size(), c);
    }

    @Override
    public boolean addAll(int index2, Collection<? extends String> c) {
        Collection<? extends String> collection = c instanceof LazyStringList ? ((LazyStringList)c).getUnderlyingElements() : c;
        boolean ret = this.list.addAll(index2, collection);
        ++this.modCount;
        return ret;
    }

    @Override
    public String remove(int index2) {
        Object o = this.list.remove(index2);
        ++this.modCount;
        return this.asString(o);
    }

    @Override
    public void clear() {
        this.list.clear();
        ++this.modCount;
    }

    @Override
    public void add(ByteString element) {
        this.list.add(element);
        ++this.modCount;
    }

    @Override
    public ByteString getByteString(int index2) {
        Object o = this.list.get(index2);
        if (o instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)o);
            this.list.set(index2, b);
            return b;
        }
        return (ByteString)o;
    }

    private String asString(Object o) {
        if (o instanceof String) {
            return (String)o;
        }
        return ((ByteString)o).toStringUtf8();
    }

    @Override
    public List<?> getUnderlyingElements() {
        return Collections.unmodifiableList(this.list);
    }
}

