/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.model;

public class S3BucketLoggingStatus {
    private String targetBucketName = null;
    private String logfilePrefix = null;

    public S3BucketLoggingStatus() {
    }

    public S3BucketLoggingStatus(String targetBucketName, String logfilePrefix) {
        this.targetBucketName = targetBucketName;
        this.logfilePrefix = logfilePrefix;
    }

    public boolean isLoggingEnabled() {
        return this.targetBucketName != null && this.logfilePrefix != null;
    }

    public String getLogfilePrefix() {
        return this.logfilePrefix;
    }

    public void setLogfilePrefix(String logfilePrefix) {
        this.logfilePrefix = logfilePrefix;
    }

    public String getTargetBucketName() {
        return this.targetBucketName;
    }

    public void setTargetBucketName(String targetBucketName) {
        this.targetBucketName = targetBucketName;
    }

    public String toString() {
        String result2 = "LoggingStatus enabled=" + this.isLoggingEnabled();
        if (this.isLoggingEnabled()) {
            result2 = result2 + ", targetBucketName=" + this.getTargetBucketName() + ", logfilePrefix=" + this.getLogfilePrefix();
        }
        return result2;
    }

    public String toXml() {
        StringBuffer sb = new StringBuffer();
        sb.append("<BucketLoggingStatus xmlns=\"http://s3.amazonaws.com/doc/2006-03-01/\">" + (!this.isLoggingEnabled() ? "" : "<LoggingEnabled><TargetBucket>" + this.getTargetBucketName() + "</TargetBucket>" + "<TargetPrefix>" + this.getLogfilePrefix() + "</TargetPrefix>" + "</LoggingEnabled>") + "</BucketLoggingStatus>");
        return sb.toString();
    }
}

