/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service;

import com.jamesmurty.utils.XMLBuilder;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.CloudFrontServiceException;
import org.jets3t.service.Constants;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.impl.rest.CloudFrontXmlResponsesSaxParser;
import org.jets3t.service.impl.rest.httpclient.AWSRequestAuthorizer;
import org.jets3t.service.impl.rest.httpclient.HttpClientAndConnectionManager;
import org.jets3t.service.model.cloudfront.Distribution;
import org.jets3t.service.model.cloudfront.DistributionConfig;
import org.jets3t.service.model.cloudfront.LoggingStatus;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.utils.RestUtils;
import org.jets3t.service.utils.ServiceUtils;

public class CloudFrontService
implements AWSRequestAuthorizer {
    private static final Log log = LogFactory.getLog((Class)CloudFrontService.class);
    public static final String ENDPOINT = "https://cloudfront.amazonaws.com/";
    public static final String VERSION = "2009-04-02";
    public static final String XML_NAMESPACE = "http://cloudfront.amazonaws.com/doc/2009-04-02/";
    public static final String DEFAULT_BUCKET_SUFFIX = ".s3.amazonaws.com";
    private HttpClient httpClient = null;
    private CredentialsProvider credentialsProvider = null;
    private AWSCredentials awsCredentials = null;
    protected Jets3tProperties jets3tProperties = null;
    private String invokingApplicationDescription = null;
    protected int internalErrorRetryMax = 5;
    protected long timeOffset = 0L;

    public CloudFrontService(AWSCredentials awsCredentials, String invokingApplicationDescription, CredentialsProvider credentialsProvider, Jets3tProperties jets3tProperties, HostConfiguration hostConfig) throws CloudFrontServiceException {
        this.awsCredentials = awsCredentials;
        this.invokingApplicationDescription = invokingApplicationDescription;
        this.credentialsProvider = credentialsProvider;
        if (jets3tProperties == null) {
            jets3tProperties = Jets3tProperties.getInstance(Constants.JETS3T_PROPERTIES_FILENAME);
        }
        this.jets3tProperties = jets3tProperties;
        System.setProperty("networkaddress.cache.ttl", "300");
        System.setProperty("networkaddress.cache.negative.ttl", "1");
        this.internalErrorRetryMax = jets3tProperties.getIntProperty("cloudfront-service.internal-error-retry-max", 5);
        if (hostConfig == null) {
            hostConfig = new HostConfiguration();
        }
        HttpClientAndConnectionManager initHttpResult = RestUtils.initHttpConnection(this, hostConfig, jets3tProperties, this.invokingApplicationDescription, this.credentialsProvider);
        this.httpClient = initHttpResult.getHttpClient();
        if (this.jets3tProperties.getBoolProperty("httpclient.proxy-autodetect", true)) {
            RestUtils.initHttpProxy(this.httpClient);
        } else {
            String proxyHostAddress = this.jets3tProperties.getStringProperty("httpclient.proxy-host", null);
            int proxyPort = this.jets3tProperties.getIntProperty("httpclient.proxy-port", -1);
            String proxyUser = this.jets3tProperties.getStringProperty("httpclient.proxy-user", null);
            String proxyPassword = this.jets3tProperties.getStringProperty("httpclient.proxy-password", null);
            String proxyDomain = this.jets3tProperties.getStringProperty("httpclient.proxy-domain", null);
            RestUtils.initHttpProxy(this.httpClient, proxyHostAddress, proxyPort, proxyUser, proxyPassword, proxyDomain);
        }
        this.httpClient.getParams().setBooleanParameter("http.protocol.expect-continue", false);
    }

    public CloudFrontService(AWSCredentials awsCredentials) throws CloudFrontServiceException {
        this(awsCredentials, null, null, null, null);
    }

    public AWSCredentials getAWSCredentials() {
        return this.awsCredentials;
    }

    protected Date getCurrentTimeWithOffset() {
        return new Date(System.currentTimeMillis() + this.timeOffset);
    }

    public void authorizeHttpRequest(HttpMethod httpMethod) throws Exception {
        String date = ServiceUtils.formatRfc822Date(this.getCurrentTimeWithOffset());
        httpMethod.setRequestHeader("Date", date);
        String signature = ServiceUtils.signWithHmacSha1(this.getAWSCredentials().getSecretKey(), date);
        String authorizationString = "AWS " + this.getAWSCredentials().getAccessKey() + ":" + signature;
        httpMethod.setRequestHeader("Authorization", authorizationString);
    }

    protected void performRestRequest(HttpMethod httpMethod, int expectedResponseCode) throws CloudFrontServiceException {
        if (httpMethod.getRequestHeader("Date") == null) {
            httpMethod.setRequestHeader("Date", ServiceUtils.formatRfc822Date(this.getCurrentTimeWithOffset()));
        }
        boolean completedWithoutRecoverableError = true;
        int internalErrorCount = 0;
        try {
            do {
                completedWithoutRecoverableError = true;
                this.authorizeHttpRequest(httpMethod);
                int responseCode = this.httpClient.executeMethod(httpMethod);
                if (responseCode == expectedResponseCode) continue;
                if (responseCode == 500) {
                    long delayMs = 1000L;
                    if (++internalErrorCount < this.internalErrorRetryMax) {
                        log.warn((Object)("Encountered " + internalErrorCount + " CloudFront Internal Server error(s), will retry in " + delayMs + "ms"));
                        Thread.sleep(delayMs);
                        completedWithoutRecoverableError = false;
                        continue;
                    }
                    throw new CloudFrontServiceException("Encountered too many CloudFront Internal Server errors (" + internalErrorCount + "), aborting request.");
                }
                CloudFrontXmlResponsesSaxParser.ErrorHandler handler = new CloudFrontXmlResponsesSaxParser(this.jets3tProperties).parseErrorResponse(httpMethod.getResponseBodyAsStream());
                CloudFrontServiceException exception = new CloudFrontServiceException("Request failed with CloudFront Service error", responseCode, handler.getType(), handler.getCode(), handler.getMessage(), handler.getDetail(), handler.getRequestId());
                if ("RequestExpired".equals(exception.getErrorCode())) {
                    this.timeOffset = RestUtils.getAWSTimeAdjustment();
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("Adjusted time offset in response to RequestExpired error. Local machine and CloudFront server disagree on the time by approximately " + this.timeOffset / 1000L + " seconds. Retrying connection."));
                    }
                    completedWithoutRecoverableError = false;
                    continue;
                }
                throw exception;
            } while (!completedWithoutRecoverableError);
        }
        catch (CloudFrontServiceException e) {
            httpMethod.releaseConnection();
            throw e;
        }
        catch (Throwable t) {
            httpMethod.releaseConnection();
            throw new CloudFrontServiceException("CloudFront Request failed", t);
        }
    }

    public Distribution[] listDistributions(int pagingSize) throws CloudFrontServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Listing distributions for AWS user: " + this.getAWSCredentials().getAccessKey()));
        }
        try {
            ArrayList distributions = new ArrayList();
            String nextMarker = null;
            boolean incompleteListing = true;
            do {
                String uri = "https://cloudfront.amazonaws.com/2009-04-02/distribution?MaxItems=" + pagingSize;
                if (nextMarker != null) {
                    uri = uri + "&Marker=" + nextMarker;
                }
                GetMethod httpMethod = new GetMethod(uri);
                this.performRestRequest(httpMethod, 200);
                CloudFrontXmlResponsesSaxParser.ListDistributionListHandler handler = new CloudFrontXmlResponsesSaxParser(this.jets3tProperties).parseDistributionListResponse(httpMethod.getResponseBodyAsStream());
                distributions.addAll(handler.getDistributions());
                incompleteListing = handler.isTruncated();
                nextMarker = handler.getNextMarker();
                if (!incompleteListing || nextMarker != null) continue;
                throw new CloudFrontServiceException("Unable to retrieve paginated DistributionList results without a valid NextMarker value.");
            } while (incompleteListing);
            return distributions.toArray(new Distribution[distributions.size()]);
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public Distribution[] listDistributions() throws CloudFrontServiceException {
        return this.listDistributions(100);
    }

    public Distribution[] listDistributions(String bucketName) throws CloudFrontServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Listing distributions for the S3 bucket '" + bucketName + "' for AWS user: " + this.getAWSCredentials().getAccessKey()));
        }
        ArrayList<Distribution> bucketDistributions = new ArrayList<Distribution>();
        Distribution[] allDistributions = this.listDistributions();
        for (int i = 0; i < allDistributions.length; ++i) {
            String distributionOrigin = allDistributions[i].getOrigin();
            if (!distributionOrigin.equals(bucketName) && !bucketName.equals(ServiceUtils.findBucketNameInHostname(distributionOrigin))) continue;
            bucketDistributions.add(allDistributions[i]);
        }
        return bucketDistributions.toArray(new Distribution[bucketDistributions.size()]);
    }

    public Distribution createDistribution(String origin) throws CloudFrontServiceException {
        return this.createDistribution(origin, null, null, null, true, null);
    }

    public Distribution createDistribution(String origin, String callerReference, String[] cnames, String comment2, boolean enabled, LoggingStatus loggingStatus) throws CloudFrontServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating distribution for origin: " + origin));
        }
        origin = CloudFrontService.sanitizeS3BucketName(origin);
        if (callerReference == null) {
            callerReference = "" + System.currentTimeMillis();
        }
        if (cnames == null) {
            cnames = new String[]{};
        }
        if (comment2 == null) {
            comment2 = "";
        }
        PostMethod httpMethod = new PostMethod("https://cloudfront.amazonaws.com/2009-04-02/distribution");
        try {
            XMLBuilder builder = XMLBuilder.create((String)"DistributionConfig").a("xmlns", XML_NAMESPACE).e("Origin").t(origin).up().e("CallerReference").t(callerReference).up();
            for (int i = 0; i < cnames.length; ++i) {
                builder.e("CNAME").t(cnames[i]).up();
            }
            builder.e("Comment").t(comment2).up().e("Enabled").t("" + enabled);
            if (loggingStatus != null) {
                builder.e("Logging").e("Bucket").t(loggingStatus.getBucket()).up().e("Prefix").t(loggingStatus.getPrefix()).up().up();
            }
            httpMethod.setRequestEntity(new StringRequestEntity(builder.asString(null), "text/xml", Constants.DEFAULT_ENCODING));
            this.performRestRequest(httpMethod, 201);
            CloudFrontXmlResponsesSaxParser.DistributionHandler handler = new CloudFrontXmlResponsesSaxParser(this.jets3tProperties).parseDistributionResponse(httpMethod.getResponseBodyAsStream());
            return handler.getDistribution();
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public Distribution getDistributionInfo(String id) throws CloudFrontServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting information for distribution with id: " + id));
        }
        GetMethod httpMethod = new GetMethod("https://cloudfront.amazonaws.com/2009-04-02/distribution/" + id);
        try {
            this.performRestRequest(httpMethod, 200);
            CloudFrontXmlResponsesSaxParser.DistributionHandler handler = new CloudFrontXmlResponsesSaxParser(this.jets3tProperties).parseDistributionResponse(httpMethod.getResponseBodyAsStream());
            return handler.getDistribution();
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public DistributionConfig getDistributionConfig(String id) throws CloudFrontServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting configuration for distribution with id: " + id));
        }
        GetMethod httpMethod = new GetMethod("https://cloudfront.amazonaws.com/2009-04-02/distribution/" + id + "/config");
        try {
            this.performRestRequest(httpMethod, 200);
            CloudFrontXmlResponsesSaxParser.DistributionConfigHandler handler = new CloudFrontXmlResponsesSaxParser(this.jets3tProperties).parseDistributionConfigResponse(httpMethod.getResponseBodyAsStream());
            DistributionConfig config = handler.getDistributionConfig();
            config.setEtag(httpMethod.getResponseHeader("ETag").getValue());
            return config;
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public DistributionConfig updateDistributionConfig(String id, String[] cnames, String comment2, boolean enabled, LoggingStatus loggingStatus) throws CloudFrontServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting configuration of distribution with id: " + id));
        }
        DistributionConfig oldConfig = this.getDistributionConfig(id);
        if (cnames == null) {
            cnames = oldConfig.getCNAMEs();
        }
        if (comment2 == null) {
            comment2 = oldConfig.getComment();
        }
        PutMethod httpMethod = new PutMethod("https://cloudfront.amazonaws.com/2009-04-02/distribution/" + id + "/config");
        try {
            XMLBuilder builder = XMLBuilder.create((String)"DistributionConfig").a("xmlns", XML_NAMESPACE).e("Origin").t(oldConfig.getOrigin()).up().e("CallerReference").t(oldConfig.getCallerReference()).up();
            for (int i = 0; i < cnames.length; ++i) {
                builder.e("CNAME").t(cnames[i]).up();
            }
            builder.e("Comment").t(comment2).up().e("Enabled").t("" + enabled);
            if (loggingStatus != null) {
                builder.e("Logging").e("Bucket").t(loggingStatus.getBucket()).up().e("Prefix").t(loggingStatus.getPrefix()).up().up();
            }
            httpMethod.setRequestEntity(new StringRequestEntity(builder.asString(null), "text/xml", Constants.DEFAULT_ENCODING));
            httpMethod.setRequestHeader("If-Match", oldConfig.getEtag());
            this.performRestRequest(httpMethod, 200);
            CloudFrontXmlResponsesSaxParser.DistributionConfigHandler handler = new CloudFrontXmlResponsesSaxParser(this.jets3tProperties).parseDistributionConfigResponse(httpMethod.getResponseBodyAsStream());
            DistributionConfig config = handler.getDistributionConfig();
            config.setEtag(httpMethod.getResponseHeader("ETag").getValue());
            return config;
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public void disableDistributionForDeletion(String id) throws CloudFrontServiceException {
        this.updateDistributionConfig(id, new String[0], "Disabled prior to deletion", false, null);
    }

    public void deleteDistribution(String id) throws CloudFrontServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deleting distribution with id: " + id));
        }
        DistributionConfig currentConfig = this.getDistributionConfig(id);
        DeleteMethod httpMethod = new DeleteMethod("https://cloudfront.amazonaws.com/2009-04-02/distribution/" + id);
        try {
            httpMethod.setRequestHeader("If-Match", currentConfig.getEtag());
            this.performRestRequest(httpMethod, 204);
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public static String sanitizeS3BucketName(String proposedBucketName) {
        if (!proposedBucketName.endsWith(DEFAULT_BUCKET_SUFFIX)) {
            log.warn((Object)("Bucket names used within the CloudFront service should be specified as full S3 subdomain paths like 'jets3t.s3.amazonaws.com'. Repairing faulty bucket name value \"" + proposedBucketName + "\" by adding suffix " + "'" + DEFAULT_BUCKET_SUFFIX + "'."));
            return proposedBucketName + DEFAULT_BUCKET_SUFFIX;
        }
        return proposedBucketName;
    }
}

