/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.utils;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import org.glassfish.grizzly.utils.TransferQueue;

public class LinkedTransferQueue<E>
extends AbstractQueue<E>
implements TransferQueue<E>,
Serializable {
    private static final long serialVersionUID = -3223113410248163686L;
    static final int NOWAIT = 0;
    static final int TIMEOUT = 1;
    static final int WAIT = 2;
    static final int NCPUS = Runtime.getRuntime().availableProcessors();
    static final int maxTimedSpins = NCPUS < 2 ? 0 : 32;
    static final int maxUntimedSpins = maxTimedSpins * 16;
    static final long spinForTimeoutThreshold = 1000L;
    private final transient PaddedAtomicReference<QNode> head;
    private final transient PaddedAtomicReference<QNode> tail;
    private final transient PaddedAtomicReference<QNode> cleanMe;

    private boolean advanceHead(QNode h, QNode nh) {
        if (h == this.head.get() && this.head.compareAndSet(h, nh)) {
            h.clearNext();
            return true;
        }
        return false;
    }

    private Object xfer(Object e, int mode, long nanos) {
        Object x;
        QNode first;
        boolean isData = e != null;
        QNode s2 = null;
        PaddedAtomicReference<QNode> head2 = this.head;
        PaddedAtomicReference<QNode> tail = this.tail;
        while (true) {
            QNode t = (QNode)tail.get();
            QNode h = (QNode)head2.get();
            if (t != null && (t == h || t.isData == isData)) {
                QNode last2;
                if (s2 == null) {
                    s2 = new QNode(e, isData);
                }
                if ((last2 = t.next) != null) {
                    if (t != tail.get()) continue;
                    tail.compareAndSet(t, last2);
                    continue;
                }
                if (!t.casNext(null, s2)) continue;
                tail.compareAndSet(t, s2);
                return this.awaitFulfill(t, s2, e, mode, nanos);
            }
            if (h == null) continue;
            first = h.next;
            if (t == tail.get() && first != null && this.advanceHead(h, first) && (x = first.get()) != first && first.compareAndSet(x, e)) break;
        }
        LockSupport.unpark(first.waiter);
        return isData ? e : x;
    }

    private Object fulfill(Object e) {
        Object x;
        QNode first;
        boolean isData = e != null;
        PaddedAtomicReference<QNode> head2 = this.head;
        PaddedAtomicReference<QNode> tail = this.tail;
        while (true) {
            QNode t = (QNode)tail.get();
            QNode h = (QNode)head2.get();
            if (t != null && (t == h || t.isData == isData)) {
                QNode last2 = t.next;
                if (t != tail.get()) continue;
                if (last2 != null) {
                    tail.compareAndSet(t, last2);
                    continue;
                }
                return null;
            }
            if (h == null) continue;
            first = h.next;
            if (t == tail.get() && first != null && this.advanceHead(h, first) && (x = first.get()) != first && first.compareAndSet(x, e)) break;
        }
        LockSupport.unpark(first.waiter);
        return isData ? e : x;
    }

    private Object awaitFulfill(QNode pred, QNode s2, Object e, int mode, long nanos) {
        if (mode == 0) {
            return null;
        }
        long lastTime = mode == 1 ? System.nanoTime() : 0L;
        Thread w = Thread.currentThread();
        int spins = -1;
        while (true) {
            long now;
            Object x;
            if (w.isInterrupted()) {
                s2.compareAndSet(e, s2);
            }
            if ((x = s2.get()) != e) {
                this.advanceHead(pred, s2);
                if (x == s2) {
                    this.clean(pred, s2);
                    return null;
                }
                if (x != null) {
                    s2.set(s2);
                    return x;
                }
                return e;
            }
            if (mode == 1 && (nanos -= (now = System.nanoTime()) - (lastTime = now)) <= 0L) {
                s2.compareAndSet(e, s2);
                continue;
            }
            if (spins < 0) {
                QNode h = (QNode)this.head.get();
                int n = h != null && h.next == s2 ? (mode == 1 ? maxTimedSpins : maxUntimedSpins) : (spins = 0);
            }
            if (spins > 0) {
                --spins;
                continue;
            }
            if (s2.waiter == null) {
                s2.waiter = w;
                continue;
            }
            if (mode != 1) {
                LockSupport.park(this);
                s2.waiter = null;
                spins = -1;
                continue;
            }
            if (nanos <= 1000L) continue;
            LockSupport.parkNanos(this, nanos);
            s2.waiter = null;
            spins = -1;
        }
    }

    private QNode getValidatedTail() {
        QNode t;
        while (true) {
            QNode h = (QNode)this.head.get();
            QNode first = h.next;
            if (first != null && first.next == first) {
                this.advanceHead(h, first);
                continue;
            }
            t = (QNode)this.tail.get();
            QNode last2 = t.next;
            if (t != this.tail.get()) continue;
            if (last2 == null) break;
            this.tail.compareAndSet(t, last2);
        }
        return t;
    }

    private void clean(QNode pred, QNode s2) {
        Thread w = s2.waiter;
        if (w != null) {
            s2.waiter = null;
            if (w != Thread.currentThread()) {
                LockSupport.unpark(w);
            }
        }
        if (pred == null) {
            return;
        }
        while (pred.next == s2) {
            QNode sn;
            QNode oldpred = this.reclean();
            QNode t = this.getValidatedTail();
            if (!(s2 != t ? (sn = s2.next) == s2 || pred.casNext(s2, sn) : oldpred == pred || oldpred == null && this.cleanMe.compareAndSet(null, pred))) continue;
            break;
        }
    }

    private QNode reclean() {
        QNode t;
        QNode s2;
        QNode pred;
        while ((pred = (QNode)this.cleanMe.get()) != null && (s2 = pred.next) != (t = this.getValidatedTail())) {
            QNode sn;
            if (s2 != null && s2 != pred && s2.get() == s2 && (sn = s2.next) != s2 && !pred.casNext(s2, sn)) continue;
            this.cleanMe.compareAndSet(pred, null);
        }
        return pred;
    }

    public LinkedTransferQueue() {
        QNode dummy = new QNode(null, false);
        this.head = new PaddedAtomicReference<QNode>(dummy);
        this.tail = new PaddedAtomicReference<QNode>(dummy);
        this.cleanMe = new PaddedAtomicReference<Object>(null);
    }

    public LinkedTransferQueue(Collection<? extends E> c) {
        this();
        this.addAll(c);
    }

    @Override
    public void put(E e) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        this.xfer(e, 0, 0L);
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        this.xfer(e, 0, 0L);
        return true;
    }

    @Override
    public boolean offer(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.xfer(e, 0, 0L);
        return true;
    }

    @Override
    public boolean add(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.xfer(e, 0, 0L);
        return true;
    }

    @Override
    public void transfer(E e) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        if (this.xfer(e, 2, 0L) == null) {
            Thread.interrupted();
            throw new InterruptedException();
        }
    }

    @Override
    public boolean tryTransfer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        if (this.xfer(e, 1, unit.toNanos(timeout)) != null) {
            return true;
        }
        if (!Thread.interrupted()) {
            return false;
        }
        throw new InterruptedException();
    }

    @Override
    public boolean tryTransfer(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        return this.fulfill(e) != null;
    }

    @Override
    public E take() throws InterruptedException {
        Object e = this.xfer(null, 2, 0L);
        if (e != null) {
            return (E)e;
        }
        Thread.interrupted();
        throw new InterruptedException();
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        Object e = this.xfer(null, 1, unit.toNanos(timeout));
        if (e != null || !Thread.interrupted()) {
            return (E)e;
        }
        throw new InterruptedException();
    }

    @Override
    public E poll() {
        return (E)this.fulfill(null);
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        E e;
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        while ((e = this.poll()) != null) {
            c.add(e);
            ++n;
        }
        return n;
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        E e;
        int n;
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        for (n = 0; n < maxElements && (e = this.poll()) != null; ++n) {
            c.add(e);
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private QNode traversalHead() {
        while (true) {
            QNode t = (QNode)this.tail.get();
            QNode h = (QNode)this.head.get();
            if (h != null && t != null) {
                QNode last2 = t.next;
                QNode first = h.next;
                if (t == this.tail.get()) {
                    if (last2 != null) {
                        this.tail.compareAndSet(t, last2);
                    } else {
                        if (first == null) return h;
                        Object x = first.get();
                        if (x != first) return h;
                        this.advanceHead(h, first);
                    }
                }
            }
            this.reclean();
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public E peek() {
        Object x;
        while (true) {
            QNode h = this.traversalHead();
            QNode p = h.next;
            if (p == null) {
                return null;
            }
            x = p.get();
            if (p == x) continue;
            if (!p.isData) {
                return null;
            }
            if (x != null) break;
        }
        return (E)x;
    }

    @Override
    public boolean isEmpty() {
        while (true) {
            QNode h = this.traversalHead();
            QNode p = h.next;
            if (p == null) {
                return true;
            }
            Object x = p.get();
            if (p == x) continue;
            if (!p.isData) {
                return true;
            }
            if (x != null) break;
        }
        return false;
    }

    @Override
    public boolean hasWaitingConsumer() {
        Object x;
        QNode p;
        do {
            QNode h = this.traversalHead();
            p = h.next;
            if (p != null) continue;
            return false;
        } while (p == (x = p.get()));
        return !p.isData;
    }

    @Override
    public int size() {
        Object x;
        int count2 = 0;
        QNode h = this.traversalHead();
        QNode p = h.next;
        while (p != null && p.isData && ((x = p.get()) == null || x == p || ++count2 != Integer.MAX_VALUE)) {
            p = p.next;
        }
        return count2;
    }

    @Override
    public int getWaitingConsumerCount() {
        int count2 = 0;
        QNode h = this.traversalHead();
        QNode p = h.next;
        while (!(p == null || p.isData || p.get() == null && ++count2 == Integer.MAX_VALUE)) {
            p = p.next;
        }
        return count2;
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            return false;
        }
        block0: while (true) {
            QNode pred = this.traversalHead();
            while (true) {
                QNode q;
                if ((q = pred.next) == null || !q.isData) {
                    return false;
                }
                if (q == pred) continue block0;
                Object x = q.get();
                if (x != null && x != q && o.equals(x) && q.compareAndSet(x, q)) {
                    this.clean(pred, q);
                    return true;
                }
                pred = q;
            }
            break;
        }
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        throw new UnsupportedOperationException("serialization is not Not supported");
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException("serialization is not Not supported");
    }

    class Itr
    implements Iterator<E> {
        QNode next;
        QNode pnext;
        QNode snext;
        QNode curr;
        QNode pcurr;
        E nextItem;

        Itr() {
            this.findNext();
        }

        void findNext() {
            while (true) {
                QNode pred = this.pnext;
                QNode q = this.next;
                if (pred == null || pred == q) {
                    pred = LinkedTransferQueue.this.traversalHead();
                    q = pred.next;
                }
                if (q == null || !q.isData) {
                    this.next = null;
                    return;
                }
                Object x = q.get();
                QNode s2 = q.next;
                if (x != null && q != x && q != s2) {
                    this.nextItem = x;
                    this.snext = s2;
                    this.pnext = pred;
                    this.next = q;
                    return;
                }
                this.pnext = q;
                this.next = s2;
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public E next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.pcurr = this.pnext;
            this.curr = this.next;
            this.pnext = this.next;
            this.next = this.snext;
            Object x = this.nextItem;
            this.findNext();
            return x;
        }

        @Override
        public void remove() {
            QNode p = this.curr;
            if (p == null) {
                throw new IllegalStateException();
            }
            Object x = p.get();
            if (x != null && x != p && p.compareAndSet(x, p)) {
                LinkedTransferQueue.this.clean(this.pcurr, p);
            }
        }
    }

    static final class PaddedAtomicReference<T>
    extends AtomicReference<T> {
        Object p0;
        Object p1;
        Object p2;
        Object p3;
        Object p4;
        Object p5;
        Object p6;
        Object p7;
        Object p8;
        Object p9;
        Object pa;
        Object pb;
        Object pc;
        Object pd;
        Object pe;

        PaddedAtomicReference(T r) {
            super(r);
        }
    }

    static final class QNode
    extends AtomicReference<Object> {
        volatile QNode next;
        volatile Thread waiter;
        final boolean isData;
        static final AtomicReferenceFieldUpdater<QNode, QNode> nextUpdater = AtomicReferenceFieldUpdater.newUpdater(QNode.class, QNode.class, "next");

        QNode(Object item, boolean isData) {
            super(item);
            this.isData = isData;
        }

        final boolean casNext(QNode cmp, QNode val) {
            return nextUpdater.compareAndSet(this, cmp, val);
        }

        final void clearNext() {
            nextUpdater.lazySet(this, this);
        }
    }
}

