/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.compression.lzma.impl.lz;

import java.io.IOException;
import org.glassfish.grizzly.Buffer;

public class InWindow {
    public byte[] _bufferBase;
    Buffer _buffer;
    int _posLimit;
    boolean _streamEndWasReached;
    int _pointerToLastSafePosition;
    public int _bufferOffset;
    public int _blockSize;
    public int _pos;
    int _keepSizeBefore;
    int _keepSizeAfter;
    public int _streamPos;

    public void moveBlock() {
        int offset = this._bufferOffset + this._pos - this._keepSizeBefore;
        if (offset > 0) {
            --offset;
        }
        int numBytes = this._bufferOffset + this._streamPos - offset;
        for (int i = 0; i < numBytes; ++i) {
            this._bufferBase[i] = this._bufferBase[offset + i];
        }
        this._bufferOffset -= offset;
    }

    public void readBlock() throws IOException {
        if (this._streamEndWasReached) {
            return;
        }
        int size2;
        while ((size2 = 0 - this._bufferOffset + this._blockSize - this._streamPos) != 0) {
            int pos = this._buffer.position();
            size2 = Math.min(size2, this._buffer.remaining());
            this._buffer.get(this._bufferBase, this._bufferOffset + this._streamPos, size2);
            int numReadBytes = this._buffer.position() - pos;
            if (numReadBytes == 0) {
                this._posLimit = this._streamPos;
                int pointerToPostion = this._bufferOffset + this._posLimit;
                if (pointerToPostion > this._pointerToLastSafePosition) {
                    this._posLimit = this._pointerToLastSafePosition - this._bufferOffset;
                }
                this._streamEndWasReached = true;
                return;
            }
            this._streamPos += numReadBytes;
            if (this._streamPos < this._pos + this._keepSizeAfter) continue;
            this._posLimit = this._streamPos - this._keepSizeAfter;
        }
        return;
    }

    void free() {
        this._bufferBase = null;
    }

    public void create(int keepSizeBefore, int keepSizeAfter, int keepSizeReserv) {
        this._keepSizeBefore = keepSizeBefore;
        this._keepSizeAfter = keepSizeAfter;
        int blockSize = keepSizeBefore + keepSizeAfter + keepSizeReserv;
        if (this._bufferBase == null || this._blockSize != blockSize) {
            this.free();
            this._blockSize = blockSize;
            this._bufferBase = new byte[this._blockSize];
        }
        this._pointerToLastSafePosition = this._blockSize - keepSizeAfter;
    }

    public void setBuffer(Buffer buffer) {
        this._buffer = buffer;
    }

    public void releaseBuffer() {
        this._buffer = null;
    }

    public void init() throws IOException {
        this._bufferOffset = 0;
        this._pos = 0;
        this._streamPos = 0;
        this._streamEndWasReached = false;
        this.readBlock();
    }

    public void movePos() throws IOException {
        ++this._pos;
        if (this._pos > this._posLimit) {
            int pointerToPostion = this._bufferOffset + this._pos;
            if (pointerToPostion > this._pointerToLastSafePosition) {
                this.moveBlock();
            }
            this.readBlock();
        }
    }

    public byte getIndexByte(int index2) {
        return this._bufferBase[this._bufferOffset + this._pos + index2];
    }

    public int getMatchLen(int index2, int distance, int limit) {
        int i;
        if (this._streamEndWasReached && this._pos + index2 + limit > this._streamPos) {
            limit = this._streamPos - (this._pos + index2);
        }
        ++distance;
        int pby = this._bufferOffset + this._pos + index2;
        for (i = 0; i < limit && this._bufferBase[pby + i] == this._bufferBase[pby + i - distance]; ++i) {
        }
        return i;
    }

    public int getNumAvailableBytes() {
        return this._streamPos - this._pos;
    }

    public void reduceOffsets(int subValue) {
        this._bufferOffset += subValue;
        this._posLimit -= subValue;
        this._pos -= subValue;
        this._streamPos -= subValue;
    }
}

