/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class NodeId
implements Comparable<NodeId> {
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static NodeId newInstance(String host, int port) {
        NodeId nodeId = Records.newRecord(NodeId.class);
        nodeId.setHost(host);
        nodeId.setPort(port);
        nodeId.build();
        return nodeId;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract String getHost();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    protected abstract void setHost(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract int getPort();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    protected abstract void setPort(int var1);

    public String toString() {
        return this.getHost() + ":" + this.getPort();
    }

    public int hashCode() {
        int prime = 493217;
        int result2 = 8501;
        result2 = 493217 * result2 + this.getHost().hashCode();
        result2 = 493217 * result2 + this.getPort();
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeId other = (NodeId)obj;
        if (!this.getHost().equals(other.getHost())) {
            return false;
        }
        return this.getPort() == other.getPort();
    }

    @Override
    public int compareTo(NodeId other) {
        int hostCompare = this.getHost().compareTo(other.getHost());
        if (hostCompare == 0) {
            if (this.getPort() > other.getPort()) {
                return 1;
            }
            if (this.getPort() < other.getPort()) {
                return -1;
            }
            return 0;
        }
        return hostCompare;
    }

    protected abstract void build();
}

