/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Progressable;

public class Options {
    public static <base, T extends base> T getOption(Class<T> cls, base[] opts) throws IOException {
        for (base o : opts) {
            if (o.getClass() != cls) continue;
            return (T)o;
        }
        return null;
    }

    public static <T> T[] prependOptions(T[] oldOpts, T ... newOpts) {
        T[] result2 = Arrays.copyOf(newOpts, newOpts.length + oldOpts.length);
        System.arraycopy(oldOpts, 0, result2, newOpts.length, oldOpts.length);
        return result2;
    }

    public static abstract class ProgressableOption {
        private final Progressable value;

        protected ProgressableOption(Progressable value2) {
            this.value = value2;
        }

        public Progressable getValue() {
            return this.value;
        }
    }

    public static abstract class FSDataOutputStreamOption {
        private final FSDataOutputStream value;

        protected FSDataOutputStreamOption(FSDataOutputStream value2) {
            this.value = value2;
        }

        public FSDataOutputStream getValue() {
            return this.value;
        }
    }

    public static abstract class FSDataInputStreamOption {
        private final FSDataInputStream value;

        protected FSDataInputStreamOption(FSDataInputStream value2) {
            this.value = value2;
        }

        public FSDataInputStream getValue() {
            return this.value;
        }
    }

    public static abstract class PathOption {
        private final Path value;

        protected PathOption(Path value2) {
            this.value = value2;
        }

        public Path getValue() {
            return this.value;
        }
    }

    public static abstract class LongOption {
        private final long value;

        protected LongOption(long value2) {
            this.value = value2;
        }

        public long getValue() {
            return this.value;
        }
    }

    public static abstract class IntegerOption {
        private final int value;

        protected IntegerOption(int value2) {
            this.value = value2;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static abstract class BooleanOption {
        private final boolean value;

        protected BooleanOption(boolean value2) {
            this.value = value2;
        }

        public boolean getValue() {
            return this.value;
        }
    }

    public static abstract class ClassOption {
        private final Class<?> value;

        protected ClassOption(Class<?> value2) {
            this.value = value2;
        }

        public Class<?> getValue() {
            return this.value;
        }
    }

    public static abstract class StringOption {
        private final String value;

        protected StringOption(String value2) {
            this.value = value2;
        }

        public String getValue() {
            return this.value;
        }
    }
}

