/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.service;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.LifecycleEvent;
import org.apache.hadoop.service.ServiceStateChangeListener;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public interface Service
extends Closeable {
    public void init(Configuration var1);

    public void start();

    public void stop();

    @Override
    public void close() throws IOException;

    public void registerServiceListener(ServiceStateChangeListener var1);

    public void unregisterServiceListener(ServiceStateChangeListener var1);

    public String getName();

    public Configuration getConfig();

    public STATE getServiceState();

    public long getStartTime();

    public boolean isInState(STATE var1);

    public Throwable getFailureCause();

    public STATE getFailureState();

    public boolean waitForServiceToStop(long var1);

    public List<LifecycleEvent> getLifecycleHistory();

    public Map<String, String> getBlockers();

    public static enum STATE {
        NOTINITED(0, "NOTINITED"),
        INITED(1, "INITED"),
        STARTED(2, "STARTED"),
        STOPPED(3, "STOPPED");

        private final int value;
        private final String statename;

        private STATE(int value2, String name) {
            this.value = value2;
            this.statename = name;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            return this.statename;
        }
    }
}

