/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp.dao;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.TaskAttemptInfo;
import org.apache.hadoop.yarn.util.Times;

@XmlRootElement(name="taskAttempt")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ReduceTaskAttemptInfo
extends TaskAttemptInfo {
    protected long shuffleFinishTime;
    protected long mergeFinishTime;
    protected long elapsedShuffleTime;
    protected long elapsedMergeTime;
    protected long elapsedReduceTime;

    public ReduceTaskAttemptInfo() {
    }

    public ReduceTaskAttemptInfo(TaskAttempt ta, TaskType type) {
        super(ta, type, false);
        this.shuffleFinishTime = ta.getShuffleFinishTime();
        this.mergeFinishTime = ta.getSortFinishTime();
        this.elapsedShuffleTime = Times.elapsed(this.startTime, this.shuffleFinishTime, false);
        if (this.elapsedShuffleTime == -1L) {
            this.elapsedShuffleTime = 0L;
        }
        this.elapsedMergeTime = Times.elapsed(this.shuffleFinishTime, this.mergeFinishTime, false);
        if (this.elapsedMergeTime == -1L) {
            this.elapsedMergeTime = 0L;
        }
        this.elapsedReduceTime = Times.elapsed(this.mergeFinishTime, this.finishTime, false);
        if (this.elapsedReduceTime == -1L) {
            this.elapsedReduceTime = 0L;
        }
    }

    public long getShuffleFinishTime() {
        return this.shuffleFinishTime;
    }

    public long getMergeFinishTime() {
        return this.mergeFinishTime;
    }

    public long getElapsedShuffleTime() {
        return this.elapsedShuffleTime;
    }

    public long getElapsedMergeTime() {
        return this.elapsedMergeTime;
    }

    public long getElapsedReduceTime() {
        return this.elapsedReduceTime;
    }
}

