/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp;

import com.google.inject.Inject;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.JobInfo;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.hamlet.HamletImpl;
import org.apache.hadoop.yarn.webapp.hamlet.HamletSpec;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;

public class JobsBlock
extends HtmlBlock {
    final AppContext appContext;

    @Inject
    JobsBlock(AppContext appCtx) {
        this.appContext = appCtx;
    }

    @Override
    protected void render(HtmlBlock.Block html) {
        HamletSpec.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)((HamletImpl.EImp)((Object)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.THEAD)((Hamlet.TABLE)html.h2("Active Jobs").table("#jobs")).thead()).tr()).th(".id", "Job ID")).th(".name", "Name")).th(".state", "State")).th("Map Progress")).th("Maps Total")).th("Maps Completed")).th("Reduce Progress")).th("Reduces Total")).th("Reduces Completed")))._())._()).tbody();
        for (Job j : this.appContext.getAllJobs().values()) {
            JobInfo job = new JobInfo(j, false);
            ((HamletImpl.EImp)((Object)((Hamlet.TR)((Hamlet.TR)((Hamlet.TD)((Hamlet.DIV)((HamletImpl.EImp)((Object)((Hamlet.DIV)((Hamlet.DIV)((Hamlet.DIV)((Hamlet.TD)((HamletImpl.EImp)((Object)((Hamlet.SPAN)((Hamlet.TD)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TD)((Hamlet.DIV)((HamletImpl.EImp)((Object)((Hamlet.DIV)((Hamlet.DIV)((Hamlet.DIV)((Hamlet.TD)((HamletImpl.EImp)((Object)((Hamlet.SPAN)((Hamlet.TD)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((HamletImpl.EImp)((Object)((Hamlet.TD)((HamletImpl.EImp)((Object)((Hamlet.SPAN)((Hamlet.TD)((Hamlet.TR)((Hamlet.TBODY)tbody).tr()).td()).span()).$title(String.valueOf(job.getId()))))._()).a(this.url("job", job.getId()), job.getId())))._()).td(job.getName())).td(job.getState())).td()).span()).$title(job.getMapProgressPercent())))._()).div(".ui-progressbar.ui-widget.ui-widget-content.ui-corner-all")).$title(StringHelper.join(job.getMapProgressPercent(), Character.valueOf('%')))).div(".ui-progressbar-value.ui-widget-header.ui-corner-left")).$style(StringHelper.join("width:", job.getMapProgressPercent(), Character.valueOf('%')))))._())._())._()).td(String.valueOf(job.getMapsTotal()))).td(String.valueOf(job.getMapsCompleted()))).td()).span()).$title(job.getReduceProgressPercent())))._()).div(".ui-progressbar.ui-widget.ui-widget-content.ui-corner-all")).$title(StringHelper.join(job.getReduceProgressPercent(), Character.valueOf('%')))).div(".ui-progressbar-value.ui-widget-header.ui-corner-left")).$style(StringHelper.join("width:", job.getReduceProgressPercent(), Character.valueOf('%')))))._())._())._()).td(String.valueOf(job.getReducesTotal()))).td(String.valueOf(job.getReducesCompleted()))))._();
        }
        ((Hamlet.TABLE)((HamletImpl.EImp)((Object)tbody))._())._();
    }
}

