/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.URLConnection;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.HftpFileSystem;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSecretManager;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.GenericOptionsParser;
import org.spark-project.guava.base.Charsets;

@InterfaceAudience.Private
public class DelegationTokenFetcher {
    private static final Log LOG = LogFactory.getLog(DelegationTokenFetcher.class);
    private static final String WEBSERVICE = "webservice";
    private static final String RENEWER = "renewer";
    private static final String CANCEL = "cancel";
    private static final String RENEW = "renew";
    private static final String PRINT = "print";
    private static final String HELP = "help";
    private static final String HELP_SHORT = "h";

    private static void printUsage(PrintStream err2) {
        err2.println("fetchdt retrieves delegation tokens from the NameNode");
        err2.println();
        err2.println("fetchdt <opts> <token file>");
        err2.println("Options:");
        err2.println("  --webservice <url>  Url to contact NN on");
        err2.println("  --renewer <name>    Name of the delegation token renewer");
        err2.println("  --cancel            Cancel the delegation token");
        err2.println("  --renew             Renew the delegation token.  Delegation token must have been fetched using the --renewer <name> option.");
        err2.println("  --print             Print the delegation token");
        err2.println();
        GenericOptionsParser.printGenericCommandUsage(err2);
        System.exit(1);
    }

    private static Collection<Token<?>> readTokens(Path file, Configuration conf) throws IOException {
        Credentials creds = Credentials.readTokenStorageFile(file, conf);
        return creds.getAllTokens();
    }

    public static void main(String[] args) throws Exception {
        final HdfsConfiguration conf = new HdfsConfiguration();
        Options fetcherOptions = new Options();
        fetcherOptions.addOption(WEBSERVICE, true, "HTTP url to reach the NameNode at");
        fetcherOptions.addOption(RENEWER, true, "Name of the delegation token renewer");
        fetcherOptions.addOption(CANCEL, false, "cancel the token");
        fetcherOptions.addOption(RENEW, false, "renew the token");
        fetcherOptions.addOption(PRINT, false, "print the token");
        fetcherOptions.addOption(HELP_SHORT, HELP, false, "print out help information");
        GenericOptionsParser parser = new GenericOptionsParser(conf, fetcherOptions, args);
        CommandLine cmd = parser.getCommandLine();
        final String webUrl = cmd.hasOption(WEBSERVICE) ? cmd.getOptionValue(WEBSERVICE) : null;
        final String renewer = cmd.hasOption(RENEWER) ? cmd.getOptionValue(RENEWER) : null;
        final boolean cancel = cmd.hasOption(CANCEL);
        final boolean renew = cmd.hasOption(RENEW);
        final boolean print = cmd.hasOption(PRINT);
        boolean help2 = cmd.hasOption(HELP);
        String[] remaining = parser.getRemainingArgs();
        if (help2) {
            DelegationTokenFetcher.printUsage(System.out);
            System.exit(0);
        }
        if (cancel && renew || cancel && print || renew && print || cancel && renew && print) {
            System.err.println("ERROR: Only specify cancel, renew or print.");
            DelegationTokenFetcher.printUsage(System.err);
        }
        if (remaining.length != 1 || remaining[0].charAt(0) == '-') {
            System.err.println("ERROR: Must specify exacltly one token file");
            DelegationTokenFetcher.printUsage(System.err);
        }
        LocalFileSystem local = FileSystem.getLocal(conf);
        final Path tokenFile = new Path(((FileSystem)local).getWorkingDirectory(), remaining[0]);
        UserGroupInformation.getCurrentUser().doAs(new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                if (print) {
                    DelegationTokenIdentifier id = new DelegationTokenSecretManager(0L, 0L, 0L, 0L, null).createIdentifier();
                    for (Token token2 : DelegationTokenFetcher.readTokens(tokenFile, conf)) {
                        DataInputStream in = new DataInputStream(new ByteArrayInputStream(token2.getIdentifier()));
                        id.readFields(in);
                        System.out.println("Token (" + id + ") for " + token2.getService());
                    }
                    return null;
                }
                if (renew) {
                    for (Token token3 : DelegationTokenFetcher.readTokens(tokenFile, conf)) {
                        if (!token3.isManaged()) continue;
                        long result2 = token3.renew(conf);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("Renewed token for " + token3.getService() + " until: " + new Date(result2)));
                    }
                } else if (cancel) {
                    for (Token token4 : DelegationTokenFetcher.readTokens(tokenFile, conf)) {
                        if (!token4.isManaged()) continue;
                        token4.cancel(conf);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("Cancelled token for " + token4.getService()));
                    }
                } else if (webUrl != null) {
                    Credentials creds = DelegationTokenFetcher.getDTfromRemote(webUrl, renewer);
                    creds.writeTokenStorageFile(tokenFile, conf);
                    for (Token<? extends TokenIdentifier> token5 : creds.getAllTokens()) {
                        System.out.println("Fetched token via " + webUrl + " for " + token5.getService() + " into " + tokenFile);
                    }
                } else {
                    FileSystem fs = FileSystem.get(conf);
                    Credentials cred = new Credentials();
                    Token<?>[] tokens = fs.addDelegationTokens(renewer, cred);
                    cred.writeTokenStorageFile(tokenFile, conf);
                    for (Token<?> token6 : tokens) {
                        System.out.println("Fetched token for " + token6.getService() + " into " + tokenFile);
                    }
                }
                return null;
            }
        });
    }

    public static Credentials getDTfromRemote(String nnAddr, String renewer) throws IOException {
        FilterInputStream dis = null;
        InetSocketAddress serviceAddr = NetUtils.createSocketAddr(nnAddr);
        try {
            StringBuffer url = new StringBuffer();
            if (renewer != null) {
                url.append(nnAddr).append("/getDelegationToken").append("?").append(RENEWER).append("=").append(renewer);
            } else {
                url.append(nnAddr).append("/getDelegationToken");
            }
            URL remoteURL = new URL(url.toString());
            URLConnection connection = SecurityUtil.openSecureHttpConnection(remoteURL);
            InputStream in = connection.getInputStream();
            Credentials ts = new Credentials();
            dis = new DataInputStream(in);
            ts.readFields((DataInput)((Object)dis));
            for (Token<? extends TokenIdentifier> token2 : ts.getAllTokens()) {
                token2.setKind(HftpFileSystem.TOKEN_KIND);
                SecurityUtil.setTokenService(token2, serviceAddr);
            }
            Credentials credentials = ts;
            return credentials;
        }
        catch (Exception e) {
            throw new IOException("Unable to obtain remote token", e);
        }
        finally {
            if (dis != null) {
                dis.close();
            }
        }
    }

    public static long renewDelegationToken(String nnAddr, Token<DelegationTokenIdentifier> tok) throws IOException {
        StringBuilder buf = new StringBuilder();
        buf.append(nnAddr);
        buf.append("/renewDelegationToken");
        buf.append("?");
        buf.append("token");
        buf.append("=");
        buf.append(tok.encodeToUrlString());
        BufferedReader in = null;
        HttpURLConnection connection = null;
        try {
            URL url = new URL(buf.toString());
            connection = (HttpURLConnection)SecurityUtil.openSecureHttpConnection(url);
            if (connection.getResponseCode() != 200) {
                throw new IOException("Error renewing token: " + connection.getResponseMessage());
            }
            in = new BufferedReader(new InputStreamReader(connection.getInputStream(), Charsets.UTF_8));
            long result2 = Long.parseLong(in.readLine());
            in.close();
            return result2;
        }
        catch (IOException ie) {
            LOG.info((Object)"error in renew over HTTP", (Throwable)ie);
            IOException e = DelegationTokenFetcher.getExceptionFromResponse(connection);
            IOUtils.cleanup(LOG, in);
            if (e != null) {
                LOG.info((Object)("rethrowing exception from HTTP request: " + e.getLocalizedMessage()));
                throw e;
            }
            throw ie;
        }
    }

    private static IOException getExceptionFromResponse(HttpURLConnection con) {
        String resp;
        Throwable e = null;
        if (con == null) {
            return null;
        }
        try {
            resp = con.getResponseMessage();
        }
        catch (IOException ie) {
            return null;
        }
        if (resp == null || resp.isEmpty()) {
            return null;
        }
        String exceptionClass = "";
        String exceptionMsg = "";
        String[] rs = resp.split(";");
        if (rs.length < 2) {
            return null;
        }
        exceptionClass = rs[0];
        exceptionMsg = rs[1];
        LOG.info((Object)("Error response from HTTP request=" + resp + ";ec=" + exceptionClass + ";em=" + exceptionMsg));
        if (exceptionClass == null || exceptionClass.isEmpty()) {
            return null;
        }
        try {
            Class<Exception> ec = Class.forName(exceptionClass).asSubclass(Exception.class);
            Constructor<Exception> constructor = ec.getConstructor(String.class);
            e = (IOException)constructor.newInstance(exceptionMsg);
        }
        catch (Exception ee) {
            LOG.warn((Object)"failed to create object of this class", (Throwable)ee);
        }
        if (e == null) {
            return null;
        }
        e.setStackTrace(new StackTraceElement[0]);
        LOG.info((Object)("Exception from HTTP response=" + e.getLocalizedMessage()));
        return e;
    }

    public static void cancelDelegationToken(String nnAddr, Token<DelegationTokenIdentifier> tok) throws IOException {
        StringBuilder buf = new StringBuilder();
        buf.append(nnAddr);
        buf.append("/cancelDelegationToken");
        buf.append("?");
        buf.append("token");
        buf.append("=");
        buf.append(tok.encodeToUrlString());
        Object in = null;
        HttpURLConnection connection = null;
        try {
            URL url = new URL(buf.toString());
            connection = (HttpURLConnection)SecurityUtil.openSecureHttpConnection(url);
            if (connection.getResponseCode() != 200) {
                throw new IOException("Error cancelling token: " + connection.getResponseMessage());
            }
        }
        catch (IOException ie) {
            LOG.info((Object)"error in cancel over HTTP", (Throwable)ie);
            IOException e = DelegationTokenFetcher.getExceptionFromResponse(connection);
            IOUtils.cleanup(LOG, in);
            if (e != null) {
                LOG.info((Object)("rethrowing exception from HTTP request: " + e.getLocalizedMessage()));
                throw e;
            }
            throw ie;
        }
    }
}

