/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import com.google.common.base.Function;
import org.spark-project.guava.collect.ComparisonChain;

public class RemoteEditLog
implements Comparable<RemoteEditLog> {
    private long startTxId = -12345L;
    private long endTxId = -12345L;
    private boolean isInProgress = false;
    public static final Function<RemoteEditLog, Long> GET_START_TXID = new Function<RemoteEditLog, Long>(){

        public Long apply(RemoteEditLog log2) {
            if (null == log2) {
                return -12345L;
            }
            return log2.getStartTxId();
        }
    };

    public RemoteEditLog() {
    }

    public RemoteEditLog(long startTxId, long endTxId) {
        this.startTxId = startTxId;
        this.endTxId = endTxId;
        this.isInProgress = endTxId == -12345L;
    }

    public RemoteEditLog(long startTxId, long endTxId, boolean inProgress) {
        this.startTxId = startTxId;
        this.endTxId = endTxId;
        this.isInProgress = inProgress;
    }

    public long getStartTxId() {
        return this.startTxId;
    }

    public long getEndTxId() {
        return this.endTxId;
    }

    public boolean isInProgress() {
        return this.isInProgress;
    }

    public String toString() {
        if (!this.isInProgress) {
            return "[" + this.startTxId + "," + this.endTxId + "]";
        }
        return "[" + this.startTxId + "-? (in-progress)]";
    }

    @Override
    public int compareTo(RemoteEditLog log2) {
        return ComparisonChain.start().compare(this.startTxId, log2.startTxId).compare(this.endTxId, log2.endTxId).result();
    }

    public boolean equals(Object o) {
        if (!(o instanceof RemoteEditLog)) {
            return false;
        }
        return this.compareTo((RemoteEditLog)o) == 0;
    }

    public int hashCode() {
        return (int)(this.startTxId * this.endTxId);
    }
}

