/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class BlockLocation {
    private String[] hosts;
    private String[] names;
    private String[] topologyPaths;
    private long offset;
    private long length;
    private boolean corrupt;

    public BlockLocation() {
        this(new String[0], new String[0], 0L, 0L);
    }

    public BlockLocation(String[] names, String[] hosts, long offset, long length) {
        this(names, hosts, offset, length, false);
    }

    public BlockLocation(String[] names, String[] hosts, long offset, long length, boolean corrupt) {
        this.names = names == null ? new String[0] : names;
        this.hosts = hosts == null ? new String[0] : hosts;
        this.offset = offset;
        this.length = length;
        this.topologyPaths = new String[0];
        this.corrupt = corrupt;
    }

    public BlockLocation(String[] names, String[] hosts, String[] topologyPaths, long offset, long length) {
        this(names, hosts, topologyPaths, offset, length, false);
    }

    public BlockLocation(String[] names, String[] hosts, String[] topologyPaths, long offset, long length, boolean corrupt) {
        this(names, hosts, offset, length, corrupt);
        this.topologyPaths = topologyPaths == null ? new String[0] : topologyPaths;
    }

    public String[] getHosts() throws IOException {
        if (this.hosts == null || this.hosts.length == 0) {
            return new String[0];
        }
        return this.hosts;
    }

    public String[] getNames() throws IOException {
        if (this.names == null || this.names.length == 0) {
            return new String[0];
        }
        return this.names;
    }

    public String[] getTopologyPaths() throws IOException {
        if (this.topologyPaths == null || this.topologyPaths.length == 0) {
            return new String[0];
        }
        return this.topologyPaths;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getLength() {
        return this.length;
    }

    public boolean isCorrupt() {
        return this.corrupt;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public void setCorrupt(boolean corrupt) {
        this.corrupt = corrupt;
    }

    public void setHosts(String[] hosts) throws IOException {
        this.hosts = hosts == null ? new String[0] : hosts;
    }

    public void setNames(String[] names) throws IOException {
        this.names = names == null ? new String[0] : names;
    }

    public void setTopologyPaths(String[] topologyPaths) throws IOException {
        this.topologyPaths = topologyPaths == null ? new String[0] : topologyPaths;
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder();
        result2.append(this.offset);
        result2.append(',');
        result2.append(this.length);
        if (this.corrupt) {
            result2.append("(corrupt)");
        }
        for (String h : this.hosts) {
            result2.append(',');
            result2.append(h);
        }
        return result2.toString();
    }
}

