/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import org.apache.commons.math.Field;
import org.apache.commons.math.FieldElement;
import org.apache.commons.math.MathRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenIntToFieldHashMap<T extends FieldElement<T>>
implements Serializable {
    protected static final byte FREE = 0;
    protected static final byte FULL = 1;
    protected static final byte REMOVED = 2;
    private static final long serialVersionUID = -9179080286849120720L;
    private static final String CONCURRENT_MODIFICATION_MESSAGE = "map has been modified while iterating";
    private static final String EXHAUSTED_ITERATOR_MESSAGE = "iterator exhausted";
    private static final float LOAD_FACTOR = 0.5f;
    private static final int DEFAULT_EXPECTED_SIZE = 16;
    private static final int RESIZE_MULTIPLIER = 2;
    private static final int PERTURB_SHIFT = 5;
    private final Field<T> field;
    private int[] keys;
    private T[] values;
    private byte[] states;
    private final T missingEntries;
    private int size;
    private int mask;
    private transient int count;

    public OpenIntToFieldHashMap(Field<T> field2) {
        this(field2, 16, (FieldElement)field2.getZero());
    }

    public OpenIntToFieldHashMap(Field<T> field2, T missingEntries) {
        this(field2, 16, missingEntries);
    }

    public OpenIntToFieldHashMap(Field<T> field2, int expectedSize) {
        this(field2, expectedSize, (FieldElement)field2.getZero());
    }

    public OpenIntToFieldHashMap(Field<T> field2, int expectedSize, T missingEntries) {
        this.field = field2;
        int capacity = OpenIntToFieldHashMap.computeCapacity(expectedSize);
        this.keys = new int[capacity];
        this.values = this.buildArray(capacity);
        this.states = new byte[capacity];
        this.missingEntries = missingEntries;
        this.mask = capacity - 1;
    }

    public OpenIntToFieldHashMap(OpenIntToFieldHashMap<T> source) {
        this.field = source.field;
        int length = source.keys.length;
        this.keys = new int[length];
        System.arraycopy(source.keys, 0, this.keys, 0, length);
        this.values = this.buildArray(length);
        System.arraycopy(source.values, 0, this.values, 0, length);
        this.states = new byte[length];
        System.arraycopy(source.states, 0, this.states, 0, length);
        this.missingEntries = source.missingEntries;
        this.size = source.size;
        this.mask = source.mask;
        this.count = source.count;
    }

    private static int computeCapacity(int expectedSize) {
        if (expectedSize == 0) {
            return 1;
        }
        int capacity = (int)Math.ceil((float)expectedSize / 0.5f);
        int powerOfTwo = Integer.highestOneBit(capacity);
        if (powerOfTwo == capacity) {
            return capacity;
        }
        return OpenIntToFieldHashMap.nextPowerOfTwo(capacity);
    }

    private static int nextPowerOfTwo(int i) {
        return Integer.highestOneBit(i) << 1;
    }

    public T get(int key) {
        int hash = OpenIntToFieldHashMap.hashOf(key);
        int index2 = hash & this.mask;
        if (this.containsKey(key, index2)) {
            return this.values[index2];
        }
        if (this.states[index2] == 0) {
            return this.missingEntries;
        }
        int j = index2;
        int perturb = OpenIntToFieldHashMap.perturb(hash);
        while (this.states[index2] != 0) {
            index2 = (j = OpenIntToFieldHashMap.probe(perturb, j)) & this.mask;
            if (this.containsKey(key, index2)) {
                return this.values[index2];
            }
            perturb >>= 5;
        }
        return this.missingEntries;
    }

    public boolean containsKey(int key) {
        int hash = OpenIntToFieldHashMap.hashOf(key);
        int index2 = hash & this.mask;
        if (this.containsKey(key, index2)) {
            return true;
        }
        if (this.states[index2] == 0) {
            return false;
        }
        int j = index2;
        int perturb = OpenIntToFieldHashMap.perturb(hash);
        while (this.states[index2] != 0) {
            index2 = (j = OpenIntToFieldHashMap.probe(perturb, j)) & this.mask;
            if (this.containsKey(key, index2)) {
                return true;
            }
            perturb >>= 5;
        }
        return false;
    }

    public Iterator iterator() {
        return new Iterator();
    }

    private static int perturb(int hash) {
        return hash & Integer.MAX_VALUE;
    }

    private int findInsertionIndex(int key) {
        return OpenIntToFieldHashMap.findInsertionIndex(this.keys, this.states, key, this.mask);
    }

    private static int findInsertionIndex(int[] keys, byte[] states, int key, int mask) {
        int hash = OpenIntToFieldHashMap.hashOf(key);
        int index2 = hash & mask;
        if (states[index2] == 0) {
            return index2;
        }
        if (states[index2] == 1 && keys[index2] == key) {
            return OpenIntToFieldHashMap.changeIndexSign(index2);
        }
        int perturb = OpenIntToFieldHashMap.perturb(hash);
        int j = index2;
        if (states[index2] == 1) {
            do {
                j = OpenIntToFieldHashMap.probe(perturb, j);
                index2 = j & mask;
                perturb >>= 5;
            } while (states[index2] == 1 && keys[index2] != key);
        }
        if (states[index2] == 0) {
            return index2;
        }
        if (states[index2] == 1) {
            return OpenIntToFieldHashMap.changeIndexSign(index2);
        }
        int firstRemoved = index2;
        while (states[index2 = (j = OpenIntToFieldHashMap.probe(perturb, j)) & mask] != 0) {
            if (states[index2] == 1 && keys[index2] == key) {
                return OpenIntToFieldHashMap.changeIndexSign(index2);
            }
            perturb >>= 5;
        }
        return firstRemoved;
    }

    private static int probe(int perturb, int j) {
        return (j << 2) + j + perturb + 1;
    }

    private static int changeIndexSign(int index2) {
        return -index2 - 1;
    }

    public int size() {
        return this.size;
    }

    public T remove(int key) {
        int hash = OpenIntToFieldHashMap.hashOf(key);
        int index2 = hash & this.mask;
        if (this.containsKey(key, index2)) {
            return this.doRemove(index2);
        }
        if (this.states[index2] == 0) {
            return this.missingEntries;
        }
        int j = index2;
        int perturb = OpenIntToFieldHashMap.perturb(hash);
        while (this.states[index2] != 0) {
            index2 = (j = OpenIntToFieldHashMap.probe(perturb, j)) & this.mask;
            if (this.containsKey(key, index2)) {
                return this.doRemove(index2);
            }
            perturb >>= 5;
        }
        return this.missingEntries;
    }

    private boolean containsKey(int key, int index2) {
        return (key != 0 || this.states[index2] == 1) && this.keys[index2] == key;
    }

    private T doRemove(int index2) {
        this.keys[index2] = 0;
        this.states[index2] = 2;
        T previous = this.values[index2];
        this.values[index2] = this.missingEntries;
        --this.size;
        ++this.count;
        return previous;
    }

    public T put(int key, T value2) {
        int index2 = this.findInsertionIndex(key);
        T previous = this.missingEntries;
        boolean newMapping = true;
        if (index2 < 0) {
            index2 = OpenIntToFieldHashMap.changeIndexSign(index2);
            previous = this.values[index2];
            newMapping = false;
        }
        this.keys[index2] = key;
        this.states[index2] = 1;
        this.values[index2] = value2;
        if (newMapping) {
            ++this.size;
            if (this.shouldGrowTable()) {
                this.growTable();
            }
            ++this.count;
        }
        return previous;
    }

    private void growTable() {
        int oldLength = this.states.length;
        int[] oldKeys = this.keys;
        T[] oldValues = this.values;
        byte[] oldStates = this.states;
        int newLength = 2 * oldLength;
        int[] newKeys = new int[newLength];
        FieldElement[] newValues = this.buildArray(newLength);
        byte[] newStates = new byte[newLength];
        int newMask = newLength - 1;
        for (int i = 0; i < oldLength; ++i) {
            if (oldStates[i] != 1) continue;
            int key = oldKeys[i];
            int index2 = OpenIntToFieldHashMap.findInsertionIndex(newKeys, newStates, key, newMask);
            newKeys[index2] = key;
            newValues[index2] = oldValues[i];
            newStates[index2] = 1;
        }
        this.mask = newMask;
        this.keys = newKeys;
        this.values = newValues;
        this.states = newStates;
    }

    private boolean shouldGrowTable() {
        return (float)this.size > (float)(this.mask + 1) * 0.5f;
    }

    private static int hashOf(int key) {
        int h = key ^ (key >>> 20 ^ key >>> 12);
        return h ^ h >>> 7 ^ h >>> 4;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.count = 0;
    }

    private T[] buildArray(int length) {
        return (FieldElement[])Array.newInstance(((FieldElement)this.field.getZero()).getClass(), length);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Iterator {
        private final int referenceCount;
        private int current;
        private int next;

        private Iterator() {
            this.referenceCount = OpenIntToFieldHashMap.this.count;
            this.next = -1;
            try {
                this.advance();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }

        public boolean hasNext() {
            return this.next >= 0;
        }

        public int key() throws ConcurrentModificationException, NoSuchElementException {
            if (this.referenceCount != OpenIntToFieldHashMap.this.count) {
                throw MathRuntimeException.createConcurrentModificationException(OpenIntToFieldHashMap.CONCURRENT_MODIFICATION_MESSAGE, new Object[0]);
            }
            if (this.current < 0) {
                throw MathRuntimeException.createNoSuchElementException(OpenIntToFieldHashMap.EXHAUSTED_ITERATOR_MESSAGE, new Object[0]);
            }
            return OpenIntToFieldHashMap.this.keys[this.current];
        }

        public T value() throws ConcurrentModificationException, NoSuchElementException {
            if (this.referenceCount != OpenIntToFieldHashMap.this.count) {
                throw MathRuntimeException.createConcurrentModificationException(OpenIntToFieldHashMap.CONCURRENT_MODIFICATION_MESSAGE, new Object[0]);
            }
            if (this.current < 0) {
                throw MathRuntimeException.createNoSuchElementException(OpenIntToFieldHashMap.EXHAUSTED_ITERATOR_MESSAGE, new Object[0]);
            }
            return OpenIntToFieldHashMap.this.values[this.current];
        }

        public void advance() throws ConcurrentModificationException, NoSuchElementException {
            block4: {
                if (this.referenceCount != OpenIntToFieldHashMap.this.count) {
                    throw MathRuntimeException.createConcurrentModificationException(OpenIntToFieldHashMap.CONCURRENT_MODIFICATION_MESSAGE, new Object[0]);
                }
                this.current = this.next;
                try {
                    while (OpenIntToFieldHashMap.this.states[++this.next] != 1) {
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    this.next = -2;
                    if (this.current >= 0) break block4;
                    throw MathRuntimeException.createNoSuchElementException(OpenIntToFieldHashMap.EXHAUSTED_ITERATOR_MESSAGE, new Object[0]);
                }
            }
        }
    }
}

